/*
 * Decompiled with CFR 0.152.
 */
package objects.query.broker;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.util.Sizeof;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import objects.query.QueryFactory;
import objects.query.broker.BrokerPrms;
import objects.query.broker.GFXDBrokerQueryFactory;
import objects.query.broker.OQLBrokerQueryFactory;

public class Broker
implements Serializable {
    public static String REGION_TABLE_NAME = "brokers";
    public static String REGION_TABLE_SHORT_NAME = "b";
    private int id;
    private String name;

    protected static String getName(int i) {
        return "Jane Doe " + i % BrokerPrms.getNumBrokerNames();
    }

    public static String getTableName() {
        return REGION_TABLE_NAME;
    }

    public static String getTableShortName() {
        return REGION_TABLE_SHORT_NAME;
    }

    public static String getTableAndShortName() {
        return REGION_TABLE_NAME + " " + REGION_TABLE_SHORT_NAME;
    }

    public static QueryFactory getQueryFactory(int api) {
        switch (api) {
            case 0: {
                return new OQLBrokerQueryFactory();
            }
            case 1: {
                return new GFXDBrokerQueryFactory();
            }
        }
        throw new UnsupportedOperationException("No factory for: " + api);
    }

    public static String commaSeparatedStringFor(Vector fields) {
        StringBuffer sb = new StringBuffer();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (field.equals("*")) {
                return field;
            }
            sb.append(REGION_TABLE_SHORT_NAME + "." + field);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void init(int i) {
        this.id = i;
        this.name = Broker.getName(i);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Broker #" + this.id + "=" + this.name;
    }

    public int sizeof(Object o) {
        if (o instanceof Broker) {
            Broker obj = (Broker)o;
            return Sizeof.sizeof((int)obj.id) + Sizeof.sizeof((String)obj.name);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
        DataSerializer.writeString((String)this.name, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.name = DataSerializer.readString((DataInput)in);
    }
}

