/*
 * Decompiled with CFR 0.152.
 */
package objects.query.broker;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import hydra.BasePrms;
import hydra.Log;
import hydra.RegionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import objects.query.BaseOQLQueryFactory;
import objects.query.QueryObjectException;
import objects.query.broker.Broker;
import objects.query.broker.BrokerPrms;
import objects.query.broker.OQLBrokerTicketQueryFactory;

public class OQLBrokerQueryFactory
extends BaseOQLQueryFactory {
    private static Region BrokerRegion;
    private OQLBrokerTicketQueryFactory brokerTicketQueryFactory = new OQLBrokerTicketQueryFactory();

    private static synchronized void setRegion(Region r) {
        BrokerRegion = r;
    }

    @Override
    public void init() {
        super.init();
        this.brokerTicketQueryFactory.init();
    }

    @Override
    public void createRegions() {
        OQLBrokerQueryFactory.setRegion(RegionHelper.createRegion(Broker.getTableName(), BrokerPrms.getBrokerRegionConfig()));
        this.brokerTicketQueryFactory.createRegions();
    }

    @Override
    public void createIndexes() {
    }

    public List getConstraintStatements() {
        return new ArrayList();
    }

    public List getInsertObjects(int bid) {
        int numBrokers = BrokerPrms.getNumBrokers();
        if (bid >= numBrokers) {
            String s = "Attempt to get insert object with bid=" + bid + " when " + BasePrms.nameForKey(BrokerPrms.numBrokers) + "=" + numBrokers;
            throw new QueryObjectException(s);
        }
        ArrayList<Object> objs = new ArrayList<Object>();
        Broker obj = new Broker();
        obj.init(bid);
        objs.add(obj);
        objs.add(this.brokerTicketQueryFactory.getInsertObjects(bid));
        return objs;
    }

    @Override
    public List getPreparedInsertObjects() {
        ArrayList<Object> pobjs = new ArrayList<Object>();
        Broker pobj = new Broker();
        pobjs.add(pobj);
        pobjs.add(this.brokerTicketQueryFactory.getPreparedInsertObjects());
        return pobjs;
    }

    @Override
    public Map fillAndExecutePreparedInsertObjects(List pobjs, int i) {
        Broker pobj = (Broker)pobjs.get(0);
        pobj.init(i);
        if (this.logUpdates) {
            Log.getLogWriter().info("Executing update: " + pobj);
        }
        BrokerRegion.put((Object)String.valueOf(pobj.getId()), (Object)pobj);
        if (this.logUpdates) {
            Log.getLogWriter().info("Executed update: " + pobj);
        }
        this.brokerTicketQueryFactory.fillAndExecutePreparedInsertObjects((List)pobjs.get(1), pobj.getId());
        return null;
    }

    public OQLIndexInfo getPrimaryKeyIndexOnBrokerId() {
        return new OQLIndexInfo("brokerId", IndexType.PRIMARY_KEY, "id", "/" + Broker.REGION_TABLE_NAME);
    }

    public OQLIndexInfo getFunctionalIndexOnBrokerId(String indexType) {
        return new OQLIndexInfo("brokerId", IndexType.FUNCTIONAL, "id", "/" + Broker.REGION_TABLE_NAME);
    }

    public OQLIndexInfo getFunctionalIndexOnBrokerName() {
        return new OQLIndexInfo("brokerName", IndexType.FUNCTIONAL, "name", "/" + Broker.REGION_TABLE_NAME);
    }

    @Override
    public int getQueryType() {
        return BrokerPrms.getQueryType(0);
    }

    @Override
    public int getUpdateQueryType() {
        return BrokerPrms.getUpdateQueryType(0);
    }

    @Override
    public int getDeleteQueryType() {
        return BrokerPrms.getDeleteQueryType(0);
    }

    @Override
    public String getQuery(int queryType, int i) {
        return "";
    }

    @Override
    public String getPreparedQuery(int queryType) {
        return "";
    }

    public String getRandomEqualityOnBrokerIdQuery(int i) {
        return "";
    }

    @Override
    public void readResultSet(int queryType, Object resultSet) {
    }

    @Override
    public Object fillAndExecutePreparedQueryStatement(Query query, int queryType, int id) {
        return null;
    }

    class OQLIndexInfo {
        private IndexType indexType;
        private String name;
        private String indexedExpression;
        private String fromClause;

        public OQLIndexInfo(String name, IndexType indexType, String indexedExpression, String fromClause) {
            this.name = name;
            this.indexType = indexType;
            this.indexedExpression = indexedExpression;
            this.fromClause = fromClause;
        }
    }
}

