/*
 * Decompiled with CFR 0.152.
 */
package objects.query.broker;

import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.RegionHelper;
import java.util.ArrayList;
import java.util.List;
import objects.query.BaseQueryFactory;
import objects.query.QueryObjectException;
import objects.query.broker.BrokerPrms;
import objects.query.broker.BrokerTicket;

public class OQLBrokerTicketQueryFactory
extends BaseQueryFactory {
    private static Region BrokerTicketRegion;

    private static synchronized void setRegion(Region r) {
        BrokerTicketRegion = r;
    }

    public void createRegions() {
        OQLBrokerTicketQueryFactory.setRegion(RegionHelper.createRegion(BrokerTicket.getTableName(), BrokerPrms.getBrokerTicketRegionConfig()));
    }

    public List getInsertObjects(int bid) {
        int numTicketsPerBroker = BrokerPrms.getNumTicketsPerBroker();
        int numTicketPrices = BrokerPrms.getNumTicketPrices();
        ArrayList<BrokerTicket> objs = new ArrayList<BrokerTicket>();
        for (int i = 0; i < numTicketsPerBroker; ++i) {
            BrokerTicket obj = new BrokerTicket();
            obj.init(i, bid, numTicketsPerBroker, numTicketPrices);
            objs.add(obj);
        }
        return objs;
    }

    public List getPreparedInsertObjects() {
        ArrayList<BrokerTicket> pobjs = new ArrayList<BrokerTicket>();
        BrokerTicket pobj = new BrokerTicket();
        pobjs.add(pobj);
        return pobjs;
    }

    public void fillAndExecutePreparedInsertObjects(List pobjs, int bid) throws QueryObjectException {
        int numTicketsPerBroker = BrokerPrms.getNumTicketsPerBroker();
        int numTicketPrices = BrokerPrms.getNumTicketPrices();
        BrokerTicket pobj = (BrokerTicket)pobjs.get(0);
        for (int i = 0; i < numTicketsPerBroker; ++i) {
            pobj.init(i, bid, numTicketsPerBroker, numTicketPrices);
            if (this.logUpdates) {
                Log.getLogWriter().info("Executing update: " + pobj);
            }
            BrokerTicketRegion.put((Object)String.valueOf(pobj.getId()), (Object)pobj);
            if (!this.logUpdates) continue;
            Log.getLogWriter().info("Executed update: " + pobj);
        }
    }
}

