/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.simple;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.org.jgroups.util.StringId;
import hydra.ClientPrms;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Handler;
import org.jgroups.simple.Order;
import org.jgroups.simple.SimpleBlackboard;
import org.jgroups.simple.SimpleParms;
import org.jgroups.simple.SimpleTestException;
import org.jgroups.simple.cache.Attributes;
import org.jgroups.simple.cache.CacheAccess;
import org.jgroups.simple.cache.CacheAttributes;
import org.jgroups.simple.cache.JCache;
import org.jgroups.simple.cache.JCacheException;
import org.jgroups.simple.cache.JTimeoutException;

public class SimpleClient {
    static boolean useHydra = true;
    static CacheAttributes cacheAttr = null;
    static CacheAccess ca = null;
    static int duration;
    static int sltime;
    static String ORDERS;
    static final String REGION_NAME;
    static SharedCounters counters;
    private static final int TIMEOUT_MS = 2000;
    private static final String[] jgNames;
    private static final Long[] jgNamesKeys;
    private static final String MULTICAST_HOST = "224.0.0.0";
    private static final String MULTICAST_PORT = "16385";
    private static final String MULTICAST_TTL = "32";
    private static final String[] jgDefaults;
    static StandaloneLogger myLogger;

    public static void initialize() {
        int i;
        if (useHydra) {
            counters = SimpleBlackboard.getInstance().getSharedCounters();
            duration = TestConfig.tab().intAt(SimpleParms.duration);
            sltime = TestConfig.tab().intAt(SimpleParms.sleepTime);
        } else {
            myLogger = new StandaloneLogger();
        }
        StringBuffer sb = new StringBuffer();
        boolean foundJg = false;
        for (i = 0; i < jgNames.length; ++i) {
            String p = useHydra ? TestConfig.tab().stringAt(jgNamesKeys[i]) : System.getProperty(jgNames[i]);
            if (p == null || p.length() == 0) continue;
            foundJg = true;
            sb.append(p);
            if (i >= jgNames.length - 1) continue;
            sb.append(":");
        }
        if (!foundJg) {
            for (i = 0; i < jgDefaults.length; ++i) {
                sb.append(jgDefaults[i]);
                if (i >= jgDefaults.length - 1) continue;
                sb.append(":");
            }
        }
        String props = sb.toString();
        if (!useHydra) {
            SimpleClient.log().config("Jgroups configuration = " + props);
        }
        try {
            cacheAttr = new CacheAttributes();
            cacheAttr.setDistribute(true);
            String regionModifier = System.getProperty("regionModifier", "");
            JCache.init(cacheAttr);
            Attributes regionAttr = new Attributes();
            long flags = 1L;
            regionAttr.setFlags(flags);
            CacheAccess.defineRegion(REGION_NAME + regionModifier, regionAttr);
            ca = CacheAccess.getAccess(REGION_NAME + regionModifier, props);
            Assert.assertTrue((boolean)CacheAccess.isOpen());
            Vector vec = SimpleClient.createVector();
            SimpleClient.getOwnershipIfSync(ORDERS);
            ca.put(ORDERS, regionAttr, vec);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static Vector createVector() {
        Vector<Order> vec = new Vector<Order>();
        for (int j = 0; j < 10; ++j) {
            vec.addElement(new Order(String.valueOf(j), 34, new Date(), 34.5));
        }
        return vec;
    }

    public static void shutdown() {
        try {
            if (ca != null) {
                ca.close();
                ca = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static boolean replyRequested(String entryName) throws JCacheException {
        Attributes attrs = null;
        try {
            attrs = ca.getAttributes(entryName);
        }
        catch (JCacheException ex1) {
            attrs = ca.getAttributes();
        }
        return (attrs.getFlags() & 4L) > 0L;
    }

    public static void putOrders() {
        int sleepTime = sltime;
        long t3 = 0L;
        int timeOuts = 0;
        long start = System.currentTimeMillis();
        long end = start + 1000L * (long)duration;
        Attributes objAttr = new Attributes();
        long flags = 1L;
        objAttr.setFlags(flags);
        try {
            int i = 0;
            while (System.currentTimeMillis() < end) {
                try {
                    Vector vec = SimpleClient.createVector();
                    SimpleClient.getOwnershipIfSync(ORDERS);
                    if (ca.isPresent(ORDERS)) {
                        ca.destroy(ORDERS);
                    }
                    long t1 = System.currentTimeMillis();
                    ca.put(ORDERS, objAttr, vec);
                    long t2 = System.currentTimeMillis();
                    t3 += t2 - t1;
                    if (sleepTime > 0) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SimpleTestException("Failure during operation", ex);
                }
                finally {
                    try {
                        if (SimpleClient.replyRequested(ORDERS)) {
                            ca.waitForResponse(2000);
                        }
                    }
                    catch (JTimeoutException ex1) {
                        ++timeOuts;
                        ca.cancelResponse();
                    }
                    SimpleClient.releaseOwnershipIfSync(ORDERS);
                }
                ++i;
            }
            if (useHydra) {
                counters.add(SimpleBlackboard.NumEvents, i);
                counters.add(SimpleBlackboard.EventsElapsed, t3);
                counters.add(SimpleBlackboard.NumTimeOuts, timeOuts);
            } else {
                System.out.println("" + i + "\t" + t3 + "\t" + timeOuts);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SimpleTestException("failure during operation", ex);
        }
    }

    public static void replaceUnchangedOrders() {
        int sleepTime = sltime;
        long t3 = 0L;
        int timeOuts = 0;
        long start = System.currentTimeMillis();
        long end = start + 1000L * (long)duration;
        Attributes objAttr = new Attributes();
        long flags = 1L;
        objAttr.setFlags(flags);
        Vector vec = SimpleClient.createVector();
        try {
            ca.put(ORDERS, objAttr, vec);
        }
        catch (JCacheException jCacheException) {
            // empty catch block
        }
        try {
            int i = 0;
            while (System.currentTimeMillis() < end) {
                try {
                    SimpleClient.getOwnershipIfSync(ORDERS);
                    vec = (Vector)ca.get(ORDERS);
                    long t1 = System.currentTimeMillis();
                    ca.replace(ORDERS, vec);
                    long t2 = System.currentTimeMillis();
                    t3 += t2 - t1;
                    if (sleepTime > 0) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SimpleTestException("Failure during operation", ex);
                }
                finally {
                    try {
                        if (SimpleClient.replyRequested(ORDERS)) {
                            ca.waitForResponse(2000);
                        }
                    }
                    catch (JTimeoutException ex1) {
                        ++timeOuts;
                        ca.cancelResponse();
                    }
                    SimpleClient.releaseOwnershipIfSync(ORDERS);
                }
                ++i;
            }
            if (useHydra) {
                counters.add(SimpleBlackboard.NumEvents, i);
                counters.add(SimpleBlackboard.EventsElapsed, t3);
                counters.add(SimpleBlackboard.NumTimeOuts, timeOuts);
            } else {
                System.out.println("" + i + "\t" + t3 + "\t" + timeOuts);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static void replaceChangedOrders() {
        int sleepTime = sltime;
        long t3 = 0L;
        int timeOuts = 0;
        long start = System.currentTimeMillis();
        long end = start + 1000L * (long)duration;
        Attributes objAttr = new Attributes();
        long flags = 1L;
        objAttr.setFlags(flags);
        Vector vec = SimpleClient.createVector();
        try {
            ca.put(ORDERS, objAttr, vec);
        }
        catch (JCacheException jCacheException) {
            // empty catch block
        }
        try {
            int i = 0;
            while (System.currentTimeMillis() < end) {
                try {
                    vec = SimpleClient.createVector();
                    SimpleClient.getOwnershipIfSync(ORDERS);
                    long t1 = System.currentTimeMillis();
                    ca.replace(ORDERS, vec);
                    long t2 = System.currentTimeMillis();
                    t3 += t2 - t1;
                    if (sleepTime > 0) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SimpleTestException("failure during operation", ex);
                }
                finally {
                    try {
                        if (SimpleClient.replyRequested(ORDERS)) {
                            ca.waitForResponse(2000);
                        }
                    }
                    catch (JTimeoutException ex1) {
                        ca.cancelResponse();
                        ++timeOuts;
                    }
                    SimpleClient.releaseOwnershipIfSync(ORDERS);
                }
                ++i;
            }
            if (useHydra) {
                counters.add(SimpleBlackboard.NumEvents, i);
                counters.add(SimpleBlackboard.EventsElapsed, t3);
                counters.add(SimpleBlackboard.NumTimeOuts, timeOuts);
            } else {
                System.out.println("" + i + "\t" + t3 + "\t" + timeOuts);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SimpleTestException("failure during operation", ex);
        }
    }

    public static void getOrders() {
        int sleepTime = sltime;
        long t3 = 0L;
        long start = System.currentTimeMillis();
        long end = start + 1000L * (long)duration;
        try {
            int i = 0;
            while (System.currentTimeMillis() < end) {
                try {
                    long t1 = System.currentTimeMillis();
                    ca.get(ORDERS);
                    long t2 = System.currentTimeMillis();
                    t3 += t2 - t1;
                    if (sleepTime > 0) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SimpleTestException("failure during operation", ex);
                }
                ++i;
            }
            if (useHydra) {
                counters.add(SimpleBlackboard.NumEvents, i);
                counters.add(SimpleBlackboard.EventsElapsed, t3);
            } else {
                System.out.println("" + i + "\t" + t3);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SimpleTestException("failure during operation", ex);
        }
    }

    static boolean isSynchronized(String entryName) throws JCacheException {
        Attributes attrs = null;
        try {
            attrs = ca.getAttributes(entryName);
        }
        catch (JCacheException ex1) {
            attrs = ca.getAttributes();
        }
        return (attrs.getFlags() & 8L) > 0L;
    }

    static void getOwnership(String entryName) throws JCacheException {
        try {
            ca.getOwnership(entryName, 2000);
        }
        catch (JCacheException ex) {
            String s = "Could not get ownership of entry " + entryName + " within " + 2000 + " milliseconds.";
            throw new SimpleTestException(s, ex);
        }
    }

    static void getOwnershipIfSync(String entryName) throws JCacheException {
        if (SimpleClient.isSynchronized(entryName)) {
            SimpleClient.getOwnership(entryName);
        }
    }

    static void releaseOwnership(String entryName) throws JCacheException {
        try {
            ca.releaseOwnership(2000);
        }
        catch (JCacheException ex) {
            String s = "Could not release ownership of entry " + entryName + " within " + 2000 + " milliseconds.";
            throw new SimpleTestException(s, ex);
        }
    }

    static void releaseOwnershipIfSync(String entryName) throws JCacheException {
        if (SimpleClient.isSynchronized(entryName)) {
            SimpleClient.releaseOwnership(entryName);
        }
    }

    public static synchronized void createCacheTask() {
        Assert.assertTrue((boolean)useHydra);
        SimpleClient.log().info("initializing the cache...");
        SimpleClient.initialize();
        SimpleClient.log().info("Initialized the cache");
    }

    public static synchronized void closeCacheTask() {
        Assert.assertTrue((boolean)useHydra);
        SimpleClient.log().info("Closing the cache");
        SimpleClient.shutdown();
        SimpleClient.log().info("Closed the cache");
    }

    private static void runBenchmark(String task) {
        if (task == null || task.length() == 0) {
            task = "get";
        }
        if (task.equals("get")) {
            SimpleClient.getOrders();
        } else if (task.equals("put")) {
            SimpleClient.putOrders();
        } else if (task.equals("replaceChanged")) {
            SimpleClient.replaceChangedOrders();
        } else if (task.equals("replaceUnchanged")) {
            SimpleClient.replaceUnchangedOrders();
        } else {
            throw new SimpleTestException("Unknown task type = " + task);
        }
    }

    public static void runBenchmarkTask() {
        Assert.assertTrue((boolean)useHydra);
        String task = TestConfig.tab().stringAt(SimpleParms.task);
        SimpleClient.runBenchmark(task);
    }

    public static void printBlackboardsTask() {
        Assert.assertTrue((boolean)useHydra);
        SimpleBlackboard bb = SimpleBlackboard.getInstance();
        bb.printSharedCounters();
        String[] names = bb.getCounterNames();
        long[] counterValues = bb.getSharedCounters().getCounterValues();
        try {
            int i;
            File f;
            duration = TestConfig.tab().intAt(SimpleParms.duration);
            sltime = TestConfig.tab().intAt(SimpleParms.sleepTime);
            String summary = TestConfig.tab().stringAt(SimpleParms.summary);
            if (summary == null || summary.length() == 0) {
                summary = "results.tsv";
            }
            boolean needHeader = !(f = new File(summary)).exists();
            FileOutputStream os = new FileOutputStream(f, true);
            PrintStream ps = new PrintStream(os);
            if (needHeader) {
                int i2;
                ps.print("Date\t");
                ps.print("duration\tsleepTime\tnumVM\tnumThreads\t");
                for (i2 = 0; i2 < names.length; ++i2) {
                    ps.print(names[i2]);
                    ps.print("\t");
                }
                for (i2 = 0; i2 < jgNames.length; ++i2) {
                    ps.print(jgNames[i2]);
                    if (i2 >= jgNames.length - 1) continue;
                    ps.print("\t");
                }
                ps.println();
            }
            long numVM = TestConfig.tab().longAt(ClientPrms.vmQuantities);
            long numThreads = TestConfig.tab().longAt(ClientPrms.vmThreads);
            SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
            String now = df.format(new Date());
            ps.print(now + "\t" + duration + "\t" + sltime + "\t" + numVM + "\t" + numThreads + "\t");
            for (i = 0; i < names.length; ++i) {
                ps.print(counterValues[i]);
                ps.print("\t");
            }
            for (i = 0; i < jgNames.length; ++i) {
                String val = TestConfig.tab().stringAt(jgNamesKeys[i]);
                ps.print(val);
                if (i >= jgNames.length - 1) continue;
                ps.print("\t");
            }
            ps.println();
            ps.close();
        }
        catch (Exception e) {
            throw new SimpleTestException("Error writing stats: ", e);
        }
    }

    private static LogWriter log() {
        if (useHydra) {
            return Log.getLogWriter();
        }
        return myLogger;
    }

    public static void main(String[] args) {
        String task = args[0];
        duration = Integer.parseInt(args[1]);
        sltime = Integer.parseInt(args[2]);
        useHydra = false;
        SimpleClient.initialize();
        SimpleClient.runBenchmark(task);
        SimpleClient.shutdown();
    }

    static {
        ORDERS = "MyVec";
        REGION_NAME = System.getProperty("regionName", "OrderTest");
        jgNames = new String[]{"jg1", "jg2", "jg3", "jg4", "jg5", "jg6", "jg7", "jg8", "jg9", "jg10", "jg11"};
        jgNamesKeys = new Long[]{SimpleParms.jg1, SimpleParms.jg2, SimpleParms.jg3, SimpleParms.jg4, SimpleParms.jg5, SimpleParms.jg6, SimpleParms.jg7, SimpleParms.jg8, SimpleParms.jg9, SimpleParms.jg10, SimpleParms.jg11};
        jgDefaults = new String[]{"UDP(ip_mcast=true;mcast_port=16385;use_packet_handler=false;mcast_addr=224.0.0.0;ip_ttl=32)", "PING(timeout=1000;num_initial_members=2)", "FD_SOCK(start_port=0)", "VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false)", "pbcast.NAKACK(max_xmit_size=4096;down_thread=false;gc_lag=50;up_thread=false;retransmit_timeout=300,600,1200,2400,4800)", "UNICAST(timeout=5000;down_thread=false)", "pbcast.STABLE(desired_avg_gossip=20000;down_thread=false;up_thread=false)", "FRAG(frag_size=4096;down_thread=false;up_thread=false)", "pbcast.GMS(print_local_addr=false;join_timeout=5000;join_retry_timeout=2000;shun=false)", "pbcast.STATE_TRANSFER(down_thread=false;up_thread=false)"};
    }

    static class StandaloneLogger
    implements LogWriter {
        StandaloneLogger() {
        }

        public boolean severeEnabled() {
            return true;
        }

        public void severe(String msg, Throwable ex) {
            System.out.println("[severe] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void severe(String msg) {
            System.out.println("[severe] " + msg);
        }

        public void severe(Throwable ex) {
            System.out.println("[severe] " + ex.toString());
            ex.printStackTrace();
        }

        public boolean errorEnabled() {
            return true;
        }

        public void error(String msg, Throwable ex) {
            System.out.println("[error] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void error(String msg) {
            System.out.println("[error] " + msg);
        }

        public void error(Throwable ex) {
            System.out.println("[error] " + ex.toString());
            ex.printStackTrace();
        }

        public boolean warningEnabled() {
            return true;
        }

        public void warning(String msg, Throwable ex) {
            System.out.println("[warning] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void warning(String msg) {
            System.out.println("[warning] " + msg);
        }

        public void warning(Throwable ex) {
            System.out.println("[warning] " + ex.toString());
            ex.printStackTrace();
        }

        public boolean infoEnabled() {
            return true;
        }

        public void info(String msg, Throwable ex) {
            System.out.println("[info] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void info(String msg) {
            System.out.println("[info] " + msg);
        }

        public void info(Throwable ex) {
            System.out.println("[info] " + ex.toString());
            ex.printStackTrace();
        }

        public boolean configEnabled() {
            return true;
        }

        public void config(String msg, Throwable ex) {
            System.out.println("[config] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void config(String msg) {
            System.out.println("[config] " + msg);
        }

        public void config(Throwable ex) {
            System.out.println("[config] " + ex.toString());
            ex.printStackTrace();
        }

        public boolean fineEnabled() {
            return true;
        }

        public void fine(String msg, Throwable ex) {
            System.out.println("[fine] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void fine(String msg) {
            System.out.println("[fine] " + msg);
        }

        public void fine(Throwable ex) {
            System.out.println("[fine] " + ex.toString());
            ex.printStackTrace();
        }

        public boolean finerEnabled() {
            return true;
        }

        public void finer(String msg, Throwable ex) {
            System.out.println("[finer] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void finer(String msg) {
            System.out.println("[finer] " + msg);
        }

        public void finer(Throwable ex) {
            System.out.println("[finer] " + ex.toString());
            ex.printStackTrace();
        }

        public void entering(String sourceClass, String sourceMethod) {
        }

        public void exiting(String sourceClass, String sourceMethod) {
        }

        public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        }

        public boolean finestEnabled() {
            return true;
        }

        public void finest(String msg, Throwable ex) {
            System.out.println("[finest] " + msg + " " + ex.toString());
            ex.printStackTrace();
        }

        public void finest(String msg) {
            System.out.println("[finest] " + msg);
        }

        public void finest(Throwable ex) {
            System.out.println("[finest] " + ex.toString());
            ex.printStackTrace();
        }

        public Handler getHandler() {
            return null;
        }

        public void config(StringId msgId, Object param, Throwable ex) {
        }

        public void config(StringId msgId, Object param) {
        }

        public void config(StringId msgId, int i) {
        }

        public void config(StringId msgId, Object[] params, Throwable ex) {
        }

        public void config(StringId msgId, Object[] params) {
        }

        public void config(StringId msgId, Throwable ex) {
        }

        public void config(StringId msgId) {
        }

        public void error(StringId msgId, Object param, Throwable ex) {
        }

        public void error(StringId msgId, Object param) {
        }

        public void error(StringId msgId, Object[] params, Throwable ex) {
        }

        public void error(StringId msgId, Object[] params) {
        }

        public void error(StringId msgId, Throwable ex) {
        }

        public void error(StringId msgId) {
        }

        public void error(StringId msgId, int i) {
        }

        public void info(StringId msgId, Object param, Throwable ex) {
        }

        public void info(StringId msgId, Object param) {
        }

        public void info(StringId msgId, Object[] params, Throwable ex) {
        }

        public void info(StringId msgId, Object[] params) {
        }

        public void info(StringId msgId, Throwable ex) {
        }

        public void info(StringId msgId, int i) {
        }

        public void info(StringId msgId) {
        }

        public void severe(StringId msgId, Object param, Throwable ex) {
        }

        public void severe(StringId msgId, Object param) {
        }

        public void severe(StringId msgId, Object[] params, Throwable ex) {
        }

        public void severe(StringId msgId, Object[] params) {
        }

        public void severe(StringId msgId, Throwable ex) {
        }

        public void severe(StringId msgId, int i) {
        }

        public void severe(StringId msgId) {
        }

        public void warning(StringId msgId, Object param, Throwable ex) {
        }

        public void warning(StringId msgId, Object param) {
        }

        public void warning(StringId msgId, Object[] params, Throwable ex) {
        }

        public void warning(StringId msgId, Object[] params) {
        }

        public void warning(StringId msgId, Throwable ex) {
        }

        public void warning(StringId msgId, int i, Throwable ex) {
        }

        public void warning(StringId msgId, int i) {
            this.warning(msgId, i, (Throwable)null);
        }

        public void warning(StringId msgId) {
        }

        public LogWriter convertToLegacyLogWriter() {
            return this;
        }

        public LogWriterI18n convertToLogWriterI18n() {
            throw new UnsupportedOperationException("Cannot convert this LogWriter to LogWriterI18n");
        }
    }
}

