/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.simple.cache;

import java.io.Serializable;
import org.jgroups.simple.cache.CacheEventListener;
import org.jgroups.simple.cache.CacheLoader;
import org.jgroups.simple.cache.InvalidArgumentException;

public class Attributes
implements Cloneable,
Serializable {
    public static final long DISTRIBUTE = 1L;
    public static final long NOFLUSH = 2L;
    public static final long REPLY = 4L;
    public static final long SYNCHRONIZE = 8L;
    public static final long SPOOL = 16L;
    public static final long ORIGINAL = 32L;
    private long flags;
    private long timeToLive;
    private long defaultTimeToLive;
    private long idleTime;
    private int objSize;
    private long lastUpdateTime = System.currentTimeMillis();
    private CacheLoader loader;
    private CacheEventListener listener;
    private long version;

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
        this.checkLoader();
        this.checkListener();
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void setDefaultTimeToLive(long ttl) {
        this.defaultTimeToLive = ttl;
    }

    public void setIdleTime(long idle) {
        this.idleTime = idle;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void setListener(CacheEventListener l) {
        this.listener = l;
        this.checkListener();
    }

    public void setSize(int size) {
        this.objSize = size;
    }

    public int getSize() {
        return this.objSize;
    }

    public boolean isSet(long theFlags) {
        return (this.flags & theFlags) != 0L;
    }

    public long getCreateTime() {
        return this.lastUpdateTime;
    }

    public CacheLoader getLoader() {
        return this.loader;
    }

    protected CacheEventListener getListener() {
        return this.listener;
    }

    public void setLoader(CacheLoader l) {
        this.loader = l;
        this.checkLoader();
    }

    public long getVersion() {
        return this.version;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    protected void setLastUpdateTime(long t) {
        this.lastUpdateTime = t;
    }

    public long timeToSeconds(int days, int hours, int minutes, int seconds) throws InvalidArgumentException {
        long l = (long)seconds * 1000L;
        l += (long)minutes * 60000L;
        l += (long)hours * 3600000L;
        return l += (long)days * 86400000L;
    }

    protected final boolean isDistributed() {
        return (this.flags & 1L) == 1L;
    }

    protected final void valueUpdated() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    protected void resetAttributes(Attributes other) {
    }

    public final Object clone() {
        Attributes attr = new Attributes();
        attr.setFlags(this.flags);
        attr.setTimeToLive(this.timeToLive);
        attr.setDefaultTimeToLive(this.defaultTimeToLive);
        attr.setIdleTime(this.idleTime);
        attr.setSize(this.objSize);
        attr.setLastUpdateTime(this.lastUpdateTime);
        attr.setLoader(this.loader);
        attr.setListener(this.listener);
        attr.setVersion(this.version);
        return attr;
    }

    public String toString() {
        return "flags: " + this.flagsToString() + "\ntimeToLive: " + this.timeToLive + "  idleTime: " + this.idleTime + "\nsize: " + this.objSize + "  age: " + (System.currentTimeMillis() - this.lastUpdateTime);
    }

    private String flagsToString() {
        StringBuffer b = new StringBuffer();
        if ((this.flags & 1L) != 0L) {
            b.append("DISTR ");
        }
        if ((this.flags & 2L) != 0L) {
            b.append("NOFLUSH ");
        }
        if ((this.flags & 8L) != 0L) {
            b.append("SYNCH ");
        }
        if ((this.flags & 4L) != 0L) {
            b.append("REPLY ");
        }
        if ((this.flags & 0x20L) != 0L) {
            b.append("ORIG ");
        }
        if ((this.flags & 0x10L) != 0L) {
            b.append("SPOOL ");
        }
        return b.toString();
    }

    private void checkLoader() {
    }

    private void checkListener() {
    }
}

