/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.simple.cache;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.ChannelFactory;
import com.gemstone.org.jgroups.JChannelFactory;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.View;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.jgroups.simple.cache.Attributes;
import org.jgroups.simple.cache.CacheEntry;
import org.jgroups.simple.cache.CacheEvent;
import org.jgroups.simple.cache.CacheEventListener;
import org.jgroups.simple.cache.CacheLoader;
import org.jgroups.simple.cache.CacheNotAvailableException;
import org.jgroups.simple.cache.CacheObjectInfo;
import org.jgroups.simple.cache.InvalidHandleException;
import org.jgroups.simple.cache.JCacheException;
import org.jgroups.simple.cache.NullObjectNameException;
import org.jgroups.simple.cache.ObjectExistsException;
import org.jgroups.simple.cache.ObjectNotFoundException;

public class CacheAccess
implements Runnable {
    private static CacheAccess instance;
    private static Channel jgroups;
    private static Attributes regionAttr;
    private static final int PUT_OPERATION = 0;
    private static final int DESTROY_OPERATION = 1;
    private Channel jchannel;
    private Thread readerThread;
    private volatile boolean shutdown;
    private static String groupname;
    private Map localm;
    private boolean closed;
    private boolean trace;
    private boolean usemcast = Boolean.getBoolean("usemcast");

    public static CacheAccess getDefault() {
        return instance;
    }

    public static boolean isOpen() {
        if (instance == null) {
            System.out.println("CacheAcces.isOpen: no instances");
            return false;
        }
        Channel ch = CacheAccess.instance.jchannel;
        if (ch == null) {
            System.out.println("CacheAccess.isOpen: no channel");
            return false;
        }
        if (!ch.isOpen()) {
            System.out.println("CacheAccess.isOpen: channel not open");
            return false;
        }
        if (!ch.isConnected()) {
            System.out.println("CacheAccess.isOpen: channel not connected");
            return false;
        }
        return true;
    }

    public void contentsSet(Map new_entries) {
        this.localm = new_entries;
    }

    public static void defineRegion(String regionName, Attributes attr) throws ObjectExistsException, NullObjectNameException, CacheNotAvailableException {
        regionAttr = attr;
        groupname = regionName;
    }

    public static CacheAccess getAccess(String regionName, String props) throws JCacheException {
        groupname = regionName;
        boolean trace = Boolean.getBoolean("trace");
        JChannelFactory factory = new JChannelFactory();
        instance = new CacheAccess();
        instance.start((ChannelFactory)factory, props, trace);
        return instance;
    }

    public void close() throws JCacheException {
        if (!this.closed) {
            this.closed = true;
            this.stopReader();
            this.jchannel.close();
        }
    }

    public Object get(Object name) throws JCacheException {
        return this.get(name, null);
    }

    public Object get(Object name, Object args) throws JCacheException {
        CacheEntry ce = null;
        ce = (CacheEntry)this.localm.get(name);
        if (ce != null) {
            if (ce.isValid()) {
                return ce.getValue();
            }
            if (this.trace) {
                System.out.println("Found invalid entry for '" + name + "'");
            }
        }
        CacheLoader cl = null;
        cl = ce == null || ce.getAttributes().getLoader() == null ? regionAttr.getLoader() : ce.getAttributes().getLoader();
        if (cl != null) {
            Object loadedObj;
            if (ce == null) {
                ce = new CacheEntry(name, (Attributes)regionAttr.clone());
            }
            if (this.trace) {
                System.out.println("Invoking loader for '" + name + "'");
            }
            if ((loadedObj = cl.load(ce, args)) != null) {
                ce.setValue(loadedObj);
                this.localm.put(name, ce);
                if (ce.getAttributes().isDistributed()) {
                    this.distributePut(name, loadedObj);
                }
                return loadedObj;
            }
        }
        throw new ObjectNotFoundException();
    }

    public void put(Object name, Object value) throws JCacheException {
        this.put(name, (Attributes)regionAttr.clone(), value);
    }

    public void put(Object name, Attributes attr, Object value) throws JCacheException {
        this.replace(name, attr, value);
    }

    public void replace(Object name, Object value) throws JCacheException {
        this.replace(name, null, value);
    }

    private void replace(Object name, Attributes attr, Object value) throws JCacheException {
        if (this.localm.containsKey(name)) {
            CacheEntry ce = (CacheEntry)this.localm.get(name);
            ce.setValue(value);
            if (this.trace) {
                System.out.println("replacing object '" + name + "' attributes:" + ce.getAttributes());
            }
            if (ce.getAttributes().isDistributed()) {
                this.distributePut(name, value);
            }
        } else {
            if (attr == null) {
                attr = (Attributes)regionAttr.clone();
            }
            CacheEntry ce = new CacheEntry(name, attr, value);
            if (this.trace) {
                System.out.println("adding object '" + name + "' attributes:" + attr);
            }
            this.localm.put(name, ce);
            if (attr.isDistributed()) {
                this.distributePut(name, value);
            }
        }
    }

    public void invalidate() throws JCacheException {
    }

    public void invalidate(Object name) throws JCacheException {
        CacheEntry ce = (CacheEntry)this.localm.get(name);
        if (ce != null) {
            if (this.trace) {
                System.out.println("invalidating local object '" + name + "'");
            }
            ce.invalidate();
            if (ce.getAttributes().isDistributed()) {
                this.distributePut(name, null);
            }
        } else {
            throw new ObjectNotFoundException();
        }
    }

    public void defineObject(Object name, Attributes attr) throws JCacheException {
        if (this.localm.containsKey(name)) {
            throw new ObjectExistsException();
        }
        if (attr == null) {
            attr = (Attributes)regionAttr.clone();
        }
        CacheEntry ce = new CacheEntry(name, attr);
        if (this.trace) {
            System.out.println("defining object '" + name + "' attributes:" + attr);
        }
        this.localm.put(name, ce);
        if (attr.isDistributed()) {
            this.distributePut(name, null);
        }
    }

    private void distributePut(Object name, Object value) throws JCacheException {
        try {
            if (this.usemcast) {
                this.jchannel.send((Address)null, this.jchannel.getLocalAddress(), (Serializable)new Object[]{new Integer(0), name, value});
            } else {
                View v = this.jchannel.getView();
                Vector mbrs = v.getMembers();
                Address myAddr = this.jchannel.getLocalAddress();
                Message m = new Message((Address)null, this.jchannel.getLocalAddress(), (Serializable)new Object[]{new Integer(0), name, value});
                for (int i = mbrs.size() - 1; i >= 0; --i) {
                    Address dest = (Address)mbrs.get(i);
                    if (dest.equals(myAddr)) continue;
                    m.setDest(dest);
                    this.jchannel.send(m);
                }
            }
        }
        catch (Exception e) {
            throw new JCacheException("Unable to distributed put operation", e);
        }
    }

    private void distributeDestroy(Object name) throws JCacheException {
        try {
            this.jchannel.send((Address)null, this.jchannel.getLocalAddress(), (Serializable)new Object[]{new Integer(1), name});
        }
        catch (Exception e) {
            throw new JCacheException("Unable to distributed put operation", e);
        }
    }

    public void destroy(Object name) throws JCacheException {
        CacheEntry ce = (CacheEntry)this.localm.get(name);
        if (ce != null) {
            if (this.trace) {
                System.out.println("destroying object '" + name + "'");
            }
        } else {
            throw new ObjectNotFoundException();
        }
        this.localm.remove(name);
        this.distributeDestroy(name);
    }

    public void waitForResponse(int timeout) throws JCacheException {
    }

    public void cancelResponse() throws JCacheException {
    }

    public void getOwnership(Object name, int timeout) throws JCacheException {
    }

    public void releaseOwnership(int timeout) throws JCacheException {
    }

    public void releaseOwnership(Object name, int timeout) throws JCacheException {
    }

    public void resetAttributes(Attributes attr) throws JCacheException {
        regionAttr = attr;
    }

    public void resetAttributes(Object name, Attributes attr) throws JCacheException, InvalidHandleException {
        CacheEntry ce = (CacheEntry)this.localm.get(name);
        if (ce == null) {
            throw new ObjectNotFoundException();
        }
        ce.getAttributes().resetAttributes(attr);
    }

    public Attributes getAttributes() throws JCacheException {
        return (Attributes)regionAttr.clone();
    }

    public Attributes getAttributes(Object name) throws JCacheException {
        CacheEntry ce = (CacheEntry)this.localm.get(name);
        if (ce != null) {
            return (Attributes)ce.getAttributes().clone();
        }
        throw new ObjectNotFoundException();
    }

    public void save() {
    }

    public void preLoad(Object name) {
        try {
            this.get(name);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPresent(Object name) {
        CacheEntry ce = (CacheEntry)this.localm.get(name);
        if (ce != null) {
            return ce.isValid();
        }
        return false;
    }

    protected Hashtable getCombinedView() {
        Hashtable<Object, CacheObjectInfo> t = new Hashtable<Object, CacheObjectInfo>();
        for (CacheEntry cacheEntry : this.localm.entrySet()) {
            t.put(cacheEntry.getName(), cacheEntry.getInfo());
        }
        return t;
    }

    private void startReader() {
        Thread readerThread = new Thread(this);
        readerThread.setDaemon(true);
        readerThread.setName("jgroups reader thread");
        readerThread.start();
    }

    private void stopReader() {
        if (this.readerThread != null && this.readerThread.isAlive()) {
            this.shutdown = true;
            try {
                this.readerThread.join(20000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            this.readJGroupsMessage();
            if (!Thread.currentThread().isInterrupted()) continue;
            this.shutdown = true;
            System.out.println("shutting down jchannel thread due to interrupt");
        }
    }

    private void readJGroupsMessage() {
        try {
            Object obj = this.jchannel.receive(5000L);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (obj != null && obj instanceof Message) {
                this.processMessage((Message)obj);
            }
        }
        catch (TimeoutException obj) {
        }
        catch (ChannelClosedException cl) {
            this.shutdown = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processMessage(Message m) {
        if (m.getSrc().equals(this.jchannel.getLocalAddress())) {
            return;
        }
        Object[] payload = (Object[])m.getObject();
        switch ((Integer)payload[0]) {
            case 0: {
                CacheEntry ce;
                if (this.trace) {
                    System.out.println("distributed put(" + payload[1] + "," + payload[2]);
                }
                if ((ce = (CacheEntry)this.localm.get(payload[1])) == null) {
                    ce = new CacheEntry(payload[1], (Attributes)regionAttr.clone());
                    ce.setValue(payload[2]);
                    this.localm.put(payload[1], ce);
                } else {
                    ce.setValue(payload[2]);
                }
                CacheEventListener l = ce.getAttributes().getListener();
                if (l == null) break;
                try {
                    if (this.trace) {
                        System.out.println("invoking listener");
                    }
                    l.handleEvent(new CacheEvent(ce.isValid() ? 2 : 1));
                }
                catch (Throwable t) {
                    System.err.println("Error in applying distributed Put");
                    t.printStackTrace();
                }
                break;
            }
            case 1: {
                CacheEventListener l;
                CacheEntry ce = (CacheEntry)this.localm.remove(payload[1]);
                if (ce == null || (l = ce.getAttributes().getListener()) == null) break;
                try {
                    l.handleEvent(new CacheEvent(3));
                }
                catch (Throwable t) {
                    System.err.println("Error in applying distributed Put");
                    t.printStackTrace();
                }
                break;
            }
            default: {
                System.err.println("Unknown message type: " + payload[0]);
            }
        }
    }

    private void start(ChannelFactory factory, String props, boolean trace) {
        this.trace = trace;
        try {
            this.jchannel = factory.createChannel((Object)props);
            this.jchannel.connect("bcache");
            this.startReader();
        }
        catch (ChannelException ce) {
            throw new RuntimeException("error initializing jgroups", ce);
        }
        this.localm = new HashMap();
        if (regionAttr == null) {
            regionAttr = new Attributes();
        }
        int tries = 0;
        while (!this.jchannel.isConnected()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            if (++tries <= 4) continue;
            System.err.println("warning: jgroups channel still not connected after " + tries + " seconds");
            break;
        }
    }

    public void entrySet(Object key, Object value) {
        Attributes attr;
        CacheEntry ce = (CacheEntry)this.localm.get(key);
        if (ce != null && (attr = ce.getAttributes()).isDistributed()) {
            if (this.trace) {
                System.out.println("Update received for " + key);
            }
            ce.setValue(value);
            if (attr.getListener() != null) {
                try {
                    attr.getListener().handleEvent(new CacheEvent(ce.isValid() ? 2 : 1));
                }
                catch (Exception e) {
                    System.err.println("event listener error:");
                    e.printStackTrace();
                }
            }
        } else if (this.trace) {
            System.out.println("Ignoring update for non-referenced object '" + key + "'");
        }
    }

    public void entryRemoved(Object key) {
    }

    public void viewChange(Vector joined, Vector left) {
        if (this.trace) {
            System.out.println("New members: " + joined + ", left members: " + left);
        }
    }

    static {
        groupname = "GFCache";
    }
}

