/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegCreateDestroy;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import parReg.colocation.Month;
import parReg.execute.PartitionObjectHolder;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import util.PRObserver;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class ColocationAndEvictionTest
extends ParRegCreateDestroy {
    private ArrayList errorMsgs = new ArrayList();
    private ArrayList errorException = new ArrayList();
    protected static final int ENTRIES_TO_PUT = 50;
    protected static final int HEAVY_OBJECT_SIZE_VAL = 500;
    private static ArrayList bucketsInTheDataStore;
    private static String bucketReferenceRegion;
    private static ArrayList primaryBucketsInTheDataStore;
    private static String primaryBucketReferenceRegion;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize();
            testInstance = new ColocationAndEvictionTest();
            testInstance.initialize();
        }
        Log.getLogWriter().info("isBridgeConfiguration: " + isBridgeConfiguration);
        Log.getLogWriter().info("isBridgeClient: " + isBridgeClient);
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new ColocationAndEvictionTest();
            ((ColocationAndEvictionTest)testInstance).initialize();
            BridgeHelper.startBridgeServer("bridge");
        }
        isBridgeClient = false;
        Log.getLogWriter().info("isBridgeConfiguration: " + isBridgeConfiguration);
        Log.getLogWriter().info("isBridgeClient: " + isBridgeClient);
    }

    public static void HydraTask_populateRegions() {
        ((ColocationAndEvictionTest)testInstance).doPopulate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_createRegionsAndPopulate() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        try {
            do {
                ((ColocationAndEvictionTest)testInstance).doCreateRegionsOnly();
                ((ColocationAndEvictionTest)testInstance).doPopulate();
            } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        }
        finally {
            if (isBridgeConfiguration) {
                for (Region r : theCache.rootRegions()) {
                    ClientHelper.release(r);
                }
            }
        }
    }

    public static void HydraTask_createBridgeServerRegions() {
        Region aRegion = null;
        String regionDescriptName = null;
        for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
            regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
            System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            try {
                aRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
                Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
                continue;
            }
            catch (RegionExistsException e) {
                Log.getLogWriter().info("Using existing partitioned region " + regionName);
                aRegion = e.getRegion();
                if (aRegion != null) continue;
                throw new TestException("RegionExistsException.getRegion returned null");
            }
        }
    }

    public static void HydraTask_dumpBuckets() {
        ((ColocationAndEvictionTest)testInstance).dumpAllTheBuckets();
    }

    public static void HydraTask_verifyColocatedRegions() {
        ((ColocationAndEvictionTest)testInstance).HydraTask_verifyCustomPartitioning();
        ((ColocationAndEvictionTest)testInstance).HydraTask_verifyCoLocation();
    }

    public static void HydraTask_verifyColocatedRegionsWhenOneNodeDown() {
        MasterController.sleepForMs(90000);
        ((ColocationAndEvictionTest)testInstance).HydraTask_verifyCustomPartitioningWhenOneNodeDown();
        ((ColocationAndEvictionTest)testInstance).HydraTask_verifyCoLocation();
    }

    public synchronized void HydraTask_verifyCustomPartitioning() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyCustomPartitioning(pr);
        }
    }

    protected void HydraTask_verifyCoLocation() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            int index;
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyPrimaryBucketCoLocation(pr);
            this.verifyBucketCoLocation(pr);
            if (this.errorMsgs.size() != 0) {
                for (index = 0; index < this.errorMsgs.size(); ++index) {
                    Log.getLogWriter().error((String)this.errorMsgs.get(index));
                }
            }
            if (this.errorException.size() == 0 || (index = 0) >= this.errorException.size()) continue;
            throw (TestException)this.errorException.get(index);
        }
    }

    public synchronized void HydraTask_verifyCustomPartitioningWhenOneNodeDown() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyCustomPartitioningWhenOneNodeDown(pr);
        }
    }

    public static void HydraTask_verifyPRWhenOneNodeDown() {
        ((ColocationAndEvictionTest)testInstance).verifyPRWhenOneNodeDown();
    }

    public static void HydraTask_killVMs() {
        ((ColocationAndEvictionTest)testInstance).killVms();
    }

    public void dumpAllTheBuckets() {
        try {
            for (int i = 0; i < regionDescriptNames.size(); ++i) {
                String regionDescriptName = (String)regionDescriptNames.get(i);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                PartitionedRegion pr = (PartitionedRegion)aRegion;
                pr.dumpAllBuckets(false, Log.getLogWriter().convertToLogWriterI18n());
            }
        }
        catch (ReplyException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not dumping data stores on region  because it is not a PartitionedRegion (probably because it's a region  from a bridge client");
        }
    }

    public static void HydraTask_verifyOverflowToDisk() {
        ((ColocationAndEvictionTest)testInstance).verifyOverflowToDisk();
    }

    public static void HydraTask_verifyMemLRU() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            ColocationAndEvictionTest.verifyMemLRU(pr);
        }
    }

    public static void HydraTask_verifyEvictionFairness() {
        ColocationAndEvictionTest.verifyEvictionBucketFairness();
    }

    public static void HydraTask_verifyEvictionLocalDestroy() {
        ((ColocationAndEvictionTest)testInstance).verifyEvictionLocalDestroy();
    }

    public static void HydraTask_verifyPR() {
        ((ColocationAndEvictionTest)testInstance).verifyPR();
    }

    private void doPopulate() {
        if (isBridgeConfiguration && !isBridgeClient) {
            Log.getLogWriter().info("Inside bridge server");
            this.doPopulateRegions(bridgeRegionDescriptNames);
        } else if (isBridgeConfiguration) {
            this.doPopulateRegions(regionDescriptNames);
        } else {
            long numOfAccessors = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfAccessors);
            if (numOfAccessors > TestConfig.tab().longAt(ParRegPrms.numberOfAccessors, 0L)) {
                Iterator iterator = regionDescriptNames.iterator();
                ArrayList<String> nonAccessorRegionDescriptNames = new ArrayList<String>();
                while (iterator.hasNext()) {
                    String regionDescription = (String)iterator.next();
                    if (regionDescription.startsWith("aRegion")) continue;
                    nonAccessorRegionDescriptNames.add(regionDescription);
                }
                this.doPopulateRegions(nonAccessorRegionDescriptNames);
            } else {
                Iterator iterator = regionDescriptNames.iterator();
                ArrayList<String> accessorRegionDescriptNames = new ArrayList<String>();
                while (iterator.hasNext()) {
                    String regionDescription = (String)iterator.next();
                    if (!regionDescription.startsWith("aRegion")) continue;
                    accessorRegionDescriptNames.add(regionDescription);
                }
                this.doPopulateRegions(accessorRegionDescriptNames);
            }
        }
    }

    public void doCreateAndPopulateRegions(List regionDescriptNames) {
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            Region aRegion;
            block4: {
                String regionDescriptName = (String)regionDescriptNames.get(j);
                System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
                String poolName = attributes.getPoolName();
                if (poolName != null) {
                    PoolHelper.createPool(poolName);
                }
                try {
                    aRegion = theCache.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
                    Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
                }
                catch (RegionExistsException e) {
                    Log.getLogWriter().info("Using existing partitioned region " + regionName);
                    aRegion = e.getRegion();
                    if (aRegion != null) break block4;
                    throw new TestException("RegionExistsException.getRegion returned null");
                }
            }
            this.populateRegion(aRegion);
        }
    }

    public void doPopulateRegions(List regionDescriptNames) {
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            Region aRegion;
            block4: {
                String regionDescriptName = (String)regionDescriptNames.get(j);
                System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
                String poolName = attributes.getPoolName();
                if (poolName != null) {
                    PoolHelper.createPool(poolName);
                }
                try {
                    aRegion = theCache.getRegion(regionName);
                    Log.getLogWriter().info("Got partitioned region " + regionName + " from cache with region descript name " + regionDescriptName);
                }
                catch (RegionExistsException e) {
                    Log.getLogWriter().info("Using existing partitioned region " + regionName);
                    aRegion = e.getRegion();
                    if (aRegion != null) break block4;
                    throw new TestException("RegionExistsException.getRegion returned null");
                }
            }
            this.populateRegion(aRegion);
        }
    }

    public void populateRegion(Region aRegion) {
        Log.getLogWriter().info("Putting 50 entries into " + aRegion.getFullPath());
        for (int i = 1; i <= 50; ++i) {
            String errStr;
            try {
                Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                String keyName = aRegion.getName() + " " + System.currentTimeMillis();
                PartitionObjectHolder key = new PartitionObjectHolder(keyName, callBackArg);
                if (TestConfig.tab().booleanAt(ParRegPrms.isEvictionTest, false)) {
                    byte[] newVal = new byte[250000];
                    Integer keyObject = new Integer((int)ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations));
                    aRegion.put((Object)keyObject, (Object)newVal);
                } else {
                    aRegion.put((Object)key, (Object)new Integer(i), (Object)callBackArg);
                }
                MasterController.sleepForMs(10);
                continue;
            }
            catch (RegionDestroyedException e) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + " while putting into " + aRegion.getFullPath() + "; continuing test");
                break;
            }
            catch (PartitionedRegionStorageException e) {
                errStr = e.toString();
                if (errStr.indexOf(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString()) >= 0 || errStr.indexOf(PRHARedundancyProvider.TIMEOUT_MSG.toLocalizedString()) >= 0) {
                    Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + " while putting into " + aRegion.getFullPath() + "; continuing test");
                    break;
                }
                throw e;
            }
            catch (CacheWriterException e) {
                if (isBridgeClient) {
                    errStr = e.toString();
                    if (errStr.indexOf("Either the specified region, key or value was invalid. ") >= 0 || errStr.indexOf("The BridgeWriter has been closed") >= 0 || errStr.indexOf(PRHARedundancyProvider.TIMEOUT_MSG.toLocalizedString()) >= 0 || errStr.indexOf("was not found during put request") >= 0 || errStr.indexOf("RegionDestroyedException") >= 0) {
                        Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + " while putting into " + aRegion.getFullPath() + "; continuing test");
                        break;
                    }
                    if (errStr.indexOf("Failed to put entry") >= 0) {
                        throw new TestException("Bug 37120 detected: " + TestHelper.getStackTrace(e));
                    }
                    throw e;
                }
                throw e;
            }
        }
    }

    protected void verifyCustomPartitioning(PartitionedRegion aRegion) {
        PartitionedRegion pr = aRegion;
        int totalBuckets = pr.getTotalNumberOfBuckets();
        RegionAttributes attr = aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        int redundantCopies = prAttr.getRedundantCopies();
        int expectedNumCopies = redundantCopies + 1;
        int verifyBucketCopiesBucketId = 0;
        while (verifyBucketCopiesBucketId < totalBuckets) {
            Log.getLogWriter().info("Verifying data for bucket id " + verifyBucketCopiesBucketId + " out of " + totalBuckets + " buckets");
            List listOfMaps = null;
            try {
                listOfMaps = pr.getAllBucketEntries(verifyBucketCopiesBucketId);
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            int size = listOfMaps.size();
            if (size == 0) {
                Log.getLogWriter().info("Bucket " + verifyBucketCopiesBucketId + " is empty");
                ++verifyBucketCopiesBucketId;
                continue;
            }
            if (size != expectedNumCopies) {
                this.errorMsgs.add("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size());
                this.errorException.add(new TestException("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size()));
            } else {
                Log.getLogWriter().info("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, and have " + listOfMaps.size());
            }
            Log.getLogWriter().info("Validating co-location for all the redundant copies of the bucket with Id : " + verifyBucketCopiesBucketId);
            for (int i = 0; i < listOfMaps.size(); ++i) {
                BucketDump dump = (BucketDump)listOfMaps.get(i);
                Map map = dump.getValues();
                this.verifyCustomPartition(map, verifyBucketCopiesBucketId);
                this.verifyUniqueBucketForCustomPartioning(verifyBucketCopiesBucketId);
            }
            ++verifyBucketCopiesBucketId;
        }
    }

    protected void verifyCustomPartitioningWhenOneNodeDown(PartitionedRegion aRegion) {
        int redundantCopies;
        PartitionedRegion pr = aRegion;
        int totalBuckets = pr.getTotalNumberOfBuckets();
        RegionAttributes attr = aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        int expectedNumCopies = redundantCopies = prAttr.getRedundantCopies();
        int verifyBucketCopiesBucketId = 0;
        while (verifyBucketCopiesBucketId < totalBuckets) {
            Log.getLogWriter().info("Verifying data for bucket id " + verifyBucketCopiesBucketId + " out of " + totalBuckets + " buckets");
            List listOfMaps = null;
            try {
                listOfMaps = pr.getAllBucketEntries(verifyBucketCopiesBucketId);
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            int size = listOfMaps.size();
            if (size == 0) {
                Log.getLogWriter().info("Bucket " + verifyBucketCopiesBucketId + " is empty");
                ++verifyBucketCopiesBucketId;
                continue;
            }
            if (size != expectedNumCopies) {
                this.errorMsgs.add("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size());
                this.errorException.add(new TestException("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size()));
            } else {
                Log.getLogWriter().info("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, and have " + listOfMaps.size());
            }
            Log.getLogWriter().info("Validating co-location for all the redundant copies of the bucket with Id : " + verifyBucketCopiesBucketId);
            for (int i = 0; i < listOfMaps.size(); ++i) {
                BucketDump dump = (BucketDump)listOfMaps.get(i);
                Map map = dump.getValues();
                this.verifyCustomPartition(map, verifyBucketCopiesBucketId);
                this.verifyUniqueBucketForCustomPartioning(verifyBucketCopiesBucketId);
            }
            ++verifyBucketCopiesBucketId;
        }
    }

    protected void verifyCustomPartition(Map map, int bucketid) {
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        PartitionObjectHolder key = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = (PartitionObjectHolder)entry.getKey();
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid) == null) {
                Log.getLogWriter().info("RoutingObject for the bucket id to be set in the BB");
                ParRegBB.getBB().getSharedMap().put("RoutingObjectForBucketid:" + bucketid, key.getRoutingHint().toString());
                ParRegBB.getBB().getSharedMap().put("RoutingObjectKeyBucketid:" + bucketid, key);
                Log.getLogWriter().info("BB value set to " + key.getRoutingHint().toString());
                continue;
            }
            Log.getLogWriter().info("Checking the value for the routing object ");
            String blackBoardRoutingObject = (String)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid);
            String keyRoutingObject = key.getRoutingHint().toString();
            if (!keyRoutingObject.equalsIgnoreCase(blackBoardRoutingObject)) {
                throw new TestException("Expected same routing objects for the entries in this bucket id " + bucketid + "but got different values " + blackBoardRoutingObject + " and " + keyRoutingObject);
            }
            Log.getLogWriter().info("Got the expected values " + blackBoardRoutingObject + " and " + keyRoutingObject + " for the keys " + ParRegBB.getBB().getSharedMap().get("RoutingObjectKeyBucketid:" + bucketid) + " and " + key);
        }
    }

    protected void verifyUniqueBucketForCustomPartioning(int bucketId) {
        if (bucketId == 0) {
            Log.getLogWriter().info("This is the first bucket, so no validation required as there is no bucket to be compared");
            return;
        }
        for (int i = 0; i < bucketId; ++i) {
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i) == null) continue;
            String referenceValue = (String)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i);
            String currentValue = (String)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketId);
            Log.getLogWriter().info("currentValue: " + currentValue);
            Log.getLogWriter().info("referenceValue: " + referenceValue);
            if (currentValue.equalsIgnoreCase(referenceValue)) {
                throw new TestException("Two buckets with the id " + i + " and " + bucketId + " have the same routing Object " + referenceValue);
            }
            Log.getLogWriter().info("As expected the bucket with ids " + i + " and " + bucketId + " have the different routing Object " + currentValue + " and " + referenceValue);
        }
    }

    protected void killVms() {
        Object value = ParRegBB.getBB().getSharedMap().get("ReadyToKill");
        while (value != null && !((Boolean)value).booleanValue()) {
            Log.getLogWriter().info("Waiting to be ready to kill...");
            MasterController.sleepForMs(2000);
            value = ParRegBB.getBB().getSharedMap().get("ReadyToKill");
        }
        ParRegBB.getBB().getSharedMap().put("ReadyToKill", new Boolean(false));
        try {
            RegionAttributes attr;
            PartitionAttributes prAttr;
            Object regionDescriptName;
            String regionName;
            Region region;
            MasterController.sleepForMs(5000);
            if (regionDescriptNames.size() > 0 && (region = theCache.getRegion(regionName = RegionHelper.getRegionDescription((String)(regionDescriptName = (String)regionDescriptNames.get(0))).getRegionName())) instanceof PartitionedRegion && (prAttr = (attr = region.getAttributes()).getPartitionAttributes()).getLocalMaxMemory() == 0) {
                Log.getLogWriter().info("This is an accessor which is getting killed and hence to be restarted as an accessor");
                ParRegBB.getBB().getSharedMap().put("Vm Id: " + RemoteTestModule.getMyVmid(), "Accessor");
            }
            regionDescriptName = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static void HydraTask_killVMForever() {
        ((ColocationAndEvictionTest)testInstance).killVmForEver();
    }

    protected void killVmForEver() {
        try {
            RegionAttributes attr;
            PartitionAttributes prAttr;
            Object regionDescriptName;
            String regionName;
            Region region;
            MasterController.sleepForMs(5000);
            if (regionDescriptNames.size() > 0 && (region = theCache.getRegion(regionName = RegionHelper.getRegionDescription((String)(regionDescriptName = (String)regionDescriptNames.get(0))).getRegionName())) instanceof PartitionedRegion && (prAttr = (attr = region.getAttributes()).getPartitionAttributes()).getLocalMaxMemory() == 0) {
                Log.getLogWriter().info("This is an accessor which is getting killed and hence to be restarted as an accessor");
                ParRegBB.getBB().getSharedMap().put("Vm Id: " + RemoteTestModule.getMyVmid(), "Accessor");
            }
            regionDescriptName = ClientVmMgr.stop("Killing the VM", -21, -32);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public synchronized void verifyOverflowToDisk() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyOverflowToDisk(pr);
        }
    }

    protected void verifyOverflowToDisk(PartitionedRegion aRegion) {
        if (aRegion.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        long numOverflowToDisk = aRegion.getDiskRegionStats().getNumOverflowOnDisk();
        long entriesInVm = aRegion.getDiskRegionStats().getNumEntriesInVM();
        long totalEntriesInBuckets = 0L;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Log.getLogWriter().info("Number of buckets= " + bucketList.size());
        for (Map.Entry entry : bucketList) {
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket == null) continue;
            totalEntriesInBuckets += (long)localBucket.entryCount();
        }
        if (bucketList.size() > 0) {
            if (numOverflowToDisk == 0L) {
                throw new TestException("For the region " + aRegion.getName() + " no eviction happened ");
            }
            Log.getLogWriter().info("For the region " + aRegion.getName() + " entries overflown to disk is " + numOverflowToDisk);
        }
        if (totalEntriesInBuckets != numOverflowToDisk + entriesInVm) {
            throw new TestException("Total Entries in bucket (actual value " + totalEntriesInBuckets + " ) is not the same as the sum of entries in disk and entries in vm ( " + numOverflowToDisk + " and " + entriesInVm + ")");
        }
        if (entriesInVm == 0L) {
            EvictionAlgorithm evicAlgorithm = aRegion.getAttributes().getEvictionAttributes().getAlgorithm();
            if (evicAlgorithm == EvictionAlgorithm.LRU_HEAP) {
                Log.getLogWriter().warning(" After eviction(overflow to disk) the entries in vm is zero but entries in disk is " + numOverflowToDisk);
            } else {
                throw new TestException(" After eviction(overflow to disk) the entries in vm is zero but entries in disk is " + numOverflowToDisk);
            }
        }
        Log.getLogWriter().info("Total Entries in bucket (actual value " + totalEntriesInBuckets + " ) is the same as the sum of entries in disk and entries in vm ( " + numOverflowToDisk + " and " + entriesInVm + ")");
    }

    public synchronized void verifyEvictionLocalDestroy() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyEvictionLocalDestroy(pr);
        }
    }

    protected void verifyEvictionLocalDestroy(PartitionedRegion aRegion) {
        if (aRegion.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        double numEvicted = 0.0;
        EvictionAlgorithm evicAlgorithm = aRegion.getAttributes().getEvictionAttributes().getAlgorithm();
        if (evicAlgorithm == EvictionAlgorithm.LRU_ENTRY) {
            Log.getLogWriter().info("Eviction algorithm is LRU ENTRY");
            numEvicted = ColocationAndEvictionTest.getNumLRUEvictions();
            Log.getLogWriter().info("Evicted numbers :" + numEvicted);
            if (numEvicted == 0.0) {
                throw new TestException("No eviction happened in this test");
            }
        } else if (evicAlgorithm == EvictionAlgorithm.LRU_MEMORY) {
            Log.getLogWriter().info("Eviction algorithm is MEMORY LRU");
            numEvicted = ColocationAndEvictionTest.getNumMemLRUEvictions();
            Log.getLogWriter().info("Evicted numbers :" + numEvicted);
            if (numEvicted == 0.0) {
                throw new TestException("No eviction happened in this test");
            }
        } else if (evicAlgorithm == EvictionAlgorithm.LRU_HEAP) {
            Log.getLogWriter().info("Eviction algorithm is HEAP LRU");
            numEvicted = ColocationAndEvictionTest.getNumHeapLRUEvictions();
            Log.getLogWriter().info("Evicted numbers :" + numEvicted);
            if (numEvicted == 0.0) {
                throw new TestException("No eviction happened in this test");
            }
        }
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Iterator iterator = bucketList.iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket == null) continue;
            Log.getLogWriter().info("The entries in the bucket " + localBucket.getName() + " after eviction " + localBucket.entryCount());
            if (evicAlgorithm == EvictionAlgorithm.LRU_HEAP && localBucket.entryCount() == 0) {
                Log.getLogWriter().warning("Buckets are empty after evictions with local destroy eviction action");
            }
            if (evicAlgorithm != EvictionAlgorithm.LRU_ENTRY && evicAlgorithm != EvictionAlgorithm.LRU_MEMORY) continue;
            count += localBucket.getCounter();
        }
        if (evicAlgorithm == EvictionAlgorithm.LRU_ENTRY && count != (long)aRegion.getAttributes().getEvictionAttributes().getMaximum()) {
            throw new TestException("After Eviction total entries in region " + aRegion.getName() + " expected= " + aRegion.getAttributes().getEvictionAttributes().getMaximum() + " but found= " + count);
        }
        if (evicAlgorithm == EvictionAlgorithm.LRU_MEMORY) {
            int configuredByteLimit = aRegion.getAttributes().getEvictionAttributes().getMaximum() * 1024 * 1024;
            int ALLOWANCE = 250000;
            int upperLimitAllowed = configuredByteLimit + 250000;
            int lowerLimitAllowed = aRegion.getAttributes().getEvictionAttributes().getMaximum() * 1024 * 102;
            Log.getLogWriter().info("memlru, configuredByteLimit: " + configuredByteLimit);
            Log.getLogWriter().info("upperLimitAllowed (bytes): " + upperLimitAllowed);
            Log.getLogWriter().info("lowerLimitAllowed (bytes): " + lowerLimitAllowed);
            Log.getLogWriter().info("actual number of bytes: " + count);
            if (count > (long)upperLimitAllowed || count < (long)lowerLimitAllowed) {
                throw new TestException("After Eviction, configured memLRU bytes = " + configuredByteLimit + " total number of bytes in region " + count);
            }
        }
    }

    public static double getNumLRUEvictions() {
        String spec = "* LRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static double getNumMemLRUEvictions() {
        String spec = "* LRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static double getNumHeapLRUEvictions() {
        String spec = "* HeapLRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static void verifyEvictionBucketFairness() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            ColocationAndEvictionTest.verifyEvictionBucketFairness(pr);
        }
    }

    protected static void verifyEvictionBucketFairness(PartitionedRegion aRegion) {
        if (aRegion.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        long numOverflowToDisk = aRegion.getDiskRegionStats().getNumOverflowOnDisk();
        Set bucketSet = aRegion.getDataStore().getAllLocalBuckets();
        int averageEvictionPerBucket = (int)numOverflowToDisk / bucketSet.size();
        Log.getLogWriter().info("averageEvictionPerBucket = " + averageEvictionPerBucket);
        for (Map.Entry entry : bucketSet) {
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket == null) continue;
            long entriesInVmForBucket = localBucket.getNumEntriesInVM();
            long entriesInDiskForBucket = localBucket.getNumOverflowOnDisk();
            if ((double)entriesInDiskForBucket > (double)averageEvictionPerBucket * 1.4 || (double)entriesInDiskForBucket < (double)averageEvictionPerBucket * 0.75) {
                throw new TestException("For the region " + aRegion.getName() + " average expected eviction per bucket is " + averageEvictionPerBucket + " but for bucket id " + localBucket.getId() + " num evicted is " + entriesInDiskForBucket);
            }
            Log.getLogWriter().info("For the region " + aRegion.getName() + " for bucket id " + localBucket.getId() + " num evicted is " + entriesInDiskForBucket + " which is within the expected limit");
        }
    }

    protected void verifyPrimaryBucketCoLocation(PartitionedRegion aRegion) {
        String regionName = aRegion.getName();
        ArrayList primaryBucketList = (ArrayList)aRegion.getLocalPrimaryBucketsListTestOnly();
        Log.getLogWriter().info("The primary buckets in this data Store for the Partioned Region " + regionName);
        if (primaryBucketList == null) {
            if (aRegion.getLocalMaxMemory() == 0) {
                Log.getLogWriter().info("This is an accessor and no need to verify colocation");
                return;
            }
            throw new TestException("Bucket List returned null, but it is not an accessor");
        }
        Log.getLogWriter().info("Primary Buckets of " + aRegion.getName() + " " + primaryBucketList.toString());
        if (primaryBucketsInTheDataStore == null) {
            Log.getLogWriter().info(" Setting the reference primary buckets in the Data Store for this vm with the Partitioned Region " + aRegion.getName());
            primaryBucketsInTheDataStore = primaryBucketList;
            primaryBucketReferenceRegion = regionName;
        } else {
            Log.getLogWriter().info("Reference primary buckets in the Data Store for this vm already set");
            Log.getLogWriter().info(" Verifying for the region " + regionName);
            for (Integer currentPrimaryBucket : primaryBucketList) {
                if (primaryBucketsInTheDataStore.contains(currentPrimaryBucket)) {
                    Log.getLogWriter().info("Both the Regions " + primaryBucketReferenceRegion + " and " + regionName + " have the bucket " + currentPrimaryBucket + " in this node");
                    continue;
                }
                this.errorException.add(new TestException("Region " + regionName + " does not have its bucket " + currentPrimaryBucket + " colocated"));
                this.errorMsgs.add("Region " + regionName + " does not have its bucket " + currentPrimaryBucket + " colocated");
            }
            Log.getLogWriter().info("Looking for missed buckets");
            for (Integer referenceRegionBucket : primaryBucketsInTheDataStore) {
                if (primaryBucketList.contains(referenceRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + bucketReferenceRegion + " and " + regionName + " have the primary bucket " + referenceRegionBucket + " in this node");
                    continue;
                }
                this.errorException.add(new TestException("Region " + regionName + " does not have its primary bucket " + referenceRegionBucket + " colocated"));
                this.errorMsgs.add("Region " + regionName + " does not have its primary bucket " + referenceRegionBucket + " colocated");
            }
        }
    }

    protected void verifyBucketCoLocation(PartitionedRegion aRegion) {
        String regionName = aRegion.getName();
        ArrayList bucketList = (ArrayList)aRegion.getLocalBucketsListTestOnly();
        Log.getLogWriter().info("The buckets in this data Store for the Partioned Region " + regionName);
        if (bucketList == null) {
            if (aRegion.getLocalMaxMemory() == 0) {
                Log.getLogWriter().info("This is an accessor and no need to verify colocation");
                return;
            }
            throw new TestException("Bucket List returned null, but it is not an accessor");
        }
        Log.getLogWriter().info("Buckets of " + aRegion.getName() + " " + bucketList.toString());
        if (bucketsInTheDataStore == null) {
            Log.getLogWriter().info(" Setting the reference buckets in the Data Store for this vm with the Partitioned Region " + aRegion.getName());
            bucketsInTheDataStore = bucketList;
            bucketReferenceRegion = regionName;
        } else {
            Log.getLogWriter().info("Reference primary buckets in the Data Store for this vm already set");
            Log.getLogWriter().info(" Verifying for the region " + regionName);
            for (Integer currentRegionBucket : bucketList) {
                if (bucketsInTheDataStore.contains(currentRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + bucketReferenceRegion + " and " + regionName + " have the bucket " + currentRegionBucket + " in this node");
                    continue;
                }
                this.errorException.add(new TestException("Region " + regionName + " does not have its bucket " + currentRegionBucket + " colocated"));
                this.errorMsgs.add("Region " + regionName + " does not have its bucket " + currentRegionBucket + " colocated");
            }
            Log.getLogWriter().info("Looking for missed buckets");
            for (Integer referenceRegionBucket : bucketsInTheDataStore) {
                if (bucketList.contains(referenceRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + bucketReferenceRegion + " and " + regionName + " have the bucket " + referenceRegionBucket + " in this node");
                    continue;
                }
                this.errorException.add(new TestException("Region " + regionName + " does not have its bucket " + referenceRegionBucket + " colocated"));
                this.errorMsgs.add("Region " + regionName + " does not have its bucket " + referenceRegionBucket + " colocated");
            }
        }
    }

    public void verifyPRWhenOneNodeDown() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            RegionAttributes attr = aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            int redundantCopies = prAttr.getRedundantCopies();
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyPR(pr, redundantCopies - 1);
        }
    }

    public void verifyPR() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            RegionAttributes attr = aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            int redundantCopies = prAttr.getRedundantCopies();
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            this.verifyPR(pr, redundantCopies);
        }
    }

    public void verifyPR(PartitionedRegion aRegion, int redundantCopies) {
        try {
            ParRegUtil.verifyPRMetaData((Region)aRegion);
        }
        catch (Exception e) {
            throw new TestException(e.getMessage());
        }
        catch (TestException e) {
            throw new TestException(e.getMessage());
        }
        try {
            ParRegUtil.verifyPrimaries((Region)aRegion, redundantCopies);
        }
        catch (Exception e) {
            throw new TestException(e.getMessage());
        }
        catch (TestException e) {
            throw new TestException(e.getMessage());
        }
    }

    protected static void verifyMemLRU(PartitionedRegion aRegion) {
        long maxPermissibleBytes;
        long approxBytesPerEntry;
        long entriesInVm = aRegion.getDiskRegionStats().getNumEntriesInVM();
        double approxBytesInVm = entriesInVm * (approxBytesPerEntry = 250000L);
        if (approxBytesInVm > (double)(maxPermissibleBytes = (long)(aRegion.getAttributes().getEvictionAttributes().getMaximum() * 1024 * 1024))) {
            throw new TestException("Permissible Bytes for this region (memLRU) is " + maxPermissibleBytes + " but approx bytes in VM is " + approxBytesInVm);
        }
        Log.getLogWriter().info("Permissible Bytes for this region (memLRU) is " + maxPermissibleBytes + " but approx bytes in VM is " + approxBytesInVm);
    }

    public static void HydraTask_sleepForSomeTime() {
        MasterController.sleepForMs(180000);
    }

    public static void HydraTask_makeReadyToKill() {
        ParRegBB.getBB().getSharedMap().put("ReadyToKill", new Boolean(true));
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
        primaryBucketsInTheDataStore = null;
    }

    public static void HydraTask_logRegionSizes() {
        Set regSet = CacheHelper.getCache().rootRegions();
        for (Region aRegion : regSet) {
            Log.getLogWriter().info("Verifying region " + aRegion.getFullPath() + " of size " + aRegion.size());
        }
    }
}

