/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import getInitialImage.InitImageTest;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientCachePrms;
import hydra.ClientRegionHelper;
import hydra.ClientVmInfo;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GatewayPrms;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.HDFSStoreHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import pdx.PdxTest;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.PRObserver;
import util.SilenceListener;
import util.StopStartBB;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class KnownKeysTest
extends InitImageTest {
    protected static String DataStoreVmStr = "DataStoreVM_";
    protected static boolean isBridgeConfiguration;
    protected static boolean isGatewayConfiguration;
    protected static boolean isClientCache;
    protected static boolean isGatewaySenderConfiguration;
    protected static Set missingKeys;
    protected static Set missingValues;
    protected static int verifyRegionSizeIndex;
    protected static boolean verifyRegionSizeCompleted;
    protected static int verifyRegionContentsIndex;
    protected static StringBuffer verifyRegionContentsErrStr;
    protected static StringBuffer verifyRegionContentsSizeStr;
    protected static boolean verifyRegionContentsCompleted;
    protected static ParRegUtil parRegUtilInstance;
    protected boolean lockOperations;
    protected DistributedLockService distLockService;
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;
    protected boolean highAvailability;
    protected static boolean diskFilesRecorded;

    public static void StartTask_initialize() {
        PRObserver.initialize();
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        boolean isBridgeConfiguration = bridgeNames != null;
        HydraVector gatewayNames = TestConfig.tab().vecAt(GatewayPrms.names, null);
        HydraVector senderNames = TestConfig.tab().vecAt(GatewaySenderPrms.names, null);
        boolean isWanConfiguration = gatewayNames == null ? senderNames != null : true;
        int numKeys = TestConfig.tab().intAt(InitImagePrms.numKeys);
        KeyIntervals intervals = null;
        intervals = isWanConfiguration || ConfigPrms.getHadoopConfig() != null ? new KeyIntervals(new int[]{1000, 1003, 1005, 1006}, numKeys) : new KeyIntervals(new int[]{1000, 1001, 1003, 1005, 1006}, numKeys);
        InitImageBB.getBB().getSharedMap().put(InitImageBB.KEY_INTERVALS, intervals);
        Log.getLogWriter().info("Created keyIntervals: " + intervals);
        SharedCounters sc = InitImageBB.getBB().getSharedCounters();
        sc.setIfLarger(InitImageBB.LASTKEY_INVALIDATE, intervals.getFirstKey(1001) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_DESTROY, intervals.getFirstKey(1003) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY, intervals.getFirstKey(1005) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_GET, intervals.getFirstKey(1006) - 1);
        InitImageBB.getBB().printSharedMap();
        InitImageBB.getBB().printSharedCounters();
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new KnownKeysTest();
            ((KnownKeysTest)testInstance).initInstance("clientRegion");
            if (isGatewayConfiguration) {
                String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
                GatewayHubHelper.createGatewayHub(gatewayHubConfig);
            }
        }
    }

    public void initInstance(String regDescriptName) {
        super.initInstance();
        isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
        isGatewayConfiguration = TestConfig.tab().stringAt(GatewayPrms.names, null) != null;
        isGatewaySenderConfiguration = TestConfig.tab().stringAt(GatewaySenderPrms.names, null) != null;
        this.lockOperations = TestConfig.tab().booleanAt(ParRegPrms.lockOperations, false);
        this.highAvailability = TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false);
        boolean bl = isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
        if (isBridgeConfiguration && regDescriptName.equalsIgnoreCase("accessorRegion")) {
            boolean bl2 = isClientCache = TestConfig.tab().stringAt(ClientCachePrms.names, null) != null;
        }
        if (isClientCache) {
            ClientCache myCache = ClientCacheHelper.createCache("clientCache");
            this.aRegion = ClientRegionHelper.createRegion(regDescriptName);
            this.supportsConcurrentMap = true;
        } else {
            String hdfsStoreConfig;
            InternalResourceManager.ResourceObserver ro;
            Cache myCache = CacheHelper.createCache("cache1");
            PoolDescription poolDescript = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription();
            if (isGatewaySenderConfiguration && poolDescript == null) {
                String senderConfig = ConfigPrms.getGatewaySenderConfig();
                GatewaySenderHelper.createGatewaySenders(senderConfig);
            }
            if ((ro = ParRegPrms.getResourceObserver()) != null) {
                InternalResourceManager rm = InternalResourceManager.getInternalResourceManager((Cache)myCache);
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)ro);
            }
            ParRegUtil.createDiskStoreIfNecessary(regDescriptName);
            RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
            String regionName = RegionHelper.getRegionDescription(regDescriptName).getRegionName();
            if (poolDescript != null) {
                String poolConfigName = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription().getName();
                if (poolConfigName != null) {
                    PoolHelper.createPool(poolConfigName);
                }
                this.supportsConcurrentMap = true;
            }
            if ((hdfsStoreConfig = attr.getHDFSStoreName()) != null) {
                HDFSStoreHelper.createHDFSStore(hdfsStoreConfig);
            }
            this.aRegion = CacheHelper.getCache().createRegion(regionName, attr);
            Log.getLogWriter().info("Created region " + this.aRegion.getFullPath());
            isGatewayConfiguration = TestConfig.tab().stringAt(GatewayPrms.names, null) != null;
            this.lockOperations = TestConfig.tab().booleanAt(ParRegPrms.lockOperations, false);
            if (this.lockOperations) {
                Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
                this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
                Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
            }
        }
    }

    public static synchronized void HydraTask_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new KnownKeysTest();
            ((KnownKeysTest)testInstance).initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(KnownKeysTest.testInstance.aRegion);
            }
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new KnownKeysTest();
            ((KnownKeysTest)testInstance).initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(KnownKeysTest.testInstance.aRegion);
            }
        }
    }

    public static synchronized void HydraTask_dataStoreInitialize() {
        if (testInstance == null) {
            testInstance = new KnownKeysTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
            if (isGatewayConfiguration) {
                String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
                GatewayHubHelper.createGatewayHub(gatewayHubConfig);
            }
        }
    }

    public static synchronized void HydraTask_startGatewayHub() {
        if (isGatewayConfiguration) {
            String gatewayConfig = ConfigPrms.getGatewayConfig();
            GatewayHubHelper.addGateways(gatewayConfig);
            GatewayHubHelper.startGatewayHub();
        }
    }

    public static synchronized void HydraTask_createGatewaySenderIds() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static synchronized void HydraTask_startNewWanComponents() {
        if (TestConfig.tab().stringAt(GatewaySenderPrms.names, null) != null) {
            GatewaySenderHelper.startGatewaySenders(ConfigPrms.getGatewaySenderConfig());
            GatewayReceiverHelper.createAndStartGatewayReceivers(ConfigPrms.getGatewayReceiverConfig());
        }
    }

    public static synchronized void HydraTask_writeDiskDirsToBB() {
        if (!diskFilesRecorded) {
            ParRegUtil.writeDiskDirsToBB(KnownKeysTest.testInstance.aRegion);
            diskFilesRecorded = true;
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new KnownKeysTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            RegionAttributes attr = KnownKeysTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            if (prAttr == null) {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(-1L));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(-1L));
            } else {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(prAttr.getRecoveryDelay()));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(prAttr.getStartupRecoveryDelay()));
            }
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static void HydraTask_waitForStartupRecovery() {
        ArrayList startupVMs = new ArrayList(StopStartBB.getBB().getSharedMap().getMap().values());
        List vmsExpectingRecovery = StopStartVMs.getMatchVMs(startupVMs, "dataStore");
        vmsExpectingRecovery.addAll(StopStartVMs.getMatchVMs(startupVMs, "bridge"));
        if (vmsExpectingRecovery.size() == 0) {
            throw new TestException("No startup vms to wait for");
        }
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        if (startupRecoveryDelay >= 0L) {
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, numPRs, null, null, false);
        }
    }

    public static void HydraTask_waitForMyStartupRecovery() {
        if (KnownKeysTest.testInstance.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies() == 0) {
            Log.getLogWriter().info("RedundantCopies is 0, so no startup recovery will occur");
            return;
        }
        int myVmID = RemoteTestModule.getMyVmid();
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        if (startupRecoveryDelay >= 0L) {
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRebalRecov(myVmID, 1, numPRs, null, null, false);
        }
    }

    public static void HydraTask_validatePR() {
        int redundantCopies = KnownKeysTest.testInstance.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
        ParRegUtil.verifyPRMetaData(KnownKeysTest.testInstance.aRegion);
        ParRegUtil.verifyPrimaries(KnownKeysTest.testInstance.aRegion, redundantCopies);
        ParRegUtil.verifyBucketCopies(KnownKeysTest.testInstance.aRegion, redundantCopies);
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.DiskRecoveryCounter);
        PRObserver.initialize();
        parRegUtilInstance = new ParRegUtil();
        verifyRegionContentsIndex = 0;
        verifyRegionContentsErrStr = new StringBuffer();
        verifyRegionContentsSizeStr = new StringBuffer();
        verifyRegionContentsCompleted = false;
    }

    public static synchronized void HydraTask_logLocalSize() {
        Log.getLogWriter().info("Number of entries in this data store: " + ParRegUtil.getLocalSize(KnownKeysTest.testInstance.aRegion));
    }

    public static void HydraTask_loadRegion() {
        PdxTest.initClassLoader();
        testInstance.loadRegion();
    }

    public static void HydraTask_doOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 9);
        testInstance.doOps(availableOps);
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    public static void HydraTask_doPrTxOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1);
        availableOps.flip(3);
        availableOps.flip(5);
        availableOps.flip(6);
        availableOps.flip(7);
        testInstance.doOps(availableOps);
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    public static void HydraTask_waitForSilence() {
        SilenceListener.waitForSilence(30L, 1000L);
    }

    public static void HydraTask_verifyPRMetaData() {
        try {
            ParRegUtil.verifyPRMetaData(KnownKeysTest.testInstance.aRegion);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyUniqueHosts() {
        try {
            ParRegUtil.verifyBucketsOnUniqueHosts(KnownKeysTest.testInstance.aRegion);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyPrimaries() {
        try {
            RegionAttributes attr = KnownKeysTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            int redundantCopies = 0;
            if (prAttr != null) {
                redundantCopies = prAttr.getRedundantCopies();
            }
            if (((KnownKeysTest)KnownKeysTest.testInstance).highAvailability) {
                ParRegUtil.verifyPrimariesWithWait(KnownKeysTest.testInstance.aRegion, redundantCopies);
            } else {
                ParRegUtil.verifyPrimaries(KnownKeysTest.testInstance.aRegion, redundantCopies);
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyBucketCopiesBatched() {
        try {
            RegionAttributes attr = KnownKeysTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            int redundantCopies = 0;
            if (prAttr != null) {
                redundantCopies = prAttr.getRedundantCopies();
            }
            parRegUtilInstance.verifyBucketCopiesBatched(KnownKeysTest.testInstance.aRegion, redundantCopies);
        }
        catch (TestException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_stopStartVms() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            ((KnownKeysTest)testInstance).stopStartVms();
            long timeToStop = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
            if (timeToStop <= 0L) continue;
            throw new StopSchedulingTaskOnClientOrder("Ops have completed");
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    public static void HydraTask_verifyRegionContents() {
        InitImageBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        testInstance.verifyRegionContents();
    }

    public static void HydraTask_verifyHDFSRegionContents() {
        InitImageBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        ((KnownKeysTest)testInstance).verifyHDFSRegionContents();
    }

    public static void HydraTask_verifyRegionSize() {
        ((KnownKeysTest)testInstance).verifyRegionSize();
    }

    protected void verifyRegionSize() {
        if (verifyRegionSizeCompleted) {
            throw new TestException("Test configuration problem; already verified region size, cannot call this task again without resetting batch variables");
        }
        long lastLogTime = System.currentTimeMillis();
        int size = this.aRegion.size();
        long numOriginalKeysCreated = InitImageBB.getBB().getSharedCounters().read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long nameCounter = NameFactory.getPositiveNameCounter();
        Log.getLogWriter().info("In HydraTask_verifyRegionSize, region size is " + size + ", numKeysToCreate is " + numKeysToCreate + ", numOriginalKeysCreated is " + numOriginalKeysCreated + ", nameCounter is " + nameCounter);
        if (numOriginalKeysCreated != (long)numKeysToCreate || numOriginalKeysCreated != nameCounter) {
            throw new TestException("Error in test, numOriginalKeysCreated " + numOriginalKeysCreated + ", numKeysToCreate " + numKeysToCreate + ", nameCounter " + nameCounter);
        }
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        boolean first = true;
        while (verifyRegionSizeIndex < numKeysToCreate) {
            String key;
            ++verifyRegionSizeIndex;
            if (first) {
                Log.getLogWriter().info("In HydraTask_verifyRegionSize, starting verify with verifyRegionSizeIndex " + verifyRegionSizeIndex);
                first = false;
            }
            if (!this.aRegion.containsKey((Object)(key = NameFactory.getObjectNameForCounter(verifyRegionSizeIndex)))) {
                missingKeys.add(key);
            }
            if (!this.aRegion.containsValueForKey((Object)key)) {
                missingValues.add(key);
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Verified " + verifyRegionSizeIndex + " keys/values out of " + numKeysToCreate);
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime < minTaskGranularityMS) continue;
            Log.getLogWriter().info("In HydraTask_verifyRegionSize, returning before completing verify because of task granularity (this task must be batched to complete); last key verified is " + key);
            return;
        }
        verifyRegionSizeCompleted = true;
        if (missingKeys.size() != 0) {
            throw new TestException("Missing " + missingKeys.size() + " keys: " + missingKeys);
        }
        if (missingValues.size() != 0) {
            throw new TestException("Missing " + missingValues.size() + " values: " + missingValues);
        }
        if (size != numKeysToCreate) {
            throw new TestException("Unexpected region size " + size + "; expected " + numKeysToCreate);
        }
        String aStr = "In HydraTask_verifyRegionSize, verified " + verifyRegionSizeIndex + " keys and values";
        Log.getLogWriter().info(aStr);
        throw new StopSchedulingTaskOnClientOrder(aStr);
    }

    @Override
    public void verifyRegionContents() {
        if (verifyRegionContentsCompleted) {
            throw new TestException("Test configuration problem; already verified region contents, cannot call this task again without resetting batch variables");
        }
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        long size = this.aRegion.size();
        boolean first = true;
        int numKeysToCheck = this.keyIntervals.getNumKeys() + this.numNewKeys;
        while (verifyRegionContentsIndex < numKeysToCheck) {
            String key;
            block27: {
                ++verifyRegionContentsIndex;
                if (first) {
                    Log.getLogWriter().info("In verifyRegionContents, region has " + size + " keys; starting verify at verifyRegionContentsIndex " + verifyRegionContentsIndex + "; verifying key names with indexes through (and including) " + numKeysToCheck);
                    first = false;
                }
                if (verifyRegionContentsIndex == 1 && (long)this.totalNumKeys != size) {
                    String tmpStr = "Expected region size to be " + this.totalNumKeys + ", but it is size " + size;
                    Log.getLogWriter().info(tmpStr);
                    verifyRegionContentsSizeStr.append(tmpStr + "\n");
                }
                key = NameFactory.getObjectNameForCounter(verifyRegionContentsIndex);
                try {
                    Object value;
                    if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1000) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1000) || verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1006) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1006)) {
                        this.checkContainsKey(key, true, "key was untouched");
                        this.checkContainsValueForKey(key, true, "key was untouched");
                        value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                    } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1001) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1001)) {
                        this.checkContainsKey(key, true, "key was invalidated");
                        this.checkContainsValueForKey(key, false, "key was invalidated");
                    } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1002) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1002)) {
                        this.checkContainsKey(key, true, "key was locally invalidated");
                        this.checkContainsValueForKey(key, true, "key was locally invalidated");
                        value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                    } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1003) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1003)) {
                        this.checkContainsKey(key, false, "key was destroyed");
                        this.checkContainsValueForKey(key, false, "key was destroyed");
                    } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1004) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1004)) {
                        this.checkContainsKey(key, true, "key was locally destroyed");
                        this.checkContainsValueForKey(key, true, "key was locally destroyed");
                        value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                    } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1005) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1005)) {
                        this.checkContainsKey(key, true, "key was updated");
                        this.checkContainsValueForKey(key, true, "key was updated");
                        value = this.aRegion.get((Object)key);
                        this.checkUpdatedValue(key, value);
                    } else if (verifyRegionContentsIndex > this.keyIntervals.getNumKeys()) {
                        this.checkContainsKey(key, true, "key was new");
                        this.checkContainsValueForKey(key, true, "key was new");
                        value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                    }
                }
                catch (TestException e) {
                    Log.getLogWriter().info(TestHelper.getStackTrace(e));
                    Set failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.FAILED_TXOPS);
                    Set inDoubtOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
                    if (failedOps.contains(key) || inDoubtOps.contains(key)) break block27;
                    verifyRegionContentsErrStr.append(e.getMessage() + "\n");
                }
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Verified key " + verifyRegionContentsIndex + " out of " + this.totalNumKeys);
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime < minTaskGranularityMS) continue;
            Log.getLogWriter().info("In HydraTask_verifyRegionContents, returning before completing verify because of task granularity (this task must be batched to complete); last key verified is " + key);
            return;
        }
        verifyRegionContentsCompleted = true;
        StringBuffer error = new StringBuffer();
        Set failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.FAILED_TXOPS);
        if (failedOps.size() > 0) {
            if (verifyRegionContentsErrStr.length() > 0) {
                error.append("Test detected BUG 43428 (" + failedOps.size() + " failed transactions) with additional issues reported\n");
                error.append(verifyRegionContentsSizeStr);
                error.append(verifyRegionContentsErrStr);
                throw new TestException(error.toString());
            }
            error.append("Test detected BUG 43428 (" + failedOps.size() + " failed transactions) with no additional issues reported\n");
            error.append(verifyRegionContentsSizeStr);
            error.append(verifyRegionContentsErrStr);
            Log.getLogWriter().info("Inconsistencies are related to Transaction HA behavior (not currently supported): " + error.toString());
        } else if (ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS).size() > 0) {
            failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
            if (verifyRegionContentsErrStr.length() > 0) {
                error.append("Test reported " + failedOps.size() + " TransactionInDoubtExceptions with additional issues reported\n");
                error.append(verifyRegionContentsSizeStr);
                error.append(verifyRegionContentsErrStr);
                throw new TestException(error.toString());
            }
            error.append("Test reported " + failedOps.size() + " TransactionInDoubtExceptions with no additional issues reported\n");
            error.append(verifyRegionContentsSizeStr);
            error.append(verifyRegionContentsErrStr);
            Log.getLogWriter().info("Inconsistencies are related to Transaction HA behavior (not currently supported): " + error.toString());
        } else if (verifyRegionContentsErrStr.length() > 0) {
            verifyRegionContentsSizeStr.append(verifyRegionContentsErrStr);
            throw new TestException(verifyRegionContentsSizeStr.toString());
        }
        String aStr = "In HydraTask_verifyRegionContents, verified " + numKeysToCheck + " keys/values";
        Log.getLogWriter().info(aStr);
        throw new StopSchedulingTaskOnClientOrder(aStr);
    }

    public static void HydraTask_verifyHDFSRegionSize() {
        ((KnownKeysTest)testInstance).verifyHDFSRegionSize();
    }

    protected void verifyHDFSRegionSize() {
        if (verifyRegionSizeCompleted) {
            throw new TestException("Test configuration problem; already verified region size, cannot call this task again without resetting batch variables");
        }
        if (!this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().equals(EvictionAlgorithm.NONE)) {
            Log.getLogWriter().info("verifyHDFSRegionSize() returning (without validating) as this HDFS region is configured with eviction");
            throw new StopSchedulingTaskOnClientOrder("Cannot verify region size for HDFS regions");
        }
        long lastLogTime = System.currentTimeMillis();
        int size = this.aRegion.size();
        long numOriginalKeysCreated = InitImageBB.getBB().getSharedCounters().read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long nameCounter = NameFactory.getPositiveNameCounter();
        Log.getLogWriter().info("In HydraTask_verifyRegionSize, region size is " + size + ", numKeysToCreate is " + numKeysToCreate + ", numOriginalKeysCreated is " + numOriginalKeysCreated + ", nameCounter is " + nameCounter);
        if (numOriginalKeysCreated != (long)numKeysToCreate || numOriginalKeysCreated != nameCounter) {
            throw new TestException("Error in test, numOriginalKeysCreated " + numOriginalKeysCreated + ", numKeysToCreate " + numKeysToCreate + ", nameCounter " + nameCounter);
        }
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        boolean first = true;
        while (verifyRegionSizeIndex < numKeysToCreate) {
            String key;
            ++verifyRegionSizeIndex;
            if (first) {
                Log.getLogWriter().info("In HydraTask_verifyRegionSize, starting verify with verifyRegionSizeIndex " + verifyRegionSizeIndex);
                first = false;
            }
            if (!this.aRegion.containsKey((Object)(key = NameFactory.getObjectNameForCounter(verifyRegionSizeIndex)))) {
                missingKeys.add(key);
            }
            if (!this.aRegion.containsValueForKey((Object)key)) {
                missingValues.add(key);
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Verified " + verifyRegionSizeIndex + " keys/values out of " + numKeysToCreate);
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime < minTaskGranularityMS) continue;
            Log.getLogWriter().info("In HydraTask_verifyRegionSize, returning before completing verify because of task granularity (this task must be batched to complete); last key verified is " + key);
            return;
        }
        verifyRegionSizeCompleted = true;
        if (missingKeys.size() != 0) {
            throw new TestException("Missing " + missingKeys.size() + " keys: " + missingKeys);
        }
        if (missingValues.size() != 0) {
            throw new TestException("Missing " + missingValues.size() + " values: " + missingValues);
        }
        if (size != numKeysToCreate) {
            throw new TestException("Unexpected region size " + size + "; expected " + numKeysToCreate);
        }
        String aStr = "In HydraTask_verifyRegionSize, verified " + verifyRegionSizeIndex + " keys and values";
        Log.getLogWriter().info(aStr);
        throw new StopSchedulingTaskOnClientOrder(aStr);
    }

    public void verifyHDFSRegionContents() {
        if (verifyRegionContentsCompleted) {
            throw new TestException("Test configuration problem; already verified region contents, cannot call this task again without resetting batch variables");
        }
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        long size = this.aRegion.size();
        boolean first = true;
        int numKeysToCheck = this.keyIntervals.getNumKeys() + this.numNewKeys;
        while (verifyRegionContentsIndex < numKeysToCheck) {
            String taskType;
            String key;
            block29: {
                ++verifyRegionContentsIndex;
                if (first) {
                    Log.getLogWriter().info("In verifyRegionContents, region has " + size + " keys; starting verify at verifyRegionContentsIndex " + verifyRegionContentsIndex + "; verifying key names with indexes through (and including) " + numKeysToCheck);
                    first = false;
                }
                if (verifyRegionContentsIndex == 1 && (long)this.totalNumKeys != size) {
                    String tmpStr = "Expected region size to be " + this.totalNumKeys + ", but it is size " + size;
                    Log.getLogWriter().info(tmpStr);
                    verifyRegionContentsSizeStr.append(tmpStr + "\n");
                }
                key = NameFactory.getObjectNameForCounter(verifyRegionContentsIndex);
                try {
                    if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1000) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1000) || verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1006) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1006)) {
                        Object value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                        break block29;
                    }
                    if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1001) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1001)) {
                        Object value = this.aRegion.get((Object)key);
                        if (value != null) {
                            throw new TestException("Expected get(" + key + ") to return null, but it returned " + value + " key was invalidated");
                        }
                        break block29;
                    }
                    if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1002) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1002)) {
                        Object value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                        break block29;
                    }
                    if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1003) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1003)) {
                        boolean gotENFE = false;
                        try {
                            Object value = this.aRegion.get((Object)key);
                            if (value != null) {
                                throw new TestException("Expected get(" + key + ") to return null, but it returned " + value + " : entry was destroyed");
                            }
                            this.aRegion.destroy((Object)key);
                        }
                        catch (EntryNotFoundException e) {
                            gotENFE = true;
                        }
                        if (!gotENFE) {
                            throw new TestException("Expected get(" + key + ") to throw EntryNotFoundException, but it did not : entry was destroyed");
                        }
                        break block29;
                    }
                    if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1004) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1004)) {
                        Object value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                    } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1005) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1005)) {
                        Object value = this.aRegion.get((Object)key);
                        this.checkUpdatedValue(key, value);
                    } else if (verifyRegionContentsIndex > this.keyIntervals.getNumKeys()) {
                        Object value = this.aRegion.get((Object)key);
                        this.checkValue(key, value);
                    }
                }
                catch (TestException e) {
                    Log.getLogWriter().info(TestHelper.getStackTrace(e));
                    Set failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.FAILED_TXOPS);
                    Set inDoubtOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
                    if (failedOps.contains(key) || inDoubtOps.contains(key)) break block29;
                    verifyRegionContentsErrStr.append(e.getMessage() + "\n");
                }
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Verified key " + verifyRegionContentsIndex + " out of " + this.totalNumKeys);
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime < minTaskGranularityMS || (taskType = RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString()).equalsIgnoreCase("ENDTASK")) continue;
            Log.getLogWriter().info("In HydraTask_verifyRegionContents, returning before completing verify because of task granularity (this task must be batched to complete); last key verified is " + key);
            return;
        }
        verifyRegionContentsCompleted = true;
        StringBuffer error = new StringBuffer();
        Set failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.FAILED_TXOPS);
        if (failedOps.size() > 0) {
            if (verifyRegionContentsErrStr.length() > 0) {
                error.append("Test detected BUG 43428 (" + failedOps.size() + " failed transactions) with additional issues reported\n");
                error.append(verifyRegionContentsSizeStr);
                error.append(verifyRegionContentsErrStr);
                throw new TestException(error.toString());
            }
            error.append("Test detected BUG 43428 (" + failedOps.size() + " failed transactions) with no additional issues reported\n");
            error.append(verifyRegionContentsSizeStr);
            error.append(verifyRegionContentsErrStr);
            Log.getLogWriter().info("Inconsistencies are related to Transaction HA behavior (not currently supported): " + error.toString());
        } else if (ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS).size() > 0) {
            failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
            if (verifyRegionContentsErrStr.length() > 0) {
                error.append("Test reported " + failedOps.size() + " TransactionInDoubtExceptions with additional issues reported\n");
                error.append(verifyRegionContentsSizeStr);
                error.append(verifyRegionContentsErrStr);
                throw new TestException(error.toString());
            }
            error.append("Test reported " + failedOps.size() + " TransactionInDoubtExceptions with no additional issues reported\n");
            error.append(verifyRegionContentsSizeStr);
            error.append(verifyRegionContentsErrStr);
            Log.getLogWriter().info("Inconsistencies are related to Transaction HA behavior (not currently supported): " + error.toString());
        } else if (verifyRegionContentsErrStr.length() > 0) {
            verifyRegionContentsSizeStr.append(verifyRegionContentsErrStr);
            throw new TestException(verifyRegionContentsSizeStr.toString());
        }
        String aStr = "In HydraTask_verifyRegionContents, verified " + numKeysToCheck + " keys/values";
        Log.getLogWriter().info(aStr);
        String taskType = RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString();
        if (!taskType.equalsIgnoreCase("ENDTASK")) {
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
    }

    protected void stopStartVms() {
        PRObserver.initialize();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        Log.getLogWriter().info("In stopStartVms, choosing " + numVMsToStop + " vm(s) to stop...");
        List vmList = this.getDataStoreVms();
        ArrayList targetVms = new ArrayList();
        ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 1; i <= numVMsToStop; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            targetVms.add(vmList.get(randInt));
            vmList.remove(randInt);
            stopModes.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        StopStartVMs.stopStartVMs(targetVms, stopModes);
        long recoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("recoveryDelay");
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        PRObserver.waitForRecovery(recoveryDelay, startupRecoveryDelay, targetVms, vmList, numVMsToStop, 1, null, null);
        Log.getLogWriter().info("Done in KnownKeysTest.stopStartVms()");
    }

    protected List getDataStoreVms() {
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        Map aMap = ParRegBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(DataStoreVmStr)) continue;
            aList.add(new ClientVmInfo((Integer)aMap.get(key), null, null));
        }
        return aList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void doOps(BitSet availableOps) {
        minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        minTaskGranularityMS = minTaskGranularitySec * 1000L;
        startTime = System.currentTimeMillis();
        useTransactions = InitImagePrms.useTransactions();
        if (useTransactions) {
            // empty if block
        }
        while (availableOps.cardinality() != 0 && System.currentTimeMillis() - startTime < minTaskGranularityMS) {
            whichOp = this.getOp(availableOps, KnownKeysTest.operations.length);
            doneWithOps = false;
            gotTheLock = false;
            if (this.lockOperations) {
                Log.getLogWriter().info("Trying to get distributed lock " + KnownKeysTest.LOCK_NAME + "...");
                gotTheLock = this.distLockService.lock((Object)KnownKeysTest.LOCK_NAME, -1L, -1L);
                Log.getLogWriter().info("Returned from trying to get distributed lock " + KnownKeysTest.LOCK_NAME + ", lock acquired " + gotTheLock);
                if (!gotTheLock) {
                    throw new TestException("Did not get lock " + KnownKeysTest.LOCK_NAME);
                }
            }
            rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            try {
                switch (whichOp) {
                    case 7: {
                        doneWithOps = this.addNewKey();
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        doneWithOps = this.putAllNewKey();
                        ** break;
lbl29:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        doneWithOps = this.invalidate();
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        doneWithOps = this.destroy();
                        ** break;
lbl37:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        doneWithOps = this.updateExistingKey();
                        ** break;
lbl41:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        doneWithOps = this.get();
                        ** break;
lbl45:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        doneWithOps = this.localInvalidate();
                        ** break;
lbl49:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        doneWithOps = this.localDestroy();
                        ** break;
lbl53:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)te + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)e + ". " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)e + ".  Expected with concurrent execution, continuing test.");
                this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)te + " on rollback() after catching Exception " + (Object)e + " during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            finally {
                if (gotTheLock) {
                    gotTheLock = false;
                    this.distLockService.unlock((Object)KnownKeysTest.LOCK_NAME);
                    Log.getLogWriter().info("Released distributed lock " + KnownKeysTest.LOCK_NAME);
                }
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)e + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.INDOUBT_TXOPS);
                }
                catch (ConflictException e) {
                    throw new TestException("Unexpected Exception " + (Object)e + ". " + TestHelper.getStackTrace(e));
                }
            }
            if (!doneWithOps) continue;
            Log.getLogWriter().info("Done with operation " + whichOp);
            availableOps.clear(whichOp);
        }
    }

    protected void recordFailedOps(String sharedMapKey) {
    }

    static {
        missingKeys = new HashSet();
        missingValues = new HashSet();
        verifyRegionSizeIndex = 0;
        verifyRegionSizeCompleted = false;
        verifyRegionContentsIndex = 0;
        verifyRegionContentsErrStr = new StringBuffer();
        verifyRegionContentsSizeStr = new StringBuffer();
        verifyRegionContentsCompleted = false;
        parRegUtilInstance = new ParRegUtil();
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock";
        diskFilesRecorded = false;
    }
}

