/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ToDataException;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.PoolCancelledException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.WritablePdxInstance;
import delta.DeltaValueHolder;
import getInitialImage.InitImagePrms;
import hdfs.HDFSUtil;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientCacheHelper;
import hydra.ClientPrms;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ConfigPrms;
import hydra.DiskStoreDescription;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolDescription;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import memscale.MemScaleBB;
import memscale.OffHeapHelper;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import rebalance.RebalanceUtil;
import util.AdminHelper;
import util.BaseValueHolder;
import util.CacheDefPrms;
import util.CacheDefinition;
import util.CacheUtil;
import util.CliHelper;
import util.CliHelperPrms;
import util.DeclarativeGenerator;
import util.MethodCoordinator;
import util.NameFactory;
import util.PRObserver;
import util.PersistenceUtil;
import util.RandomValues;
import util.RegionDefinition;
import util.SilenceListener;
import util.StopStartBB;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;
import util.ValueHolderPrms;

public class ParRegTest {
    public static ParRegTest testInstance;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int ENTRY_PUTALL_OPERATION = 9;
    protected static final int ENTRY_DESTROY_PERCENT_OPERATION = 10;
    protected static final int ENTRY_LOCAL_DESTROY_PERCENT_OPERATION = 11;
    protected static final int ENTRY_PUT_IF_ABSENT_OPERATION = 12;
    protected static final int ENTRY_PUT_IF_ABSENT_AS_GET_OPERATION = 13;
    protected static final int ENTRY_PUT_IF_ABSENT_AS_CREATE_OPERATION = 14;
    protected static final int ENTRY_REMOVE_OPERATION = 15;
    protected static final int ENTRY_REMOVE_AS_NOOP_OPERATION = 16;
    protected static final int ENTRY_REPLACE_OPERATION = 17;
    protected static final int ENTRY_REPLACE_AS_UPDATE_OPERATION = 18;
    protected static final int ENTRY_REPLACE_AS_NOOP_OPERATION = 19;
    protected static final int ENTRY_REPLACE_NO_INVAL_OPERATION = 20;
    protected static final int ENTRY_REPLACE_OLD_OPERATION = 21;
    protected static final int ENTRY_REPLACE_OLD_AS_UPDATE_OPERATION = 22;
    protected static final int ENTRY_REPLACE_OLD_AS_NOOP_OPERATION = 23;
    protected static final int ENTRY_REPLACE_OLD_NO_INVAL_OPERATION = 24;
    protected static final int QUERY_OPERATION = 25;
    protected static final int CREATE_INDEX_OPERATION = 26;
    protected static final int REMOVE_INDEX_OPERATION = 27;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    public boolean isSerialExecution;
    protected int numThreadsInClients;
    protected RandomValues randomValues = new RandomValues();
    public Region aRegion;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected int numVMsToStop;
    protected RegionDefinition regDef;
    protected CacheDefinition cacheDef;
    public boolean highAvailability;
    protected boolean lockOperations;
    protected boolean regionLocallyDestroyed;
    protected boolean cacheIsClosed;
    protected boolean disconnected;
    protected int secondsToRun;
    protected int numThreadsInThisVM = 0;
    public boolean hasPRCacheLoader;
    public int redundantCopies;
    protected int currentValidateKeyIndex = 1;
    protected int currentIntervalKeyIndex = 1;
    protected boolean isEmptyClient = false;
    protected boolean isThinClient = false;
    protected Map regionSnapshot;
    protected Set destroyedKeys;
    protected Map txRegionSnapshot;
    protected Set txDestroyedKeys;
    protected DistributedLockService distLockService;
    public boolean isBridgeConfiguration;
    public boolean isBridgeClient;
    public boolean uniqueHostsOn;
    public int exceptionCount;
    public boolean thisVmRunningHAController = false;
    protected boolean hasLRUEntryEviction = false;
    protected int LRUEntryMax = -1;
    protected List<ClientVmInfo> cycleVMs_targetVMs = null;
    protected List<ClientVmInfo> cycleVMs_notChosenVMs = null;
    protected String bridgeOrderingWorkaround;
    public HydraThreadLocal uniqueKeyIndex = new HydraThreadLocal();
    protected boolean uniqueKeys = false;
    public boolean isDataStore = true;
    public boolean isClientCache = false;
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final int RECENT_HISTORY = 20;
    protected static final String VmIDStr = "VmId_";
    protected static final String isDataStoreKey = "isDataStore for vmID ";
    protected static final String shutDownAllInProgressKey = "shutDownAllInProgress";
    protected static final String expectOfflineExceptionKey = "expectOfflineException";
    protected static volatile MethodCoordinator concVerifyCoordinator;
    protected static volatile MethodCoordinator registerInterestCoordinator;
    protected static final int CLOSE_CACHE = 0;
    protected static final int DISCONNECT = 1;
    protected static final int LOCAL_DESTROY = 2;
    protected static final int CLOSE_REGION = 3;
    protected static final int MAX_CHOICES = 4;
    protected static final int MAX_CHOICES_FOR_CLIENT_SERVER = 2;
    static final String objectType;
    protected static boolean diskFilesRecorded;
    public int offHeapVerifyTargetCount = -1;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            String regionConfigName = ParRegTest.getClientRegionConfigName();
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeRegion(regionConfigName, ParRegTest.getCachePrmsName());
            testInstance.initPdxDiskStore();
            testInstance.initializeInstance();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isBridgeClient = true;
                ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
                ParRegTest.testInstance.isEmptyClient = regionConfigName.equals("emptyClientRegion");
                ParRegTest.testInstance.isThinClient = regionConfigName.equals("thinClientRegion");
                ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_initializeWithClientCache() {
        if (testInstance == null) {
            String regionConfigName = ParRegTest.getClientRegionConfigName();
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeClientRegion("clientCache", regionConfigName);
            testInstance.initializeInstance();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isBridgeClient = true;
                ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
                ParRegTest.testInstance.isClientCache = true;
                ParRegTest.testInstance.isEmptyClient = regionConfigName.equals("emptyClientRegion");
                ParRegTest.testInstance.isThinClient = regionConfigName.equals("thinClientRegion");
                ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_initializeWithRegDef() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeWithRegDef();
            testInstance.initializeInstance();
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            String regionConfigName = ParRegTest.getRegionConfigName();
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeRegion(regionConfigName, "cache1");
            testInstance.initPdxDiskStore();
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            ParRegTest.testInstance.isBridgeClient = false;
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_initializeBridgeServerAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeRegion("PrAccessor", ParRegTest.getCachePrmsName());
            testInstance.initializeInstance();
            testInstance.initPdxDiskStore();
            BridgeHelper.startBridgeServer("bridge");
            ParRegTest.testInstance.isBridgeClient = false;
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_HA_initializeAccessor() {
        if (testInstance == null) {
            String regionConfigName = ParRegTest.getClientRegionConfigName();
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeRegion(regionConfigName, ParRegTest.getCachePrmsName());
            testInstance.initPdxDiskStore();
            testInstance.initializeInstance();
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isBridgeClient = true;
                ParRegTest.testInstance.isEmptyClient = regionConfigName.equals("emptyClientRegion");
                ParRegTest.testInstance.isThinClient = regionConfigName.equals("thinClientRegion");
                ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_HA_initializeDataStore() {
        if (testInstance == null) {
            String regionConfigName = ParRegTest.getRegionConfigName();
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeRegion(regionConfigName, "cache1");
            testInstance.initPdxDiskStore();
            testInstance.initializeInstance();
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_HA_reinitializeWithClientCache() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.HA_reinitializeClientRegion();
            testInstance.initializeInstance();
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isEmptyClient = ParRegTest.testInstance.aRegion.getAttributes().getDataPolicy().isEmpty();
                ParRegTest.testInstance.isThinClient = !ParRegTest.testInstance.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().isNone();
                ParRegTest.testInstance.isBridgeClient = true;
                boolean repeatUntilSuccess = ParRegTest.testInstance.numVMsToStop > ParRegTest.testInstance.redundantCopies;
                ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion, repeatUntilSuccess);
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public static synchronized void HydraTask_HA_reinitializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.HA_reinitializeRegion(ParRegTest.getCachePrmsName());
            testInstance.initPdxDiskStore();
            testInstance.initializeInstance();
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isEmptyClient = ParRegTest.testInstance.aRegion.getAttributes().getDataPolicy().isEmpty();
                ParRegTest.testInstance.isThinClient = !ParRegTest.testInstance.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().isNone();
                ParRegTest.testInstance.isBridgeClient = true;
                boolean repeatUntilSuccess = ParRegTest.testInstance.numVMsToStop > ParRegTest.testInstance.redundantCopies;
                ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion, repeatUntilSuccess);
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    protected static void setUniqueKeyIndex() {
        Integer uniqueKeyIndexFromBB = (Integer)ParRegBB.getBB().getSharedMap().get("Thread_" + RemoteTestModule.getCurrentThread().getThreadId());
        if (uniqueKeyIndexFromBB == null) {
            ParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
        } else {
            ParRegTest.testInstance.uniqueKeyIndex.set(uniqueKeyIndexFromBB);
        }
    }

    public static synchronized void HydraTask_HA_reinitializeDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new ParRegTest();
            testInstance.HA_reinitializeRegion("cache1");
            testInstance.initPdxDiskStore();
            testInstance.initializeInstance();
            ParRegTest.testInstance.isDataStore = ParRegTest.getIsDataStore();
            if (ParRegTest.testInstance.isBridgeConfiguration) {
                ParRegTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        ParRegTest.setUniqueKeyIndex();
    }

    public void initializeRegion(String regDescriptName) {
        this.initializeRegion(regDescriptName, "cache1");
    }

    public void initializeRegion(String regDescriptName, String cachePrmsName) {
        String xmlFile;
        String key;
        block7: {
            CacheHelper.createCache(cachePrmsName);
            key = VmIDStr + RemoteTestModule.getMyVmid();
            xmlFile = key + ".xml";
            try {
                PoolDescription poolDescr = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription();
                DiskStoreDescription desc = RegionHelper.getRegionDescription(regDescriptName).getDiskStoreDescription();
                String diskStoreName = null;
                if (desc != null) {
                    diskStoreName = desc.getName();
                }
                Log.getLogWriter().info("About to generate xml, diskStoreName is " + diskStoreName);
                if (poolDescr != null) {
                    CacheHelper.generateCacheXmlFile(cachePrmsName, null, regDescriptName, null, null, poolDescr.getName(), diskStoreName, null, xmlFile);
                } else {
                    CacheHelper.generateCacheXmlFile(cachePrmsName, null, regDescriptName, null, null, null, diskStoreName, null, xmlFile);
                }
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0 || errStr.indexOf("Cache XML file already exists") >= 0) break block7;
                throw e;
            }
        }
        if (ConfigPrms.getHadoopConfig() != null) {
            ParRegUtil.createDiskStoreIfNecessary(regDescriptName);
            this.aRegion = RegionHelper.createRegion(regDescriptName);
        } else {
            this.aRegion = ParRegUtil.createRegion(cachePrmsName, regDescriptName, xmlFile);
        }
        ParRegBB.getBB().getSharedMap().put(key, regDescriptName);
    }

    public void initializeClientRegion(String cacheConfig, String regionConfig) {
        String xmlFile;
        String key;
        block2: {
            ClientCacheHelper.createCache(cacheConfig);
            key = VmIDStr + RemoteTestModule.getMyVmid();
            xmlFile = key + ".xml";
            try {
                ClientCacheHelper.generateCacheXmlFile(cacheConfig, regionConfig, xmlFile);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0 || errStr.indexOf("Cache XML file already exists") >= 0) break block2;
                throw e;
            }
        }
        this.aRegion = ParRegUtil.createClientRegion("clientCache", regionConfig, xmlFile);
        ParRegBB.getBB().getSharedMap().put(key, regionConfig);
    }

    public void initializeWithRegDef() {
        this.cacheDef = CacheDefinition.createCacheDefinition(CacheDefPrms.cacheSpecs, "cache1");
        this.regDef = RegionDefinition.createRegionDefinition();
        String key = VmIDStr + RemoteTestModule.getMyVmid();
        String xmlFile = key + ".xml";
        DeclarativeGenerator.createDeclarativeXml(key + ".xml", this.cacheDef, this.regDef, true);
        this.aRegion = CacheUtil.createRegion(this.cacheDef, this.regDef, xmlFile);
    }

    public void initializeInstance() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = TestConfig.tab().intAt(ParRegPrms.numOpsPerTask, Integer.MAX_VALUE);
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        this.upperThreshold = TestConfig.tab().intAt(ParRegPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(ParRegPrms.lowerThreshold, -1);
        this.bridgeOrderingWorkaround = TestConfig.tab().stringAt(ParRegPrms.bridgeOrderingWorkaround, "");
        ParRegBB.getBB().getSharedMap().replace("bridgeOrderingWorkaround", null, this.bridgeOrderingWorkaround);
        this.bridgeOrderingWorkaround = (String)ParRegBB.getBB().getSharedMap().get("bridgeOrderingWorkaround");
        this.uniqueKeys = this.bridgeOrderingWorkaround.equalsIgnoreCase("uniqueKeys");
        this.numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop, 1);
        this.secondsToRun = TestConfig.tab().intAt(ParRegPrms.secondsToRun, 1800);
        this.cacheIsClosed = false;
        this.disconnected = false;
        this.regionLocallyDestroyed = false;
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        this.isBridgeConfiguration = bridgeNames != null;
        Integer anInt = Integer.getInteger("numThreads");
        if (anInt != null) {
            this.numThreadsInThisVM = anInt;
        }
        this.isBridgeClient = false;
        this.redundantCopies = -1;
        RegionAttributes attr = this.aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        if (prAttr != null) {
            this.redundantCopies = prAttr.getRedundantCopies();
            long recoveryDelay = prAttr.getRecoveryDelay();
            long startupRecoveryDelay = prAttr.getStartupRecoveryDelay();
            ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(recoveryDelay));
            ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(startupRecoveryDelay));
        }
        ParRegBB.getBB().getSharedCounters().setIfLarger(ParRegBB.MaxRC, this.redundantCopies);
        this.hasPRCacheLoader = attr.getCacheLoader() != null;
        this.highAvailability = TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false);
        this.lockOperations = TestConfig.tab().booleanAt(ParRegPrms.lockOperations, false);
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
        boolean expectOfflineException = ParRegPrms.getUseShutDownAllMembers();
        try {
            HydraVector aVec = TestConfig.tab().vecAt(ParRegPrms.numVMsToStop);
            int maxNumToStop = 0;
            for (String numToStop : aVec) {
                maxNumToStop = Math.max(maxNumToStop, Integer.valueOf(numToStop));
            }
            if (!this.isSerialExecution && this.numVMsToStop > this.redundantCopies) {
                expectOfflineException = true;
            }
        }
        catch (HydraConfigException hydraConfigException) {
            // empty catch block
        }
        ParRegBB.getBB().getSharedMap().put(expectOfflineExceptionKey, new Boolean(expectOfflineException));
        this.uniqueHostsOn = DistributedSystemHelper.getGemFireDescription().getEnforceUniqueHost();
        boolean bl = this.hasLRUEntryEviction = this.aRegion.getAttributes().getEvictionAttributes() != null;
        if (this.hasLRUEntryEviction) {
            this.hasLRUEntryEviction = this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUEntry();
            if (this.hasLRUEntryEviction) {
                this.LRUEntryMax = this.aRegion.getAttributes().getEvictionAttributes().getMaximum();
            }
        }
        if (OffHeapHelper.isOffHeapMemoryConfigured()) {
            MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.membersWithOffHeap);
        }
        this.offHeapVerifyTargetCount = TestHelper.getNumThreads();
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", " + "minTaskGranularityMS " + this.minTaskGranularityMS + ", " + "numOpsPerTask " + this.numOpsPerTask + ", " + "isSerialExecution " + this.isSerialExecution + ", " + "lockOperations " + this.lockOperations + ", " + "upperThreshold " + this.upperThreshold + ", " + "lowerThreshold " + this.lowerThreshold + ", " + "numThreadsInThisVM " + this.numThreadsInThisVM + ", " + "numVMsToStop " + this.numVMsToStop + ", " + "isBridgeConfiguration " + this.isBridgeConfiguration + ", " + "isDataStore " + this.isDataStore + ", " + "isClientCache " + this.isClientCache + ", " + "bridgeOrderingWorkaround " + this.bridgeOrderingWorkaround + ", " + "uniqueKeys " + this.uniqueKeys + "," + "hasPRCacheLoader " + this.hasPRCacheLoader + "," + "uniqueHostsOn " + this.uniqueHostsOn);
        if (this.isSerialExecution) {
            this.regionSnapshot = new HashMap();
            this.destroyedKeys = new HashSet();
        }
    }

    public String HA_reinitializeClientRegion() {
        this.isClientCache = true;
        return this.HA_reinitializeRegion();
    }

    public String HA_reinitializeRegion() {
        return this.HA_reinitializeRegion("cache1");
    }

    public String HA_reinitializeRegion(String cachePrmsName) {
        String key = VmIDStr + RemoteTestModule.getMyVmid();
        String regDescriptName = (String)ParRegBB.getBB().getSharedMap().get(key);
        String xmlFile = key + ".xml";
        if (this.isClientCache) {
            this.aRegion = ParRegUtil.createClientRegion("clientCache", regDescriptName, xmlFile);
        } else if (ConfigPrms.getHadoopConfig() != null) {
            CacheHelper.createCache(cachePrmsName);
            this.aRegion = RegionHelper.createRegion(regDescriptName);
        } else {
            this.aRegion = CacheUtil.createRegion(cachePrmsName, regDescriptName, xmlFile);
        }
        this.initPdxDiskStore();
        Log.getLogWriter().info("After recreating " + this.aRegion.getFullPath() + ", size is " + this.aRegion.size());
        if (InitImagePrms.useTransactions()) {
            TxHelper.setTransactionManager();
        }
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            try {
                this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
                Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
            }
            catch (IllegalArgumentException e) {
                String exceptStr = e.toString();
                if (exceptStr.indexOf("Service named " + LOCK_SERVICE_NAME + " already created") >= 0) {
                    Log.getLogWriter().info("Caught " + e + "; continuing test because lock service already exists");
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        return regDescriptName;
    }

    protected static String getClientRegionConfigName() {
        String regionConfigName = "clientRegion";
        int desiredNumEmptyClients = ParRegPrms.getNumEmptyClients();
        long numEmptyClients = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numEmptyClients);
        if (numEmptyClients <= (long)desiredNumEmptyClients) {
            regionConfigName = "emptyClientRegion";
        } else {
            int desiredNumThinClients = ParRegPrms.getNumThinClients();
            long numThinClients = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numThinClients);
            if (numThinClients <= (long)desiredNumThinClients) {
                regionConfigName = "thinClientRegion";
            }
        }
        return regionConfigName;
    }

    protected static String getRegionConfigName() {
        String regionConfigName = "dataStoreRegion";
        int desiredNumAccessors = ParRegPrms.getNumberOfAccessors();
        long numAccessors = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfAccessors);
        if (numAccessors <= (long)desiredNumAccessors) {
            regionConfigName = "accessorRegion";
        }
        return regionConfigName;
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.DiskRecoveryCounter);
        PRObserver.initialize();
    }

    public static void HydraTask_prepareForRecovery() {
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.numOfAccessors);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.numEmptyClients);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.numThinClients);
    }

    public static String getCachePrmsName() {
        HydraVector cacheNames = TestConfig.tab().vecAt(CachePrms.names);
        String cachePrmsName = "cache1";
        if (cacheNames.contains("accessorCache")) {
            cachePrmsName = "accessorCache";
        }
        return cachePrmsName;
    }

    public static void HydraTask_doRROpsAndVerify() {
        testInstance.doRROpsAndVerify();
    }

    public static void HydraTask_doConcOps() {
        PdxTest.initClassLoader();
        testInstance.doConcOps();
    }

    public static void HydraTask_loadToUpperThreshold() {
        long startTime = System.currentTimeMillis();
        long lastLogTime = System.currentTimeMillis();
        do {
            Object key = testInstance.getNewKey();
            BaseValueHolder anObj = testInstance.getValueForKey(key);
            ParRegTest.testInstance.aRegion.put(key, (Object)anObj);
            long counter = NameFactory.getCounterForName(key);
            if (counter >= (long)ParRegTest.testInstance.upperThreshold) {
                String s = "NameFactory nameCounter has reached " + counter;
                throw new StopSchedulingTaskOnClientOrder(s);
            }
            if (System.currentTimeMillis() - lastLogTime < 10000L) continue;
            Log.getLogWriter().info("Current nameCounter is " + counter);
            lastLogTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < ParRegTest.testInstance.minTaskGranularityMS);
    }

    public static void HydraTask_doIntervalOps() {
        testInstance.doIntervalOps();
    }

    public static void HydraTask_validateIntervalOps() {
        testInstance.validateIntervalOps();
    }

    public static void HydraTask_doConcOpsAndVerify() {
        PdxTest.initClassLoader();
        testInstance.doConcOpsAndVerify();
    }

    public static void HydraTask_doEntryOpsDataLoss() {
        testInstance.doEntryOperations(ParRegTest.testInstance.aRegion);
    }

    public static void HydraTask_doEntryOps() {
        testInstance.doEntryOperations(ParRegTest.testInstance.aRegion);
    }

    public static void HydraTask_HADoEntryOps() {
        PdxTest.initClassLoader();
        testInstance.HADoEntryOps();
    }

    public static void HydraTask_shutDownAllHADoEntryOps() {
        testInstance.shutDownAllHADoEntryOps();
    }

    public static void HydraTask_HAController() {
        testInstance.HAController();
    }

    public static void HydraTask_shutDownAllHAController() {
        testInstance.shutDownAllHAController();
    }

    public static void HydraTask_recoveryController() {
        testInstance.recoveryController();
    }

    public static void HydraTask_recoveryEntryOps() {
        testInstance.recoveryEntryOps();
    }

    public static void HydraTask_stopStartVMs() {
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        Object[] tmpArr = StopStartVMs.getOtherVMsWithExclude(numVMsToStop, "locator");
        List vms = (List)tmpArr[0];
        List stopModes = (List)tmpArr[1];
        Log.getLogWriter().info("VMs to stop and restart: " + vms);
        for (int i = 0; i < vms.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)vms.get(i);
            PRObserver.initialize(info.getVmid());
        }
        StopStartVMs.stopStartVMs(vms, stopModes);
    }

    public static synchronized void HydraTask_logLocalSize() {
        Log.getLogWriter().info("Number of entries in this data store: " + ParRegUtil.getLocalSize(ParRegTest.testInstance.aRegion));
    }

    public static void HydraTask_waitForStartupRecovery() {
        if (ParRegTest.testInstance.redundantCopies == 0) {
            Log.getLogWriter().info("RedundantCopies is 0, so no startup recovery will occur");
            return;
        }
        ArrayList startupVMs = new ArrayList(StopStartBB.getBB().getSharedMap().getMap().values());
        List vmsExpectingRecovery = StopStartVMs.getMatchVMs(startupVMs, "dataStore");
        vmsExpectingRecovery.addAll(StopStartVMs.getMatchVMs(startupVMs, "bridge"));
        if (vmsExpectingRecovery.size() == 0) {
            throw new TestException("No startup vms to wait for");
        }
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        if (startupRecoveryDelay >= 0L) {
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, numPRs, null, null, false);
        }
    }

    public static void HydraTask_waitForMyStartupRecovery() {
        if (ParRegTest.testInstance.redundantCopies == 0) {
            Log.getLogWriter().info("RedundantCopies is 0, so no startup recovery will occur");
            return;
        }
        if (!ParRegTest.testInstance.isDataStore) {
            Log.getLogWriter().info("This is an accessor or a client, so no startup recovery will occur");
            return;
        }
        int myVmID = RemoteTestModule.getMyVmid();
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        if (startupRecoveryDelay >= 0L) {
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRebalRecov(myVmID, 1, numPRs, null, null, false);
        }
    }

    public static synchronized void HydraTask_writeDiskDirsToBB() {
        if (!diskFilesRecorded) {
            ParRegUtil.writeDiskDirsToBB(ParRegTest.testInstance.aRegion);
            diskFilesRecorded = true;
        }
    }

    public static void HydraTask_validateRegionContents() {
        PdxTest.initClassLoader();
        testInstance.verifyFromSnapshotOnly();
    }

    public static void HydraTask_validateInternalPRState() {
        PdxTest.initClassLoader();
        testInstance.verifyInternalPRState();
    }

    public static void HydraTask_validatePR() {
        PdxTest.initClassLoader();
        Log.getLogWriter().info(ParRegTest.testInstance.aRegion.getFullPath() + " size is " + ParRegTest.testInstance.aRegion.size() + " isDataStore " + ParRegTest.testInstance.isDataStore);
        if (ParRegTest.testInstance.isDataStore && ParRegTest.testInstance.aRegion.size() == 0 && !ParRegTest.testInstance.aRegion.getAttributes().getDataPolicy().withHDFS()) {
            throw new TestException("Expected " + ParRegTest.testInstance.aRegion.getFullPath() + " to have a size > 0, but it has size " + ParRegTest.testInstance.aRegion.size());
        }
        testInstance.verifyFromSnapshot();
    }

    public static void HydraTask_prepareForValidation() {
        if (ParRegTest.testInstance.isEmptyClient || ParRegTest.testInstance.isThinClient) {
            Log.getLogWriter().info("This vm will not write a snapshot to the blackboard because it is empty or thin");
            return;
        }
        PdxTest.initClassLoader();
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.RecoverySnapshotLeader);
        if (counter == 1L) {
            boolean withEviction;
            boolean bl = withEviction = !ParRegTest.testInstance.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().equals(EvictionAlgorithm.NONE);
            if (ConfigPrms.getHadoopConfig() != null) {
                testInstance.writeHDFSRegionSnapshotToBB();
                return;
            }
            HashMap regionSnapshot = new HashMap();
            Set keySet = ParRegTest.testInstance.aRegion.keySet();
            for (Object key : keySet) {
                Object value = null;
                if (ParRegTest.testInstance.aRegion.containsValueForKey(key)) {
                    value = ParRegTest.testInstance.aRegion.get(key);
                }
                if (value instanceof BaseValueHolder || value instanceof PdxInstance) {
                    regionSnapshot.put(key, PdxTest.toValueHolder((Object)value).myValue);
                    continue;
                }
                regionSnapshot.put(key, value);
            }
            Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + regionSnapshot.size() + ": " + regionSnapshot);
            ParRegBB.getBB().getSharedMap().put("RegionSnapshot", regionSnapshot);
            ParRegBB.getBB().getSharedMap().put("DestroyedKeys", new HashSet());
        }
    }

    public static void HydraTask_verifyFromSnapshotAndSync() {
        testInstance.verifyFromSnapshot();
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads(), true, -1L, 2000L);
    }

    public static void HydraTask_verifyRecoveredVMsFromSnapshotAndSync() {
        ParRegTest.testInstance.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        testInstance.verifyFromSnapshot();
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, ParRegTest.testInstance.numThreadsInClients - ParRegTest.testInstance.numThreadsInThisVM, true, -1L, 2000L);
    }

    public static void HydraTask_startVmAndRebalance() {
        long rebalance = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.rebalance);
        if (rebalance == 1L) {
            ParRegTest.HydraTask_initializeBridgeServer();
            ParRegTest.HydraTask_writeDiskDirsToBB();
            ResourceManager resMan = CacheHelper.getCache().getResourceManager();
            RebalanceFactory factory = resMan.createRebalanceFactory();
            Log.getLogWriter().info("Starting rebalancing");
            RebalanceOperation rebalanceOp = factory.start();
            try {
                RebalanceResults rebalanceResults = rebalanceOp.getResults();
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.rebalance);
                throw new StopSchedulingTaskOnClientOrder("This vm has completed rebalancing");
            }
            catch (CancellationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Sleeping for 5 seconds (it's not this vm's turn to init/rebalance");
        MasterController.sleepForMs(5000);
    }

    public static void HydraTask_assignBucketsToPartitions() {
        Log.getLogWriter().info("Calling PartitionRegionHelper.assignBucketsToPartitions...");
        PartitionRegionHelper.assignBucketsToPartitions((Region)ParRegTest.testInstance.aRegion);
        Log.getLogWriter().info("Done calling PartitionRegionHelper.assignBucketsToPartitions");
    }

    public static void HydraTask_restoreBackups() {
        PdxTest.initClassLoader();
        int numVMs = 0;
        if (CliHelperPrms.getUseCli()) {
            HydraVector aVec = TestConfig.tab().vecAt(ClientPrms.names);
            for (String name : aVec) {
                if (!name.contains("peer")) continue;
                ++numVMs;
            }
        } else {
            numVMs = TestHelper.getNumVMs();
        }
        Log.getLogWriter().info("numVMs is " + numVMs);
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.verifyBackups);
        if (counter == 1L) {
            File[] contents;
            Log.getLogWriter().info("This thread is the restore leader");
            ParRegTest.HydraTask_prepareForRecovery();
            ParRegBB.getBB().getSharedCounters().zero(ParRegBB.backupRestored);
            ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Reinitialized);
            ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
            ArrayList<File> backupDirList = new ArrayList<File>();
            String currDirName = System.getProperty("user.dir");
            File currDir = new File(currDirName);
            for (File aDir : contents = currDir.listFiles()) {
                if (!aDir.getName().startsWith("backup_")) continue;
                backupDirList.add(aDir);
            }
            Log.getLogWriter().info("Backup dir list is " + backupDirList);
            Log.getLogWriter().info("Restoring backups, expect to fail because disk dirs already exist");
            for (File backupDir : backupDirList) {
                ParRegTest.runRestoreScript(backupDir, false);
            }
            Log.getLogWriter().info("Done restoring failed backups");
            for (int i = 0; i < backupDirList.size(); ++i) {
                File backupDir = (File)backupDirList.get(i);
                String backupDirName = backupDir.getName();
                long backupNum = Long.valueOf(backupDirName.substring(backupDirName.indexOf("_") + 1, backupDirName.length()));
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.onlineBackupNumber);
                ParRegBB.getBB().getSharedCounters().setIfLarger(ParRegBB.onlineBackupNumber, backupNum);
                PRObserver.initialize();
                Log.getLogWriter().info("Backup number is " + backupNum);
                Log.getLogWriter().info("Restoring from " + backupDir.getName());
                ParRegTest.deleteExistingDiskDirs();
                ParRegTest.runRestoreScript(backupDir, true);
                Log.getLogWriter().info("Done restoring from " + backupDir.getName());
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.backupRestored);
                Log.getLogWriter().info("Initializing...");
                ParRegTest.HydraTask_initialize();
                Log.getLogWriter().info("Done initializing");
                ParRegTest.HydraTask_waitForMyStartupRecovery();
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Reinitialized", ParRegBB.Reinitialized, numVMs - 1, true, -1L);
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Reinitialized);
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ReadyToBegin);
                testInstance.validateAfterRestore(backupNum);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, numVMs - 1, true, -1L);
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
                Log.getLogWriter().info("Preparing for next restore...");
                ParRegTest.HydraTask_prepareForRecovery();
                ParRegTest.HydraTask_disconnect();
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.backupRestored);
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Reinitialized);
                if (i == backupDirList.size() - 1) {
                    ParRegBB.getBB().getSharedCounters().increment(ParRegBB.backupsDone);
                }
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.ReadyToBegin", ParRegBB.ReadyToBegin, numVMs - 1, true, -1L);
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.ReadyToBegin);
            }
        } else {
            do {
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.backupRestored", ParRegBB.backupRestored, 1L, true, -1L);
                Log.getLogWriter().info("Initializing...");
                ParRegTest.HydraTask_initialize();
                Log.getLogWriter().info("Done initializing");
                ParRegTest.HydraTask_waitForMyStartupRecovery();
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Reinitialized);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Reinitialized", ParRegBB.Reinitialized, numVMs, true, -1L);
                long backupNumber = ParRegBB.getBB().getSharedCounters().read(ParRegBB.onlineBackupNumber);
                testInstance.validateAfterRestore(backupNumber);
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, numVMs, true, -1L);
                Log.getLogWriter().info("Preparing for next restore...");
                ParRegTest.HydraTask_prepareForRecovery();
                ParRegTest.HydraTask_disconnect();
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.ReadyToBegin);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.ReadyToBegin", ParRegBB.ReadyToBegin, numVMs, true, -1L);
            } while (ParRegBB.getBB().getSharedCounters().read(ParRegBB.backupsDone) <= 0L);
            Log.getLogWriter().info("All backups have been restored");
        }
    }

    protected void validateAfterRestore(long backupNum) {
        int regionSize = this.aRegion.size();
        String aStr = "After restoring from backup number " + backupNum + " region size is " + regionSize;
        Log.getLogWriter().info(aStr);
        if (this.isSerialExecution) {
            String snapFileName = "snapshotForBackup_" + backupNum + ".ser";
            String destroyedFileName = "destroyKeysForBackup_" + backupNum + ".ser";
            try {
                FileInputStream fis = new FileInputStream(snapFileName);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.regionSnapshot = (Map)ois.readObject();
                fis = new FileInputStream(destroyedFileName);
                ois = new ObjectInputStream(fis);
                this.destroyedKeys = (Set)ois.readObject();
            }
            catch (FileNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            ParRegBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
            ParRegBB.getBB().getSharedMap().put("DestroyedKeys", this.destroyedKeys);
            this.verifyFromSnapshot();
        } else {
            HashSet prKeySet = new HashSet(ParRegTest.keySetWithoutCreates(this.aRegion));
            if (prKeySet.size() != regionSize) {
                ((LocalRegion)this.aRegion).dumpBackingMap();
                throw new TestException("Size for " + this.aRegion.getFullPath() + " is " + regionSize + ", but its keySet size is " + prKeySet.size());
            }
            ParRegUtil.verifyPRMetaData(this.aRegion);
            if (this.highAvailability) {
                ParRegUtil.verifyPrimariesWithWait(this.aRegion, this.redundantCopies);
            } else {
                ParRegUtil.verifyPrimaries(this.aRegion, this.redundantCopies);
            }
            ParRegUtil.verifyBucketCopies(this.aRegion, this.redundantCopies);
            if (this.uniqueHostsOn) {
                ParRegUtil.verifyBucketsOnUniqueHosts(this.aRegion);
            }
            if (this.isBridgeClient) {
                this.verifyServerKeysFromSnapshot();
            }
        }
    }

    protected static void deleteExistingDiskDirs() {
        File[] contents;
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (File aDir : contents = currDir.listFiles()) {
            if (!aDir.isDirectory() || aDir.getName().indexOf("_disk_") < 0 || aDir.list().length == 0) continue;
            ParRegTest.deleteDir(aDir);
        }
    }

    protected static void deleteDir(File aDir) {
        try {
            File[] contents;
            for (File aFile : contents = aDir.listFiles()) {
                if (aFile.isDirectory()) {
                    ParRegTest.deleteDir(aFile);
                    continue;
                }
                if (aFile.delete()) continue;
                throw new TestException("Could not delete " + aFile.getCanonicalPath());
            }
            if (!aDir.delete()) {
                throw new TestException("Could not delete " + aDir.getCanonicalPath());
            }
            Log.getLogWriter().info("Successfully deleted " + aDir.getCanonicalPath());
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static void runRestoreScript(File backupDir, boolean expectSuccess) {
        File[] dateDirContents;
        File[] backupContents = backupDir.listFiles();
        if (backupContents.length != 1) {
            throw new TestException("Expecting backup directory to contain 1 directory, but it contains " + backupContents.length);
        }
        File dateDir = backupContents[0];
        block4: for (File hostAndPidDir : dateDirContents = dateDir.listFiles()) {
            File[] hostAndPidContents;
            for (File aFile : hostAndPidContents = hostAndPidDir.listFiles()) {
                if (!aFile.getName().equals("restore.sh") && !aFile.getName().equals("restore.bat")) continue;
                try {
                    String cmd = null;
                    cmd = HostHelper.isWindows() ? "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c " : "/bin/bash ";
                    cmd = cmd + aFile.getCanonicalPath();
                    try {
                        Log.getLogWriter().info("Running restore scripts");
                        String cmdResult = ProcessMgr.fgexec(cmd, 0);
                        Log.getLogWriter().info("Result is " + cmdResult);
                        if (!expectSuccess) {
                            throw new TestException("Expected restore script to fail, but it succeeded");
                        }
                        Log.getLogWriter().info("Restore script executed successfully");
                        continue block4;
                    }
                    catch (HydraRuntimeException e) {
                        if (expectSuccess) {
                            throw e;
                        }
                        String errStr = e.getCause().toString();
                        if (errStr.indexOf("Backup not restored. Refusing to overwrite") >= 0) {
                            Log.getLogWriter().info("restore script got expected exception " + (Object)((Object)e) + " " + e.getCause());
                            continue block4;
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
        }
    }

    public void doRROpsAndVerify() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newClassLoader = PdxTest.initClassLoader();
        ParRegTest.logExecutionNumber();
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        long roundPosition = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.RoundPosition);
        Log.getLogWriter().info("In doRROpsAndVerify, roundPosition is " + roundPosition);
        if (roundPosition == (long)this.numThreadsInClients) {
            Log.getLogWriter().info("In doRROpsAndVerify, last in round");
            this.verifyFromSnapshot();
            ParRegBB.getBB().getSharedCounters().zero(ParRegBB.RoundPosition);
            roundPosition = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.RoundPosition);
        }
        if (roundPosition == 1L) {
            long roundNumber = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.RoundNumber);
            Log.getLogWriter().info("In doRROpsAndVerify, first in round, round number " + roundNumber);
            this.doEntryOperations(this.aRegion);
            if (this.isBridgeConfiguration) {
                SilenceListener.waitForSilence(30L, 5000L);
            }
            Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + this.regionSnapshot.size() + ": " + this.regionSnapshot);
            ParRegBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
            Log.getLogWriter().info("Writing destroyedKeys to blackboard: " + this.destroyedKeys);
            ParRegBB.getBB().getSharedMap().put("DestroyedKeys", this.destroyedKeys);
            if (!this.isThinClient && !this.isEmptyClient) {
                ParRegUtil.verifySize(this.aRegion, this.regionSnapshot.size());
            }
            DataPolicy dataPolicy = this.aRegion.getAttributes().getDataPolicy();
            if (ParRegPrms.getDoOnlineBackup() && dataPolicy.withPersistence() && dataPolicy.withPartitioning()) {
                PersistenceUtil.doOnlineBackup(false);
            } else if (ParRegPrms.getDoIncrementalBackup() && dataPolicy.withPersistence() && dataPolicy.withPartitioning()) {
                long backupNumber = ParRegBB.getBB().getSharedCounters().read(ParRegBB.onlineBackupNumber);
                if (backupNumber == 0L) {
                    Log.getLogWriter().fine("Incremental backup parameter set.  Performing full backup for number " + backupNumber);
                    PersistenceUtil.doOnlineBackup(false);
                } else {
                    Log.getLogWriter().fine("Incremental backup parameter set.  Performing incremental backup for number " + backupNumber);
                    PersistenceUtil.doOnlineBackup(true);
                }
            }
            try {
                long backupNum = ParRegBB.getBB().getSharedCounters().read(ParRegBB.onlineBackupNumber);
                String snapFileName = "snapshotForBackup_" + backupNum + ".ser";
                String destroyedFileName = "destroyKeysForBackup_" + backupNum + ".ser";
                FileOutputStream fos = new FileOutputStream(snapFileName);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.regionSnapshot);
                fos = new FileOutputStream(destroyedFileName);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(this.destroyedKeys);
            }
            catch (FileNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (this.highAvailability) {
                this.cycleVMsNoWait();
                this.verifyFromSnapshotOnly();
                this.waitForRecoveryAfterCycleVMs();
                this.verifyInternalPRState();
                this.loseAndRecreatePR(originalClassLoader, newClassLoader);
            }
        } else if (roundPosition != (long)this.numThreadsInClients) {
            Log.getLogWriter().info("In doRROpsAndVerify, neither first nor last");
            this.verifyFromSnapshot();
        }
    }

    protected void loseAndRecreatePR(ClassLoader originalClassLoader, ClassLoader newClassLoader) {
        int i;
        Object[] choices = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
        if (this.isBridgeConfiguration && !this.isBridgeClient) {
            choices = new Object[]{new Integer(0), new Integer(1)};
        } else {
            DataPolicy dataPolicy = this.aRegion.getAttributes().getDataPolicy();
            if (this.isDataStore && this.redundantCopies == 0 && dataPolicy.withPersistence() && dataPolicy.withPartitioning()) {
                choices = new Object[]{new Integer(0), new Integer(1), new Integer(3)};
            }
        }
        List<Object> aList = Arrays.asList(choices);
        ArrayList otherVMs = new ArrayList(ClientVmMgr.getOtherClientVmids());
        for (i = 0; i < aList.size(); ++i) {
            Collections.swap(aList, i, TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1));
        }
        for (i = 0; i < aList.size(); ++i) {
            String cachePrmsName;
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            int choice = (Integer)aList.get(i);
            if (choice == 0) {
                Log.getLogWriter().info("Losing PR by closing the cache...");
                if (this.isClientCache) {
                    ClientCacheHelper.closeCache();
                } else {
                    CacheHelper.closeCache();
                }
            } else if (choice == 1) {
                Log.getLogWriter().info("Losing PR by disconnecting from the distributed system...");
                DistributedSystemHelper.disconnect();
            } else if (choice == 2) {
                Log.getLogWriter().info("Losing PR by locally destroying the partitioned region...");
                this.aRegion.localDestroyRegion();
            } else if (choice == 3) {
                Log.getLogWriter().info("Losing PR by closing the partitioned region...");
                this.aRegion.close();
            }
            Log.getLogWriter().info("Recreating the partitioned region...");
            String string = cachePrmsName = this.isDataStore ? "cache1" : ParRegTest.getCachePrmsName();
            if (newClassLoader != null) {
                Log.getLogWriter().info("Setting class loader to original " + originalClassLoader + " for reinit step");
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            this.HA_reinitializeRegion(cachePrmsName);
            Log.getLogWriter().info("Done recreating the partitioned region...");
            if (newClassLoader != null) {
                Log.getLogWriter().info("Resetting the class loader after reinit step");
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            if (this.isBridgeConfiguration) {
                if (ParRegTest.testInstance.isBridgeClient) {
                    ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
                } else {
                    BridgeHelper.startBridgeServer("bridge");
                }
            }
            this.verifyFromSnapshotOnly();
            if (this.isDataStore) {
                RegionAttributes attr = this.aRegion.getAttributes();
                PartitionAttributes prAttr = attr.getPartitionAttributes();
                if (prAttr.getRedundantCopies() != 0) {
                    int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
                    PRObserver.waitForRecovery(prAttr.getRecoveryDelay(), prAttr.getStartupRecoveryDelay(), new Integer(RemoteTestModule.getMyVmid()), otherVMs, 1, numPRs, null, null);
                } else {
                    Log.getLogWriter().info("Redundant copies is 0 so no redundancy recovery to wait for");
                }
            }
            this.verifyInternalPRState();
        }
    }

    protected void doConcOps() {
        this.doEntryOperations(this.aRegion);
        int entries = this.aRegion.size();
        if (entries >= this.upperThreshold - this.numThreadsInClients) {
            String s = "Done adding " + entries + " entries";
            throw new StopSchedulingTaskOnClientOrder(s);
        }
    }

    protected void doConcOpsAndVerify() {
        DataPolicy dataPolicy;
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ReadyToBegin);
        if (counter == 1L) {
            ParRegTest.logExecutionNumber();
        }
        this.offHeapVerifyTargetCount = this.getOffHeapVerifyTargetCount();
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        concVerifyCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "concVerify");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ConcurrentLeader);
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.ReadyToBegin", ParRegBB.ReadyToBegin, this.numThreadsInClients, true, -1L, 1000L);
        this.checkForLastIteration();
        Log.getLogWriter().info("Zeroing ShapshotWritten and finishedMemCheck");
        MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.finishedMemCheck);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.SnapshotWritten);
        boolean doOnlineBackup = false;
        if ((ParRegPrms.getDoOnlineBackup() || ParRegPrms.getDoIncrementalBackup()) && !this.isBridgeClient && (dataPolicy = this.aRegion.getAttributes().getDataPolicy()).withPersistence() && dataPolicy.withPartitioning()) {
            counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.onlineBackup);
            boolean bl = doOnlineBackup = counter == 1L;
        }
        if (doOnlineBackup && ParRegPrms.getDoOnlineBackup()) {
            PersistenceUtil.doOnlineBackup(false);
            if (CliHelperPrms.getUseCli()) {
                this.destroyPercent(this.aRegion, false, 50);
                Set<String> diskStores = PersistenceUtil.getDiskStores();
                for (String diskStoreName : diskStores) {
                    String command = "compact disk-store --name=" + diskStoreName;
                    String result = CliHelper.execCommandOnRemoteCli(command, true)[1];
                    boolean compactionResult = ((LocalRegion)this.aRegion).getDiskStore().forceCompaction();
                    if (!result.contains("Compaction was attempted but nothing to compact") || !compactionResult) continue;
                    throw new TestException("The result of running command " + command + " returned " + result + " but forcing a compaction returned " + compactionResult + " indicating it found work to do");
                }
            }
        } else if (doOnlineBackup && ParRegPrms.getDoIncrementalBackup()) {
            boolean incremental = ParRegBB.getBB().getSharedCounters().read(ParRegBB.onlineBackupNumber) > 0L;
            PersistenceUtil.doOnlineBackup(incremental);
        } else {
            this.doEntryOperations(this.aRegion);
        }
        ClientCache cache = this.isClientCache ? ClientCacheHelper.getCache() : CacheHelper.getCache();
        RebalanceFactory factory = cache.getResourceManager().createRebalanceFactory();
        RebalanceOperation rop = factory.start();
        RebalanceResults results = null;
        try {
            results = rop.getResults();
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(results, "rebalance"));
        Log.getLogWriter().info("Zeroing FinishedVerify");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing ReadyToBegin");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ReadyToBegin);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.onlineBackup);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
            if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
                registerInterestCoordinator.executeOnce(this, new Object[0]);
                if (!registerInterestCoordinator.methodWasExecuted()) {
                    throw new TestException("Test problem: RegisterInterest did not execute");
                }
            }
        }
        concVerifyCoordinator.executeOnce(this, new Object[0]);
        if (!concVerifyCoordinator.methodWasExecuted()) {
            throw new TestException("Test problem: concVerify did not execute");
        }
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing Pausing");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
        counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
        if (this.isBridgeClient) {
            ClientHelper.release(this.aRegion);
        }
    }

    public int getOffHeapVerifyTargetCount() {
        return TestHelper.getNumVMs();
    }

    protected void HAController() {
        ParRegTest.logExecutionNumber();
        ParRegBB.getBB().getSharedMap().put(shutDownAllInProgressKey, new Boolean(false));
        this.thisVmRunningHAController = true;
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        this.checkForLastIteration();
        Log.getLogWriter().info("setting exceptionCount to 0");
        this.exceptionCount = 0;
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ConcurrentLeader);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Reinitialized);
        this.cycleVms();
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        PRObserver.initialize(RemoteTestModule.getMyVmid());
        ArrayList<ClientVmInfo> thisVmAsList = new ArrayList<ClientVmInfo>();
        thisVmAsList.add(new ClientVmInfo(RemoteTestModule.getMyVmid(), RemoteTestModule.getMyClientName(), null));
        long maxChoices = 4L;
        if (this.isBridgeConfiguration) {
            maxChoices = 2L;
        }
        List<ClientVmInfo> me = Collections.singletonList(new ClientVmInfo(new Integer(RemoteTestModule.getMyVmid()), RemoteTestModule.getMyClientName(), RemoteTestModule.getMyLogicalHost()));
        this.clearBBCriticalState(me);
        long choice = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.choice) % maxChoices;
        if (choice == 0L) {
            Log.getLogWriter().info("Closing the cache...");
            this.cacheIsClosed = true;
            if (this.isClientCache) {
                ClientCacheHelper.closeCache();
            } else {
                CacheHelper.closeCache();
            }
        } else if (choice == 1L) {
            Log.getLogWriter().info("Disconnecting from the distributed system...");
            this.disconnected = true;
            DistributedSystemHelper.disconnect();
        } else if (choice == 2L) {
            Log.getLogWriter().info("Locally destroying the partitioned region...");
            this.regionLocallyDestroyed = true;
            this.aRegion.localDestroyRegion();
        } else if (choice == 3L) {
            Log.getLogWriter().info("Closing the partitioned region...");
            this.regionLocallyDestroyed = true;
            this.aRegion.close();
        } else {
            throw new TestException("Test problem; Unknown choice " + choice);
        }
        while (this.exceptionCount != this.numThreadsInThisVM - 1) {
            Log.getLogWriter().info("Waiting for exceptionCount " + this.exceptionCount + " to become " + (this.numThreadsInThisVM - 1));
            MasterController.sleepForMs(1000);
        }
        Log.getLogWriter().info("Exception count is " + this.exceptionCount + " expected count to be " + (this.numThreadsInThisVM - 1));
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.SnapshotWritten);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.rebalanceCompleted);
        MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.finishedMemCheck);
        Log.getLogWriter().info("Recreating the partitioned region...");
        String cachePrmsName = this.isDataStore ? "cache1" : ParRegTest.getCachePrmsName();
        this.HA_reinitializeRegion(cachePrmsName);
        Log.getLogWriter().info("Done recreating the partitioned region...");
        PdxTest.initClassLoader();
        if (this.isBridgeConfiguration) {
            if (this.isBridgeClient) {
                ParRegUtil.registerInterest(this.aRegion);
            } else {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        this.cacheIsClosed = false;
        this.disconnected = false;
        this.regionLocallyDestroyed = false;
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Reinitialized);
        if (this.isDataStore && this.redundantCopies > 0) {
            this.waitForSelfRecovery();
        } else {
            Log.getLogWriter().info("No redundancy recovery because this is not a data store with redundantCopies > 0");
        }
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
            registerInterestCoordinator.executeOnce(this, new Object[0]);
            if (!registerInterestCoordinator.methodWasExecuted()) {
                throw new TestException("Test problem: RegisterInterest did not execute");
            }
        }
        Log.getLogWriter().info("Starting concVerify");
        this.concVerify();
        Log.getLogWriter().info("Done with concVerify");
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
        Log.getLogWriter().info("Starting rebalancing");
        ParRegUtil.doRebalance();
        Log.getLogWriter().info("Done with rebalancing");
        this.verifyFromSnapshot();
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.rebalanceCompleted);
        this.thisVmRunningHAController = false;
        long counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
        if (this.isBridgeClient) {
            ClientHelper.release(this.aRegion);
        }
    }

    protected void HADoEntryOps() {
        this.checkForLastIteration();
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        try {
            testInstance.doEntryOperations(ParRegTest.testInstance.aRegion);
            if (ParRegBB.getBB().getSharedCounters().read(ParRegBB.Pausing) > 0L) {
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
                if (this.isBridgeConfiguration) {
                    SilenceListener.waitForSilence(30L, 5000L);
                }
                if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
                    registerInterestCoordinator.executeOnce(this, new Object[0]);
                    if (!registerInterestCoordinator.methodWasExecuted()) {
                        throw new TestException("Test problem: RegisterInterest did not execute");
                    }
                }
                this.concVerify();
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.rebalanceCompleted", ParRegBB.rebalanceCompleted, 1L, true, -1L, 5000L);
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.isBridgeClient) {
            ClientHelper.release(ParRegTest.testInstance.aRegion);
        }
    }

    protected void shutDownAllHAController() {
        ParRegTest.logExecutionNumber();
        this.thisVmRunningHAController = true;
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        this.checkForLastIteration();
        Log.getLogWriter().info("setting exceptionCount to 0");
        this.exceptionCount = 0;
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ConcurrentLeader);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Reinitialized);
        MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.finishedMemCheck);
        Log.getLogWriter().info("Sleeping for 15 seconds to allow threads to do ops...");
        MasterController.sleepForMs(15000);
        this.doShutDownAllMembers();
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        PRObserver.initialize(RemoteTestModule.getMyVmid());
        ArrayList otherVMs = new ArrayList(ClientVmMgr.getOtherClientVmids());
        ArrayList<ClientVmInfo> thisVmAsList = new ArrayList<ClientVmInfo>();
        thisVmAsList.add(new ClientVmInfo(RemoteTestModule.getMyVmid(), RemoteTestModule.getMyClientName(), null));
        List<ClientVmInfo> me = Collections.singletonList(new ClientVmInfo(new Integer(RemoteTestModule.getMyVmid()), RemoteTestModule.getMyClientName(), RemoteTestModule.getMyLogicalHost()));
        this.clearBBCriticalState(me);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.SnapshotWritten);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.rebalanceCompleted);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Reinitialized);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
            registerInterestCoordinator.executeOnce(this, new Object[0]);
            if (!registerInterestCoordinator.methodWasExecuted()) {
                throw new TestException("Test problem: RegisterInterest did not execute");
            }
        }
        Log.getLogWriter().info("Starting concVerify");
        this.concVerify();
        Log.getLogWriter().info("Done with concVerify");
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
        Log.getLogWriter().info("Starting rebalancing");
        ParRegUtil.doRebalance();
        Log.getLogWriter().info("Done with rebalancing");
        this.verifyFromSnapshot();
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.rebalanceCompleted);
        this.thisVmRunningHAController = false;
        long counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
        if (this.isBridgeClient) {
            ClientHelper.release(this.aRegion);
        }
    }

    protected void shutDownAllHADoEntryOps() {
        this.checkForLastIteration();
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        try {
            testInstance.doEntryOperations(ParRegTest.testInstance.aRegion);
            if (ParRegBB.getBB().getSharedCounters().read(ParRegBB.Pausing) > 0L) {
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
                if (this.isBridgeConfiguration) {
                    SilenceListener.waitForSilence(30L, 5000L);
                }
                if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
                    registerInterestCoordinator.executeOnce(this, new Object[0]);
                    if (!registerInterestCoordinator.methodWasExecuted()) {
                        throw new TestException("Test problem: RegisterInterest did not execute");
                    }
                }
                this.concVerify();
                ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
                TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.rebalanceCompleted", ParRegBB.rebalanceCompleted, 1L, true, -1L, 5000L);
                ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.isBridgeClient) {
            ClientHelper.release(ParRegTest.testInstance.aRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleException(Exception anExcept) {
        boolean disconnectError;
        Object mapValue = ParRegBB.getBB().getSharedMap().get(shutDownAllInProgressKey);
        boolean shutDownAllInProgress = false;
        if (mapValue instanceof Boolean) {
            shutDownAllInProgress = (Boolean)mapValue;
        }
        mapValue = ParRegBB.getBB().getSharedMap().get(expectOfflineExceptionKey);
        boolean expectOfflineException = false;
        if (mapValue instanceof Boolean) {
            expectOfflineException = (Boolean)mapValue;
        }
        boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
        String errStr = anExcept.toString();
        boolean bl = disconnectError = errStr.indexOf("This connection to a distributed system has been disconnected") >= 0 || errStr.indexOf("System is disconnecting") >= 0;
        if (anExcept instanceof CancelException) {
            if (!(thisVMReceivedNiceKill || this.cacheIsClosed || this.disconnected || shutDownAllInProgress || anExcept instanceof PoolCancelledException && this.isBridgeConfiguration && this.regionLocallyDestroyed)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof LockServiceDestroyedException) {
            if (!(this.lockOperations && thisVMReceivedNiceKill || this.lockOperations && this.disconnected || this.lockOperations && this.cacheIsClosed)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof IllegalStateException) {
            if (disconnectError) {
                if (!this.disconnected && !thisVMReceivedNiceKill) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            } else {
                if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
                if (errStr.indexOf("Proxy not properly initialized") < 0) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            }
        } else if (anExcept instanceof CacheLoaderException) {
            if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill && !this.regionLocallyDestroyed && !this.disconnected && !this.cacheIsClosed) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (anExcept.toString().indexOf("The BridgeLoader has been closed") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof BridgeWriterException) {
            if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill && !this.regionLocallyDestroyed && !this.disconnected && !this.cacheIsClosed) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (anExcept.toString().indexOf("The BridgeWriter has been closed") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof RegionDestroyedException) {
            if (!(this.regionLocallyDestroyed || shutDownAllInProgress || thisVMReceivedNiceKill)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof PartitionOfflineException || anExcept instanceof ServerOperationException && anExcept.getCause() instanceof PartitionOfflineException) {
            if (!expectOfflineException) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
            if (!this.thisVmRunningHAController) {
                Log.getLogWriter().info("handleException got expected exception " + anExcept + ", returning normally to allow a possible nice exit, continuing test");
                return;
            }
        } else if (anExcept instanceof CacheClosedException) {
            if (!shutDownAllInProgress) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof DistributedSystemDisconnectedException) {
            if (!shutDownAllInProgress) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof ToDataException) {
            if (!(thisVMReceivedNiceKill || this.disconnected || this.cacheIsClosed)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
            Throwable lastCausedBy = TestHelper.getLastCausedBy(anExcept);
            if (!(lastCausedBy instanceof CacheClosedException) && lastCausedBy instanceof EOFException) {
                void var9_10;
                Exception exception = anExcept;
                Throwable currCausedBy = anExcept.getCause();
                if (currCausedBy != null) {
                    while (currCausedBy.getCause() != null) {
                        Throwable throwable = currCausedBy;
                        currCausedBy.getCause();
                    }
                }
                if (!(var9_10 instanceof CacheClosedException)) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            }
        } else {
            if (!(anExcept instanceof com.gemstone.gemfire.admin.RegionNotFoundException)) throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
            String aStr = anExcept.toString();
            if (aStr.indexOf(" could not be found while reading a DataSerializer stream") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        }
        Log.getLogWriter().info("Caught " + anExcept + "; expected, continuing test");
        ParRegTest parRegTest = this;
        synchronized (parRegTest) {
            ++this.exceptionCount;
            Log.getLogWriter().info("exceptionCount is now " + this.exceptionCount);
        }
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Reinitialized", ParRegBB.Reinitialized, 1L, true, -1L, 1000L);
    }

    protected void recoveryController() {
        ParRegTest.logExecutionNumber();
        if (!this.isDataStore) {
            throw new TestException("Test config error; accessor vm cannot run this task");
        }
        MasterController.sleepForMs(20000);
        this.thisVmRunningHAController = true;
        Log.getLogWriter().info("Stopping all vms except myself");
        List otherClientInfos = StopStartVMs.getAllVMs();
        ArrayList<ClientVmInfo> accessors = new ArrayList<ClientVmInfo>();
        ArrayList<ClientVmInfo> dataStores = new ArrayList<ClientVmInfo>();
        int myselfIndex = -1;
        for (int i = 0; i < otherClientInfos.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)otherClientInfos.get(i);
            if (info.toString().indexOf("vm_" + RemoteTestModule.getMyVmid() + "_") >= 0) {
                myselfIndex = i;
                continue;
            }
            if (info.toString().indexOf("dataStore") >= 0) {
                dataStores.add(info);
                continue;
            }
            accessors.add(info);
        }
        ClientVmInfo myself = (ClientVmInfo)otherClientInfos.remove(myselfIndex);
        Log.getLogWriter().info("List of other VMs: " + otherClientInfos);
        Log.getLogWriter().info("List of dataStores: " + dataStores);
        Log.getLogWriter().info("List of accessors: " + accessors);
        Log.getLogWriter().info("Myself: " + myself);
        ArrayList<ClientVmInfo> notChosenVMs = new ArrayList<ClientVmInfo>();
        for (ClientVmInfo info : otherClientInfos) {
            notChosenVMs.add(info);
        }
        ArrayList targetVMs = new ArrayList();
        while (otherClientInfos.size() > 0) {
            PRObserver.initialize();
            int numToStopThisTime = Math.min(this.redundantCopies, otherClientInfos.size());
            ArrayList<ClientVmInfo> vmsToStopThisTime = new ArrayList<ClientVmInfo>();
            ArrayList<String> stopModeList = new ArrayList<String>();
            while (vmsToStopThisTime.size() < numToStopThisTime) {
                ClientVmInfo clientInfo = (ClientVmInfo)otherClientInfos.get(0);
                otherClientInfos.remove(0);
                vmsToStopThisTime.add(clientInfo);
                stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
                notChosenVMs.remove(clientInfo);
            }
            targetVMs.addAll(vmsToStopThisTime);
            StopStartVMs.stopVMs(vmsToStopThisTime, stopModeList);
            Log.getLogWriter().info("After stopping " + vmsToStopThisTime + ", remaining is " + otherClientInfos);
            if (this.redundantCopies == 0) continue;
            List dataStoresNotChosen = StopStartVMs.getMatchVMs(notChosenVMs, "dataStore");
            dataStoresNotChosen.addAll(StopStartVMs.getMatchVMs(notChosenVMs, "bridge"));
            dataStoresNotChosen.add(myself);
            List targetDataStores = StopStartVMs.getMatchVMs(targetVMs, "dataStore");
            targetDataStores.addAll(StopStartVMs.getMatchVMs(targetVMs, "bridge"));
            if (dataStoresNotChosen.size() <= 0) continue;
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRebalRecov(dataStoresNotChosen, vmsToStopThisTime.size(), numPRs, null, null, true);
        }
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        MasterController.sleepForMs(10000);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInThisVM, true, -1L, 2000L);
        HashMap rSnapshot = new HashMap();
        Set keySet = ParRegTest.testInstance.aRegion.keySet();
        for (Object key : keySet) {
            Object value = null;
            if (ParRegTest.testInstance.aRegion.containsValueForKey(key)) {
                value = ParRegTest.testInstance.aRegion.get(key);
            }
            if (value instanceof BaseValueHolder || value instanceof PdxInstance) {
                rSnapshot.put(key, PdxTest.toValueHolder((Object)value).myValue);
                continue;
            }
            rSnapshot.put(key, value);
        }
        Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + rSnapshot.size() + ": " + rSnapshot);
        ParRegBB.getBB().getSharedMap().put("RegionSnapshot", rSnapshot);
        ParRegBB.getBB().getSharedMap().put("DestroyedKeys", new HashSet());
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        this.disconnected = true;
        Log.getLogWriter().info("Disconnecting myself from the distributed system");
        DistributedSystemHelper.getDistributedSystem().disconnect();
        this.thisVmRunningHAController = false;
        PRObserver.initialize(RemoteTestModule.getMyVmid());
        PRObserver.initialize();
        Log.getLogWriter().info("Starting datastores first...");
        List threadList = StopStartVMs.startAsync(dataStores);
        Log.getLogWriter().info("Recreating the partitioned region...");
        this.HA_reinitializeRegion("cache1");
        this.disconnected = false;
        Log.getLogWriter().info("Done recreating the partitioned region...");
        Log.getLogWriter().info("Waiting for datastore to complete recovery before allowing accessors to proceed");
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, ParRegTest.testInstance.numThreadsInThisVM * dataStores.size(), false, -1L, 2000L);
        Log.getLogWriter().info("Starting accessors next...");
        threadList.addAll(StopStartVMs.startAsync(accessors));
        for (Thread aThread : threadList) {
            try {
                aThread.join();
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("All vms are back; they have completed verification");
        this.verifyFromSnapshot();
        ParRegUtil.doRebalance();
        this.verifyFromSnapshot();
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients - this.numThreadsInThisVM, true, -1L, 5000L);
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
        long counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
        if (this.isBridgeClient) {
            ClientHelper.release(this.aRegion);
        }
    }

    protected void recoveryEntryOps() {
        this.checkForLastIteration();
        long pausing = ParRegBB.getBB().getSharedCounters().read(ParRegBB.Pausing);
        if (pausing > 0L) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
            TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients - this.numThreadsInThisVM + 1, true, -1L, 5000L);
        }
        try {
            testInstance.doEntryOperations(ParRegTest.testInstance.aRegion);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doEntryOperations(Region r) {
        Log.getLogWriter().info("In doEntryOperations with " + r.getFullPath());
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        startTime = System.currentTimeMillis();
        numOps = 0;
        useTransactions = InitImagePrms.useTransactions();
        if (!useTransactions || this.isBridgeClient) {
            // empty if block
        }
        do {
            block65: {
                opInfo = this.getOperation(r);
                whichOp = opInfo[0];
                gotTheLock = false;
                if (this.lockOperations) {
                    Log.getLogWriter().info("Trying to get distributed lock " + ParRegTest.LOCK_NAME + "...");
                    gotTheLock = this.distLockService.lock((Object)ParRegTest.LOCK_NAME, -1L, -1L);
                    if (!gotTheLock) {
                        throw new TestException("Did not get lock " + ParRegTest.LOCK_NAME);
                    }
                    Log.getLogWriter().info("Got distributed lock " + ParRegTest.LOCK_NAME + ": " + gotTheLock);
                }
                rolledback = false;
                if (useTransactions) {
                    TxHelper.begin();
                    if (this.isBridgeClient && this.isSerialExecution) {
                        this.saveRegionSnapshot();
                    }
                }
                try {
                    switch (whichOp) {
                        case 1: {
                            this.addEntry(r);
                            ** break;
lbl30:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            this.invalidateEntry(r, false);
                            ** break;
lbl34:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.destroyEntry(r, false);
                            ** break;
lbl38:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            this.updateEntry(r);
                            ** break;
lbl42:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            this.getKey(r);
                            ** break;
lbl46:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            this.getNewKey(r);
                            ** break;
lbl50:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            this.invalidateEntry(r, true);
                            ** break;
lbl54:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            this.destroyEntry(r, true);
                            ** break;
lbl58:
                            // 1 sources

                            break;
                        }
                        case 9: {
                            this.putAll(r);
                            ** break;
lbl62:
                            // 1 sources

                            break;
                        }
                        case 10: {
                            this.destroyPercent(r, false, opInfo[1]);
                            ** break;
lbl66:
                            // 1 sources

                            break;
                        }
                        case 11: {
                            this.destroyPercent(r, true, opInfo[1]);
                            ** break;
lbl70:
                            // 1 sources

                            break;
                        }
                        case 12: {
                            this.putIfAbsent(r, true);
                            ** break;
lbl74:
                            // 1 sources

                            break;
                        }
                        case 13: {
                            this.putIfAbsentAsGet(r);
                            ** break;
lbl78:
                            // 1 sources

                            break;
                        }
                        case 14: {
                            this.putIfAbsentAsCreate(r);
                            ** break;
lbl82:
                            // 1 sources

                            break;
                        }
                        case 15: {
                            this.remove(r);
                            ** break;
lbl86:
                            // 1 sources

                            break;
                        }
                        case 16: {
                            this.removeAsNoop(r);
                            ** break;
lbl90:
                            // 1 sources

                            break;
                        }
                        case 17: {
                            this.replace(r, true);
                            ** break;
lbl94:
                            // 1 sources

                            break;
                        }
                        case 19: {
                            this.replaceAsNoop(r);
                            ** break;
lbl98:
                            // 1 sources

                            break;
                        }
                        case 18: {
                            this.replaceAsUpdate(r);
                            ** break;
lbl102:
                            // 1 sources

                            break;
                        }
                        case 20: {
                            this.replace(r, false);
                            ** break;
lbl106:
                            // 1 sources

                            break;
                        }
                        case 21: {
                            this.replaceOld(r, false);
                            ** break;
lbl110:
                            // 1 sources

                            break;
                        }
                        case 23: {
                            this.replaceOldAsNoop(r);
                            ** break;
lbl114:
                            // 1 sources

                            break;
                        }
                        case 22: {
                            this.replaceOldAsUpdate(r);
                            ** break;
lbl118:
                            // 1 sources

                            break;
                        }
                        case 24: {
                            this.replaceOld(r, false);
                            ** break;
lbl122:
                            // 1 sources

                            break;
                        }
                        case 25: {
                            this.query(r);
                            ** break;
lbl126:
                            // 1 sources

                            break;
                        }
                        case 26: {
                            this.createIndex(r);
                            ** break;
lbl130:
                            // 1 sources

                            break;
                        }
                        case 27: {
                            this.removeIndex(r);
                            ** break;
lbl134:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new TestException("Unknown operation " + whichOp);
                        }
                    }
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    if (!useTransactions) {
                        throw new TestException("Unexpected Exception " + (Object)e + ", " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)e + ".  Expected with HA, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (TransactionException te) {
                        Log.getLogWriter().info("Caught exception " + (Object)te + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                    }
                    rolledback = true;
                }
                catch (TransactionDataRebalancedException e) {
                    if (!useTransactions) {
                        throw new TestException("Unexpected Exception " + (Object)e + ". " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)e + ".  Expected with HA, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (TransactionException te) {
                        Log.getLogWriter().info("Caught exception " + (Object)te + " on rollback() after catching Exception " + (Object)e + " during tx ops.  Expected, continuing test.");
                    }
                    rolledback = true;
                }
                catch (ToDataException e) {
                    lastCausedBy = TestHelper.getLastCausedBy(e);
                    if (lastCausedBy instanceof TransactionDataNodeHasDepartedException) {
                        if (!useTransactions) {
                            throw new TestException("Unexpected Exception " + (Object)e + ", " + TestHelper.getStackTrace(e));
                        }
                        Log.getLogWriter().info("Caught Exception " + (Object)e + ".  Expected with HA, continuing test.");
                        Log.getLogWriter().info("Rolling back transaction.");
                        try {
                            TxHelper.rollback();
                            Log.getLogWriter().info("Done Rolling back Transaction");
                        }
                        catch (TransactionException te) {
                            Log.getLogWriter().info("Caught exception " + (Object)te + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                        }
                        rolledback = true;
                        break block65;
                    }
                    throw e;
                }
                finally {
                    if (gotTheLock) {
                        gotTheLock = false;
                        this.distLockService.unlock((Object)ParRegTest.LOCK_NAME);
                        Log.getLogWriter().info("Released distributed lock " + ParRegTest.LOCK_NAME);
                    }
                }
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)e + " on commit.  Expected with HA, continuing test.");
                    if (this.isSerialExecution && this.isBridgeClient) {
                        this.restoreRegionSnapshot();
                    }
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)e + " on commit.  Expected with HA, continuing test.");
                    if (this.isSerialExecution && this.isBridgeClient) {
                        this.restoreRegionSnapshot();
                    }
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)e + " on commit.  Expected with concurrent execution, continuing test.");
                    if (this.isSerialExecution && this.isBridgeClient) {
                        this.restoreRegionSnapshot();
                    }
                    this.recordFailedOps(ParRegBB.INDOUBT_TXOPS);
                }
                catch (ConflictException e) {
                    if (!this.isSerialExecution) {
                        Log.getLogWriter().info("Caught Exception " + (Object)e + " on commit. Expected with concurrent execution, continuing test.");
                    }
                    throw new TestException("Unexpected " + (Object)e + ". " + TestHelper.getStackTrace(e));
                }
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
        Log.getLogWriter().info("Done in doEntryOperations with " + r.getFullPath());
    }

    protected void recordFailedOps(String sharedMapKey) {
    }

    protected void saveRegionSnapshot() {
        this.txRegionSnapshot = new HashMap(this.regionSnapshot);
        this.txDestroyedKeys = new HashSet(this.destroyedKeys);
    }

    protected void restoreRegionSnapshot() {
        this.regionSnapshot = this.txRegionSnapshot;
        this.destroyedKeys = this.txDestroyedKeys;
        this.txRegionSnapshot = null;
        this.txDestroyedKeys = null;
    }

    protected Object addEntry(Region r) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = r.size();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                try {
                    Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + r.getFullPath());
                    r.create(key, (Object)anObj, (Object)callback);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (EntryExistsException e) {
                    if (this.isSerialExecution) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                }
            } else {
                try {
                    Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + r.getFullPath());
                    r.create(key, (Object)anObj);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (EntryExistsException e) {
                    if (this.isSerialExecution) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                }
            }
        } else {
            Object returnVal = null;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + r.getFullPath());
                returnVal = r.put(key, (Object)anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            } else {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + r.getFullPath());
                returnVal = r.put(key, (Object)anObj);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            }
            if (!this.isSerialExecution || this.isBridgeConfiguration) {
                // empty if block
            }
        }
        if (this.isSerialExecution) {
            if (this.isEmptyClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifySize(r, 0);
                }
            } else if (this.isThinClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifyContainsKey(r, key, true);
                    ParRegUtil.verifyContainsValueForKey(r, key, true);
                    if (!this.isClientCache) {
                        if (beforeSize < this.LRUEntryMax) {
                            ParRegUtil.verifySize(r, beforeSize + 1);
                        } else {
                            ParRegUtil.verifySize(r, this.LRUEntryMax);
                        }
                    }
                }
            } else {
                ParRegUtil.verifyContainsKey(r, key, true);
                ParRegUtil.verifyContainsValueForKey(r, key, true);
                ParRegUtil.verifySize(r, beforeSize + 1);
            }
            this.regionSnapshot.put(key, anObj.myValue);
            this.destroyedKeys.remove(key);
        }
        return key;
    }

    protected void putAll(Region r) {
        int beforeSize = 0;
        beforeSize = this.isThinClient || this.isEmptyClient ? r.keySetOnServer().size() : r.size();
        int localBeforeSize = r.size();
        int numNewKeysToPut = 0;
        int numPutAllExistingKeys = 0;
        boolean limitPutAllToOne = ParRegPrms.getLimitPutAllToOne();
        if (limitPutAllToOne) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                numNewKeysToPut = 1;
            } else {
                numPutAllExistingKeys = 1;
            }
        } else {
            numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
            String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
            if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
                numNewKeysToPut = this.upperThreshold - beforeSize;
                if (numNewKeysToPut <= 0) {
                    numNewKeysToPut = 1;
                } else {
                    int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                    max = Math.min(numNewKeysToPut, max);
                    int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                    min = Math.min(min, max);
                    numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
                }
            } else {
                numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
            }
        }
        Map mapToPut = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKey();
            BaseValueHolder anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        List keyList = ParRegUtil.getExistingKeys(r, this.uniqueKeys, this.numThreadsInClients, numPutAllExistingKeys, this.isThinClient || this.isEmptyClient);
        StringBuffer existingKeys = new StringBuffer();
        if (numPutAllExistingKeys > 0 && keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                String key = (String)keyList.get(i);
                Object anObj = this.getUpdateObject(r, key);
                mapToPut.put(key, anObj);
                existingKeys.append(key + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("PR size is " + beforeSize + ", local region size is " + localBeforeSize + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\n" + "existing keys are: " + existingKeys);
        for (String key : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + key + ", value " + TestHelper.toString(mapToPut.get(key)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
        if (this.isSerialExecution) {
            if (this.isEmptyClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifySize(r, 0);
                }
            } else if (this.isThinClient) {
                if (!TxHelper.exists() && !this.isClientCache) {
                    if (localBeforeSize < this.LRUEntryMax) {
                        int localAfterSize = r.size();
                        int expectedMinSize = localBeforeSize + numNewKeysToPut;
                        int expectedMaxSize = Math.min(localBeforeSize + mapToPut.size(), this.LRUEntryMax);
                        if (localAfterSize < localBeforeSize || localAfterSize > expectedMaxSize) {
                            throw new TestException("Expected local region size to be between " + expectedMinSize + " and " + expectedMaxSize + " inclusive, but it is " + localAfterSize);
                        }
                    } else if (!TxHelper.exists()) {
                        ParRegUtil.verifySize(r, this.LRUEntryMax);
                    }
                }
            } else {
                ParRegUtil.verifySize(r, beforeSize + numNewKeysToPut);
            }
            for (Object key : mapToPut.keySet()) {
                BaseValueHolder value = PdxTest.toValueHolder(mapToPut.get(key));
                if (!this.isEmptyClient && !this.isThinClient) {
                    ParRegUtil.verifyContainsKey(r, key, true);
                    ParRegUtil.verifyContainsValueForKey(r, key, true);
                }
                this.regionSnapshot.put(key, value.myValue);
                this.destroyedKeys.remove(key);
            }
        }
    }

    protected void invalidateEntry(Region r, boolean isLocalInvalidate) {
        int beforeSize = r.size();
        Object key = ParRegUtil.getExistingKey(r, this.uniqueKeys, this.numThreadsInClients, this.isEmptyClient || this.isThinClient);
        if (key == null) {
            if (this.isSerialExecution && beforeSize != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + beforeSize);
            }
            Log.getLogWriter().info("invalidateEntry: No keys in region");
            return;
        }
        boolean containsKey = r.containsKey(key);
        boolean containsValueForKey = r.containsValueForKey(key);
        Log.getLogWriter().info("containsKey for " + key + ": " + containsKey);
        Log.getLogWriter().info("containsValueForKey for " + key + ": " + containsValueForKey);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    r.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    r.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                r.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                r.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
            if (this.isSerialExecution) {
                if (this.isEmptyClient) {
                    if (!TxHelper.exists()) {
                        ParRegUtil.verifySize(r, 0);
                    }
                } else if (this.isThinClient) {
                    if (!TxHelper.exists()) {
                        ParRegUtil.verifySize(r, beforeSize);
                    }
                } else {
                    ParRegUtil.verifySize(r, beforeSize);
                    ParRegUtil.verifyContainsKey(r, key, true);
                    ParRegUtil.verifyContainsValueForKey(r, key, false);
                }
                this.regionSnapshot.put(key, null);
                this.destroyedKeys.remove(key);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region r, boolean isLocalDestroy) {
        Object key = ParRegUtil.getExistingKey(r, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
        if (key == null) {
            int size = r.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("destroyEntry: No keys in region");
            return;
        }
        int beforeSize = r.size();
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    r.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    r.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                r.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                r.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
            if (this.isSerialExecution) {
                if (this.isEmptyClient) {
                    if (!TxHelper.exists()) {
                        ParRegUtil.verifySize(r, 0);
                    }
                } else if (this.isThinClient) {
                    if (!TxHelper.exists()) {
                        ParRegUtil.verifyContainsKey(r, key, false);
                        ParRegUtil.verifyContainsValueForKey(r, key, false);
                        int afterSize = r.size();
                        if (afterSize != beforeSize && afterSize != beforeSize - 1) {
                            throw new TestException("Expected region size " + afterSize + " to be either " + beforeSize + " or " + (beforeSize - 1));
                        }
                    }
                } else {
                    ParRegUtil.verifyContainsKey(r, key, false);
                    ParRegUtil.verifyContainsValueForKey(r, key, false);
                    ParRegUtil.verifySize(r, beforeSize - 1);
                }
                this.regionSnapshot.remove(key);
                this.destroyedKeys.add(key);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyPercent(Region r, boolean isLocalDestroy, int percentToDestroy) {
        List keyList;
        int size = r.size();
        int numToDestroy = (int)((double)size * ((double)percentToDestroy / 100.0));
        if (numToDestroy <= 0) {
            numToDestroy = 1;
        }
        if ((keyList = ParRegUtil.getExistingKeys(r, this.uniqueKeys, this.numThreadsInClients, numToDestroy, this.isThinClient || this.isEmptyClient)).size() == 0) {
            Log.getLogWriter().info("destroyPercent: No keys in region");
            return;
        }
        Log.getLogWriter().info("destroyPercent: Destroying " + keyList.size() + " keys based on percent " + percentToDestroy + " and region size " + size);
        for (int i = 0; i < keyList.size(); ++i) {
            int beforeSize = r.size();
            Object key = keyList.get(i);
            try {
                String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
                if (isLocalDestroy) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        Log.getLogWriter().info("destroyPercent: local destroy for " + key + " callback is " + callback);
                        r.localDestroy(key, (Object)callback);
                        Log.getLogWriter().info("destroyPercent: done with local destroy for " + key);
                    } else {
                        Log.getLogWriter().info("destroyPercent: local destroy for " + key);
                        r.localDestroy(key);
                        Log.getLogWriter().info("destroyPercent: done with local destroy for " + key);
                    }
                } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyPercent: destroying key " + key + " callback is " + callback);
                    r.destroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyPercent: done destroying key " + key);
                } else {
                    Log.getLogWriter().info("destroyPercent: destroying key " + key);
                    r.destroy(key);
                    Log.getLogWriter().info("destroyPercent: done destroying key " + key);
                }
                if (!this.isSerialExecution) continue;
                if (this.isEmptyClient) {
                    if (!TxHelper.exists()) {
                        ParRegUtil.verifySize(r, 0);
                    }
                } else if (this.isThinClient) {
                    if (!TxHelper.exists()) {
                        ParRegUtil.verifyContainsKey(r, key, false);
                        ParRegUtil.verifyContainsValueForKey(r, key, false);
                        int afterSize = r.size();
                        if (afterSize != beforeSize && afterSize != beforeSize - 1) {
                            throw new TestException("Expected region size " + afterSize + " to be either " + beforeSize + " or " + (beforeSize - 1));
                        }
                    }
                } else {
                    ParRegUtil.verifyContainsKey(r, key, false);
                    ParRegUtil.verifyContainsValueForKey(r, key, false);
                    ParRegUtil.verifySize(r, beforeSize - 1);
                }
                this.regionSnapshot.remove(key);
                this.destroyedKeys.add(key);
                continue;
            }
            catch (EntryNotFoundException e) {
                if (this.isSerialExecution) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                return;
            }
        }
    }

    protected void updateEntry(Region r) {
        Object key = ParRegUtil.getExistingKey(r, this.uniqueKeys, this.numThreadsInClients, this.isEmptyClient || this.isThinClient);
        if (key == null) {
            int size = r.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("updateEntry: No keys in region");
            return;
        }
        int beforeSize = r.size();
        Object anObj = this.getUpdateObject(r, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        Object returnVal = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            returnVal = r.put(key, anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            returnVal = r.put(key, anObj, (Object)false);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        }
        if (this.isSerialExecution) {
            if (this.isEmptyClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifySize(r, 0);
                }
            } else if (this.isThinClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifyContainsKey(r, key, true);
                    ParRegUtil.verifyContainsValueForKey(r, key, true);
                    int size = r.size();
                    if (size >= beforeSize && !this.isClientCache) {
                        if (beforeSize == this.LRUEntryMax) {
                            ParRegUtil.verifySize(r, this.LRUEntryMax);
                        } else if (size != beforeSize && size != beforeSize + 1) {
                            throw new TestException("Expected region size " + size + " to be " + beforeSize + " or " + (beforeSize + 1));
                        }
                    }
                }
            } else {
                ParRegUtil.verifyContainsKey(r, key, true);
                ParRegUtil.verifyContainsValueForKey(r, key, true);
                ParRegUtil.verifySize(r, beforeSize);
            }
            this.regionSnapshot.put(key, this.getValueForBB(anObj));
            this.destroyedKeys.remove(key);
        }
    }

    protected Object getValueForBB(Object anObj) throws TestException {
        Object valueToPutInBB = null;
        if (anObj instanceof BaseValueHolder) {
            valueToPutInBB = ((BaseValueHolder)anObj).myValue;
        } else if (anObj instanceof PdxInstance) {
            valueToPutInBB = ((PdxInstance)anObj).getField("myValue");
        } else {
            throw new TestException("Unexpected value class " + anObj.getClass().getName());
        }
        return valueToPutInBB;
    }

    protected void getKey(Region aRegion) {
        Object anObj;
        Object key = ParRegUtil.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients, this.isEmptyClient || this.isThinClient);
        if (key == null) {
            int size = aRegion.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            this.getNewKey(aRegion);
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.size();
        boolean beforeContainsValueForKey = aRegion.containsValueForKey(key);
        boolean beforeContainsKey = aRegion.containsKey(key);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        } else {
            Log.getLogWriter().info("getKey: getting key " + key);
            anObj = aRegion.get(key);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        }
        if (this.isSerialExecution) {
            if (this.isEmptyClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifySize(aRegion, 0);
                }
            } else if (this.isThinClient) {
                if (!TxHelper.exists()) {
                    ParRegUtil.verifyContainsKey(aRegion, key, true);
                    Object expectedValue = this.regionSnapshot.get(key);
                    ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null || this.hasPRCacheLoader);
                    expectedValue = this.hasPRCacheLoader && !beforeContainsValueForKey ? PdxTest.toValueHolder((Object)anObj).myValue : this.regionSnapshot.get(key);
                    ParRegUtil.verifyMyValue(key, expectedValue, anObj, ParRegUtil.EQUAL);
                    if (beforeContainsKey) {
                        ParRegUtil.verifySize(aRegion, beforeSize);
                    } else if (!this.isClientCache) {
                        ParRegUtil.verifySize(aRegion, Math.min(this.LRUEntryMax, beforeSize + 1));
                    }
                }
            } else {
                ParRegUtil.verifyContainsKey(aRegion, key, true);
                ParRegUtil.verifyContainsValueForKey(aRegion, key, beforeContainsValueForKey || this.hasPRCacheLoader);
                Object expectedValue = null;
                expectedValue = this.hasPRCacheLoader && !beforeContainsValueForKey ? PdxTest.toValueHolder((Object)anObj).myValue : (Object)this.regionSnapshot.get(key);
                ParRegUtil.verifyMyValue(key, expectedValue, anObj, ParRegUtil.EQUAL);
                ParRegUtil.verifySize(aRegion, beforeSize);
            }
            if (anObj == null) {
                this.regionSnapshot.put(key, null);
            } else {
                this.regionSnapshot.put(key, PdxTest.toValueHolder((Object)anObj).myValue);
            }
            this.destroyedKeys.remove(key);
        }
    }

    protected void getNewKey(Region r) {
        Object anObj;
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = r.size();
        boolean beforeContainsValueForKey = r.containsValueForKey(key);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
            anObj = r.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key);
            anObj = r.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
        if (this.isSerialExecution) {
            ParRegUtil.verifyContainsKey(r, key, true);
            ParRegUtil.verifyContainsValueForKey(r, key, this.hasPRCacheLoader);
            boolean containsKey = this.regionSnapshot.containsKey(key);
            ParRegUtil.verifyMyValue(key, PdxTest.toValueHolder((Object)anObj).myValue, r.get(key), ParRegUtil.EQUAL);
            if (anObj == null) {
                this.regionSnapshot.put(key, null);
            } else {
                this.regionSnapshot.put(key, PdxTest.toValueHolder((Object)anObj).myValue);
            }
            this.destroyedKeys.remove(key);
        }
    }

    protected void putIfAbsent(Region aReg, boolean allowInvalidate) {
        Object key = null;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            if (key == null) {
                key = this.getNewKey();
                Log.getLogWriter().info("In putIfAbsent, targeting new key " + key);
            } else {
                Log.getLogWriter().info("In putIfAbsent, targeting existing key " + key);
            }
        } else {
            key = this.getNewKey();
            Log.getLogWriter().info("In putIfAbsent, targeting new key " + key);
        }
        Log.getLogWriter().info("Getting value for putIfAbsent");
        BaseValueHolder objToPut = null;
        if (allowInvalidate) {
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
                objToPut = this.getValueForKey(key);
            }
        } else {
            objToPut = this.getValueForKey(key);
        }
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling putIfAbsent with key " + key + ", value " + TestHelper.toString(objToPut) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        BaseValueHolder returnValue = PdxTest.toValueHolder(aReg.putIfAbsent(key, (Object)objToPut));
        Log.getLogWriter().info("Done calling putIfAbsent with key " + key + ", value " + TestHelper.toString(objToPut) + ", return value is " + TestHelper.toString(returnValue));
        if (this.isSerialExecution) {
            boolean opOccurred;
            Object expectedValue = this.regionSnapshot.get(key);
            if (expectedValue == null && returnValue != null || returnValue == null && expectedValue != null || expectedValue != null && !expectedValue.equals(returnValue.myValue)) {
                throw new TestException("Expected return value " + TestHelper.toString(returnValue) + " to be ValueHolder with myValue field " + TestHelper.toString(expectedValue));
            }
            boolean bl = this.isBridgeClient ? !containsKeyOnServer.booleanValue() : (opOccurred = !containsKey);
            if (opOccurred) {
                if (objToPut == null) {
                    this.regionSnapshot.put(key, null);
                } else {
                    this.regionSnapshot.put(key, objToPut.myValue);
                }
            }
        }
    }

    protected void putIfAbsentAsGet(Region aReg) {
        Object key = null;
        if (this.isSerialExecution) {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            if (key == null) {
                Log.getLogWriter().info("Could not get an existing key for putIfAbsentAsGet");
                return;
            }
        } else {
            throw new TestException("test config problem; putIfAbsentAsGet not supported for concurrent tests");
        }
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling putIfAbsent with existing key (functions as get) " + key + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        Object returnValue = aReg.putIfAbsent(key, (Object)"this value should not ever be put into region");
        Log.getLogWriter().info("Done calling putIfAbsent with existing key (functions as get) " + key);
        if (this.isSerialExecution) {
            Object expectedValue = this.regionSnapshot.get(key);
            ParRegUtil.verifyMyValue(key, expectedValue, returnValue, ParRegUtil.EQUAL);
        }
    }

    protected void putIfAbsentAsCreate(Region aReg) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling putIfAbsent with non-existing key (functions as put) " + key + ", value " + TestHelper.toString(anObj) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        Object returnValue = aReg.putIfAbsent(key, (Object)anObj);
        Log.getLogWriter().info("Done calling putIfAbsent with non-existing key (functions as put) " + key + ", value " + TestHelper.toString(anObj) + ", return value is " + TestHelper.toString(returnValue));
        if (returnValue != null) {
            throw new TestException("Expected return value from putIfAbsent to be null but it is " + TestHelper.toString(returnValue));
        }
        if (this.isSerialExecution) {
            this.regionSnapshot.put(key, anObj.myValue);
        }
    }

    protected void remove(Region aReg) {
        boolean expectRemovalInSerialTest;
        Object key = null;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            if (key == null) {
                key = this.getNewKey();
                Log.getLogWriter().info("In remove, targeting new key " + key);
                expectRemovalInSerialTest = false;
            } else {
                Log.getLogWriter().info("In remove, targeting existing key " + key);
                expectRemovalInSerialTest = true;
            }
        } else {
            key = this.getNewKey();
            Log.getLogWriter().info("In remove, targeting new key " + key);
            expectRemovalInSerialTest = false;
        }
        Log.getLogWriter().info("Getting value for remove...");
        Object value = this.getValueForKey(NameFactory.getObjectNameForCounter(NameFactory.getCounterForName(key) - 1L));
        boolean containsKey = aReg.containsKey(key);
        if (!this.hasPRCacheLoader && TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
            value = aReg.get(key);
            boolean bl = expectRemovalInSerialTest = expectRemovalInSerialTest;
            if (this.isThinClient && !containsKey) {
                try {
                    aReg.localDestroy(key);
                }
                catch (EntryNotFoundException e) {
                    Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + "; continuing test");
                }
            }
        } else {
            expectRemovalInSerialTest = false;
        }
        boolean testingEquality = false;
        if (ParRegPrms.getTestMapOpsEquality().booleanValue() && value instanceof BaseValueHolder) {
            testingEquality = true;
            BaseValueHolder vh = (BaseValueHolder)value;
            vh.myVersion = vh.myVersion + "_" + new Random().nextLong();
        }
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling remove with key " + key + " value " + TestHelper.toString(value) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        boolean returnValue = false;
        try {
            returnValue = aReg.remove(key, value);
        }
        catch (RuntimeException e) {
            PdxTestVersionHelper.handleException(e);
            return;
        }
        Log.getLogWriter().info("Done calling remove with key " + key + " value " + TestHelper.toString(value) + ", return value is " + returnValue);
        if (testingEquality && this.isSerialExecution && expectRemovalInSerialTest != returnValue) {
            throw new TestException("Bug 47895 (likely) detected; expected return from remove to be " + expectRemovalInSerialTest + " but it is " + returnValue);
        }
        if (this.isSerialExecution && returnValue) {
            if (this.isBridgeClient ? returnValue != containsKeyOnServer : returnValue != containsKey) {
                throw new TestException("Expected return value to be " + containsKey + " but it is " + returnValue);
            }
            if (expectRemovalInSerialTest) {
                this.regionSnapshot.remove(key);
            }
        }
    }

    protected void removeAsNoop(Region aReg) {
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.genericCounter);
        Object key = null;
        String value = "removeAsNoop: ValueDoesNotExist;" + counter;
        boolean usedExistingKey = false;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            key = "removeAsNoop: KeyDoesNotExist;" + counter;
        } else {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            if (key == null) {
                key = "removeAsNoop: ThisKeyDoesNotExist;" + counter;
            } else {
                usedExistingKey = true;
            }
        }
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling remove (functions as noop) with key " + key + " value " + TestHelper.toString(value) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        boolean returnValue = false;
        try {
            returnValue = aReg.remove(key, (Object)value);
        }
        catch (RuntimeException e) {
            PdxTestVersionHelper.handleException(e);
            return;
        }
        Log.getLogWriter().info("Done calling remove (functions as noop) with key " + key + " value " + TestHelper.toString(value) + ", return value is " + returnValue);
        if (returnValue) {
            throw new TestException("Expected return value to be false, but it is " + returnValue);
        }
        if (this.isSerialExecution) {
            containsKey = aReg.containsKey(key);
            Boolean bl = containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
            if (usedExistingKey != containsKey) {
                throw new TestException("After remove, containsKey for key " + key + " is " + containsKey);
            }
            if (usedExistingKey != containsKeyOnServer) {
                throw new TestException("After remove, containsKeyOnServer for key " + key + " is " + containsKeyOnServer);
            }
        }
    }

    protected void replace(Region aReg, boolean allowInvalidate) {
        Object key = null;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            if (key == null) {
                key = this.getNewKey();
                Log.getLogWriter().info("In replace, targeting new key " + key);
            } else {
                Log.getLogWriter().info("In replace, targeting existing key " + key);
            }
        } else {
            key = this.getNewKey();
            Log.getLogWriter().info("In replace, targeting new key " + key);
        }
        Object objToPut = null;
        if (allowInvalidate) {
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
                objToPut = this.getUpdateObject(aReg, (String)key);
            }
        } else {
            objToPut = this.getUpdateObject(aReg, (String)key);
        }
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling replace(K,V) with key " + key + ", value " + TestHelper.toString(objToPut) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        BaseValueHolder returnValue = PdxTest.toValueHolder(aReg.replace(key, objToPut));
        Log.getLogWriter().info("Done calling replace(K,V) with key " + key + ", value " + TestHelper.toString(objToPut) + ", return value is " + TestHelper.toString(returnValue));
        if (this.isSerialExecution) {
            boolean putOccurred;
            Object expectedValue = this.regionSnapshot.get(key);
            if (expectedValue == null && returnValue != null || returnValue == null && expectedValue != null || expectedValue != null && !expectedValue.equals(returnValue.myValue)) {
                throw new TestException("Expected return value " + TestHelper.toString(returnValue) + " to be ValueHolder with myValue field " + TestHelper.toString(expectedValue));
            }
            boolean bl = putOccurred = this.isBridgeClient ? containsKeyOnServer : containsKey;
            if (putOccurred) {
                if (objToPut == null) {
                    this.regionSnapshot.put(key, null);
                } else {
                    this.regionSnapshot.put(key, this.getValueForBB(objToPut));
                }
            }
        }
    }

    protected void replaceAsNoop(Region aReg) {
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.genericCounter);
        String key = "replace:KeyDoesNotExist;" + counter;
        String value = "replaceAsNoop: this should never be a value;" + counter;
        boolean containsKey = aReg.containsKey((Object)key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer((Object)key)) : null;
        Log.getLogWriter().info("Calling replace(K,V) (functions as noop) with key " + key + " value " + TestHelper.toString(value) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        Object returnValue = aReg.replace((Object)key, (Object)value);
        Log.getLogWriter().info("Done calling replace(K,V) (functions as noop) with key " + key + " value " + TestHelper.toString(value) + ", return value is " + returnValue);
        if (returnValue != null) {
            throw new TestException("Expected return value to be null, but it is " + TestHelper.toString(returnValue));
        }
        containsKey = aReg.containsKey((Object)key);
        containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer((Object)key)) : null;
        Log.getLogWriter().info("After replace as noop, containsKey is " + containsKey + ", containsKeyOnServer is " + containsKeyOnServer);
        if (containsKey) {
            throw new TestException("After replace, containsKey for key " + key + " is " + containsKey);
        }
        if (containsKeyOnServer != null && containsKeyOnServer.booleanValue()) {
            throw new TestException("After replace, containsKeyOnServer for key " + key + " is " + containsKeyOnServer);
        }
    }

    protected void replaceAsUpdate(Region aReg) {
        Object key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
        if (key == null) {
            Log.getLogWriter().info("Could not get existing key for replaceAsUpdate");
            return;
        }
        Object value = this.getUpdateObject(aReg, (String)key);
        boolean containsKey = aReg.containsKey(key);
        Object oldValue = aReg.get(key);
        if (this.isThinClient && !containsKey) {
            try {
                aReg.localDestroy(key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + "; continuing test");
            }
        }
        containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling replace(K,V) with existing key (functions as put) " + key + ", value " + TestHelper.toString(value) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        Object returnValue = aReg.replace(key, value);
        Log.getLogWriter().info("Done calling replace(K,V) with existing key (functions as put) " + key + ", value " + TestHelper.toString(value) + ", return value is " + TestHelper.toString(returnValue));
        if (this.isSerialExecution) {
            ParRegUtil.verifyMyValue(key, oldValue, returnValue, ParRegUtil.EQUAL);
            this.regionSnapshot.put(key, this.getValueForBB(value));
        }
    }

    protected void replaceOld(Region aReg, boolean allowInvalidate) {
        boolean expectedReturnValue;
        boolean usedNewKey = false;
        Object key = null;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 80) {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            expectedReturnValue = true;
            if (key == null) {
                key = this.getNewKey();
                expectedReturnValue = false;
                usedNewKey = true;
                Log.getLogWriter().info("In replaceOld, targeting new key " + key);
            } else {
                Log.getLogWriter().info("In replaceOld, targeting existing key " + key);
            }
        } else {
            key = this.getNewKey();
            expectedReturnValue = false;
            usedNewKey = true;
            Log.getLogWriter().info("In replaceOld, targeting new key " + key);
        }
        Object oldValue = "replaceOld: this value is not present in region";
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            if (!usedNewKey) {
                boolean containsKey = aReg.containsKey(key);
                boolean containsValueForKey = aReg.containsValueForKey(key);
                Log.getLogWriter().info("In replaceOld, getting oldValue...");
                oldValue = aReg.get(key);
                if (this.isSerialExecution && !containsValueForKey && this.hasPRCacheLoader) {
                    this.regionSnapshot.put(key, PdxTest.toValueHolder((Object)oldValue).myValue);
                }
                if (this.isThinClient && !containsKey) {
                    try {
                        aReg.localDestroy(key);
                    }
                    catch (EntryNotFoundException e) {
                        Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + "; continuing test");
                    }
                }
            }
            expectedReturnValue = expectedReturnValue;
        } else {
            expectedReturnValue = false;
        }
        boolean testingEquality = false;
        if (ParRegPrms.getTestMapOpsEquality().booleanValue() && oldValue instanceof BaseValueHolder) {
            testingEquality = true;
            BaseValueHolder vh = (BaseValueHolder)oldValue;
            vh.myVersion = vh.myVersion + "_" + new Random().nextLong();
        }
        BaseValueHolder newValue = null;
        if (allowInvalidate) {
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
                newValue = oldValue == null || oldValue instanceof String ? this.createObject(key) : PdxTest.toValueHolder(oldValue).getAlternateValueHolder(this.randomValues);
            }
        } else {
            newValue = oldValue == null || oldValue instanceof String ? this.createObject(key) : PdxTest.toValueHolder(oldValue).getAlternateValueHolder(this.randomValues);
        }
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling replace(K,V,V) with key " + key + " old value " + TestHelper.toString(oldValue) + ", new value " + TestHelper.toString(newValue) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        boolean returnValue = false;
        try {
            returnValue = aReg.replace(key, oldValue, (Object)newValue);
        }
        catch (RuntimeException e) {
            PdxTestVersionHelper.handleException(e);
            return;
        }
        Log.getLogWriter().info("Done calling replace(K,V,V) with key " + key + " old value " + TestHelper.toString(oldValue) + ", new value " + TestHelper.toString(newValue) + ", return value " + TestHelper.toString(returnValue));
        if (this.isSerialExecution) {
            if (returnValue != expectedReturnValue) {
                String errStr = "Expected replace to return " + expectedReturnValue + " but it returned " + returnValue;
                if (testingEquality) {
                    errStr = "Bug 47895 (likely) detected; " + errStr;
                }
                throw new TestException(errStr);
            }
            if (returnValue) {
                this.regionSnapshot.put(key, newValue.myValue);
            }
        }
    }

    protected void replaceOldAsNoop(Region aReg) {
        Object key = null;
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.genericCounter);
        String oldValue = "replaceOldAsNoop:ValueDoesNotExist;" + counter;
        String newValue = "replace(K,V,V): this should never be a value;" + counter;
        boolean keyNotPresent = false;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            key = "replaceOldAsNoop:KeyDoesNotExist;" + counter;
            keyNotPresent = true;
        } else {
            key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
            if (key == null) {
                key = "replaceOldAsNoop:KeyDoesNotExist;" + counter;
                keyNotPresent = true;
            }
        }
        boolean containsKey = aReg.containsKey(key);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling replace(K,V,V) (functions as noop) with key " + key + " old value " + TestHelper.toString(oldValue) + ", new value " + TestHelper.toString(newValue) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        boolean returnValue = false;
        try {
            returnValue = aReg.replace(key, (Object)oldValue, (Object)newValue);
        }
        catch (RuntimeException e) {
            PdxTestVersionHelper.handleException(e);
            return;
        }
        Log.getLogWriter().info("Done calling replace(K,V,V) (functions as noop) with key " + key + " old value " + TestHelper.toString(oldValue) + ", new value " + TestHelper.toString(newValue) + ", return value is " + returnValue);
        if (returnValue) {
            throw new TestException("Expected return value to be false, but it is " + returnValue);
        }
        Object afterValue = aReg.get(key);
        if (newValue.equals(afterValue)) {
            throw new TestException("After replace, value obtained from region is " + afterValue);
        }
    }

    protected void replaceOldAsUpdate(Region aReg) {
        Object key = ParRegUtil.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients, this.isThinClient || this.isEmptyClient);
        if (key == null) {
            Log.getLogWriter().info("Could not get existing key for replaceOldAsUpdate");
            return;
        }
        boolean containsKey = aReg.containsKey(key);
        BaseValueHolder oldValue = PdxTest.toValueHolder(aReg.get(key));
        if (this.isThinClient && !containsKey) {
            try {
                aReg.localDestroy(key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + "; continuing test");
            }
        }
        BaseValueHolder newValue = oldValue == null ? this.createObject(key) : oldValue.getAlternateValueHolder(this.randomValues);
        Boolean containsKeyOnServer = this.isBridgeClient ? Boolean.valueOf(aReg.containsKeyOnServer(key)) : null;
        Log.getLogWriter().info("Calling replace(K,V,V) with existing key (functions as update) " + key + ", old value " + TestHelper.toString(oldValue) + ", new value " + TestHelper.toString(newValue) + ", containsKey " + containsKey + ", containsKeyOnServer " + containsKeyOnServer);
        boolean returnValue = false;
        try {
            returnValue = aReg.replace(key, (Object)oldValue, (Object)newValue);
        }
        catch (RuntimeException e) {
            PdxTestVersionHelper.handleException(e);
            return;
        }
        Log.getLogWriter().info("Done calling replace(K,V,V) with existing key (functions as update) " + key + ", old value " + TestHelper.toString(oldValue) + ", new value " + TestHelper.toString(newValue));
        if (this.isSerialExecution) {
            ParRegUtil.verifyMyValue(key, null, returnValue, ParRegUtil.EQUAL);
            this.regionSnapshot.put(key, newValue.myValue);
        }
    }

    private void query(Region r) {
        Cache theCache;
        StringBuffer queryStr = new StringBuffer();
        queryStr.append(ParRegPrms.getQuery());
        String replaceStr = "%region%";
        int index = queryStr.indexOf(replaceStr);
        if (index >= 0) {
            queryStr.replace(index, index + replaceStr.length(), r.getFullPath());
        }
        if ((theCache = CacheHelper.getCache()) == null) {
            return;
        }
        Query query = theCache.getQueryService().newQuery(queryStr.toString());
        try {
            Log.getLogWriter().info("Current indexes: " + theCache.getQueryService().getIndexes());
            Log.getLogWriter().info("Executing query " + queryStr);
            Object qResults = query.execute();
            if (qResults instanceof SelectResults) {
                SelectResults sr = (SelectResults)qResults;
                StringBuffer aStr = new StringBuffer();
                aStr.append("Results from " + queryStr + " is size " + sr.size() + "\n");
                for (Object element : sr) {
                    aStr.append("   " + element + "\n");
                }
                Log.getLogWriter().info(aStr.toString());
            }
        }
        catch (FunctionDomainException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TypeMismatchException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NameResolutionException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (QueryInvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void createIndex(Region r) {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        QueryService qs = theCache.getQueryService();
        String indexStr = ParRegPrms.getIndex();
        String indexName = "index_" + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.indexNameCounter);
        try {
            Log.getLogWriter().info("Creating index " + indexName + " with " + indexStr);
            qs.createIndex(indexName, indexStr, r.getFullPath());
        }
        catch (RegionNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IndexInvalidException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IndexNameConflictException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IndexExistsException e) {
            Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + "; continuing test");
        }
        catch (UnsupportedOperationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void removeIndex(Region r) {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        QueryService qs = theCache.getQueryService();
        Collection indexColl = qs.getIndexes();
        if (indexColl.size() >= 1) {
            Index anIndex = (Index)indexColl.iterator().next();
            Log.getLogWriter().info("Removing index " + anIndex.getName());
            qs.removeIndex(anIndex);
        }
    }

    public void checkForLastIteration() {
        ParRegTest.checkForLastIteration(this.secondsToRun);
    }

    public static void checkForLastIteration(int numSeconds) {
        long taskStartTime = 0L;
        String bbKey = "TaskStartTime";
        Object anObj = ParRegBB.getBB().getSharedMap().get("TaskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            ParRegBB.getBB().getSharedMap().put("TaskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(numSeconds * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + numSeconds + " seconds; time remaining is " + ((long)numSeconds - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    protected void cycleVms() {
        this.cycleVMsNoWait();
        this.waitForRecoveryAfterCycleVMs();
    }

    protected void cycleVMsNoWait() {
        boolean isPdxTest;
        Log.getLogWriter().info("Cycling vms...");
        PRObserver.initialize();
        Vector vmList = ClientVmMgr.getClientVmids();
        Log.getLogWriter().info("vmList is " + vmList);
        boolean stoppingAll = this.numVMsToStop >= vmList.size();
        this.cycleVMs_targetVMs = null;
        this.cycleVMs_notChosenVMs = new ArrayList<ClientVmInfo>();
        boolean bl = isPdxTest = objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder");
        if (stoppingAll) {
            Log.getLogWriter().info("Stopping all except myself");
            this.cycleVMs_targetVMs = StopStartVMs.stopVMs(vmList.size() - 1);
            Log.getLogWriter().info("Disconnecting myself from the distributed system");
            DistributedSystemHelper.getDistributedSystem().disconnect();
            if (isPdxTest) {
                ArrayList<ClientVmInfo> accessors = new ArrayList<ClientVmInfo>();
                ArrayList<ClientVmInfo> dataStores = new ArrayList<ClientVmInfo>();
                for (ClientVmInfo info : this.cycleVMs_targetVMs) {
                    boolean vmIsDataStore = (Boolean)ParRegBB.getBB().getSharedMap().get(isDataStoreKey + info.getVmid());
                    if (vmIsDataStore) {
                        dataStores.add(info);
                        continue;
                    }
                    accessors.add(info);
                }
                Log.getLogWriter().info("This is a pdx test, starting dataStores first...");
                List threadList = StopStartVMs.startAsync(dataStores);
                if (this.isDataStore) {
                    Log.getLogWriter().info("Recreating the partitioned region...");
                    this.HA_reinitializeRegion("cache1");
                    Log.getLogWriter().info("Done recreating the partitioned region...");
                    if (this.isBridgeConfiguration) {
                        if (ParRegTest.testInstance.isBridgeClient) {
                            ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
                        } else {
                            BridgeHelper.startBridgeServer("bridge");
                        }
                    }
                }
                for (Thread aThread : threadList) {
                    try {
                        aThread.join();
                    }
                    catch (InterruptedException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
                Log.getLogWriter().info("Now starting accessors");
                StopStartVMs.startVMs(accessors);
                if (!this.isDataStore) {
                    Log.getLogWriter().info("Recreating the partitioned region...");
                    this.HA_reinitializeRegion(ParRegTest.getCachePrmsName());
                    Log.getLogWriter().info("Done recreating the partitioned region...");
                    if (this.isBridgeConfiguration) {
                        if (ParRegTest.testInstance.isBridgeClient) {
                            ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
                        } else {
                            BridgeHelper.startBridgeServer("bridge");
                        }
                    }
                }
            } else {
                List threadList = StopStartVMs.startAsync(this.cycleVMs_targetVMs);
                Log.getLogWriter().info("Recreating the partitioned region...");
                String cachePrmsName = this.isDataStore ? "cache1" : ParRegTest.getCachePrmsName();
                this.HA_reinitializeRegion(cachePrmsName);
                Log.getLogWriter().info("Done recreating the partitioned region...");
                if (this.isBridgeConfiguration) {
                    if (ParRegTest.testInstance.isBridgeClient) {
                        ParRegUtil.registerInterest(ParRegTest.testInstance.aRegion);
                    } else {
                        BridgeHelper.startBridgeServer("bridge");
                    }
                }
                for (Thread aThread : threadList) {
                    try {
                        aThread.join();
                    }
                    catch (InterruptedException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
            }
        } else {
            String stopVMsMatchStr = TestConfig.tab().stringAt(ParRegPrms.stopVMsMatchStr, null);
            String stopVMsExcludeMatchStr = TestConfig.tab().stringAt(ParRegPrms.stopVMsExcludeMatchStr, null);
            Object[] anArr = null;
            anArr = stopVMsExcludeMatchStr == null ? (stopVMsMatchStr == null ? StopStartVMs.getOtherVMs(this.numVMsToStop) : StopStartVMs.getOtherVMs(this.numVMsToStop, stopVMsMatchStr)) : StopStartVMs.getOtherVMsWithExclude(this.numVMsToStop, stopVMsExcludeMatchStr);
            this.cycleVMs_targetVMs = (List)anArr[0];
            List stopModes = (List)anArr[1];
            this.cycleVMs_notChosenVMs = (List)anArr[2];
            this.clearBBCriticalState(this.cycleVMs_targetVMs);
            StopStartVMs.stopStartVMs(this.cycleVMs_targetVMs, stopModes);
        }
        Log.getLogWriter().info("Done cycling vms");
    }

    protected void waitForRecoveryAfterCycleVMs() {
        if (ParRegBB.getBB().getSharedCounters().read(ParRegBB.MaxRC) > 0L) {
            List dataStoresNotChosen = StopStartVMs.getMatchVMs(this.cycleVMs_notChosenVMs, "dataStore");
            dataStoresNotChosen.addAll(StopStartVMs.getMatchVMs(this.cycleVMs_notChosenVMs, "bridge"));
            List targetDataStores = StopStartVMs.getMatchVMs(this.cycleVMs_targetVMs, "dataStore");
            targetDataStores.addAll(StopStartVMs.getMatchVMs(this.cycleVMs_targetVMs, "bridge"));
            ParRegTest.removeAccessors(targetDataStores);
            long recoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("recoveryDelay");
            long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRecovery(recoveryDelay, startupRecoveryDelay, targetDataStores, dataStoresNotChosen, 1, numPRs, null, null);
        }
    }

    protected void waitForSelfRecovery() {
        RegionAttributes attr = this.aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        if (prAttr != null) {
            ArrayList otherVMs = new ArrayList(ClientVmMgr.getOtherClientVmids());
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRecovery(prAttr.getRecoveryDelay(), prAttr.getStartupRecoveryDelay(), new Integer(RemoteTestModule.getMyVmid()), otherVMs, 1, numPRs, null, null);
        }
    }

    protected static void removeAccessors(List<ClientVmInfo> aList) {
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (Object anObj : ParRegBB.getBB().getSharedMap().getMap().keySet()) {
            String regionConfigName;
            String key;
            if (!(anObj instanceof String) || !(key = (String)anObj).startsWith(VmIDStr) || (regionConfigName = (String)ParRegBB.getBB().getSharedMap().get(key)).indexOf("accessor") < 0) continue;
            toBeRemoved.add(key);
        }
        block1: for (String key : toBeRemoved) {
            int vmID = Integer.valueOf(key.substring(VmIDStr.length(), key.length()));
            for (int i = 0; i < aList.size(); ++i) {
                ClientVmInfo info = aList.get(i);
                if (!info.getVmid().equals(vmID)) continue;
                aList.remove(i);
                continue block1;
            }
        }
    }

    protected void doShutDownAllMembers() {
        ClientCache theCache;
        Log.getLogWriter().info("Cycling vms by shutting down all members...");
        PRObserver.initialize();
        Vector vmList = ClientVmMgr.getClientVmids();
        Log.getLogWriter().info("vmList is " + vmList);
        List targetVMs = null;
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        Object object = theCache = this.isClientCache ? ClientCacheHelper.getCache() : CacheHelper.getCache();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        ArrayList<String> stopModes = new ArrayList<String>();
        stopModes.add("mean_kill");
        ParRegBB.getBB().getSharedMap().put(shutDownAllInProgressKey, new Boolean(true));
        Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS, stopModes);
        targetVMs = (List)tmp[0];
        Set shutdownAllResults = (Set)tmp[1];
        if (shutdownAllResults.size() != vmList.size()) {
            throw new TestException("Expected shutDownAllMembers to return " + vmList.size() + " members in its result, but it returned " + shutdownAllResults.size() + ": " + shutdownAllResults);
        }
        if (shutdownAllResults.size() > targetVMs.size()) {
            boolean cacheClosed = theCache.isClosed();
            if (cacheClosed) {
                Log.getLogWriter().info("shutDownAllMembers disconnected this vm");
            } else {
                throw new TestException("shutDownAllMembers should have disconnected this vm, but the cache " + theCache + " isClosed is " + cacheClosed);
            }
        }
        List dataStoreVMs = StopStartVMs.getMatchVMs(targetVMs, "dataStore");
        dataStoreVMs.addAll(StopStartVMs.getMatchVMs(targetVMs, "bridge"));
        List accessorVMs = StopStartVMs.getMatchVMs(targetVMs, "accessor");
        accessorVMs.addAll(StopStartVMs.getMatchVMs(targetVMs, "edge"));
        Log.getLogWriter().info("Starting dataStores first");
        if (this.isDataStore) {
            List threadList = StopStartVMs.startAsync(dataStoreVMs);
            Log.getLogWriter().info("Recreating the partitioned region...");
            this.HA_reinitializeRegion("cache1");
            Log.getLogWriter().info("Done recreating the partitioned region...");
            for (Thread aThread : threadList) {
                try {
                    aThread.join();
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            Log.getLogWriter().info("Starting accessors");
            StopStartVMs.startVMs(accessorVMs);
        } else {
            StopStartVMs.startVMs(dataStoreVMs);
            Log.getLogWriter().info("Starting accessors");
            Log.getLogWriter().info("Recreating the partitioned region...");
            this.HA_reinitializeRegion(ParRegTest.getCachePrmsName());
            Log.getLogWriter().info("Done recreating the partitioned region...");
            if (accessorVMs.size() != 0) {
                StopStartVMs.startVMs(accessorVMs);
            }
        }
        ParRegBB.getBB().getSharedMap().put(shutDownAllInProgressKey, new Boolean(false));
        if (ParRegBB.getBB().getSharedCounters().read(ParRegBB.MaxRC) > 0L) {
            List targetDataStores = StopStartVMs.getMatchVMs(targetVMs, "dataStore");
            targetDataStores.addAll(StopStartVMs.getMatchVMs(targetVMs, "bridge"));
            if (this.isDataStore) {
                ClientVmInfo thisVM = new ClientVmInfo(RemoteTestModule.getMyVmid());
                targetDataStores.add(thisVM);
            }
            long recoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("recoveryDelay");
            long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
            int numPRs = ConfigPrms.getHadoopConfig() != null ? 2 : 1;
            PRObserver.waitForRecovery(recoveryDelay, startupRecoveryDelay, targetDataStores, null, 1, numPRs, null, null);
        }
        Log.getLogWriter().info("Done cycling vms by using shutDownAllMembers");
    }

    protected void clearBBCriticalState(List<ClientVmInfo> targetVMs) {
    }

    public BaseValueHolder getValueForKey(Object key) {
        return this.createObject((String)key);
    }

    protected BaseValueHolder createObject(Object key) {
        if (objectType.equals("delta.DeltaValueHolder")) {
            return new DeltaValueHolder((String)key, this.randomValues);
        }
        if (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder")) {
            BaseValueHolder vh = PdxTest.getVersionedValueHolder(objectType, (String)key, this.randomValues);
            return vh;
        }
        return new ValueHolder((String)key, this.randomValues);
    }

    protected Object getNewKey() {
        if (this.uniqueKeys) {
            int anInt = (Integer)this.uniqueKeyIndex.get();
            this.uniqueKeyIndex.set(new Integer(anInt += this.numThreadsInClients));
            ParRegBB.getBB().getSharedMap().put("Thread_" + RemoteTestModule.getCurrentThread().getThreadId(), anInt);
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    protected Object getRecentKey(Region r, int recentHistory) {
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            return null;
        }
        long keyIndex = TestConfig.tab().getRandGen().nextLong(Math.max(maxNames - (long)recentHistory, 1L), maxNames);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        return key;
    }

    protected Object getUpdateObject(Region r, String key) {
        BaseValueHolder vhObj = null;
        Object getObj = null;
        if (r.containsKey((Object)key)) {
            if (r.containsValueForKey((Object)key)) {
                getObj = r.get((Object)key);
                vhObj = PdxTest.toValueHolder(getObj);
            }
        } else if (this.isThinClient && !this.hasPRCacheLoader) {
            getObj = r.get((Object)key);
            vhObj = PdxTest.toValueHolder(getObj);
            try {
                r.localDestroy((Object)key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Caught expected " + (Object)((Object)e) + "; continuing test");
            }
        } else if (this.isEmptyClient) {
            getObj = r.get((Object)key);
            vhObj = PdxTest.toValueHolder(getObj);
        }
        BaseValueHolder newObj = null;
        if (vhObj == null) {
            newObj = this.createObject(key);
        } else {
            BaseValueHolder vh = vhObj.getAlternateValueHolder(this.randomValues);
            if (getObj instanceof PdxInstance) {
                PdxInstance pdxInst = (PdxInstance)getObj;
                WritablePdxInstance writablePdxInst = pdxInst.createWriter();
                writablePdxInst.setField("myValue", vh.myValue);
                writablePdxInst.setField("extraObject", vh.extraObject);
                newObj = writablePdxInst;
            } else {
                newObj = vh;
            }
        }
        return newObj;
    }

    protected static void logExecutionNumber() {
        long exeNum = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected int[] getOperation(Region reg) {
        Long opsPrm = ParRegPrms.entryOperations;
        Long upperThresholdOpsPrm = ParRegPrms.upperThresholdOperations;
        Long lowerThresholdOpsPrm = ParRegPrms.lowerThresholdOperations;
        if (TestConfig.tab().booleanAt(ParRegPrms.designateOps, false)) {
            if (this.isDataStore) {
                opsPrm = ParRegPrms.dataStoreOperations;
                upperThresholdOpsPrm = ParRegPrms.upperThresholdDataStoreOperations;
                lowerThresholdOpsPrm = ParRegPrms.lowerThresholdDataStoreOperations;
            } else {
                opsPrm = ParRegPrms.accessorOperations;
                upperThresholdOpsPrm = ParRegPrms.upperThresholdAccessorOperations;
                lowerThresholdOpsPrm = ParRegPrms.lowerThresholdAccessorOperations;
            }
        }
        int[] opInfo = this.getOperation(opsPrm);
        int size = 0;
        size = this.isEmptyClient || this.isThinClient ? reg.keySetOnServer().size() : reg.size();
        if (size >= this.upperThreshold) {
            opInfo = this.getOperation(upperThresholdOpsPrm);
        } else if (size <= this.lowerThreshold) {
            opInfo = this.getOperation(lowerThresholdOpsPrm);
        }
        return opInfo;
    }

    protected int[] getOperation(Long whichPrm) {
        int op = 0;
        int extra = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putAll")) {
            op = 9;
        } else if (operation.startsWith("destroyPercent")) {
            op = 10;
            extra = Integer.valueOf(operation.substring("destroyPercent".length(), operation.length()));
        } else if (operation.equals("putIfAbsent")) {
            op = 12;
        } else if (operation.equals("putIfAbsentAsGet")) {
            op = 13;
        } else if (operation.equals("putIfAbsentAsCreate")) {
            op = 14;
        } else if (operation.equals("remove")) {
            op = 15;
        } else if (operation.equals("removeAsNoop")) {
            op = 16;
        } else if (operation.equals("replace")) {
            op = 17;
        } else if (operation.equals("replaceAsNoop")) {
            op = 19;
        } else if (operation.equals("replaceAsUpdate")) {
            op = 18;
        } else if (operation.equals("replaceNoInval")) {
            op = 20;
        } else if (operation.equals("replaceOld")) {
            op = 21;
        } else if (operation.equals("replaceOldAsNoop")) {
            op = 23;
        } else if (operation.equals("replaceOldAsUpdate")) {
            op = 22;
        } else if (operation.equals("replaceOldNoInval")) {
            op = 24;
        } else if (operation.equals("query")) {
            op = 25;
        } else if (operation.equals("createIndex")) {
            op = 26;
        } else if (operation.equals("removeIndex")) {
            op = 27;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return new int[]{op, extra};
    }

    protected void registerInterest() {
        ParRegUtil.registerInterest(this.aRegion);
    }

    protected void doIntervalOps() {
        int opPercentage = ParRegPrms.getOpPercentage();
        int numOps = (int)((double)ParRegTest.testInstance.upperThreshold * ((double)opPercentage / 100.0));
        Log.getLogWriter().info("Each operation will occur for " + opPercentage + " percent of " + ParRegTest.testInstance.upperThreshold + " entries");
        Log.getLogWriter().info("Number of entries that will receive each operation: " + numOps);
        int interval = ParRegTest.testInstance.upperThreshold / numOps;
        long startTimeMillis = System.currentTimeMillis();
        do {
            long operationsCoordinator = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.operationsCoordinator);
            long currentKeyIndex = (operationsCoordinator - 1L) * (long)interval + 1L;
            Log.getLogWriter().info("Current key index is " + currentKeyIndex);
            if (currentKeyIndex >= (long)ParRegTest.testInstance.upperThreshold) {
                throw new StopSchedulingTaskOnClientOrder("Ops have completed");
            }
            String key = NameFactory.getObjectNameForCounter(currentKeyIndex);
            ParRegTest.testInstance.aRegion.get((Object)key);
            Log.getLogWriter().info("Operation for key " + key + ": Destroying");
            ParRegTest.testInstance.aRegion.destroy((Object)key);
            key = NameFactory.getObjectNameForCounter(currentKeyIndex + 1L);
            BaseValueHolder vh = PdxTest.toValueHolder(ParRegTest.testInstance.aRegion.get((Object)key));
            vh.myValue = (Long)vh.myValue + 1L;
            Log.getLogWriter().info("Operation for key " + key + ": Updating to " + TestHelper.toString(vh));
            ParRegTest.testInstance.aRegion.put((Object)key, (Object)vh);
            key = NameFactory.getNextPositiveObjectName();
            vh = testInstance.getValueForKey(key);
            Log.getLogWriter().info("Operation for key " + key + ": Creating with value " + TestHelper.toString(vh));
            ParRegTest.testInstance.aRegion.create((Object)key, (Object)vh);
        } while (System.currentTimeMillis() - startTimeMillis < ParRegTest.testInstance.minTaskGranularityMS);
    }

    protected void initForIntervalValidation() {
        this.currentValidateKeyIndex = 1;
        this.currentIntervalKeyIndex = 1;
    }

    protected void validateIntervalOps() {
        int opPercentage = ParRegPrms.getOpPercentage();
        int numOps = (int)((double)ParRegTest.testInstance.upperThreshold * ((double)opPercentage / 100.0));
        int interval = ParRegTest.testInstance.upperThreshold / numOps;
        Log.getLogWriter().info("Beginning validation with key index " + this.currentValidateKeyIndex);
        long startTimeMillis = System.currentTimeMillis();
        do {
            BaseValueHolder value;
            String key;
            if (this.currentValidateKeyIndex >= this.upperThreshold) {
                key = NameFactory.getObjectNameForCounter(this.currentValidateKeyIndex);
                value = PdxTest.toValueHolder(this.aRegion.get((Object)key));
                if (value == null) {
                    throw new TestException("For key " + key + " value is null");
                }
                if ((Long)value.myValue != (long)this.currentValidateKeyIndex) {
                    throw new TestException("For key " + key + ", expected myValue to be " + this.currentValidateKeyIndex + ", but it is " + TestHelper.toString(value));
                }
            } else if (this.currentValidateKeyIndex == this.currentIntervalKeyIndex) {
                this.currentIntervalKeyIndex += interval;
                key = NameFactory.getObjectNameForCounter(this.currentValidateKeyIndex);
                value = PdxTest.toValueHolder(this.aRegion.get((Object)key));
                if (value != null) {
                    throw new TestException("Key " + key + " was destroyed, but get returned " + TestHelper.toString(value));
                }
                ++this.currentValidateKeyIndex;
                key = NameFactory.getObjectNameForCounter(this.currentValidateKeyIndex);
                value = PdxTest.toValueHolder(this.aRegion.get((Object)key));
                if (value == null) {
                    throw new TestException("Value for " + key + " is null");
                }
                if ((Long)value.myValue != (long)(this.currentValidateKeyIndex + 1)) {
                    throw new TestException("For key " + key + ", expected myValue to be " + (this.currentValidateKeyIndex + 1) + ", but it is " + TestHelper.toString(value));
                }
            } else {
                key = NameFactory.getObjectNameForCounter(this.currentValidateKeyIndex);
                value = PdxTest.toValueHolder(this.aRegion.get((Object)key));
                if (value == null) {
                    throw new TestException("For key " + key + " value is null");
                }
                if ((Long)value.myValue != (long)this.currentValidateKeyIndex) {
                    throw new TestException("For key " + key + ", expected myValue to be " + this.currentValidateKeyIndex + ", but it is " + TestHelper.toString(value));
                }
            }
            ++this.currentValidateKeyIndex;
        } while ((long)this.currentValidateKeyIndex <= NameFactory.getPositiveNameCounter());
        this.initForIntervalValidation();
        throw new StopSchedulingTaskOnClientOrder("Validation has completed " + NameFactory.getPositiveNameCounter() + " keys");
    }

    public void verifyFromSnapshot() {
        this.verifyFromSnapshotOnly();
        this.verifyInternalPRState();
    }

    public void verifyFromSnapshotOnly() {
        Set inDoubtOps;
        boolean withEviction;
        boolean bl = withEviction = !this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().equals(EvictionAlgorithm.NONE);
        if (this.aRegion.getAttributes().getDataPolicy().withHDFS()) {
            this.verifyHDFSRegionFromSnapshot();
            return;
        }
        if (this.isEmptyClient) {
            this.verifyServerKeysFromSnapshot();
            return;
        }
        if (this.isThinClient) {
            this.verifyThinClientFromSnapshot();
            this.verifyServerKeysFromSnapshot();
            return;
        }
        StringBuffer aStr = new StringBuffer();
        this.regionSnapshot = (Map)ParRegBB.getBB().getSharedMap().get("RegionSnapshot");
        this.destroyedKeys = (Set)ParRegBB.getBB().getSharedMap().get("DestroyedKeys");
        int snapshotSize = this.regionSnapshot.size();
        int regionSize = this.aRegion.size();
        Log.getLogWriter().info("Verifying from snapshot containing " + snapshotSize + " entries...");
        if (snapshotSize != regionSize) {
            aStr.append("Expected region " + this.aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
            ((LocalRegion)this.aRegion).dumpBackingMap();
        }
        if ((inDoubtOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS)).size() > 0) {
            Log.getLogWriter().info(inDoubtOps.size() + " TransactionInDoubtExceptions occurred on the following keys:" + inDoubtOps);
        }
        for (Map.Entry entry : this.regionSnapshot.entrySet()) {
            Object key = entry.getKey();
            Object expectedValue = entry.getValue();
            boolean anyFailures = false;
            try {
                ParRegUtil.verifyContainsKey(this.aRegion, key, true);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = this.aRegion.containsValueForKey(key);
            try {
                ParRegUtil.verifyContainsValueForKey(this.aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey && this.hasPRCacheLoader) continue;
            try {
                Object actualValue = this.aRegion.get(key);
                ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        for (Map.Entry key : this.destroyedKeys) {
            try {
                ParRegUtil.verifyContainsKey(this.aRegion, key, false);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        HashSet prKeySet = new HashSet(ParRegTest.keySetWithoutCreates(this.aRegion));
        if (prKeySet.size() != regionSize) {
            aStr.append("Size for " + this.aRegion.getFullPath() + " is " + regionSize + ", but its keySet size is " + prKeySet.size() + "\n");
            ((LocalRegion)this.aRegion).dumpBackingMap();
        }
        Set snapshotKeys = this.regionSnapshot.keySet();
        prKeySet.removeAll(snapshotKeys);
        if (prKeySet.size() != 0) {
            aStr.append("Found the following unexpected keys in " + this.aRegion.getFullPath() + ": " + prKeySet + "\n");
        }
        if (this.isBridgeClient) {
            try {
                this.verifyServerKeysFromSnapshot();
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        if (aStr.length() > 0) {
            ((LocalRegion)this.aRegion).dumpBackingMap();
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying from snapshot containing " + snapshotSize + " entries...");
    }

    public void verifyHDFSRegionFromSnapshot() {
        StringBuffer aStr = new StringBuffer();
        this.regionSnapshot = (Map)ParRegBB.getBB().getSharedMap().get("RegionSnapshot");
        this.destroyedKeys = (Set)ParRegBB.getBB().getSharedMap().get("DestroyedKeys");
        StringBuffer problemKeys = new StringBuffer();
        int snapshotSize = this.regionSnapshot.size();
        Log.getLogWriter().info("Verifying HDFS Region from snapshot containing " + snapshotSize + " entries...");
        Set inDoubtOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
        if (inDoubtOps.size() > 0) {
            Log.getLogWriter().info(inDoubtOps.size() + " TransactionInDoubtExceptions occurred on the following keys:" + inDoubtOps);
        }
        for (Map.Entry entry : this.regionSnapshot.entrySet()) {
            Object key = entry.getKey();
            Object expectedValue = entry.getValue();
            try {
                Object actualValue = this.aRegion.get(key);
                ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
                problemKeys.append(key + " ");
            }
        }
        for (Map.Entry key : this.destroyedKeys) {
            try {
                ParRegUtil.verifyContainsKey(this.aRegion, key, false);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
                problemKeys.append(key + " ");
            }
        }
        if (aStr.length() > 0) {
            Log.getLogWriter().info("Starting mapreduce job to help debug: " + aStr.toString());
            HDFSUtil.getAllHDFSEventsForKey(problemKeys.toString());
            HDFSUtil.dumpHDFSResultRegion();
            ((LocalRegion)this.aRegion).dumpBackingMap();
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying HDFS Region from snapshot containing " + snapshotSize + " entries...");
    }

    public void verifyServerKeysFromSnapshot() {
        StringBuffer aStr = new StringBuffer();
        this.regionSnapshot = (Map)ParRegBB.getBB().getSharedMap().get("RegionSnapshot");
        this.destroyedKeys = (Set)ParRegBB.getBB().getSharedMap().get("DestroyedKeys");
        Set serverKeys = this.aRegion.keySetOnServer();
        int snapshotSize = this.regionSnapshot.size();
        int numServerKeys = serverKeys.size();
        Log.getLogWriter().info("Verifying server keys from snapshot containing " + snapshotSize + " entries...");
        if (snapshotSize != numServerKeys) {
            aStr.append("Expected number of keys on server to be " + snapshotSize + ", but it is " + numServerKeys + "\n");
        }
        for (Map.Entry entry : this.regionSnapshot.entrySet()) {
            Object key = entry.getKey();
            Object expectedValue = entry.getValue();
            if (!serverKeys.contains(key)) {
                aStr.append("Expected key " + key + " to be in server keys set, but it is missing\n");
                continue;
            }
            if ((this.isThinClient || this.isEmptyClient) && (!this.isThinClient || !this.aRegion.containsKey(key))) continue;
            Object valueOnServer = this.aRegion.get(key);
            try {
                ParRegUtil.verifyMyValue(key, expectedValue, valueOnServer, ParRegUtil.EQUAL);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        for (Map.Entry key : this.destroyedKeys) {
            if (!serverKeys.contains(key)) continue;
            aStr.append("Destroyed key " + key + " was returned as a server key\n");
        }
        Set snapshotKeys = this.regionSnapshot.keySet();
        serverKeys.removeAll(snapshotKeys);
        if (serverKeys.size() != 0) {
            aStr.append("Found the following unexpected keys in server keys: : " + serverKeys + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying server keys from snapshot containing " + snapshotSize + " entries...");
    }

    public void verifyInternalPRState() {
        StringBuffer aStr = new StringBuffer();
        if (ConfigPrms.getHadoopConfig() != null) {
            Log.getLogWriter().info("ParRegTest.verifyInternalPRState(): Cannot validate PRState for HDFS regions, returning without validating PRState");
            return;
        }
        try {
            ParRegUtil.verifyPRMetaData(this.aRegion);
        }
        catch (Exception e) {
            aStr.append(TestHelper.getStackTrace(e) + "\n");
        }
        catch (TestException e) {
            aStr.append(TestHelper.getStackTrace(e) + "\n");
        }
        try {
            if (this.highAvailability) {
                ParRegUtil.verifyPrimariesWithWait(this.aRegion, this.redundantCopies);
            } else {
                ParRegUtil.verifyPrimaries(this.aRegion, this.redundantCopies);
            }
        }
        catch (Exception e) {
            aStr.append(e.toString() + "\n");
            aStr.append(e.toString() + "\n");
        }
        try {
            ParRegUtil.verifyBucketCopies(this.aRegion, this.redundantCopies);
        }
        catch (Exception e) {
            aStr.append(TestHelper.getStackTrace(e) + "\n");
        }
        catch (TestException e) {
            aStr.append(e.toString() + "\n");
        }
        if (this.uniqueHostsOn) {
            try {
                ParRegUtil.verifyBucketsOnUniqueHosts(this.aRegion);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying PR internal consistency");
    }

    public void verifyThinClientFromSnapshot() {
        StringBuffer aStr = new StringBuffer();
        this.regionSnapshot = (Map)ParRegBB.getBB().getSharedMap().get("RegionSnapshot");
        this.destroyedKeys = (Set)ParRegBB.getBB().getSharedMap().get("DestroyedKeys");
        int snapshotSize = this.regionSnapshot.size();
        int regionSize = this.aRegion.size();
        Log.getLogWriter().info("Verifying thin client from snapshot containing " + snapshotSize + " entries, verifying only those present");
        if (this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUEntry()) {
            int lruMax = this.aRegion.getAttributes().getEvictionAttributes().getMaximum();
            if (this.isSerialExecution) {
                if (regionSize > lruMax) {
                    aStr.append("Client region with LRU entry max " + lruMax + " contains " + regionSize + " entries\n");
                }
            } else {
                int allowable = lruMax + TestHelper.getNumThreads();
                if (regionSize > allowable) {
                    aStr.append("Client region with LRU entry max " + lruMax + " contains " + regionSize + " entries, allowing " + allowable + " entries\n");
                    ((LocalRegion)this.aRegion).dumpBackingMap();
                }
            }
        }
        for (Map.Entry entry : this.regionSnapshot.entrySet()) {
            Object key = entry.getKey();
            Object expectedValue = entry.getValue();
            if (!this.aRegion.containsKey(key)) continue;
            boolean containsValueForKey = this.aRegion.containsValueForKey(key);
            try {
                ParRegUtil.verifyContainsValueForKey(this.aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey && this.hasPRCacheLoader) continue;
            try {
                Object actualValue = this.aRegion.get(key);
                ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        for (Map.Entry key : this.destroyedKeys) {
            try {
                ParRegUtil.verifyContainsKey(this.aRegion, key, false);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        Set snapshotKeys = this.regionSnapshot.keySet();
        HashSet localKeySet = new HashSet(this.aRegion.keySet());
        localKeySet.removeAll(snapshotKeys);
        if (localKeySet.size() != 0) {
            aStr.append("Found the following unexpected keys in " + this.aRegion.getFullPath() + ": " + localKeySet + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying thin client from snapshot containing " + snapshotSize + " entries...");
    }

    private static Collection keySetWithoutCreates(Region region) {
        if (region instanceof PartitionedRegion) {
            return ((PartitionedRegion)region).keysWithoutCreatesForTests();
        }
        return region.keySet();
    }

    protected void concVerify() {
        boolean leader = false;
        if (!this.isEmptyClient && !this.isThinClient) {
            boolean bl = leader = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ConcurrentLeader) == 1L;
        }
        if (leader) {
            boolean withEviction;
            Log.getLogWriter().info("In concVerify, this thread is the concurrent leader");
            boolean bl = withEviction = !this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().equals(EvictionAlgorithm.NONE);
            if (this.aRegion.getAttributes().getDataPolicy().withHDFS() && withEviction) {
                this.writeHDFSRegionSnapshotToBB();
                return;
            }
            this.regionSnapshot = new HashMap();
            this.destroyedKeys = new HashSet();
            Log.getLogWriter().info("This thread is the concurrentLeader, creating region snapshot...");
            Set keySet = this.aRegion.keySet();
            for (Object key : keySet) {
                Object value = null;
                if (this.aRegion.containsValueForKey(key)) {
                    value = this.aRegion.get(key);
                }
                if (value instanceof BaseValueHolder || value instanceof PdxInstance) {
                    this.regionSnapshot.put(key, PdxTest.toValueHolder((Object)value).myValue);
                    continue;
                }
                this.regionSnapshot.put(key, value);
            }
            Log.getLogWriter().info("Done creating region snapshot with " + this.regionSnapshot.size() + " entries; " + this.regionSnapshot);
            ParRegBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
            Log.getLogWriter().info("Done creating destroyed keys with " + this.destroyedKeys.size() + " keys");
            ParRegBB.getBB().getSharedMap().put("DestroyedKeys", this.destroyedKeys);
            long snapshotWritten = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        } else {
            Log.getLogWriter().info("In concVerify, this thread is waiting for the concurrent leader to write the snapshot");
            TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.SnapshotWritten", ParRegBB.SnapshotWritten, 1L, true, -1L, 2000L);
            this.verifyFromSnapshot();
        }
    }

    protected void writeHDFSRegionSnapshotToBB() {
        this.regionSnapshot = new HashMap();
        this.destroyedKeys = new HashSet();
        Log.getLogWriter().info("This thread is the concurrentLeader, creating HDFS region snapshot...");
        long lastKeyCounter = NameFactory.getPositiveNameCounter();
        int i = 1;
        while ((long)i <= lastKeyCounter) {
            String key = NameFactory.getObjectNameForCounter(i);
            if (this.aRegion.containsKey((Object)key)) {
                Object value = this.aRegion.get((Object)key);
                if (value instanceof BaseValueHolder || value instanceof PdxInstance) {
                    this.regionSnapshot.put(key, PdxTest.toValueHolder((Object)value).myValue);
                } else {
                    this.regionSnapshot.put(key, value);
                }
            }
            ++i;
        }
        Log.getLogWriter().info("Done creating HDFS region snapshot with " + this.regionSnapshot.size() + " entries; " + this.regionSnapshot);
        ParRegBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
        Log.getLogWriter().info("Done creating destroyed keys with " + this.destroyedKeys.size() + " keys");
        ParRegBB.getBB().getSharedMap().put("DestroyedKeys", this.destroyedKeys);
        long snapshotWritten = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.SnapshotWritten);
        Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
    }

    private static void createDiskDirBackup(String backupDirName) {
        PrintWriter aFile;
        Log.getLogWriter().info("Making a copy of all disk directories in " + backupDirName);
        File backupDir = new File(backupDirName);
        if (backupDir.exists()) {
            throw new TestException("Backup directory " + backupDirName + " already exists");
        }
        backupDir.mkdir();
        String scriptFileName = "makeBackup.sh";
        File scriptFile = new File(scriptFileName);
        try {
            aFile = new PrintWriter(new FileOutputStream(scriptFile));
        }
        catch (FileNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        aFile.print("#! /bin/sh\ncp -r vm*_disk_* $1\n");
        aFile.flush();
        aFile.close();
        String cmd = "/bin/bash " + scriptFileName + " " + backupDirName;
        String cmdResults = ProcessMgr.fgexec(cmd, 0);
        Log.getLogWriter().info("Results from " + cmd + " is " + cmdResults);
    }

    protected static boolean getIsDataStore() {
        if (ParRegTest.testInstance.aRegion == null) {
            throw new TestException("aRegion is null");
        }
        PartitionAttributes prAttr = ParRegTest.testInstance.aRegion.getAttributes().getPartitionAttributes();
        boolean result = false;
        result = prAttr == null ? false : prAttr.getLocalMaxMemory() != 0;
        ParRegBB.getBB().getSharedMap().put(isDataStoreKey + RemoteTestModule.getMyVmid(), result);
        return result;
    }

    protected void initPdxDiskStore() {
        String pdxDiskStoreName;
        if (CacheHelper.getCache().getPdxPersistent() && (pdxDiskStoreName = TestConfig.tab().stringAt(CachePrms.pdxDiskStoreName, null)) != null && CacheHelper.getCache().findDiskStore(pdxDiskStoreName) == null) {
            DiskStoreHelper.createDiskStore(pdxDiskStoreName);
        }
    }

    static {
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock";
        concVerifyCoordinator = null;
        registerInterestCoordinator = null;
        objectType = TestConfig.tab().stringAt(ValueHolderPrms.objectType, "util.ValueHolder");
        diskFilesRecorded = false;
    }
}

