/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hdfs.HDFSUtil;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientRegionHelper;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.HDFSStoreDescription;
import hydra.HDFSStoreHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtilVersionHelper;
import pdx.PdxTest;
import rebalance.RebalanceUtil;
import util.BaseValueHolder;
import util.CachePrms;
import util.NameFactory;
import util.PRObserver;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class ParRegUtil {
    public static int EQUAL = 1;
    public static int EQUIVALENT = 2;
    protected int verifyBucketCopiesBucketId = -1;
    protected StringBuffer verifyBucketCopiesErrStr = new StringBuffer();
    protected boolean verifyBucketCopiesCompleted = false;
    protected static final String diskRecoveryKey = "DiskRecoveryFileNames_";

    public static Object getExistingKey(Region aRegion, boolean uniqueKeys, int numThreads, boolean useServerKeys) {
        Object key = null;
        try {
            PartitionedRegion parReg = (PartitionedRegion)aRegion;
            key = ParRegUtil.getExistingKey(parReg, uniqueKeys, numThreads);
        }
        catch (ClassCastException parReg) {
            // empty catch block
        }
        if (key == null) {
            Set aSet = null;
            aSet = useServerKeys ? aRegion.keySetOnServer() : aRegion.keySet();
            Iterator it = aSet.iterator();
            return ParRegUtil.getKey(it, uniqueKeys, numThreads);
        }
        return key;
    }

    public static Object getExistingKey(PartitionedRegion parReg, boolean uniqueKeys, int numThreads) {
        Set keySet = null;
        try {
            keySet = parReg.getSomeKeys((Random)TestConfig.tab().getRandGen());
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Iterator iter = keySet.iterator();
        return ParRegUtil.getKey(iter, uniqueKeys, numThreads);
    }

    protected static Object getKey(Iterator it, boolean uniqueKeys, int numThreads) {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        while (it.hasNext()) {
            Object key = it.next();
            if (uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                return key;
            }
            return key;
        }
        return null;
    }

    public static long getLocalSize(Region aRegion) {
        return ((PartitionedRegion)aRegion).getLocalSize();
    }

    public static List getExistingKeys(Region aRegion, boolean uniqueKeys, int numThreads, int numKeysToGet, boolean useServerKeys) {
        Log.getLogWriter().info("Trying to get " + numKeysToGet + " existing keys...");
        Set aSet = null;
        aSet = useServerKeys ? aRegion.keySetOnServer() : aRegion.keySet();
        Iterator it = aSet.iterator();
        return ParRegUtil.getKeys(it, uniqueKeys, numThreads, numKeysToGet);
    }

    public static List getExistingKeys(PartitionedRegion parReg, boolean uniqueKeys, int numThreads, int numKeysToGet) {
        Set keySet = null;
        try {
            keySet = parReg.getSomeKeys((Random)TestConfig.tab().getRandGen());
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Iterator iter = keySet.iterator();
        return ParRegUtil.getKeys(iter, uniqueKeys, numThreads, numKeysToGet);
    }

    protected static List getKeys(Iterator it, boolean uniqueKeys, int numThreads, int numKeysToGet) {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        ArrayList keyList = new ArrayList();
        while (it.hasNext()) {
            Object key = it.next();
            if (uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads == (long)myTid) {
                    keyList.add(key);
                }
            } else {
                keyList.add(key);
            }
            if (keyList.size() < numKeysToGet) continue;
            return keyList;
        }
        return keyList;
    }

    public static int getRegionCountFromClientMetaData() {
        ClientMetadataService cms = GemFireCacheImpl.getInstance().getClientMetadataService();
        return cms.getClientPRMetadata_TEST_ONLY().size();
    }

    public static void verifyMyValue(Object key, Object expectedValue, Object valueToCheck, int compareStrategy) {
        ParRegUtilVersionHelper.verifyMyValue(key, expectedValue, valueToCheck, compareStrategy);
    }

    protected static void verifyValue(Object key, Object obj1, Object obj2, int compareStrategy) {
        if (obj1 instanceof BaseValueHolder) {
            ParRegUtil.verifyMyValue(key, ((BaseValueHolder)obj1).myValue, obj2, EQUAL);
        } else if (obj2 instanceof BaseValueHolder) {
            ParRegUtil.verifyMyValue(key, ((BaseValueHolder)obj2).myValue, obj1, EQUAL);
        } else if (obj1 == null) {
            if (obj2 != null) {
                throw new TestException(obj1 + " is not equal to " + TestHelper.toString(obj2));
            }
        } else if (obj2 == null) {
            if (obj1 != null) {
                throw new TestException(obj2 + " is not equal to " + TestHelper.toString(obj1));
            }
        } else if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
            if (!Arrays.equals((byte[])obj1, (byte[])obj2)) {
                throw new TestException(TestHelper.toString(obj1) + " is not equal to  " + TestHelper.toString(obj2));
            }
        } else if (!obj1.equals(obj2)) {
            throw new TestException(TestHelper.toString(obj1) + " is not equal to " + TestHelper.toString(obj2));
        }
    }

    public static void verifyContainsKey(Region aRegion, Object key, boolean expected) {
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey != expected) {
            RegionAttributes attr = aRegion.getAttributes();
            String extra = ParRegUtilVersionHelper.getVersionTagStr(aRegion, key);
            throw new TestException("Expected containsKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsKey + extra);
        }
    }

    public static void verifyContainsValueForKey(Region aRegion, Object key, boolean expected) {
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        if (containsValueForKey != expected) {
            RegionAttributes attr = aRegion.getAttributes();
            throw new TestException("Expected containsValueForKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsValueForKey);
        }
    }

    public static void verifySize(Region aRegion, int expectedSize) {
        int size = aRegion.size();
        if (size != expectedSize) {
            ParRegUtilVersionHelper.dumpBackingMap(aRegion);
            throw new TestException("Expected size of " + aRegion.getFullPath() + " to be " + expectedSize + ", but it is " + size);
        }
    }

    public static void verifySize(Region aRegion, int expectedSize, Map regionSnapshot) {
        int size = aRegion.size();
        if (size != expectedSize) {
            LogWriter log = Log.getLogWriter();
            StringBuffer sb = new StringBuffer(10000);
            sb.append("region has wrong size (").append(size).append(").\n");
            StringBuffer notThere = new StringBuffer();
            notThere.append("These keys are in the region but shouldn't be:\n");
            int notThereCount = 0;
            for (Map.Entry entry : aRegion.entrySet()) {
                if (regionSnapshot.containsKey(entry.getKey())) continue;
                notThere.append(entry.getKey()).append("\n");
                ++notThereCount;
            }
            if (notThereCount > 0) {
                sb.append(notThere);
            }
            StringBuffer there = new StringBuffer();
            there.append("These keys are not in the region but should be:\n");
            int thereCount = 0;
            for (Map.Entry entry : regionSnapshot.entrySet()) {
                if (aRegion.containsKey(entry.getKey())) continue;
                there.append(entry.getKey()).append("\n");
                ++thereCount;
            }
            if (thereCount > 0) {
                sb.append(there);
            }
            log.info(sb.toString());
            throw new TestException("Expected size of " + aRegion.getFullPath() + " to be " + expectedSize + ", but it is " + size);
        }
    }

    public static void dumpAllDataStores(Region aRegion) {
        try {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            pr.dumpAllBuckets(false, Log.getLogWriter().convertToLogWriterI18n());
        }
        catch (ReplyException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not dumping data stores on " + aRegion + " because it is not a PartitionedRegion (probably because it's a region " + " from a bridge client");
        }
    }

    public static void dumpAllPartitionedRegions() {
        Log.getLogWriter().info("[dumpAllPartitionedRegions]");
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            Log.getLogWriter().info("[dumpAllPartitionedRegions] no cache found in this member");
            return;
        }
        Set parRegs = cache.getPartitionedRegions();
        if (parRegs.isEmpty()) {
            Log.getLogWriter().info("[dumpAllPartitionedRegions] no partitioned regions found in this member");
        }
        Log.getLogWriter().info("[dumpAllPartitionedRegions] dumping " + parRegs.size() + " partitioned regions...");
        Throwable thrown = null;
        Iterator iter = parRegs.iterator();
        while (iter.hasNext()) {
            try {
                PartitionedRegion pr = (PartitionedRegion)iter.next();
                Log.getLogWriter().info("[dumpAllPartitionedRegions] dumping " + pr);
                pr.dumpAllBuckets(false, Log.getLogWriter().convertToLogWriterI18n());
            }
            catch (VirtualMachineError err) {
                throw err;
            }
            catch (Throwable e) {
                Log.getLogWriter().error("[dumpAllPartitionedRegions] failed", e);
                if (thrown != null) continue;
                thrown = e;
            }
        }
        Log.getLogWriter().info("[dumpAllPartitionedRegions] finished dumping " + parRegs.size() + " partitioned regions.");
        if (thrown != null) {
            throw new TestException(TestHelper.getStackTrace(thrown));
        }
    }

    public static void verifyPRMetaData(Region aRegion) {
        Log.getLogWriter().info("Attempting to verify PR metadata for " + aRegion.getFullPath());
        try {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            try {
                pr.validateAllBuckets();
            }
            catch (ReplyException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not verifying PR metadata on " + aRegion + " because it is not a PartitionedRegion (probably because it's a region " + " from a bridge client");
        }
    }

    public static void verifyPrimaries(Region aRegion, int numExtraCopies) {
        String errStr = ParRegUtil._verifyPrimaries(aRegion, numExtraCopies, true);
        if (errStr != null) {
            throw new TestException(errStr.toString());
        }
    }

    public static void verifyPrimariesWithWait(Region aRegion, int numExtraCopies) {
        int THRESHOLD_MILLIS = 180000;
        int SLEEP_MILLIS = 5000;
        String errStr = ParRegUtil._verifyPrimaries(aRegion, numExtraCopies, true);
        int numAttempts = 1;
        long startTime = System.currentTimeMillis();
        while (errStr != null) {
            Log.getLogWriter().info("Got a failure in verifyPrimaries, now sleeping for 5000 millis before trying again, failure is: " + errStr);
            MasterController.sleepForMs(5000);
            errStr = ParRegUtil._verifyPrimaries(aRegion, numExtraCopies, false);
            ++numAttempts;
            long duration = System.currentTimeMillis() - startTime;
            if (errStr == null) {
                Log.getLogWriter().info("verifyPrimaries successful after " + numAttempts + " attempts and " + duration + " millis");
                return;
            }
            if (duration <= 180000L) continue;
            Log.getLogWriter().info("After " + numAttempts + " attempts and " + duration + " millis, verifyPrimaries still fails: " + errStr);
            throw new TestException(errStr.toString());
        }
    }

    public static String _verifyPrimaries(Region aRegion, int numExtraCopies, boolean logProgress) {
        Log.getLogWriter().info("Attempting to verify primaries for " + aRegion.getFullPath() + " with numExtraCopies " + numExtraCopies);
        StringBuffer errStr = new StringBuffer();
        int expectedNumBuckets = numExtraCopies + 1;
        try {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            try {
                int totalBuckets = pr.getTotalNumberOfBuckets();
                for (int i = 0; i < totalBuckets; ++i) {
                    List aList;
                    if (logProgress) {
                        Log.getLogWriter().info("Verifying primary for bucket id " + i + " out of " + totalBuckets + " buckets.");
                    }
                    if ((aList = pr.getBucketOwnersForValidation(i)).size() == 0) continue;
                    int primaryCount = 0;
                    Object primaryMember = null;
                    StringBuffer primaryStatusStr = new StringBuffer();
                    for (int j = 0; j < aList.size(); ++j) {
                        Object[] tmpArr = (Object[])aList.get(j);
                        Object member = tmpArr[0];
                        Boolean isPrimary = (Boolean)tmpArr[1];
                        primaryStatusStr.append("<" + member + " isPrimary=" + isPrimary + "> ");
                        if (!isPrimary.booleanValue()) continue;
                        ++primaryCount;
                        primaryMember = member;
                    }
                    if (primaryCount != 1) {
                        errStr.append("Expected 1 primary for bucket id " + i + ", but found " + primaryCount + ": " + primaryStatusStr + "\n");
                    } else {
                        InternalDistributedMember member = pr.getBucketPrimary(i);
                        if (!member.toString().equalsIgnoreCase(primaryMember.toString())) {
                            errStr.append("Primary for bucket id " + i + " is " + member + ", but " + primaryMember + " claims to be the primary; " + primaryStatusStr + "\n");
                        }
                    }
                    if (numExtraCopies == -1 || aList.size() == expectedNumBuckets) continue;
                    errStr.append("For bucket id " + i + ", expected " + expectedNumBuckets + " members in primary list, but found " + aList.size() + "; " + primaryStatusStr + "\n");
                }
            }
            catch (ReplyException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not verifying PR primaries on " + aRegion + " because it is not a PartitionedRegion (probably because it's a region " + " from a bridge client");
        }
        if (errStr.length() == 0) {
            return null;
        }
        return errStr.toString();
    }

    public static void verifyBucketCopies(Region aRegion, int numExtraCopies) {
        Log.getLogWriter().info("Attempting to verify bucket copies for " + aRegion.getFullPath() + " with numExtraCopies " + numExtraCopies);
        try {
            PartitionedRegion partitionedRegion = (PartitionedRegion)aRegion;
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not verifying bucket copies on " + aRegion + " because it is not a PartitionedRegion (probably because it's a region " + " from a bridge client");
            return;
        }
        ParRegUtil instance = new ParRegUtil();
        boolean done = false;
        while (!done) {
            done = instance.verify_bucket_copies(aRegion, numExtraCopies, Long.MAX_VALUE);
        }
    }

    public void verifyBucketCopiesBatched(Region aRegion, int numExtraCopies) {
        Log.getLogWriter().info("Attempting to verify bucket copies (batched) for " + aRegion.getFullPath());
        try {
            PartitionedRegion partitionedRegion = (PartitionedRegion)aRegion;
        }
        catch (ClassCastException e) {
            throw new StopSchedulingTaskOnClientOrder("Not verifying bucket copies on " + aRegion + " because it is not a PartitionedRegion (probably because it's a region " + " from a bridge client");
        }
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        boolean done = this.verify_bucket_copies(aRegion, numExtraCopies, minTaskGranularitySec);
        if (done) {
            throw new StopSchedulingTaskOnClientOrder("Done verifying all buckets");
        }
    }

    private boolean verify_bucket_copies(Region aRegion, int numExtraCopies, long secondsToRun) {
        block9: {
            if (this.verifyBucketCopiesCompleted) {
                return true;
            }
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            int totalBuckets = pr.getTotalNumberOfBuckets();
            int expectedNumCopies = numExtraCopies + 1;
            long msToRun = secondsToRun * 1000L;
            long startTime = System.currentTimeMillis();
            while (true) {
                ++this.verifyBucketCopiesBucketId;
                if (this.verifyBucketCopiesBucketId >= totalBuckets) break block9;
                Log.getLogWriter().info("Verifying data for bucket id " + this.verifyBucketCopiesBucketId + " out of " + totalBuckets + " buckets");
                List listOfMaps = null;
                try {
                    listOfMaps = pr.getAllBucketEntries(this.verifyBucketCopiesBucketId);
                }
                catch (ForceReattemptException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                int size = listOfMaps.size();
                if (size == 0) continue;
                if (numExtraCopies != -1 && size != expectedNumCopies) {
                    this.verifyBucketCopiesErrStr.append("For bucketId " + this.verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size() + "\n");
                }
                if (listOfMaps.size() > 1) {
                    Object firstMap = listOfMaps.get(0);
                    for (int j = 1; j < listOfMaps.size(); ++j) {
                        Object aMap = listOfMaps.get(j);
                        this.verifyBucketCopiesErrStr.append(ParRegUtil.compareBucketMaps(firstMap, aMap));
                    }
                }
                if (secondsToRun != 0L && System.currentTimeMillis() - startTime >= msToRun) break;
            }
            return false;
        }
        this.verifyBucketCopiesCompleted = true;
        if (this.verifyBucketCopiesErrStr.length() != 0) {
            int MAX_ERR_STR_SIZE = 5000;
            if (this.verifyBucketCopiesErrStr.length() > 5000) {
                String errStr = this.verifyBucketCopiesErrStr.toString();
                Log.getLogWriter().info("Full error string: " + errStr);
                throw new TestException(errStr.substring(0, 5000) + "\n...<more in log file>");
            }
            throw new TestException(this.verifyBucketCopiesErrStr.toString());
        }
        return true;
    }

    protected static String compareBucketMaps(Object dump1, Object dump2) {
        return ParRegUtilVersionHelper.compareBucketMaps(dump1, dump2);
    }

    public static void registerInterest(Region aRegion, boolean loopUntilSuccess) {
        while (true) {
            try {
                Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES");
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
                return;
            }
            catch (ServerOperationException e) {
                if (!(e.getCause() instanceof PartitionOfflineException)) {
                    throw e;
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + " caused by " + e.getCause() + "; retrying registerInterest, continuting test");
                MasterController.sleepForMs(1000);
                continue;
            }
            break;
        }
    }

    public static void registerInterest(Region aRegion) {
        Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES");
        aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
    }

    public static void verifyBucketsOnUniqueHosts(Region aRegion) {
        Log.getLogWriter().info("Attempting to verify bucket copies are on unique hosts...");
        StringBuffer errStr = new StringBuffer();
        try {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            try {
                int totalBuckets = pr.getTotalNumberOfBuckets();
                Object lc = null;
                if (lc == null) {
                    for (int i = 0; i < totalBuckets; ++i) {
                        Log.getLogWriter().info("Verifying bucket copies are on unique hosts for bucket id " + i + " out of " + totalBuckets + " buckets.");
                        List aList = pr.getBucketOwnersForValidation(i);
                        if (aList.size() == 0) continue;
                        StringBuffer statusStr = new StringBuffer();
                        statusStr.append("<Bucket id " + i + " has copies on the following members: ");
                        boolean onSameHost = false;
                        ArrayList<String> hostList = new ArrayList<String>();
                        for (int j = 0; j < aList.size(); ++j) {
                            Object[] tmpArr = (Object[])aList.get(j);
                            InternalDistributedMember member = (InternalDistributedMember)tmpArr[0];
                            String hostName = member.getHost();
                            if (hostList.contains(hostName)) {
                                onSameHost = true;
                            }
                            hostList.add(hostName);
                            statusStr.append(member + " ");
                        }
                        if (!onSameHost) continue;
                        errStr.append("Found more than 1 copy of bucket id " + i + " on the same host; " + statusStr + "\n");
                    }
                } else {
                    for (int i = 0; i < totalBuckets; ++i) {
                        Log.getLogWriter().info("Verifying bucket copies are on unique ESX hosts for bucket id " + i + " out of " + totalBuckets + " buckets.");
                        List aList = pr.getBucketOwnersForValidation(i);
                        if (aList.size() == 0) continue;
                        StringBuffer statusStr = new StringBuffer();
                        statusStr.append("<Bucket id " + i + " has copies on the following members: ");
                        boolean onSameHost = false;
                        ArrayList<String> hostTokenList = new ArrayList<String>();
                        for (int j = 0; j < aList.size(); ++j) {
                            Object[] tmpArr = (Object[])aList.get(j);
                            InternalDistributedMember member = (InternalDistributedMember)tmpArr[0];
                            String hostToken = (String)tmpArr[2];
                            if (hostTokenList.contains(hostToken)) {
                                onSameHost = true;
                            }
                            hostTokenList.add(hostToken);
                            statusStr.append(member + "[" + hostToken + "] ");
                        }
                        if (!onSameHost) continue;
                        errStr.append("Found more than 1 copy of bucket id " + i + " on the same ESX host; " + statusStr + "\n");
                    }
                }
            }
            catch (ReplyException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not verifying PR primaries on " + aRegion + " because it is not a PartitionedRegion (probably because it's a region " + " from a bridge client");
        }
        if (errStr.length() != 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static void doRebalance() {
        ParRegUtil.doRebalance((GemFireCache)CacheHelper.getCache());
    }

    public static void doRebalance(GemFireCache cache) {
        ResourceManager resMan = cache.getResourceManager();
        boolean heapEviction = resMan.getEvictionHeapPercentage() > 0.0f;
        RebalanceFactory factory = resMan.createRebalanceFactory();
        try {
            RebalanceResults simulateResults = null;
            if (!heapEviction) {
                Log.getLogWriter().info("Calling rebalance simulate");
                RebalanceOperation simulateOp = factory.simulate();
                simulateResults = simulateOp.getResults();
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(simulateResults, "Simulate"));
            }
            Log.getLogWriter().info("Starting rebalancing");
            RebalanceOperation rebalanceOp = factory.start();
            RebalanceResults rebalanceResults = rebalanceOp.getResults();
            Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
            if (!heapEviction && ConfigPrms.getHadoopConfig() == null) {
                RebalanceUtil.isBalanceImproved(rebalanceResults);
                RebalanceUtil.checkSimulateAgainstRebalance(simulateResults, rebalanceResults);
            }
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_rebalance() {
        PdxTest.initClassLoader();
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.rebalance);
        if (counter == 1L) {
            ParRegUtil.doRebalance();
        }
    }

    public static synchronized void HydraTask_waitForRecovery() {
        ParRegUtil.HydraTask_waitForRecovery((GemFireCache)CacheHelper.getCache());
    }

    public static synchronized void HydraTask_waitForRecovery(GemFireCache cache) {
        Set regSet = cache.rootRegions();
        Integer thisVmId = RemoteTestModule.getMyVmid();
        ArrayList<String> prNames = new ArrayList<String>();
        Iterator it = regSet.iterator();
        int numColocatedRegions = 0;
        while (it.hasNext()) {
            Region aRegion = (Region)it.next();
            PartitionAttributes prAttr = aRegion.getAttributes().getPartitionAttributes();
            if (prAttr == null || prAttr.getLocalMaxMemory() == 0) continue;
            if (prAttr.getRedundantCopies() != 0) {
                prNames.add(aRegion.getFullPath());
            }
            if (prAttr.getColocatedWith() == null) continue;
            ++numColocatedRegions;
        }
        if (prNames.size() != 0) {
            if (ConfigPrms.getHadoopConfig() != null) {
                int numPRs = prNames.size() * 2 - numColocatedRegions;
                PRObserver.waitForRebalRecov(thisVmId, 1, numPRs, null, null, false);
            } else {
                PRObserver.waitForRebalRecov(thisVmId, 1, prNames.size(), prNames, null, false);
            }
        } else {
            Log.getLogWriter().info("No recovery to wait for; there are no data store PRs in this vm");
        }
    }

    public static synchronized void HydraTask_recreateBucketsFromHDFS() {
        ParRegUtil.HydraTask_recreateBucketsFromHDFS((GemFireCache)CacheHelper.getCache());
    }

    public static synchronized void HydraTask_recreateBucketsFromHDFS(GemFireCache cache) {
        Set regSet = cache.rootRegions();
        Integer thisVmId = RemoteTestModule.getMyVmid();
        for (Region aRegion : regSet) {
            PartitionAttributes prAttr = aRegion.getAttributes().getPartitionAttributes();
            if (prAttr == null || prAttr.getLocalMaxMemory() == 0) continue;
            Set keys = aRegion.keySet();
            Log.getLogWriter().info("after aRegion.keySet() recreateBucketsFromHDFS found keySet size = " + keys.size() + " with region.size() = " + aRegion.size() + " for " + aRegion.getFullPath());
            for (Object key : keys) {
                aRegion.get(key);
            }
            Log.getLogWriter().info("iterating aRegion.keySet() recreateBucketsFromHDFS found keySet size = " + keys.size() + " with region.size() = " + aRegion.size() + " for " + aRegion.getFullPath());
        }
    }

    public static void writeDiskDirsToBB(Region reg) {
        String diskStoreName = reg.getAttributes().getDiskStoreName();
        if (diskStoreName == null && ConfigPrms.getHadoopConfig() != null) {
            HDFSStoreDescription hsd = HDFSStoreHelper.getHDFSStoreDescription(HDFSUtil.getHDFSStoreName(reg));
            diskStoreName = hsd.getDiskStoreDescription().getName();
        }
        if (diskStoreName == null) {
            Log.getLogWriter().info("The region " + reg.getFullPath() + " does not have a diskStore; not writing disk dirs to bb");
            return;
        }
        DiskStore dStore = DiskStoreHelper.getDiskStore(diskStoreName);
        File[] diskDirs = dStore.getDiskDirs();
        ArrayList<String> diskDirNameList = new ArrayList<String>();
        for (File aFile : diskDirs) {
            try {
                diskDirNameList.add(aFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.DiskDirsCounter);
        String bbKey = diskRecoveryKey + counter;
        ParRegBB.getBB().getSharedMap().put(bbKey, diskDirNameList);
        Log.getLogWriter().info("Put into ParRegBB shared map, key " + bbKey + ", value " + diskDirNameList);
    }

    public static void validateAfterRecovery(Region reg) {
        Log.getLogWriter().info(reg.getFullPath() + " size is " + reg.size());
        if (reg.size() == 0) {
            throw new TestException("Expected " + reg.getFullPath() + " to have a size > 0, but it has size " + reg.size());
        }
        int redundantCopies = reg.getAttributes().getPartitionAttributes().getRedundantCopies();
        ParRegUtil.verifyPRMetaData(reg);
        ParRegUtil.verifyPrimaries(reg, redundantCopies);
        ParRegUtil.verifyBucketCopies(reg, redundantCopies);
    }

    public static void createDiskStoreIfNecessary(String hydraRegionConfigName) {
        boolean recoverFromDisk = ParRegPrms.getRecoverFromDisk();
        RegionAttributes attr = RegionHelper.getRegionAttributes(hydraRegionConfigName);
        String diskStoreName = attr.getDiskStoreName();
        if (diskStoreName == null && attr.getDataPolicy().withHDFS()) {
            String hdfsStoreName = attr.getHDFSStoreName();
            diskStoreName = HDFSStoreHelper.getHDFSStoreDescription(hdfsStoreName).getDiskStoreDescription().getName();
        }
        if (diskStoreName == null) {
            if (hydraRegionConfigName.indexOf("accessor") >= 0) {
                Log.getLogWriter().info("No diskStore to create for " + hydraRegionConfigName);
                return;
            }
            if (recoverFromDisk) {
                throw new TestException("hydra region config name " + hydraRegionConfigName + " did not specify a DiskStore name, but ParRegPrms-recoverFromDisk is true");
            }
            Log.getLogWriter().info("No diskStore defined in " + hydraRegionConfigName);
            return;
        }
        if (recoverFromDisk) {
            DiskStoreFactory dsFactory = DiskStoreHelper.getDiskStoreFactory(diskStoreName);
            long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.DiskRecoveryCounter);
            String bbKey = diskRecoveryKey + counter;
            Object anObj = ParRegBB.getBB().getSharedMap().get(bbKey);
            if (anObj == null) {
                throw new TestException("Unexpected null in blackboard map for key " + bbKey);
            }
            List diskNameList = (List)anObj;
            File[] diskDirs = new File[diskNameList.size()];
            for (int i = 0; i < diskNameList.size(); ++i) {
                File aFile;
                diskDirs[i] = aFile = new File((String)diskNameList.get(i));
            }
            dsFactory.setDiskDirs(diskDirs);
            DiskStoreHelper.createDiskStore(diskStoreName, dsFactory);
        } else {
            DiskStoreHelper.createDiskStore(diskStoreName);
        }
    }

    public static Region createRegion(String cacheDescriptName, String regionDescriptName, String xmlFile) {
        Region createdRegion = null;
        RegionDescription regDescript = RegionHelper.getRegionDescription(regionDescriptName);
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds != null && ds.isConnected()) {
            Cache theCache = CacheHelper.getCache();
            if (theCache == null) {
                theCache = CacheHelper.createCache(cacheDescriptName);
                createdRegion = theCache.getRegion(regDescript.getRegionName());
                if (createdRegion == null) {
                    createdRegion = ParRegUtil.createRegionProgrammatically(regionDescriptName);
                }
            } else {
                createdRegion = ParRegUtil.createRegionProgrammatically(regionDescriptName);
            }
        } else if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile)) {
            Log.getLogWriter().info("Creating " + regDescript.getRegionName() + " with " + xmlFile);
            Cache theCache = CacheHelper.createCacheFromXml(xmlFile);
            if (theCache == null) {
                throw new TestException("Unexpected null cache");
            }
            createdRegion = theCache.getRegion(regDescript.getRegionName());
            if (createdRegion == null) {
                throw new TestException("Unexpected null region");
            }
            Log.getLogWriter().info("Finished creating " + TestHelper.regionToString(createdRegion, true) + " by using " + xmlFile);
        } else {
            Cache theCache = CacheHelper.createCache(cacheDescriptName);
            createdRegion = ParRegUtil.createRegionProgrammatically(regionDescriptName);
        }
        return createdRegion;
    }

    private static Region createRegionProgrammatically(String regDescriptName) {
        String poolConfigName;
        ParRegUtil.createDiskStoreIfNecessary(regDescriptName);
        RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
        String regionName = RegionHelper.getRegionDescription(regDescriptName).getRegionName();
        PoolDescription poolDescript = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription();
        if (poolDescript != null && (poolConfigName = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription().getName()) != null) {
            PoolHelper.createPool(poolConfigName);
        }
        return CacheHelper.getCache().createRegion(regionName, attr);
    }

    public static Region createClientRegion(String cacheConfig, String regionConfig, String xmlFile) {
        Region createdRegion = null;
        String regionName = ClientRegionHelper.getClientRegionDescription(regionConfig).getRegionName();
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds != null && ds.isConnected()) {
            ClientCache theCache = ClientCacheHelper.getCache();
            if (theCache == null) {
                theCache = ClientCacheHelper.createCache(cacheConfig);
                createdRegion = theCache.getRegion(regionName);
                if (createdRegion == null) {
                    createdRegion = ClientRegionHelper.createRegion(regionConfig);
                }
            } else {
                createdRegion = ClientRegionHelper.createRegion(regionConfig);
            }
        } else if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile)) {
            Log.getLogWriter().info("Creating " + regionName + " with " + xmlFile);
            ClientCache theCache = ClientCacheHelper.createCacheFromXml(xmlFile);
            if (theCache == null) {
                throw new TestException("Unexpected null cache");
            }
            createdRegion = theCache.getRegion(regionName);
            if (createdRegion == null) {
                throw new TestException("Unexpected null region");
            }
            Log.getLogWriter().info("Finished creating " + TestHelper.regionToString(createdRegion, true) + " by using " + xmlFile);
        } else {
            ClientCache theCache = ClientCacheHelper.createCache(cacheConfig);
            createdRegion = ClientRegionHelper.createRegion(regionConfig);
        }
        return createdRegion;
    }

    public static Boolean[] getBucketStatus(Region aRegion, int bucketId) {
        List aList;
        try {
            aList = ((PartitionedRegion)aRegion).getBucketOwnersForValidation(bucketId);
        }
        catch (ForceReattemptException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (aList.size() == 0) {
            return null;
        }
        DistributedMember thisMember = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        for (int j = 0; j < aList.size(); ++j) {
            Object[] tmpArr = (Object[])aList.get(j);
            DistributedMember member = (DistributedMember)tmpArr[0];
            Boolean isPrimary = (Boolean)tmpArr[1];
            if (!member.equals(thisMember)) continue;
            return new Boolean[]{member.equals(thisMember), isPrimary};
        }
        return new Boolean[]{false, false};
    }
}

