/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CacheServerHelper;
import hydra.ConfigPrms;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegCreateDestroy;
import rebalance.RebalanceBB;
import rebalance.RebalancePrms;
import rebalance.RebalanceTest;
import rebalance.RebalanceUtil;
import rebalance.RecoveryStopStart;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class RebalanceParRegCreateDestroy
extends ParRegCreateDestroy {
    private static final String cacheServerStr = "cacheserver";

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new RebalanceParRegCreateDestroy();
            testInstance.initialize();
        }
        Log.getLogWriter().info("isBridgeConfiguration: " + isBridgeConfiguration);
        Log.getLogWriter().info("isBridgeClient: " + isBridgeClient);
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new RebalanceParRegCreateDestroy();
            testInstance.initialize();
            BridgeHelper.startBridgeServer("bridge");
        }
        isBridgeClient = false;
        Log.getLogWriter().info("isBridgeConfiguration: " + isBridgeConfiguration);
        Log.getLogWriter().info("isBridgeClient: " + isBridgeClient);
    }

    @Override
    protected void initialize() {
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        isBridgeConfiguration = bridgeNames != null;
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            if (regionDescriptName.startsWith("bridge")) {
                bridgeRegionDescriptNames.add(regionDescriptName);
                continue;
            }
            if (regionDescriptName.equalsIgnoreCase("cacheServerRegion")) continue;
            regionDescriptNames.add(regionDescriptName);
        }
        if (isBridgeConfiguration && bridgeRegionDescriptNames.size() != regionDescriptNames.size()) {
            throw new TestException("Error in test configuration; need equal number of region descriptions for bridge servers and bridge clients");
        }
        Log.getLogWriter().info("bridgeRegionDescriptNames is " + bridgeRegionDescriptNames);
        Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
        theCache = CacheHelper.createCache("cache1");
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        ParRegBB.getBB().getSharedMap().put(RecoveryStopStart.DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
    }

    public static synchronized void HydraTask_rebalanceTask() {
        if (testInstance == null) {
            testInstance = new RebalanceParRegCreateDestroy();
            testInstance.initialize();
        }
        testInstance.doCreateRegionsOnly();
        RebalanceTest.HydraTask_rebalanceTask();
    }

    public static synchronized void HydraTask_createXml() {
        block2: {
            String key = cacheServerStr;
            String xmlFileName = key + ".xml";
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionDescriptName = ConfigPrms.getRegionConfig();
            ArrayList regionNames = new ArrayList(TestConfig.tab().vecAt(RegionPrms.regionName));
            int index = regionNames.indexOf("cacheServerRegion");
            regionNames.remove(index);
            try {
                CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), regionDescriptName, regionNames, xmlFileName);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block2;
                throw e;
            }
        }
    }

    public static synchronized void HydraTask_rebalanceWithCacheServer() {
        Cache myCache;
        if (testInstance == null) {
            testInstance = new RebalanceParRegCreateDestroy();
        }
        if ((myCache = CacheHelper.getCache()) == null) {
            throw new TestException("HydraTask_rebalanceWithCacheServer() expects hydra client to have created cache and PR via initialization tasks");
        }
        testInstance.doCreateRegionsOnly();
        ResourceManager rm = myCache.getResourceManager();
        Set before = PartitionRegionHelper.getPartitionRegionInfo((Cache)myCache);
        RebalanceBB.getBB().getSharedCounters().zero(RebalanceBB.recoveryRegionCount);
        String[] extraArgs = RebalancePrms.getExtraCacheServerArgs();
        String xmlFileName = "cacheserver.xml";
        long numCacheServers = RebalanceBB.getBB().getSharedCounters().incrementAndRead(RebalanceBB.numCacheServers);
        String serverName = "cacheserver_" + numCacheServers;
        Log.getLogWriter().info("Starting up cacheServer " + serverName + " with cache.xml file " + xmlFileName + " for Rebalance");
        GemFireDescription gfd = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getGemFireDescription();
        String offHeapMemorySize = gfd.getOffHeapMemorySize();
        if (offHeapMemorySize != null) {
            extraArgs = Arrays.copyOf(extraArgs, extraArgs.length + 1);
            extraArgs[extraArgs.length - 1] = " off-heap-memory-size=" + offHeapMemorySize;
        }
        RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.criticalSection);
        CacheServerHelper.startCacheServer(serverName, xmlFileName, extraArgs);
        RebalanceUtil.waitForRecovery();
        testInstance.doCreateRegionsOnly();
        String regionPath = null;
        String regionName = null;
        for (PartitionRegionInfo prdBefore : before) {
            Log.getLogWriter().info("Before Rebalance\n" + RebalanceUtil.partitionedRegionDetailsToString(prdBefore));
            regionPath = prdBefore.getRegionPath();
            regionName = RebalanceUtil.getRegionName(prdBefore);
            Region region = myCache.getRegion(regionName);
            PartitionRegionInfo prdAfter = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
            Log.getLogWriter().info("After Rebalance \n" + RebalanceUtil.partitionedRegionDetailsToString(prdAfter));
            if (!RebalancePrms.verifyBalance()) continue;
            RebalanceUtil.isBalanceImproved(regionName, prdBefore.getPartitionMemberInfo(), prdAfter.getPartitionMemberInfo());
            Log.getLogWriter().info("PR for region " + regionName + " is balanced");
        }
        CacheServerHelper.stopCacheServer(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_createDestroy() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        try {
            do {
                long criticalSection;
                if ((criticalSection = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.criticalSection)) == 0L) {
                    testInstance.doCreateDestroy();
                    continue;
                }
                MasterController.sleepForMs(1000);
            } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        }
        finally {
            if (isBridgeConfiguration) {
                for (Region r : theCache.rootRegions()) {
                    ClientHelper.release(r);
                }
            }
        }
    }

    public static void HydraTask_rebalanceOps() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            ((RebalanceParRegCreateDestroy)testInstance).doRebalanceOps();
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected void doRebalanceOps() {
        Cache myCache = CacheHelper.getCache();
        ResourceManager rm = myCache.getResourceManager();
        RebalanceFactory factory = rm.createRebalanceFactory();
        Log.getLogWriter().info("Starting rebalance ...");
        RebalanceOperation newOp = factory.start();
        Log.getLogWriter().info("Rebalance started with operation " + newOp.toString());
        Object[] opArray = rm.getRebalanceOperations().toArray();
        if (opArray.length > 0) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, opArray.length - 1);
            RebalanceOperation op = (RebalanceOperation)opArray[randInt];
            Log.getLogWriter().info("Cancelling rebalance for operation " + op.toString());
            try {
                op.cancel();
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (!op.isCancelled()) {
                throw new TestException("Operation " + op.toString() + " was not cancelled as expected");
            }
            Log.getLogWriter().info("Operation cancelled (as expected)");
        } else {
            Log.getLogWriter().info("Cannot cancel rebalance, number of rebalance operations in progress = " + opArray.length);
        }
    }

    public static void HydraTask_populateRegions() {
        ((RebalanceParRegCreateDestroy)testInstance).populateRegions();
    }

    protected void populateRegions() {
        Cache myCache = CacheHelper.getCache();
        Set regions = myCache.rootRegions();
        for (Region aRegion : regions) {
            Log.getLogWriter().info("Putting 50 entries into " + aRegion.getFullPath());
            for (int i = 1; i <= 50; ++i) {
                aRegion.put((Object)("" + System.currentTimeMillis()), (Object)new Integer(i));
            }
        }
    }

    public static void HydraTask_recycleDataStore() {
        StopStartVMs.stopStartOtherVMs(1);
    }
}

