/*
 * Decompiled with CFR 0.152.
 */
package parReg.colocation;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DiskStorePrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayPrms;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.PoolPrms;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import hydratest.grid.GridPrms;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import parReg.colocation.Month;
import parReg.execute.UpdateBBPartitionListener;
import pdx.PdxTest;
import util.BaseValueHolder;
import util.CachePrms;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;
import util.ValueHolderPrms;

public class ParRegColocation {
    protected static ParRegColocation testInstance;
    protected static List regionDescriptNames;
    protected static List bridgeRegionDescriptNames;
    protected static int destroyThreshold;
    private static int maxRegions;
    protected static final int ENTRIES_TO_PUT = 50;
    protected static Cache theCache;
    protected static boolean isBridgeConfiguration;
    protected static boolean isBridgeClient;
    protected static boolean isGatewaySenderConfiguration;
    private static boolean highAvailability;
    private static ArrayList bucketsInTheDataStore;
    private static String bucketReferenceRegion;
    private static ArrayList primaryBucketsInTheDataStore;
    private static String primaryBucketReferenceRegion;
    protected SharedCounters sc;
    protected RandomValues randomValues = null;
    protected int numNewKeys;
    protected KeyIntervals keyIntervals;
    protected int totalNumKeys;
    protected int sleepMSAfterOps = -1;
    protected static final int INVALIDATE = 1;
    protected static final int DESTROY = 2;
    protected static final int UPDATE_EXISTING_KEY = 3;
    protected static final int GET = 4;
    protected static final int ADD_NEW_KEY = 5;
    protected static final int QUERY = 6;
    protected static final int LOCAL_INVALIDATE = 7;
    protected static final int LOCAL_DESTROY = 8;
    protected static final int FIRST_OP = 1;
    protected static final int LAST_OP = 6;
    protected static final int[] operations;
    protected final long LOG_INTERVAL_MILLIS = 10000L;
    protected static ParRegUtil parRegUtilInstance;
    protected static String DataStoreVmStr;
    protected static final String KEY_LIST = "Key List";
    protected static final String PR_TOTAL_BUCKETS = "PR Total Buckets";
    protected static final String PR_TOTAL_DATASTORES = "PR Total DataStores";
    protected static final String VmIDStr = "VmId_";

    public static void StartTask_initialize() {
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        boolean isBridgeConfiguration = bridgeNames != null;
        HydraVector gatewayNames = TestConfig.tab().vecAt(GatewayPrms.names, null);
        HydraVector senderNames = TestConfig.tab().vecAt(GatewaySenderPrms.names, null);
        boolean isWanConfiguration = gatewayNames == null ? senderNames != null : true;
        int numKeys = TestConfig.tab().intAt(InitImagePrms.numKeys);
        KeyIntervals intervals = null;
        intervals = isWanConfiguration || ConfigPrms.getHadoopConfig() != null ? new KeyIntervals(new int[]{1000, 1003, 1005, 1006}, numKeys) : new KeyIntervals(new int[]{1000, 1001, 1003, 1005, 1006}, numKeys);
        InitImageBB.getBB().getSharedMap().put(InitImageBB.KEY_INTERVALS, intervals);
        Log.getLogWriter().info("Created keyIntervals: " + intervals);
        SharedCounters sc = InitImageBB.getBB().getSharedCounters();
        sc.setIfLarger(InitImageBB.LASTKEY_INVALIDATE, intervals.getFirstKey(1001) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_DESTROY, intervals.getFirstKey(1003) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY, intervals.getFirstKey(1005) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_GET, intervals.getFirstKey(1006) - 1);
        sc.setIfLarger(InitImageBB.LAST_QUERY, intervals.getFirstKey(1006) - 1);
        InitImageBB.getBB().printSharedMap();
        InitImageBB.getBB().printSharedCounters();
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ParRegColocation();
            testInstance.initialize();
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegColocation();
            isBridgeClient = false;
            testInstance.initialize();
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration && !TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile, false)) {
                BridgeHelper.startBridgeServer("bridge");
            }
            if (InitImagePrms.useTransactions()) {
                TxHelper.setTransactionManager();
            }
        }
    }

    public static synchronized void HydraTask_HA_initDataStoreAndServerGroups() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegColocation();
            isBridgeClient = false;
            testInstance.initialize();
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration && !TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile, false)) {
                int vmId = RemoteTestModule.getMyVmid();
                if (vmId % 2 == 0) {
                    BridgeHelper.startBridgeServer("bridge");
                } else {
                    BridgeHelper.startBridgeServer("groups");
                }
            }
        }
    }

    public static synchronized void HydraTask_p2p_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegColocation();
            isBridgeClient = false;
            testInstance.initialize("dataStore");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
        }
    }

    public static synchronized void HydraTask_p2p_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new ParRegColocation();
            isBridgeClient = false;
            testInstance.initialize("accessor");
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new ParRegColocation();
            testInstance.initialize();
        }
    }

    public static synchronized void HydraTask_logLocalSize() {
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                Log.getLogWriter().info("Number of entries in this data store: " + ParRegUtil.getLocalSize(aRegion));
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                Log.getLogWriter().info("Number of entries in this data store: " + ParRegUtil.getLocalSize(aRegion));
            }
        }
    }

    public static synchronized void HydraTask_registerInterest() {
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            String regionDescriptName = (String)regionDescriptNames.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            ParRegUtil.registerInterest(aRegion);
            Log.getLogWriter().info("registered interest for the region " + regionName);
        }
    }

    public void initialize() {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        isBridgeConfiguration = bridgeNames != null;
        isGatewaySenderConfiguration = TestConfig.tab().stringAt(GatewaySenderPrms.names, null) != null;
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            if (regionDescriptName.startsWith("bridge")) {
                bridgeRegionDescriptNames.add(regionDescriptName);
                continue;
            }
            regionDescriptNames.add(regionDescriptName);
        }
        if (isBridgeConfiguration && bridgeRegionDescriptNames.size() != regionDescriptNames.size()) {
            throw new TestException("Error in test configuration; need equal number of region descriptions for bridge servers and bridge clients");
        }
        Log.getLogWriter().info("bridgeRegionDescriptNames is " + bridgeRegionDescriptNames);
        Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
        maxRegions = regionDescriptNames.size();
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile, false)) {
            this.createRegionsWithXml();
        } else {
            theCache = CacheHelper.createCache("cache1");
            if (isGatewaySenderConfiguration) {
                if (!isBridgeConfiguration) {
                    String senderConfig = ConfigPrms.getGatewaySenderConfig();
                    GatewaySenderHelper.createGatewaySenders(senderConfig);
                } else if (!isBridgeClient) {
                    String senderConfig = ConfigPrms.getGatewaySenderConfig();
                    GatewaySenderHelper.createGatewaySenders(senderConfig);
                }
            }
            this.createRegions();
        }
        TestHelper.logRegionHierarchy();
    }

    public void initialize(String regionDescription) {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            if (regionDescriptName.startsWith("dataStore") && regionDescription.startsWith("dataStore")) {
                regionDescriptNames.add(regionDescriptName);
                continue;
            }
            if (!regionDescriptName.startsWith("accessor") || !regionDescription.startsWith("accessor")) continue;
            regionDescriptNames.add(regionDescriptName);
        }
        Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
        maxRegions = regionDescriptNames.size();
        theCache = CacheHelper.createCache("cache1");
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        this.createRegions();
    }

    protected void createRegionsWithXml() {
        String key = VmIDStr + RemoteTestModule.getMyVmid();
        String cacheXmlFile = key + ".xml";
        File aFile = new File(cacheXmlFile);
        HydraVector diskStoreName = TestConfig.tab().vecAt(DiskStorePrms.names, null);
        if (!aFile.exists()) {
            if (isBridgeConfiguration && !isBridgeClient) {
                CacheHelper.generateCacheXmlFileNoCheck("cache1", null, bridgeRegionDescriptNames, null, "bridge", null, diskStoreName, GridPrms.getFunctions(), cacheXmlFile);
                theCache = CacheHelper.createCacheFromXml(cacheXmlFile);
            } else if (isBridgeConfiguration && isBridgeClient) {
                HydraVector poolNames = TestConfig.tab().vecAt(PoolPrms.names, null);
                DistributedSystemHelper.connectWithXml(cacheXmlFile);
                Log.getLogWriter().info("Pool in the list " + poolNames);
                CacheHelper.generateCacheXmlFileNoCheck("cache1", null, regionDescriptNames, null, null, poolNames, diskStoreName, GridPrms.getFunctions(), cacheXmlFile);
                theCache = CacheHelper.createCacheFromXml(cacheXmlFile);
            } else {
                CacheHelper.generateCacheXmlFileNoCheck("cache1", null, regionDescriptNames, null, null, null, diskStoreName, GridPrms.getFunctions(), cacheXmlFile);
                theCache = CacheHelper.createCacheFromXml(cacheXmlFile);
            }
        } else {
            theCache = CacheHelper.createCacheFromXml(cacheXmlFile);
        }
    }

    protected void createRegions() {
        Set rootRegions = theCache.rootRegions();
        Region aRegion = null;
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                try {
                    aRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
                    Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
                    continue;
                }
                catch (RegionExistsException e) {
                    Log.getLogWriter().info("Using existing partitioned region " + regionName);
                    aRegion = e.getRegion();
                    if (aRegion != null) continue;
                    throw new TestException("RegionExistsException.getRegion returned null");
                }
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
                String poolName = attributes.getPoolName();
                if (poolName != null) {
                    PoolHelper.createPool(poolName);
                }
                try {
                    aRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
                    Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
                    continue;
                }
                catch (RegionExistsException e) {
                    Log.getLogWriter().info("Using existing partitioned region " + regionName);
                    aRegion = e.getRegion();
                    if (aRegion != null) continue;
                    throw new TestException("RegionExistsException.getRegion returned null");
                }
            }
        }
    }

    public static void HydraTask_loadRegions() {
        PdxTest.initClassLoader();
        testInstance.loadRegions();
    }

    protected void loadRegions() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = this.sc.incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, for Region shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate;
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            try {
                Object value = this.getValueToAdd(key);
                if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                    Region aRegion;
                    String regionName;
                    int j;
                    Month callBackArg = Month.months[(int)(shouldAddCount % 12L)];
                    Log.getLogWriter().info("Callback arg is " + callBackArg.toString() + " which has hashCode " + callBackArg.hashCode());
                    InitImageBB.getBB().getSharedMap().put(key, callBackArg);
                    String regionDescriptName = null;
                    if (isBridgeConfiguration && !isBridgeClient) {
                        for (j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                            regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                            regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                            aRegion = theCache.getRegion(regionName);
                            Log.getLogWriter().info("Doing put in region " + aRegion.getName() + "for key value " + key.toString() + " " + value.toString());
                            aRegion.put((Object)key, value);
                            Log.getLogWriter().info("The region size is " + aRegion.size() + " region is " + regionName);
                        }
                    } else {
                        for (j = 0; j < regionDescriptNames.size(); ++j) {
                            regionDescriptName = (String)regionDescriptNames.get(j);
                            regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                            aRegion = theCache.getRegion(regionName);
                            Log.getLogWriter().info("Doing put in region " + aRegion.getName() + "for key value " + key.toString() + " " + value.toString());
                            aRegion.put((Object)key, value);
                            Log.getLogWriter().info("Did put in region " + aRegion.getName() + "for key value " + key.toString() + " " + value.toString());
                            Log.getLogWriter().info("The region size is " + aRegion.size() + " region is " + regionName);
                        }
                    }
                }
                this.sc.increment(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + " out of " + numKeysToCreate);
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected Object getValueToAdd(Object key) {
        String objectType = TestConfig.tab().stringAt(ValueHolderPrms.objectType, ValueHolder.class.getName());
        if (objectType.equals(ValueHolder.class.getName())) {
            return new ValueHolder((String)key, this.randomValues);
        }
        if (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder")) {
            return PdxTest.getVersionedValueHolder(objectType, (String)key, this.randomValues);
        }
        throw new TestException("Unknown objectType " + objectType);
    }

    public static void HydraTask_verifyPRMetaData() {
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    ParRegColocation.verifyPRMetaData(aRegion);
                    Log.getLogWriter().info("verified Meta Data for the region " + regionName);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify metadata");
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                ParRegColocation.verifyPRMetaData(aRegion);
                if (aRegion instanceof PartitionedRegion) {
                    ParRegColocation.verifyPRMetaData(aRegion);
                    Log.getLogWriter().info("verified Meta Data for the region " + regionName);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify metadata");
            }
        }
    }

    public static void verifyPRMetaData(Region aRegion) {
        try {
            ParRegUtil.verifyPRMetaData(aRegion);
        }
        catch (Exception e) {
            ParRegUtil.dumpAllDataStores(aRegion);
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyRegionSize() {
        testInstance.Task_verifyRegionSize();
    }

    public void Task_verifyRegionSize() {
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.verifyRegionSize(aRegion);
                Log.getLogWriter().info("verified Region size for the region " + regionName);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.verifyRegionSize(aRegion);
                Log.getLogWriter().info("verified Region size for the region " + regionName);
            }
        }
    }

    protected void verifyRegionSize(Region aRegion) {
        int size = aRegion.size();
        long numOriginalKeysCreated = InitImageBB.getBB().getSharedCounters().read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long nameCounter = NameFactory.getPositiveNameCounter();
        Log.getLogWriter().info("In HydraTask_verifyRegionSize, region size is " + size + ", numKeysToCreate is " + numKeysToCreate + ", numOriginalKeysCreated is " + numOriginalKeysCreated + ", nameCounter is " + nameCounter);
        if (numOriginalKeysCreated != (long)numKeysToCreate || numOriginalKeysCreated != nameCounter) {
            throw new TestException("Error in test, numOriginalKeysCreated " + numOriginalKeysCreated + ", numKeysToCreate " + numKeysToCreate + ", nameCounter " + nameCounter);
        }
        int verifyRegionSizeIndex = 0;
        while (verifyRegionSizeIndex < numKeysToCreate) {
            String key = NameFactory.getObjectNameForCounter(++verifyRegionSizeIndex);
            Log.getLogWriter().info("For region : " + aRegion.getName() + " : Key : " + key);
            if (!aRegion.containsKey((Object)key)) {
                throw new TestException("Key " + key + " not found in the region " + aRegion.getName());
            }
            if (aRegion.containsValueForKey((Object)key)) continue;
            throw new TestException("For the key " + key + " value is not found in the region " + aRegion.getName());
        }
        if (size != numKeysToCreate) {
            throw new TestException("Unexpected region size " + size + "; expected " + numKeysToCreate);
        }
        String aStr = "In HydraTask_verifyRegionSize, verified " + verifyRegionSizeIndex + " keys and values";
        Log.getLogWriter().info(aStr);
    }

    public static void HydraTask_doOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 7);
        testInstance.doOps(availableOps);
        Log.getLogWriter().info("Cardinality is " + availableOps.cardinality());
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
        primaryBucketsInTheDataStore = null;
        PRObserver.installObserverHook();
        PRObserver.initialize();
        UpdateBBPartitionListener.setBucketIds(new ArrayList());
        UpdateBBPartitionListener.setRecreatedBuckets(new HashSet());
    }

    public void doOps(BitSet availableOps) {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        boolean useTransactions = InitImagePrms.useTransactions();
        if (useTransactions) {
            // empty if block
        }
        while (availableOps.cardinality() != 0 && System.currentTimeMillis() - startTime < minTaskGranularityMS) {
            int whichOp = this.getOp(availableOps, operations.length);
            boolean doneWithOps = false;
            boolean gotTheLock = false;
            boolean rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            try {
                switch (whichOp) {
                    case 5: {
                        doneWithOps = this.addNewKey();
                        break;
                    }
                    case 1: {
                        doneWithOps = this.invalidate();
                        break;
                    }
                    case 2: {
                        doneWithOps = this.destroy();
                        break;
                    }
                    case 3: {
                        doneWithOps = this.updateExistingKey();
                        break;
                    }
                    case 4: {
                        doneWithOps = this.get();
                        break;
                    }
                    case 6: {
                        doneWithOps = true;
                        break;
                    }
                    case 7: {
                        doneWithOps = this.localInvalidate();
                        break;
                    }
                    case 8: {
                        doneWithOps = this.localDestroy();
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.INDOUBT_TXOPS);
                }
                catch (CommitConflictException e) {
                    throw new TestException("Unexpected CommitConflictException " + TestHelper.getStackTrace(e));
                }
            }
            if (!doneWithOps) continue;
            Log.getLogWriter().info("Done with operation " + whichOp);
            availableOps.clear(whichOp);
        }
    }

    protected void recordFailedOps(String sharedMapKey) {
    }

    protected int getOp(BitSet bs, int bsSize) {
        int randInt;
        while (!bs.get(randInt = TestConfig.tab().getRandGen().nextInt(1, bsSize))) {
        }
        return randInt;
    }

    protected void checkContainsValueForKey(Region aRegion, Object key, boolean expected, String logStr) {
        if (aRegion.getAttributes().getDataPolicy() == DataPolicy.EMPTY) {
            return;
        }
        boolean containsValue = aRegion.containsValueForKey(key);
        if (containsValue != expected) {
            throw new TestException("Expected containsValueForKey(" + key + ") to be " + expected + ", but it was " + containsValue + ": " + logStr);
        }
    }

    protected void checkContainsKey(Region aRegion, Object key, boolean expected, String logStr) {
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey(" + key + ") to be " + expected + ", but it was " + containsKey + ": " + logStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkValue(Object key, Object value) {
        if (!(value instanceof BaseValueHolder)) throw new TestException("For key " + key + ", expected value " + TestHelper.toString(value) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)value;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof Long)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a Long for " + TestHelper.toString(vh));
        Long aLong = (Long)vh.myValue;
        long longValue = aLong;
        if (keyCounter == longValue) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkUpdatedValue(Object key, Object value) {
        if (!(value instanceof BaseValueHolder)) throw new TestException("Expected value " + TestHelper.toString(value) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)value;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof String)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a String indicating it was updated, but the value for this key is " + TestHelper.toString(vh));
        String aStr = (String)vh.myValue;
        String expectedStr = "updated_" + keyCounter;
        if (aStr.equals(expectedStr)) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    protected boolean addNewKey() {
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from addNewKey()");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(key, callBackArg);
        }
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.addNewKey(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.addNewKey(aRegion, key);
            }
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    protected void addNewKey(Region aRegion, Object key) {
        Log.getLogWriter().info("In addNewKey " + key + "in the region " + aRegion.getName());
        this.checkContainsValueForKey(aRegion, key, false, "before addNewKey");
        ValueHolder value = new ValueHolder((String)key, this.randomValues);
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
            aRegion.put(key, (Object)value, (Object)callBackArg);
        }
    }

    protected boolean invalidate() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1001, nextKey)) {
            Log.getLogWriter().info("All existing keys invalidated; returning from invalidate operation");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.invalidate(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.invalidate(aRegion, key);
            }
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1001);
    }

    public void invalidate(Region aRegion, Object key) {
        Log.getLogWriter().info("Invalidating " + key + "in the region " + aRegion.getName());
        this.checkContainsValueForKey(aRegion, key, true, "before invalidate");
        aRegion.invalidate(key);
    }

    protected boolean localInvalidate() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1002, nextKey)) {
            Log.getLogWriter().info("All local invalidates completed; returning from localInvalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.localInvalidate(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.localInvalidate(aRegion, key);
            }
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1002);
    }

    public void localInvalidate(Region aRegion, Object key) {
        this.checkContainsValueForKey(aRegion, key, true, "before local invalidate");
        aRegion.localInvalidate(key);
    }

    protected boolean destroy() {
        Log.getLogWriter().info("Inside destroy()");
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            throw new TestException("Cache returned null");
        }
        Log.getLogWriter().info("Cache not null");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_DESTROY);
        if (!this.keyIntervals.keyInRange(1003, nextKey)) {
            Log.getLogWriter().info("All destroys completed; returning from destroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.destroy(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.destroy(aRegion, key);
            }
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1003);
    }

    public void destroy(Region aRegion, Object key) {
        Log.getLogWriter().info("Destroying " + key + "in the region " + aRegion.getName());
        this.checkContainsValueForKey(aRegion, key, true, "before destroy");
        aRegion.destroy(key);
    }

    protected boolean localDestroy() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_DESTROY);
        if (!this.keyIntervals.keyInRange(1004, nextKey)) {
            Log.getLogWriter().info("All local destroys completed; returning from localDestroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.localDestroy(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.localDestroy(aRegion, key);
            }
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1004);
    }

    public void localDestroy(Region aRegion, Object key) {
        Log.getLogWriter().info("Locally destroying " + key);
        this.checkContainsValueForKey(aRegion, key, true, "before local destroy");
        aRegion.localDestroy(key);
    }

    protected boolean updateExistingKey() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY);
        if (!this.keyIntervals.keyInRange(1005, nextKey)) {
            Log.getLogWriter().info("All existing keys updated; returning from updateExistingKey");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.updateExistingKey(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.updateExistingKey(aRegion, key);
            }
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1005);
    }

    public void updateExistingKey(Region aRegion, Object key) {
        Log.getLogWriter().info("Update existing key " + key + "in the region " + aRegion.getName());
        this.checkContainsValueForKey(aRegion, key, true, "before update");
        BaseValueHolder existingValue = (BaseValueHolder)aRegion.get(key);
        ValueHolder newValue = new ValueHolder((String)key, this.randomValues);
        if (existingValue == null) {
            throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
        }
        if (existingValue.myValue instanceof String) {
            throw new TestException("Trying to update a key which was already updated: " + existingValue.myValue);
        }
        newValue.myValue = "updated_" + NameFactory.getCounterForName(key);
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
            aRegion.put(key, (Object)newValue, (Object)callBackArg);
            Log.getLogWriter().info("Inside update(), did update with callback");
        }
    }

    protected boolean get() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_GET);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All gets completed; returning from get");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.get(aRegion, key);
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                this.get(aRegion, key);
            }
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    public void get(Region aRegion, Object key) {
        this.checkContainsValueForKey(aRegion, key, true, "before get");
        Object existingValue = null;
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
            existingValue = aRegion.get(key, (Object)callBackArg);
            Log.getLogWriter().info("Inside get(), did get with callback");
        }
        if (existingValue == null) {
            throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
        }
    }

    public static void HydraTask_verifyPrimaries() {
        String regionDescriptName = null;
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    ParRegColocation.verifyPrimaries(aRegion);
                    Log.getLogWriter().info("verified primaries for the region " + regionName);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify primaries");
            }
        } else {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                regionDescriptName = (String)regionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    ParRegColocation.verifyPrimaries(aRegion);
                    Log.getLogWriter().info("verified primaries for the region " + regionName);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify primaries");
            }
        }
    }

    public static void verifyPrimaries(Region aRegion) {
        try {
            RegionAttributes attr = aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            int redundantCopies = 0;
            if (prAttr != null) {
                redundantCopies = prAttr.getRedundantCopies();
            }
            if (highAvailability) {
                ParRegUtil.verifyPrimariesWithWait(aRegion, redundantCopies);
            } else {
                ParRegUtil.verifyPrimaries(aRegion, redundantCopies);
            }
        }
        catch (Exception e) {
            ParRegUtil.dumpAllDataStores(aRegion);
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyColocatedRegions() {
        testInstance.HydraTask_verifyCustomPartitioning();
        testInstance.HydraTask_verifyCoLocation();
    }

    protected void HydraTask_verifyCoLocation() {
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                String regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)aRegion;
                    this.verifyBucketCoLocation(pr);
                    this.verifyPrimaryBucketCoLocation(pr);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify colocation");
            }
        } else {
            for (int i = 0; i < regionDescriptNames.size(); ++i) {
                String regionDescriptName = (String)regionDescriptNames.get(i);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)aRegion;
                    this.verifyBucketCoLocation(pr);
                    this.verifyPrimaryBucketCoLocation(pr);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify colocation");
            }
        }
    }

    protected void verifyPrimaryBucketCoLocation(PartitionedRegion aRegion) {
        String regionName = aRegion.getName();
        ArrayList primaryBucketList = (ArrayList)aRegion.getLocalPrimaryBucketsListTestOnly();
        Log.getLogWriter().info("The primary buckets in this data Store for the Partioned Region " + regionName);
        if (primaryBucketList == null) {
            RegionAttributes ra = aRegion.getAttributes();
            PartitionAttributes pra = ra.getPartitionAttributes();
            int localMaxMemory = pra.getLocalMaxMemory();
            if (localMaxMemory == 0) {
                Log.getLogWriter().info("This is an accessor, no requirement for verifying colocation");
                return;
            }
            throw new TestException("Bucket List cannot be null for a dataStore");
        }
        Log.getLogWriter().info("Primary Buckets of " + aRegion.getName() + " " + primaryBucketList.toString());
        if (primaryBucketsInTheDataStore == null) {
            Log.getLogWriter().info(" Setting the reference primary buckets in the Data Store for this vm with the Partitioned Region " + aRegion.getName());
            primaryBucketsInTheDataStore = primaryBucketList;
            primaryBucketReferenceRegion = regionName;
        } else {
            Log.getLogWriter().info("Reference primary buckets in the Data Store for this vm already set");
            Log.getLogWriter().info(" Verifying for the region " + regionName);
            for (Integer currentPrimaryBucket : primaryBucketList) {
                if (primaryBucketsInTheDataStore.contains(currentPrimaryBucket)) {
                    Log.getLogWriter().info("Both the Regions " + primaryBucketReferenceRegion + " and " + regionName + " have the bucket " + currentPrimaryBucket + " in this node");
                    continue;
                }
                throw new TestException("Region " + regionName + " does not have its bucket " + currentPrimaryBucket + " colocated with " + primaryBucketReferenceRegion);
            }
            Log.getLogWriter().info("Looking for missed buckets");
            for (Integer referenceRegionBucket : primaryBucketsInTheDataStore) {
                if (primaryBucketList.contains(referenceRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + bucketReferenceRegion + " and " + regionName + " have the bucket " + referenceRegionBucket + " in this node");
                    continue;
                }
                throw new TestException("Region " + regionName + " does not have its bucket " + referenceRegionBucket + " not colocated");
            }
        }
    }

    protected void verifyBucketCoLocation(PartitionedRegion aRegion) {
        String regionName = aRegion.getName();
        ArrayList bucketList = (ArrayList)aRegion.getLocalBucketsListTestOnly();
        if (bucketList == null) {
            RegionAttributes ra = aRegion.getAttributes();
            PartitionAttributes pra = ra.getPartitionAttributes();
            int localMaxMemory = pra.getLocalMaxMemory();
            if (localMaxMemory == 0) {
                Log.getLogWriter().info("This is an accessor, no requirement for verifying colocation");
                return;
            }
            throw new TestException("Bucket List cannot be null for a dataStore");
        }
        Log.getLogWriter().info("The buckets in this data Store for the Partioned Region " + regionName);
        Log.getLogWriter().info("Buckets of " + aRegion.getName() + " " + bucketList.toString());
        if (bucketsInTheDataStore == null) {
            Log.getLogWriter().info(" Setting the reference buckets in the Data Store for this vm with the Partitioned Region " + aRegion.getName());
            bucketsInTheDataStore = bucketList;
            bucketReferenceRegion = regionName;
        } else {
            Log.getLogWriter().info("Reference primary buckets in the Data Store for this vm already set");
            Log.getLogWriter().info(" Verifying for the region " + regionName);
            for (Integer currentRegionBucket : bucketList) {
                if (bucketsInTheDataStore.contains(currentRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + bucketReferenceRegion + " and " + regionName + " have the bucket " + currentRegionBucket + " in this node");
                    continue;
                }
                throw new TestException("Region " + regionName + " does not have its bucket " + currentRegionBucket + " not colocated");
            }
            Log.getLogWriter().info("Looking for missed buckets");
            for (Integer referenceRegionBucket : bucketsInTheDataStore) {
                if (bucketList.contains(referenceRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + bucketReferenceRegion + " and " + regionName + " have the bucket " + referenceRegionBucket + " in this node");
                    continue;
                }
                throw new TestException("Region " + regionName + " does not have its bucket " + referenceRegionBucket + " not colocated");
            }
        }
    }

    public synchronized void HydraTask_verifyCustomPartitioning() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)aRegion;
                this.verifyCustomPartitioning(pr);
                continue;
            }
            Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify custom partitioning");
        }
    }

    protected void verifyCustomPartitioning(PartitionedRegion aRegion) {
        PartitionedRegion pr = aRegion;
        int totalBuckets = pr.getTotalNumberOfBuckets();
        RegionAttributes attr = aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        int redundantCopies = prAttr.getRedundantCopies();
        int expectedNumCopies = redundantCopies + 1;
        int verifyBucketCopiesBucketId = 0;
        while (verifyBucketCopiesBucketId < totalBuckets) {
            Log.getLogWriter().info("Verifying data for bucket id " + verifyBucketCopiesBucketId + " out of " + totalBuckets + " buckets");
            List listOfMaps = null;
            try {
                listOfMaps = pr.getAllBucketEntries(verifyBucketCopiesBucketId);
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            int size = listOfMaps.size();
            if (size == 0) {
                Log.getLogWriter().info("Bucket " + verifyBucketCopiesBucketId + " is empty");
                ++verifyBucketCopiesBucketId;
                continue;
            }
            if (size != expectedNumCopies) {
                throw new TestException("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size());
            }
            Log.getLogWriter().info("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, and have " + listOfMaps.size());
            Log.getLogWriter().info("Validating co-location for all the redundant copies of the bucket with Id : " + verifyBucketCopiesBucketId);
            for (int i = 0; i < listOfMaps.size(); ++i) {
                BucketDump dump = (BucketDump)listOfMaps.get(i);
                Map map = dump.getValues();
                if (map.size() == 0) continue;
                this.verifyCustomPartition(map, verifyBucketCopiesBucketId);
                this.verifyUniqueBucketForCustomPartioning(verifyBucketCopiesBucketId);
            }
            ++verifyBucketCopiesBucketId;
        }
    }

    protected void verifyCustomPartition(Map map, int bucketid) {
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid) == null) {
                Log.getLogWriter().info("RoutingObject for the bucket id to be set in the BB");
                ParRegBB.getBB().getSharedMap().put("RoutingObjectForBucketid:" + bucketid, InitImageBB.getBB().getSharedMap().get(key));
                ParRegBB.getBB().getSharedMap().put("RoutingObjectKeyBucketid:" + bucketid, key);
                Log.getLogWriter().info("BB value set to " + InitImageBB.getBB().getSharedMap().get(key).toString());
                continue;
            }
            Log.getLogWriter().info("Checking the value for the routing object ");
            String blackBoardRoutingObject = ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid).toString();
            String keyRoutingObject = InitImageBB.getBB().getSharedMap().get(key).toString();
            if (!keyRoutingObject.equalsIgnoreCase(blackBoardRoutingObject)) {
                throw new TestException("Expected same routing objects for the entries in this bucket id " + bucketid + "but got different values " + blackBoardRoutingObject + " and " + keyRoutingObject);
            }
            Log.getLogWriter().info("Got the expected values " + blackBoardRoutingObject + " and " + keyRoutingObject + " for the keys " + ParRegBB.getBB().getSharedMap().get("RoutingObjectKeyBucketid:" + bucketid) + " and " + key);
        }
    }

    protected void verifyUniqueBucketForCustomPartioning(int bucketId) {
        if (bucketId == 0) {
            Log.getLogWriter().info("This is the first bucket, so no validation required as there is no bucket to be compared");
            return;
        }
        for (int i = 0; i < bucketId; ++i) {
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i) == null) continue;
            String referenceValue = ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i).toString();
            String currentValue = ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketId).toString();
            Log.getLogWriter().info("currentValue: " + currentValue);
            Log.getLogWriter().info("referenceValue: " + referenceValue);
            if (currentValue.equalsIgnoreCase(referenceValue)) {
                throw new TestException("Two buckets with the id " + i + " and " + bucketId + " have the same routing Object " + referenceValue);
            }
            Log.getLogWriter().info("As expected the bucket with ids " + i + " and " + bucketId + " have the different routing Object " + currentValue + " and " + referenceValue);
        }
    }

    public static void HydraTask_verifyRegionContents() {
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                String regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                testInstance.verifyRegionContents(aRegion);
            }
        } else {
            for (int i = 0; i < regionDescriptNames.size(); ++i) {
                String regionDescriptName = (String)regionDescriptNames.get(i);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                testInstance.verifyRegionContents(aRegion);
            }
        }
    }

    public void verifyRegionContents(Region aRegion) {
        InitImageBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        StringBuffer sizeErrStr = new StringBuffer();
        StringBuffer errStr = new StringBuffer();
        long numKeys = aRegion.size();
        if ((long)this.totalNumKeys != numKeys) {
            String tmpStr = "Expected " + this.totalNumKeys + " keys, but there are " + numKeys;
            Log.getLogWriter().info(tmpStr);
            sizeErrStr.append(tmpStr + "\n");
        }
        Log.getLogWriter().info("In verifyRegionContents, region has " + numKeys + " keys");
        long lastLogTime = System.currentTimeMillis();
        int numKeysToCheck = this.keyIntervals.getNumKeys() + this.numNewKeys;
        Log.getLogWriter().info("In verifyRegionContents, iterating through " + numKeysToCheck + " key names");
        for (int i = 1; i <= numKeysToCheck; ++i) {
            block24: {
                String key = NameFactory.getObjectNameForCounter(i);
                try {
                    BaseValueHolder value;
                    if (i >= this.keyIntervals.getFirstKey(1000) && i <= this.keyIntervals.getLastKey(1000) || i >= this.keyIntervals.getFirstKey(1006) && i <= this.keyIntervals.getLastKey(1006)) {
                        this.checkContainsKey(aRegion, key, true, "key was untouched");
                        this.checkContainsValueForKey(aRegion, key, true, "key was untouched");
                        value = PdxTest.toValueHolder(aRegion.get((Object)key));
                        this.checkValue(key, value);
                    } else if (i >= this.keyIntervals.getFirstKey(1001) && i <= this.keyIntervals.getLastKey(1001)) {
                        this.checkContainsKey(aRegion, key, true, "key was invalidated");
                        this.checkContainsValueForKey(aRegion, key, false, "key was invalidated");
                    } else if (i >= this.keyIntervals.getFirstKey(1002) && i <= this.keyIntervals.getLastKey(1002)) {
                        this.checkContainsKey(aRegion, key, true, "key was locally invalidated");
                        this.checkContainsValueForKey(aRegion, key, true, "key was locally invalidated");
                        value = PdxTest.toValueHolder(aRegion.get((Object)key));
                        this.checkValue(key, value);
                    } else if (i >= this.keyIntervals.getFirstKey(1003) && i <= this.keyIntervals.getLastKey(1003)) {
                        this.checkContainsKey(aRegion, key, false, "key was destroyed");
                        this.checkContainsValueForKey(aRegion, key, false, "key was destroyed");
                    } else if (i >= this.keyIntervals.getFirstKey(1004) && i <= this.keyIntervals.getLastKey(1004)) {
                        this.checkContainsKey(aRegion, key, true, "key was locally destroyed");
                        this.checkContainsValueForKey(aRegion, key, true, "key was locally destroyed");
                        value = PdxTest.toValueHolder(aRegion.get((Object)key));
                        this.checkValue(key, value);
                    } else if (i >= this.keyIntervals.getFirstKey(1005) && i <= this.keyIntervals.getLastKey(1005)) {
                        this.checkContainsKey(aRegion, key, true, "key was updated");
                        this.checkContainsValueForKey(aRegion, key, true, "key was updated");
                        value = PdxTest.toValueHolder(aRegion.get((Object)key));
                        this.checkUpdatedValue(key, value);
                    } else if (i > this.keyIntervals.getNumKeys()) {
                        this.checkContainsKey(aRegion, key, true, "key was new");
                        this.checkContainsValueForKey(aRegion, key, true, "key was new");
                        value = PdxTest.toValueHolder(aRegion.get((Object)key));
                        this.checkValue(key, value);
                    }
                }
                catch (TestException e) {
                    Log.getLogWriter().info(TestHelper.getStackTrace(e));
                    Set failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.FAILED_TXOPS);
                    Set inDoubtOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
                    if (failedOps.contains(key) || inDoubtOps.contains(key)) break block24;
                    errStr.append(e.getMessage() + "\n");
                }
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Verified key " + i + " out of " + this.totalNumKeys);
            lastLogTime = System.currentTimeMillis();
        }
        Set failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.FAILED_TXOPS);
        StringBuffer error = new StringBuffer();
        if (failedOps.size() > 0) {
            if (errStr.length() > 0) {
                error.append("Test detected BUG 43428 (" + failedOps.size() + " failed transactions) with additional issues reported\n");
                error.append(sizeErrStr);
                error.append(errStr);
                throw new TestException(error.toString());
            }
            error.append("Test detected BUG 43428 (" + failedOps.size() + " failed transactions) with no additional issues reported\n");
            error.append(sizeErrStr);
            error.append(errStr);
            Log.getLogWriter().info("Inconsistencies are related to Transaction HA behavior (not currently supported): " + error.toString());
        } else if (ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS).size() > 0) {
            failedOps = ParRegBB.getBB().getFailedOps(ParRegBB.INDOUBT_TXOPS);
            if (errStr.length() > 0) {
                error.append("Test reported " + failedOps.size() + " TransactionInDoubtExceptions with additional issues reported\n");
                error.append(sizeErrStr);
                error.append(errStr);
                throw new TestException(error.toString());
            }
            error.append("Test reported " + failedOps.size() + " TransactionInDoubtExceptions with no additional issues reported\n");
            error.append(sizeErrStr);
            error.append(errStr);
            Log.getLogWriter().info("Inconsistencies are related to Transaction HA behavior (not currently supported): " + error.toString());
        } else if (errStr.length() > 0) {
            sizeErrStr.append(errStr);
            throw new TestException(sizeErrStr.toString());
        }
    }

    public static void HydraTask_verifyBucketCopies() {
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                String regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                testInstance.verifyBucketCopies(aRegion);
            }
        } else {
            for (int i = 0; i < regionDescriptNames.size(); ++i) {
                String regionDescriptName = (String)regionDescriptNames.get(i);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                testInstance.verifyBucketCopies(aRegion);
            }
        }
    }

    public void verifyBucketCopies(Region aRegion) {
        try {
            RegionAttributes attr = aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            int redundantCopies = 0;
            if (prAttr != null) {
                redundantCopies = prAttr.getRedundantCopies();
            }
            ParRegUtil.verifyBucketCopies(aRegion, redundantCopies);
        }
        catch (TestException e) {
            ParRegUtil.dumpAllDataStores(aRegion);
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_putKeySetInBB() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            boolean isKeySetInBB = testInstance.putKeySetInBB(aRegion);
            if (!isKeySetInBB) continue;
            return;
        }
    }

    public boolean putKeySetInBB(Region aRegion) {
        int totalNumOfBuckets = ((PartitionedRegion)aRegion).getTotalNumberOfBuckets();
        int totalDataStoreNodes = ((PartitionedRegion)aRegion).getAllNodes().size();
        ArrayList keyList = new ArrayList();
        Set keySet = ((PartitionedRegion)aRegion).keys();
        keyList.addAll(keySet);
        if (ParRegBB.getBB().getSharedMap().get(KEY_LIST) == null) {
            ParRegBB.getBB().getSharedMap().put(KEY_LIST, keyList);
            ParRegBB.getBB().getSharedMap().put(PR_TOTAL_BUCKETS, new Integer(totalNumOfBuckets));
            ParRegBB.getBB().getSharedMap().put(PR_TOTAL_DATASTORES, new Integer(totalDataStoreNodes));
            return true;
        }
        Log.getLogWriter().info("Key set already kept in BB");
        return true;
    }

    public static synchronized void HydraTask_incPR_TOTAL_DATASTORES() {
        SharedMap sMap = ParRegBB.getBB().getSharedMap();
        int totalDataStoreNodes = (Integer)sMap.get(PR_TOTAL_DATASTORES);
        sMap.put(PR_TOTAL_DATASTORES, new Integer(++totalDataStoreNodes));
    }

    public static void HydraTask_killVms() {
        MasterController.sleepForMs(5000);
        try {
            MasterController.sleepForMs(5000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static void HydraTask_waitForEventsReceival() {
        if (testInstance == null) {
            testInstance = new ParRegColocation();
        }
        testInstance.waitForEventsReceival();
    }

    public void waitForEventsReceival() {
        SilenceListener.waitForSilence(50L, 5000L);
    }

    public static void HydraTask_stopStartVms() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            testInstance.stopStartVms();
            long timeToStop = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
            if (timeToStop <= 0L) continue;
            throw new StopSchedulingTaskOnClientOrder("Ops have completed");
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected void stopStartVms() {
        int numRegions = CacheHelper.getCache().rootRegions().size();
        PRObserver.initialize();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        Log.getLogWriter().info("In stopStartVms, choosing " + numVMsToStop + " vm(s) to stop...");
        List vmList = this.getDataStoreVms();
        ArrayList targetVms = new ArrayList();
        ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 1; i <= numVMsToStop; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            targetVms.add(vmList.get(randInt));
            vmList.remove(randInt);
            stopModes.add(TestConfig.tab().stringAt(ParRegPrms.stopModes));
        }
        StopStartVMs.stopStartVMs(targetVms, stopModes);
        if (ConfigPrms.getHadoopConfig() != null) {
            ++numRegions;
        }
        PRObserver.waitForRebalRecov(targetVms, 1, numRegions, null, null, false);
        Log.getLogWriter().info("Done in ParRegColocation.stopStartVms()");
    }

    protected List getDataStoreVms() {
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        Map aMap = ParRegBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(DataStoreVmStr)) continue;
            aList.add(new ClientVmInfo((Integer)aMap.get(key), null, null));
        }
        return aList;
    }

    public static void HydraTask_verifyPRListenerInvocation() {
        testInstance.verifyPRListenerInvocation();
    }

    protected void verifyPRListenerInvocation() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            PartitionedRegion pr;
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            if (!(aRegion instanceof PartitionedRegion) || (pr = (PartitionedRegion)aRegion).getPartitionListeners() == null || pr.getPartitionListeners().length == 0) continue;
            Log.getLogWriter().info("Verifying the listener invocation for the region " + aRegion.getName() + " because the region has PR listener");
            this.verifyPRListenerInvocation(pr);
        }
    }

    protected void verifyPRListenerInvocation(PartitionedRegion aRegion) {
        UpdateBBPartitionListener listener = (UpdateBBPartitionListener)aRegion.getPartitionListeners()[1];
        ArrayList listenerInvocationIdsForNode = (ArrayList)listener.getBucketIdsList();
        ArrayList primaryBucketListForNode = (ArrayList)aRegion.getLocalPrimaryBucketsListTestOnly();
        if (listenerInvocationIdsForNode.size() != primaryBucketListForNode.size()) {
            throw new TestException("PRListener invocation for the region " + aRegion.getName() + " was for bucket ids " + listenerInvocationIdsForNode + " on this node " + " but primary buckets on this node are" + primaryBucketListForNode);
        }
        if (!listenerInvocationIdsForNode.containsAll(primaryBucketListForNode)) {
            throw new TestException("PRListener invocation for the region " + aRegion.getName() + " was for bucket ids " + listenerInvocationIdsForNode + " on this node " + " but primary buckets on this node are" + primaryBucketListForNode);
        }
    }

    public static void HydraTask_verifyPrimaryColocation() {
        testInstance.verifyPrimaryColocation();
    }

    protected void verifyPrimaryColocation() {
        if (isBridgeConfiguration && !isBridgeClient) {
            for (int j = 0; j < bridgeRegionDescriptNames.size(); ++j) {
                String regionDescriptName = (String)bridgeRegionDescriptNames.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)aRegion;
                    this.verifyPrimaryBucketCoLocation(pr);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify colocation");
            }
        } else {
            for (int i = 0; i < regionDescriptNames.size(); ++i) {
                String regionDescriptName = (String)regionDescriptNames.get(i);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = theCache.getRegion(regionName);
                if (aRegion instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)aRegion;
                    this.verifyPrimaryBucketCoLocation(pr);
                    continue;
                }
                Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify colocation");
            }
        }
    }

    static {
        regionDescriptNames = new ArrayList();
        bridgeRegionDescriptNames = new ArrayList();
        isBridgeConfiguration = false;
        isBridgeClient = true;
        isGatewaySenderConfiguration = false;
        operations = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        parRegUtilInstance = new ParRegUtil();
        DataStoreVmStr = "DataStoreVM_";
    }
}

