/*
 * Decompiled with CFR 0.152.
 */
package parReg.colocation;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import getInitialImage.InitImageBB;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import parReg.colocation.ParRegColocation;
import parReg.execute.ColocatingPartitionListener;
import util.PRObserver;
import util.StopStartVMs;
import util.TestException;
import util.TestHelperPrms;

public class ParRegListenerTest
extends ParRegColocation {
    ArrayList serverRegionDescriptions = new ArrayList();
    ArrayList clientRegionDescriptions = new ArrayList();
    Cache theCache;
    public static final int NUM_KEYS_TO_CREATE = 1000;
    private static ArrayList primaryBucketsInTheDataStore;
    private static String primaryBucketReferenceRegion;
    private static String bucketReferenceRegion;
    protected static ParRegListenerTest testInstance;

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ParRegListenerTest();
            testInstance.initializeServerRegions();
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new ParRegListenerTest();
            testInstance.initializeClientRegions();
        }
    }

    public static synchronized void HydraTask_registerInterest() {
        testInstance.registerInterest();
    }

    public static synchronized void HydraTask_loadRegions() {
        testInstance.loadRegions();
    }

    public static synchronized void HydraTask_logRegionsSize() {
        testInstance.logRegionsSize();
    }

    public static void HydraTask_verifyListenerInvocation() {
        testInstance.verifyListenerInvocation();
        InitImageBB.getBB().printSharedMap();
    }

    public static void HydraTask_verifyPrimaryCoLocation() {
        testInstance.verifyPrimaryBucketCoLocation();
    }

    public static void HydraTask_verifyEmptyRecreatedBuckets() {
        testInstance.verifyEmptyRecreatedBuckets();
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
    }

    public void verifyEmptyRecreatedBuckets() {
        PartitionedRegion aRegion;
        String regionName;
        String regionDescriptName;
        ArrayList regionList = this.serverRegionDescriptions.size() != 0 ? this.serverRegionDescriptions : this.clientRegionDescriptions;
        HashSet<Integer> recreatedBucketIdsSet = new HashSet();
        for (int i = 0; i < regionList.size(); ++i) {
            regionDescriptName = (String)regionList.get(i);
            regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            aRegion = (PartitionedRegion)this.theCache.getRegion(regionName);
            if (aRegion.getPartitionListeners() != null && aRegion.getPartitionListeners().length > 0) {
                ColocatingPartitionListener partitionListener = (ColocatingPartitionListener)aRegion.getPartitionListeners()[0];
                recreatedBucketIdsSet = partitionListener.getReCreatedBucketIds();
            }
            if (recreatedBucketIdsSet.size() > 0) break;
        }
        for (int j = 0; j < regionList.size(); ++j) {
            regionDescriptName = (String)regionList.get(j);
            regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            aRegion = (PartitionedRegion)this.theCache.getRegion(regionName);
            if (aRegion.getColocatedWith() != null || aRegion.getPartitionListeners() != null && aRegion.getPartitionListeners().length != 0) continue;
            Log.getLogWriter().info("Verifying empty recreated for the region " + aRegion.getName() + " because the region does not has PR listener");
            this.verifyEmptyRecreatedBuckets(aRegion, recreatedBucketIdsSet);
        }
    }

    public void verifyEmptyRecreatedBuckets(PartitionedRegion aRegion, Set<Integer> recreatedBucketIdsSet) {
        for (Integer bucketId : recreatedBucketIdsSet) {
            Set keySetOfBucket;
            try {
                keySetOfBucket = aRegion.getBucketKeys(bucketId.intValue());
            }
            catch (Exception e) {
                throw new TestException("Caught the exception during getBucketKeys ", e);
            }
            if (keySetOfBucket.size() == 0) continue;
            throw new TestException("Expected the bucket " + bucketId + " (which is recreated) to be empty but has the size of " + keySetOfBucket.size());
        }
    }

    public void verifyListenerInvocation() {
        ArrayList regionList = this.serverRegionDescriptions.size() != 0 ? this.serverRegionDescriptions : this.clientRegionDescriptions;
        for (int j = 0; j < regionList.size(); ++j) {
            String regionDescriptName = (String)regionList.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            PartitionedRegion aRegion = (PartitionedRegion)this.theCache.getRegion(regionName);
            if (aRegion.getPartitionListeners() == null) continue;
            Log.getLogWriter().info("Verifying the listener invocation for the region " + aRegion.getName() + " because the region has PR listener");
            this.verifyListenerInvocation(aRegion);
        }
    }

    public void verifyListenerInvocation(PartitionedRegion aRegion) {
        ArrayList primaryBucketList = (ArrayList)aRegion.getLocalPrimaryBucketsListTestOnly();
        InternalDistributedMember self = (InternalDistributedMember)this.theCache.getDistributedSystem().getDistributedMember();
        for (Object bucketId : primaryBucketList) {
            String listenerInvokedNode = (String)ParRegBB.getBB().getSharedMap().get("Bucket_" + (Integer)bucketId);
            if (self.getId().equals(listenerInvokedNode)) continue;
            throw new TestException("This node has the primary bucket " + bucketId + " but latest PR listener invocation happened on node " + listenerInvokedNode);
        }
    }

    public void verifyPrimaryBucketCoLocation() {
        ArrayList regionList = this.serverRegionDescriptions.size() != 0 ? this.serverRegionDescriptions : this.clientRegionDescriptions;
        for (int j = 0; j < regionList.size(); ++j) {
            String regionDescriptName = (String)regionList.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            PartitionedRegion aRegion = (PartitionedRegion)this.theCache.getRegion(regionName);
            Log.getLogWriter().info("Primary buckets here are for the region " + regionName + " is " + aRegion.getLocalPrimaryBucketsListTestOnly());
            ParRegListenerTest.verifyPrimaryBucketColocation(aRegion);
        }
    }

    protected static void verifyPrimaryBucketColocation(PartitionedRegion aRegion) {
        String regionName = aRegion.getName();
        ArrayList primaryBucketList = (ArrayList)aRegion.getLocalPrimaryBucketsListTestOnly();
        if (primaryBucketList == null) {
            if (aRegion.getLocalMaxMemory() == 0) {
                Log.getLogWriter().info("This is an accessor and no need to verify colocation");
                return;
            }
            throw new TestException("Bucket List returned null, but it is not an accessor");
        }
        Log.getLogWriter().info("Primary Buckets of " + aRegion.getName() + " " + primaryBucketList.toString());
        if (primaryBucketsInTheDataStore == null) {
            Log.getLogWriter().info(" Setting the reference primary buckets in the Data Store for this vm with the Partitioned Region " + aRegion.getName());
            primaryBucketsInTheDataStore = primaryBucketList;
            primaryBucketReferenceRegion = regionName;
        } else {
            Log.getLogWriter().info("Reference primary buckets in the Data Store for this vm already set and is " + primaryBucketsInTheDataStore);
            Log.getLogWriter().info(" Verifying for the region " + regionName + " which has the buckets on this node " + aRegion.getLocalBucketsListTestOnly());
            for (Integer currentPrimaryBucket : primaryBucketList) {
                if (primaryBucketsInTheDataStore.contains(currentPrimaryBucket)) {
                    Log.getLogWriter().info("Both the Regions " + primaryBucketReferenceRegion + " and " + regionName + " have the bucket " + currentPrimaryBucket + " in this node");
                    continue;
                }
                throw new TestException("Region " + regionName + " does not have its bucket " + currentPrimaryBucket + " colocated");
            }
            Log.getLogWriter().info("Looking for missed buckets");
            for (Integer referenceRegionBucket : primaryBucketsInTheDataStore) {
                if (primaryBucketList.contains(referenceRegionBucket)) {
                    Log.getLogWriter().info("Both the Regions " + primaryBucketReferenceRegion + " and " + regionName + " have the primary bucket " + referenceRegionBucket + " in this node");
                    continue;
                }
                throw new TestException("Region " + regionName + " does not have its primary bucket " + referenceRegionBucket + " colocated");
            }
        }
    }

    public void logRegionsSize() {
        ArrayList regionList = this.serverRegionDescriptions.size() != 0 ? this.serverRegionDescriptions : this.clientRegionDescriptions;
        for (int j = 0; j < regionList.size(); ++j) {
            String regionDescriptName = (String)regionList.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = this.theCache.getRegion(regionName);
            Log.getLogWriter().info("Region size for the region " + aRegion.getName() + " is " + aRegion.size());
        }
    }

    @Override
    public void loadRegions() {
        ArrayList regionList = this.serverRegionDescriptions.size() != 0 ? this.serverRegionDescriptions : this.clientRegionDescriptions;
        this.loadRegions(regionList);
    }

    public void loadRegions(List regionList) {
        long createdKeysCount = InitImageBB.getBB().getSharedCounters().read(InitImageBB.NEW_KEY_COMPLETED);
        while (createdKeysCount <= 1000L) {
            createdKeysCount = InitImageBB.getBB().getSharedCounters().incrementAndRead(InitImageBB.NEW_KEY_COMPLETED);
            Long key = new Long(createdKeysCount);
            for (int j = 0; j < regionList.size(); ++j) {
                String regionDescriptName = (String)regionList.get(j);
                String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
                Region aRegion = this.theCache.getRegion(regionName);
                RegionAttributes regionAttributes = aRegion.getAttributes();
                if (regionAttributes.getCacheLoader() != null) continue;
                Long value = new Long(createdKeysCount);
                aRegion.put((Object)key, (Object)value);
            }
        }
    }

    void registerInterest() {
        for (int j = 0; j < this.clientRegionDescriptions.size(); ++j) {
            String regionDescriptName = (String)this.clientRegionDescriptions.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = this.theCache.getRegion(regionName);
            ParRegUtil.registerInterest(aRegion);
            Log.getLogWriter().info("registered interest for the region " + regionName);
        }
    }

    void initializeClientRegions() {
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (Object regionName : regionNames) {
            String thisRegionName = (String)regionName;
            if (!thisRegionName.startsWith("client")) continue;
            this.clientRegionDescriptions.add(thisRegionName);
        }
        this.theCache = CacheHelper.createCache("cache1");
        PoolHelper.createPool("edgeDescript");
        this.createRegions(this.clientRegionDescriptions);
    }

    void initializeServerRegions() {
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (Object regionName : regionNames) {
            String thisRegionName = (String)regionName;
            if (!thisRegionName.startsWith("bridge")) continue;
            this.serverRegionDescriptions.add(thisRegionName);
        }
        this.theCache = CacheHelper.createCache("cache1");
        this.createRegions(this.serverRegionDescriptions);
    }

    void createRegions(List regionDescriptionsList) {
        for (int j = 0; j < regionDescriptionsList.size(); ++j) {
            String regionDescriptName = (String)regionDescriptionsList.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
            Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
        }
    }

    public static void HydraTask_stopStartVms() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            testInstance.stopStartVms();
            long timeToStop = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
            if (timeToStop <= 0L) continue;
            throw new StopSchedulingTaskOnClientOrder("Ops have completed");
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    @Override
    protected void stopStartVms() {
        int numRegions = CacheHelper.getCache().rootRegions().size();
        PRObserver.initialize();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        Log.getLogWriter().info("In stopStartVms, choosing " + numVMsToStop + " vm(s) to stop...");
        List vmList = this.getDataStoreVms();
        ArrayList targetVms = new ArrayList();
        ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 1; i <= numVMsToStop; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            targetVms.add(vmList.get(randInt));
            vmList.remove(randInt);
            stopModes.add(TestConfig.tab().stringAt(ParRegPrms.stopModes));
        }
        StopStartVMs.stopStartVMs(targetVms, stopModes);
        PRObserver.waitForRebalRecov(targetVms, 1, numRegions - 1, null, null, false);
        Log.getLogWriter().info("Done in stopStartVms()");
    }
}

