/*
 * Decompiled with CFR 0.152.
 */
package parReg.eviction;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.CacheHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import parReg.eviction.EvictionPrms;
import util.TestException;

public class EvictionBehaviorTest {
    protected static EvictionBehaviorTest testInstance;
    protected static Cache theCache;
    protected static PartitionedRegion aRegion;
    public static final int MAX_KEYS_TO_BE_POPULATED;
    public static final int ENTRY_SIZE_IN_BYTES = 0x140000;
    public static final int START_OF_LAST_BUCKETS_ID = 101;
    protected static int totalEvictedEntries;
    protected static int evictionThresholdKeys;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new EvictionBehaviorTest();
            testInstance.initialize("clientRegion");
        }
    }

    public static synchronized void HydraTask_populateSequentiallyAndEvenly() {
        testInstance.populateSequentiallyAndEvenly();
    }

    public static synchronized void HydraTask_populateSequentiallyAndIncrementally() {
        testInstance.populateSequentiallyAndIncrementally();
    }

    public static synchronized void HydraTask_logRegionSize() {
        testInstance.logRegionSize();
    }

    public static void HydraTask_printBucketAndDiskEntries() {
        testInstance.printBucketAndDiskEntries();
    }

    public static void HydraTask_verifyUniformBucketEviction() {
        testInstance.verifyUniformBucketEviction();
    }

    public static void HydraTask_verifyIncrementalEviction() {
        testInstance.verifyIncrementalEviction();
    }

    protected void logRegionSize() {
        Log.getLogWriter().info("Region has expected size " + aRegion.size());
    }

    protected void initialize(String regionDescriptName) {
        theCache = CacheHelper.createCache("cache1");
        String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
        Log.getLogWriter().info("Creating region " + regionName);
        RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
        aRegion = (PartitionedRegion)theCache.createRegion(regionName, attributes);
        Log.getLogWriter().info("Completed creating region " + aRegion.getName());
    }

    protected void populateSequentiallyAndEvenly() {
        int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
        int numEntriesPerBucket = MAX_KEYS_TO_BE_POPULATED / totalNumBuckets;
        for (int bucketId = 0; bucketId < totalNumBuckets; ++bucketId) {
            this.populateSpecificBucketSpecificSize(bucketId, numEntriesPerBucket);
        }
    }

    protected void populateSequentiallyAndIncrementally() {
        int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
        for (int bucketId = 0; bucketId < totalNumBuckets; ++bucketId) {
            this.populateSpecificBucketSpecificSize(bucketId, bucketId + 10);
        }
    }

    protected void populateSpecificBucketSpecificSize(int bucketId, int maxEntriesPerBucket) {
        try {
            Log.getLogWriter().info("Populating the bucketId " + bucketId + " of PR " + aRegion.getName() + " with " + maxEntriesPerBucket + "entries");
            int initialNumOfEntriesBeforePopulatingBucket = aRegion.getBucketKeys(bucketId).size();
            int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
            int entryKey = bucketId;
            for (int numEntriesPerBucket = 0; numEntriesPerBucket < maxEntriesPerBucket; ++numEntriesPerBucket) {
                if (aRegion.size() > evictionThresholdKeys && TestConfig.tab().booleanAt(EvictionPrms.pauseAfterEvictionThreshold, false)) {
                    MasterController.sleepForMs(60000);
                }
                aRegion.put((Object)entryKey, (Object)new byte[0x140000]);
                entryKey += totalNumBuckets;
            }
            int initialNumOfEntriesAfterPopulatingBucket = aRegion.getBucketKeys(bucketId).size();
            if (initialNumOfEntriesAfterPopulatingBucket != maxEntriesPerBucket && aRegion.getAttributes().getEvictionAttributes().getAction() == EvictionAction.OVERFLOW_TO_DISK) {
                throw new TestException("Test issue: bucket supposed to be " + maxEntriesPerBucket + " after population");
            }
            Log.getLogWriter().info("For bucketId " + bucketId + " numEntriesbefore populating " + initialNumOfEntriesBeforePopulatingBucket + " and after is " + initialNumOfEntriesAfterPopulatingBucket);
        }
        catch (Exception e) {
            throw new TestException("Caught exception during population ", e);
        }
    }

    protected void printBucketAndDiskEntries() {
        MasterController.sleepForMs(20000);
        int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
        int numEntriesPerBucket = MAX_KEYS_TO_BE_POPULATED / totalNumBuckets;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        for (Map.Entry entry : bucketList) {
            BucketRegion bucket = (BucketRegion)entry.getValue();
            int bucketId = bucket.getId();
            long numEvictionsForBucket = bucket.getEvictions();
            totalEvictedEntries = (int)((long)totalEvictedEntries + numEvictionsForBucket);
            if (aRegion.getAttributes().getEvictionAttributes().getAction() == EvictionAction.OVERFLOW_TO_DISK) {
                Log.getLogWriter().info(" For the bucket region with id " + bucketId + " entries left in vm is " + bucket.getNumEntriesInVM() + " and entries evicted " + bucket.getNumOverflowOnDisk());
                continue;
            }
            Log.getLogWriter().info(" For the bucket region with id " + bucketId + " entries left in vm is " + bucket.entryCount() + " and entries evicted " + bucket.getEvictions());
        }
        Log.getLogWriter().info("The tenuredHeasUsage is : " + ((InternalResourceManager)theCache.getResourceManager()).getHeapMonitor().getBytesUsed() / 0x100000L);
        Log.getLogWriter().info("Total evicted entries = " + totalEvictedEntries);
    }

    protected void verifyUniformBucketEviction() {
        int regionSize = aRegion.size();
        int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
        float averageEvictionPercentage = (float)totalEvictedEntries * 100.0f / (float)regionSize;
        int numDeviatedBuckets = 0;
        int PERCENT_TOLERANCE = 60;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Iterator iterator = bucketList.iterator();
        StringBuffer errorString = new StringBuffer();
        while (iterator.hasNext()) {
            long bucketSize;
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketRegion bucket = (BucketRegion)entry.getValue();
            int bucketId = bucket.getId();
            long numEvictionsForBucket = bucket.getEvictions();
            try {
                bucketSize = bucket.getNumEntriesInVM() + bucket.getNumOverflowOnDisk();
            }
            catch (Exception e) {
                throw new TestException("Caught ", e);
            }
            float bucketEvictionPercentage = (float)numEvictionsForBucket * 100.0f / (float)bucketSize;
            if (bucketEvictionPercentage > averageEvictionPercentage + 60.0f || bucketEvictionPercentage < averageEvictionPercentage - 60.0f) {
                errorString.append(" For the bucket region with id " + bucketId + " numEvicted is " + numEvictionsForBucket + " but average eviction is " + totalEvictedEntries / totalNumBuckets + " (Test considers " + 60 + " % tolerance.) \n");
                if (!((double)(++numDeviatedBuckets) > (double)totalNumBuckets * 0.4)) continue;
                throw new TestException(errorString);
            }
            String s = " For the bucket region with id " + bucketId + " numEvicted is " + numEvictionsForBucket + " but average eviction is " + totalEvictedEntries / totalNumBuckets;
            Log.getLogWriter().info(s);
        }
    }

    protected void verifyIncrementalEviction() {
        int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
        int numDeviatedBuckets = 0;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Comparator<Map.Entry<Integer, BucketRegion>> comparator = new Comparator<Map.Entry<Integer, BucketRegion>>(){

            @Override
            public int compare(Map.Entry<Integer, BucketRegion> o1, Map.Entry<Integer, BucketRegion> o2) {
                if (o1.getKey() < o2.getKey()) {
                    return -1;
                }
                if (o1.getKey() > o2.getKey()) {
                    return 1;
                }
                return 0;
            }
        };
        TreeSet<Map.Entry<Integer, BucketRegion>> sortedBucketSet = new TreeSet<Map.Entry<Integer, BucketRegion>>(comparator);
        sortedBucketSet.addAll(bucketList);
        Iterator<Map.Entry<Integer, BucketRegion>> iterator = sortedBucketSet.iterator();
        StringBuffer errorString = new StringBuffer();
        int previousBucketId = -1;
        long previousBucketEviction = 0L;
        long previousBucketSize = 0L;
        while (iterator.hasNext()) {
            long bucketSize;
            Map.Entry<Integer, BucketRegion> entry = iterator.next();
            BucketRegion bucket = entry.getValue();
            int bucketId = bucket.getId();
            long numEvictionsForBucket = bucket.getEvictions();
            try {
                bucketSize = bucket.getNumEntriesInVM() + bucket.getNumOverflowOnDisk();
            }
            catch (Exception e) {
                throw new TestException("Caught ", e);
            }
            float bucketEvictionPercentage = (float)numEvictionsForBucket * 100.0f / (float)bucketSize;
            if (bucketEvictionPercentage == 100.0f) {
                throw new TestException("For the bucket region with id " + bucketId + " bucket evicted all entries");
            }
            if (numEvictionsForBucket < previousBucketEviction && bucketSize > previousBucketSize) {
                errorString.append("For the bucket region with id " + bucketId + " with size " + bucketSize + " numEvicted is " + numEvictionsForBucket + " but leaner bucket with id " + previousBucketId + " with bucket size " + previousBucketSize + " evicted more entries " + previousBucketEviction + "\n");
                ++numDeviatedBuckets;
                if ((double)numDeviatedBuckets > (double)totalNumBuckets * 0.1) {
                    throw new TestException(errorString);
                }
                Log.getLogWriter().info("For the bucket region with id " + bucketId + " with size " + bucketSize + " numEvicted is " + numEvictionsForBucket + " but leaner bucket with id " + previousBucketId + " with bucket size " + previousBucketSize + " evicted more entries " + previousBucketEviction);
            } else {
                String s = "For the bucket region with id " + bucketId + " with size " + bucketSize + " numEvicted is " + numEvictionsForBucket + " and leaner bucket with id " + previousBucketId + " with bucket size " + previousBucketSize + " evicted lesser entries " + previousBucketEviction;
                Log.getLogWriter().info(s);
            }
            previousBucketId = bucketId;
            previousBucketEviction = numEvictionsForBucket;
            previousBucketSize = bucketSize;
        }
    }

    static {
        MAX_KEYS_TO_BE_POPULATED = (int)TestConfig.tab().longAt(EvictionPrms.maxEntries, 2712L);
        totalEvictedEntries = 0;
        evictionThresholdKeys = -1228;
    }
}

