/*
 * Decompiled with CFR 0.152.
 */
package parReg.eviction;

import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import hydra.Log;
import hydra.RemoteTestModule;
import parReg.eviction.EvictionBB;
import util.TestException;

public class EvictionThresholdListener
implements ResourceListener<MemoryEvent> {
    private static int normalCalls = 0;
    private static int criticalThresholdCalls = 0;
    private static int evictionThresholdCalls = 0;
    private static int disabledCalls = 0;
    private static int allCalls = 0;
    private static long bytesFromThreshold = 0L;
    private static float currentPercentage = 0.0f;
    public static final float UPPER_LIMIT_EVICTION_TOLERANCE = System.getProperty("java.vm.vendor").startsWith("IBM") ? 25.0f : 25.0f;
    public static final float LOWER_LIMIT_EVICTION_TOLERANCE = System.getProperty("java.vm.vendor").startsWith("IBM") ? 25.0f : 2.0f;
    public static final String CRITICAL_HEAP_PERCENTAGE = "Critical Heap Percentage";
    public static final String EVICTION_HEAP_PERCENTAGE = "Eviction Heap Percentage";
    public static final String CRITICAL_OFF_HEAP_PERCENTAGE = "Critical Off-Heap Percentage";
    public static final String EVICTION_OFF_HEAP_PERCENTAGE = "Eviction Off-Heap Percentage";
    public static final String EVICTION_EVENT = "Eviction";
    public static final String NORMAL_EVENT = "Normal";
    public static final String NO_EVENT_RECEIVED = "No Event Received";
    private static String lastEventReceived = "No Event Received";

    public EvictionThresholdListener() {
        Log.getLogWriter().info("Creating instance of EvictionThresholdListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getBytesFromThreshold() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return bytesFromThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getCurrentPercentage() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentPercentage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAllCalls() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return allCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNormalCalls() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return normalCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCriticalThresholdCalls() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return criticalThresholdCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEvictionThresholdCalls() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return evictionThresholdCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDisabledCalls() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return disabledCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetThresholdCalls() {
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            normalCalls = 0;
            criticalThresholdCalls = 0;
            evictionThresholdCalls = 0;
            disabledCalls = 0;
            allCalls = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String asString() {
        return "TestListenerStatus:" + (" normalCalls :" + normalCalls) + (" criticalThresholdCalls :" + criticalThresholdCalls) + (" evictionThresholdCalls :" + evictionThresholdCalls) + (" disabledCalls :" + disabledCalls) + (" allCalls :" + allCalls);
    }

    private int convertToIntPercent(double percent) {
        assert (percent >= 0.0 && percent <= 1.0);
        int ret = (int)Math.ceil(percent * 100.0);
        assert (ret >= 0 && ret <= 100);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(MemoryEvent event) {
        Log.getLogWriter().info("In EvictionThresholdListener.onEvent with " + event);
        EvictionBB.getBB().printSharedMap();
        Class<EvictionThresholdListener> clazz = EvictionThresholdListener.class;
        synchronized (EvictionThresholdListener.class) {
            if (event.isLocal()) {
                bytesFromThreshold = event.getState().isCritical() ? event.getBytesUsed() - event.getThresholds().getCriticalThresholdBytes() : (event.getState().isEviction() ? (event.getPreviousState().isCritical() ? event.getThresholds().getCriticalThresholdBytes() - event.getBytesUsed() : event.getBytesUsed() - event.getThresholds().getEvictionThresholdBytes()) : event.getThresholds().getEvictionThresholdBytes() - event.getBytesUsed());
                currentPercentage = event.getThresholds().getMaxMemoryBytes() == 0L ? 0.0f : (event.getBytesUsed() > event.getThresholds().getMaxMemoryBytes() ? 1.0f : (float)this.convertToIntPercent((double)event.getBytesUsed() / (double)event.getThresholds().getMaxMemoryBytes()));
                if (event.getState().isNormal()) {
                    this.verifyNormalEvent(event);
                    lastEventReceived = NORMAL_EVENT;
                    Log.getLogWriter().info("Received normal event number " + ++normalCalls + " bytes used " + event.getBytesUsed());
                }
                if (event.getState().isCritical() && event.getState() != event.getPreviousState()) {
                    ++criticalThresholdCalls;
                }
                if (event.getState().isEviction() && event.getState() != event.getPreviousState()) {
                    this.verifyEvictionEvent(event);
                    lastEventReceived = EVICTION_EVENT;
                    Log.getLogWriter().info("Received eviction event number " + ++evictionThresholdCalls + " bytes used " + event.getBytesUsed());
                }
                if (event.getState() == MemoryThresholds.MemoryState.DISABLED) {
                    ++disabledCalls;
                }
                ++allCalls;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void verifyEvictionEvent(MemoryEvent event) {
        String errorString;
        float evictionPercentage = 0.0f;
        float criticalPercentage = 0.0f;
        if (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY) {
            evictionPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(EVICTION_HEAP_PERCENTAGE)).floatValue();
            criticalPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(CRITICAL_HEAP_PERCENTAGE)).floatValue();
        } else if (event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY) {
            evictionPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(EVICTION_OFF_HEAP_PERCENTAGE)).floatValue();
            criticalPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(CRITICAL_OFF_HEAP_PERCENTAGE)).floatValue();
        } else {
            throw new TestException("Test cannot handle type " + event.getType());
        }
        if (currentPercentage > criticalPercentage) {
            String errorString2 = "For the Vm " + RemoteTestModule.getMyVmid() + " :Eviction event raised when the currentPercentage " + currentPercentage + " is greater than critical percentage " + criticalPercentage;
            Log.getLogWriter().info(errorString2);
            this.throwException(errorString2);
        }
        float upperLimitTolerance = evictionPercentage + UPPER_LIMIT_EVICTION_TOLERANCE;
        float lowerLimitTolerance = evictionPercentage - LOWER_LIMIT_EVICTION_TOLERANCE;
        if (currentPercentage > upperLimitTolerance) {
            errorString = "For the Vm " + RemoteTestModule.getMyVmid() + " :Eviction up event raised too late - the currentPercentage " + currentPercentage + " eviction percentage " + evictionPercentage + " (test considered tolerence up to " + upperLimitTolerance + "%)";
            Log.getLogWriter().info(errorString);
            this.throwException(errorString);
        }
        if (currentPercentage < lowerLimitTolerance) {
            errorString = "For the Vm " + RemoteTestModule.getMyVmid() + " :Eviction up event raised too early - the currentPercentage " + currentPercentage + " eviction percentage " + evictionPercentage + " (test considered tolerence up to " + lowerLimitTolerance + "%)";
            Log.getLogWriter().info(errorString);
            this.throwException(errorString);
        }
        if (lastEventReceived != NORMAL_EVENT && lastEventReceived != NO_EVENT_RECEIVED && lastEventReceived != EVICTION_EVENT) {
            errorString = "For the Vm " + RemoteTestModule.getMyVmid() + " event preceding eviction up event is " + event.toString();
            Log.getLogWriter().info(errorString);
            this.throwException(errorString);
        }
    }

    private void verifyNormalEvent(MemoryEvent event) {
        String errorString;
        float evictionPercentage = 0.0f;
        float criticalPercentage = 0.0f;
        if (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY) {
            evictionPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(EVICTION_HEAP_PERCENTAGE)).floatValue();
            criticalPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(CRITICAL_HEAP_PERCENTAGE)).floatValue();
        } else if (event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY) {
            evictionPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(EVICTION_OFF_HEAP_PERCENTAGE)).floatValue();
            criticalPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(CRITICAL_OFF_HEAP_PERCENTAGE)).floatValue();
        } else {
            throw new TestException("Test cannot handle type " + event.getType());
        }
        if (criticalPercentage != 0.0f && currentPercentage > criticalPercentage) {
            String errorString2 = "For the Vm " + RemoteTestModule.getMyVmid() + " :Normal event raised when the currentPercentage " + currentPercentage + " is greater than critical percentage " + criticalPercentage;
            Log.getLogWriter().info(errorString2);
            this.throwException(errorString2);
        }
        float upperLimitTolerance = evictionPercentage - UPPER_LIMIT_EVICTION_TOLERANCE;
        float lowerLimitTolerance = evictionPercentage + LOWER_LIMIT_EVICTION_TOLERANCE;
        if (evictionPercentage != 0.0f) {
            if (currentPercentage < upperLimitTolerance) {
                errorString = "For the Vm " + RemoteTestModule.getMyVmid() + " :Eviction down event raised too late - the currentPercentage " + currentPercentage + " eviction percentage " + evictionPercentage + " (test considered tolerence up to " + upperLimitTolerance + "%)";
                Log.getLogWriter().info(errorString);
                this.throwException(errorString);
            }
            if (currentPercentage > lowerLimitTolerance) {
                errorString = "Eviction down event raised too early - the currentPercentage " + currentPercentage + " eviction percentage " + evictionPercentage + " (test considered tolerence up to " + lowerLimitTolerance + "%)";
                Log.getLogWriter().info(errorString);
                this.throwException(errorString);
            }
        }
        if (lastEventReceived != EVICTION_EVENT) {
            errorString = "For the Vm " + RemoteTestModule.getMyVmid() + " event preceding eviction down event is " + event.toString();
            Log.getLogWriter().info(errorString);
            this.throwException(errorString);
        }
    }

    public void throwException(String reason) {
        Log.getLogWriter().info("Adding exception :" + reason);
        long exceptionNumber = EvictionBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.NUM_EXCEPTION);
        EvictionBB.getBB().getSharedMap().put(new Long(exceptionNumber), reason);
        EvictionBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.NUM_COMPLETED_EXCEPTION_LOGGING);
    }
}

