/*
 * Decompiled with CFR 0.152.
 */
package parReg.eviction;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import hydra.CacheHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import parReg.ParRegBB;
import parReg.eviction.EvictionBB;
import parReg.eviction.EvictionPrms;
import parReg.eviction.EvictionThresholdListener;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class ParRegHeapEvictionTest {
    protected static ParRegHeapEvictionTest testInstance;
    protected static List regionDescriptNames;
    protected static Cache theCache;
    protected RandomValues randomValues = null;
    protected static InternalResourceManager irm;
    protected static EvictionThresholdListener listener;
    protected int numThreadsInClients;
    public static final int KEYS_TO_PUT = 500;
    protected static final int HEAVY_OBJECT_SIZE_VAL = 500;
    public static final String CRITICAL_HEAP_PERCENTAGE = "Critical Heap Percentage";
    public static final String EVICTION_HEAP_PERCENTAGE = "Eviction Heap Percentage";
    public static final String CRITICAL_OFF_HEAP_PERCENTAGE = "Critical Off-Heap Percentage";
    public static final String EVICTION_OFF_HEAP_PERCENTAGE = "Eviction Off-Heap Percentage";
    public static final float LOWER_HEAP_LIMIT_PERCENT = 30.0f;
    public static final float UPPER_HEAP_LIMIT_PERCENT = 25.0f;
    protected static long totalNumOverFlowToDisk;
    protected static long totalEntriesInDisk;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.initialize();
    }

    public static synchronized void HydraTask_createRegions() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.createRegions();
    }

    public static synchronized void HydraTask_updateBB() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.updateBB();
    }

    public static synchronized void HydraTask_populateRegions() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.populateRegions();
    }

    public static synchronized void HydraTask_populateUniformHeavyEntries() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.populateUniformHeavyEntries();
    }

    public static synchronized void HydraTask_doQuery() {
        testInstance.doQuery();
    }

    public static synchronized void HydraTask_populateMaxEntries() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.populateMaxEntries();
    }

    public static synchronized void HydraTask_populateAndVerify() {
        testInstance.populateAndVerify();
    }

    public static synchronized void HydraTask_verifyEvictionBehavior() {
        if (testInstance == null) {
            testInstance = new ParRegHeapEvictionTest();
        }
        testInstance.verifyEvictionBehavior();
    }

    public static void HydraTask_verifyRegionFairness() {
        testInstance.verifyRegionFairness();
    }

    public static void HydraTask_verifyEviction() {
        testInstance.verifyEviction();
    }

    public static void HydraTask_verifyNoEviction() {
        testInstance.verifyNoEviction();
    }

    protected void initialize() {
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        if (regionDescriptNames.size() == 0) {
            for (int i = 0; i < regionNames.size(); ++i) {
                String regionDescriptName = (String)regionNames.get(i);
                regionDescriptNames.add(regionDescriptName);
            }
            Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
            theCache = CacheHelper.createCache("cache1");
            this.randomValues = new RandomValues();
            irm = (InternalResourceManager)theCache.getResourceManager();
            Log.getLogWriter().info("Registering Listener");
            listener = new EvictionThresholdListener();
            irm.addResourceListener(InternalResourceManager.ResourceType.MEMORY, (ResourceListener)listener);
        }
    }

    protected void createRegions() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            RegionHelper.createRegion(regionDescriptName);
        }
    }

    protected void updateBB() {
        if (irm == null) {
            throw new TestException("ResourceManager is null");
        }
        float criticalHeapPercentage = irm.getCriticalHeapPercentage();
        float evictionHeapPercentage = irm.getEvictionHeapPercentage();
        EvictionBB.getBB().getSharedMap().put(CRITICAL_HEAP_PERCENTAGE, Float.valueOf(criticalHeapPercentage));
        EvictionBB.getBB().getSharedMap().put(EVICTION_HEAP_PERCENTAGE, Float.valueOf(evictionHeapPercentage));
        float criticalOffHeapPercentage = irm.getCriticalOffHeapPercentage();
        float evictionOffHeapPercentage = irm.getEvictionOffHeapPercentage();
        EvictionBB.getBB().getSharedMap().put(CRITICAL_OFF_HEAP_PERCENTAGE, Float.valueOf(criticalOffHeapPercentage));
        EvictionBB.getBB().getSharedMap().put(EVICTION_OFF_HEAP_PERCENTAGE, Float.valueOf(evictionOffHeapPercentage));
        EvictionBB.getBB().printSharedMap();
    }

    protected void populateAndVerify() {
        ParRegHeapEvictionTest.logExecutionNumber();
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        long roundPosition = ParRegBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.RoundPosition);
        Log.getLogWriter().info("In populateAndVerify, roundPosition is " + roundPosition);
        if (roundPosition == (long)this.numThreadsInClients) {
            Log.getLogWriter().info("In populateAndVerify, last in round");
            this.verifyEvictionBehavior();
            EvictionBB.getBB().getSharedCounters().zero(EvictionBB.RoundPosition);
            roundPosition = EvictionBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.RoundPosition);
        }
        if (roundPosition == 1L) {
            long roundNumber = EvictionBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.RoundNumber);
            Log.getLogWriter().info("In populateAndVerify, first in round, round number " + roundNumber);
            this.populateRegions();
        } else if (roundPosition != (long)this.numThreadsInClients) {
            Log.getLogWriter().info("In populateAndVerify, neither first nor last");
            this.verifyEvictionBehavior();
        }
    }

    protected void populateUniformHeavyEntries() {
        Integer keyObject = new Integer((int)ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations));
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            this.populateUniformHeavyEntries(aRegion, keyObject);
        }
    }

    protected void populateUniformHeavyEntries(Region aRegion, Object key) {
        byte[] newVal = new byte[250000];
        aRegion.put(key, (Object)newVal);
    }

    protected void populateRegions() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            this.populateRegion(aRegion);
        }
    }

    protected void populateRegion(Region aRegion) {
        for (int i = 0; i < 500; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            ValueHolder value = new ValueHolder(key, this.randomValues);
            aRegion.put((Object)key, (Object)value);
        }
    }

    protected void populateMaxEntries() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            this.populateMaxEntries(aRegion);
        }
    }

    protected void populateMaxEntries(Region aRegion) {
        long maxEntries = TestConfig.tab().longAt(EvictionPrms.maxEntries);
        int numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long putCountInTheRegion = maxEntries / (long)(regionDescriptNames.size() * numThreadsInClients);
        Log.getLogWriter().info("Entries to be put " + putCountInTheRegion + " maxEntries " + maxEntries + " numThreadsInClients " + numThreadsInClients + " regionDescriptNames.size() " + regionDescriptNames.size());
        for (long i = 0L; i < putCountInTheRegion; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            aRegion.put((Object)key, (Object)new byte[0x100000]);
        }
        Log.getLogWriter().info("Completed populating region " + aRegion.getName() + " have " + aRegion.size() + " keys");
    }

    protected void doQuery() {
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            this.doQuery(aRegion);
        }
    }

    protected void doQuery(Region aRegion) {
        String queryString = "select distinct * from " + aRegion.getFullPath();
        Query query = theCache.getQueryService().newQuery(queryString);
        try {
            Object result = query.execute();
            if (result instanceof Collection) {
                Log.getLogWriter().info("Size of result is :" + ((Collection)result).size());
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
        }
    }

    protected void verifyEvictionBehavior() {
        if (TestConfig.tab().booleanAt(EvictionPrms.verifyEvictionEvents, true)) {
            this.checkBlackBoardForException();
        }
        if (TestConfig.tab().booleanAt(EvictionPrms.verifyHeapUsage, true)) {
            this.verifyHeapUsage();
        }
    }

    public void checkBlackBoardForException() {
        Log.getLogWriter().info("Checking BB for exceptions");
        long exceptionCount = EvictionBB.getBB().getSharedCounters().read(EvictionBB.NUM_EXCEPTION);
        long exceptionLoggingComplete = EvictionBB.getBB().getSharedCounters().read(EvictionBB.NUM_COMPLETED_EXCEPTION_LOGGING);
        SharedMap sharedmap = EvictionBB.getBB().getSharedMap();
        EvictionBB.getBB().printSharedMap();
        if (exceptionCount > 5L && (exceptionLoggingComplete > 0L || sharedmap.get(new Long(1L)) != null)) {
            StringBuffer reason = new StringBuffer();
            reason.append("total exceptions = " + exceptionCount);
            reason.append("\n");
            for (long i = 1L; i < exceptionCount + 1L; ++i) {
                reason.append("Reason for exception no. " + i + " : ");
                reason.append(sharedmap.get(new Long(i)));
                reason.append("\n");
            }
            throw new TestException(reason.toString());
        }
    }

    public void verifyHeapUsage() {
        Log.getLogWriter().info("Checking Heap Usage");
        if (irm == null) {
            throw new TestException("Resource Manager is null");
        }
        if (listener.getEvictionThresholdCalls() > 0) {
            HeapMemoryMonitor hmm = ((InternalResourceManager)theCache.getResourceManager()).getHeapMonitor();
            long currentHeapUsage = hmm.getBytesUsed();
            double maxTenuredBytes = hmm.getTrackedMaxMemory();
            float currentHeapUsagePercentage = (float)((double)currentHeapUsage / maxTenuredBytes) * 100.0f;
            float evictionHeapPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(EVICTION_HEAP_PERCENTAGE)).floatValue();
            float criticalHeapPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(CRITICAL_HEAP_PERCENTAGE)).floatValue();
            float heapLowerBound = evictionHeapPercentage - 30.0f;
            float heapUpperBound = evictionHeapPercentage + 25.0f;
            if (currentHeapUsagePercentage < heapLowerBound) {
                throw new TestException("Possible over eviction : Current heap utilization percent " + currentHeapUsagePercentage + " and eviction heap percent " + evictionHeapPercentage);
            }
            if (currentHeapUsagePercentage > heapUpperBound) {
                throw new TestException("Possibility of eviction not catching up : Current heap utilization percent " + currentHeapUsagePercentage + " and eviction heap percent " + evictionHeapPercentage);
            }
            Log.getLogWriter().info("CurrentHeapUsagePercent " + currentHeapUsagePercentage + " in allowable limits");
        } else {
            Log.getLogWriter().info("No eviction trigerred so far; hence not required to verify eviction behavior");
        }
    }

    public void verifyEviction() {
        double totalHeapEvictions = ParRegHeapEvictionTest.getNumHeapLRUEvictions();
        if (totalHeapEvictions <= 0.0) {
            throw new TestException("Test needs tuning - no eviction reported");
        }
        Log.getLogWriter().info("Total eviction " + totalHeapEvictions);
    }

    public void verifyNoEviction() {
        double totalHeapEvictions = ParRegHeapEvictionTest.getNumHeapLRUEvictions();
        if (totalHeapEvictions > 0.0) {
            throw new TestException("Test needs tuning, the test should not have evicted during inittask, but evicted " + totalHeapEvictions);
        }
    }

    public static double getNumHeapLRUEvictions() {
        String spec = "* HeapLRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    protected static void logExecutionNumber() {
        long exeNum = EvictionBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    public synchronized void verifyRegionFairness() {
        long totalNumEntriesInDisk = 0L;
        long totalNumEntriesInVm = 0L;
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            totalNumEntriesInDisk += pr.getDiskRegionStats().getNumOverflowOnDisk();
            totalNumEntriesInVm += pr.getDiskRegionStats().getNumEntriesInVM();
        }
        long averageEvictionPerRegion = totalNumEntriesInDisk / (long)regionDescriptNames.size();
        Log.getLogWriter().info("totalNumEntriesInDisk " + totalNumEntriesInDisk);
        Log.getLogWriter().info("totalNumEntriesInVm " + totalNumEntriesInVm);
        Log.getLogWriter().info("AverageEvictionPerRegion = " + (int)averageEvictionPerRegion);
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            String regionDescriptName = (String)regionDescriptNames.get(i);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region aRegion = theCache.getRegion(regionName);
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            long numEntriesInDisk = pr.getDiskRegionStats().getNumOverflowOnDisk();
            long entriesInVm = pr.getDiskRegionStats().getNumEntriesInVM();
            if ((double)numEntriesInDisk > (double)averageEvictionPerRegion * 1.25 || (double)numEntriesInDisk < (double)averageEvictionPerRegion * 0.75) {
                throw new TestException("For the region " + aRegion.getName() + " average expected eviction is " + averageEvictionPerRegion + " but is " + numEntriesInDisk);
            }
            Log.getLogWriter().info("For the region " + aRegion.getName() + " num evicted is " + numEntriesInDisk + " which is within the expected limit " + averageEvictionPerRegion);
        }
        if (totalNumEntriesInVm == 0L && totalNumEntriesInDisk > 0L) {
            throw new TestException("After eviction from all the regions the cache is empty");
        }
    }

    static {
        regionDescriptNames = new ArrayList();
        totalNumOverFlowToDisk = 0L;
        totalEntriesInDisk = 0L;
    }
}

