/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.GsRandom;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.ExceptionHandlingFunction;
import util.StopStartVMs;
import util.TestException;

public class ExceptionHandlingTest {
    private static final int NUM_KEYS = 500;
    protected static String DataStoreVmStr = "DataStoreVM_";
    public static GsRandom random = new GsRandom();
    protected static ExceptionHandlingTest testInstance;
    protected static Cache theCache;
    protected static Region<String, Integer> partitionedRegion;
    protected static Region<String, Integer> replicatedRegion;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ExceptionHandlingTest();
        }
        testInstance.initialize();
        ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
    }

    public static synchronized void HydraTask_initializeServer() {
        if (testInstance == null) {
            testInstance = new ExceptionHandlingTest();
        }
        testInstance.initializeServer();
        BridgeHelper.startBridgeServer("bridge");
        ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new ExceptionHandlingTest();
        }
        testInstance.initializeClient();
    }

    public static synchronized void HydraTask_populateRegion() {
        if (testInstance == null) {
            testInstance = new ExceptionHandlingTest();
        }
        testInstance.populateRegion(partitionedRegion);
        testInstance.populateRegion(replicatedRegion);
    }

    public static synchronized void HydraTask_registerFunction() {
        if (testInstance == null) {
            testInstance = new ExceptionHandlingTest();
        }
        FunctionService.registerFunction((Function)new ExceptionHandlingFunction());
    }

    public static synchronized void HydraTask_doFunctionExecutions() {
        if (TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false)) {
            testInstance.doHctFunctionExecutions();
        } else {
            testInstance.doP2PFunctionExecutions();
        }
    }

    public static void HydraTask_stopStartVms() {
        testInstance.stopStartVms();
    }

    protected void initialize() {
        theCache = CacheHelper.createCache("cache1");
        replicatedRegion = RegionHelper.createRegion("replicatedRegion");
        partitionedRegion = RegionHelper.createRegion("partitionedRegion");
    }

    protected void initializeServer() {
        theCache = CacheHelper.createCache("cache1");
        partitionedRegion = RegionHelper.createRegion("bridgePR");
        replicatedRegion = RegionHelper.createRegion("bridgeReplicated");
    }

    protected void initializeClient() {
        theCache = CacheHelper.createCache("cache1");
        partitionedRegion = RegionHelper.createRegion("edgeRegion1");
        replicatedRegion = RegionHelper.createRegion("edgeRegion2");
    }

    protected void populateRegion(Region<String, Integer> region) {
        for (int i = 0; i < 500; ++i) {
            String keyName = "Key " + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations);
            Integer value = new Integer(i);
            region.put((Object)keyName, (Object)value);
        }
        Log.getLogWriter().info("Completed put for 500 keys and region size is " + region.size());
    }

    protected void doP2PFunctionExecutions() {
        int n = random.nextInt(1, 40);
        if (n < 10) {
            this.doParitionedRegionFunctionExecution();
        } else if (n < 20) {
            this.doReplicatedRegionFunctionExecution();
        } else if (n < 30) {
            ExceptionHandlingTest.doFireAndForgetFunctionExecution();
        } else {
            this.doOnMembersFunctionExcecution();
        }
    }

    protected void doHctFunctionExecutions() {
        int n = random.nextInt(1, 40);
        if (n < 10) {
            this.doParitionedRegionFunctionExecution();
        } else if (n < 20) {
            this.doReplicatedRegionFunctionExecution();
        } else if (n < 30) {
            ExceptionHandlingTest.doFireAndForgetFunctionExecution();
        } else {
            this.doOnServersFunctionExcecution();
        }
    }

    protected void doParitionedRegionFunctionExecution() {
        Execution dataSet;
        if (random.nextBoolean()) {
            Log.getLogWriter().info("Execution on partitionedRegion with no filter");
            dataSet = FunctionService.onRegion(partitionedRegion).withCollector((ResultCollector)new ArrayListResultCollector());
        } else {
            Log.getLogWriter().info("Execution on partitionedRegion with filter");
            Set keySet = partitionedRegion.keySet();
            dataSet = FunctionService.onRegion(partitionedRegion).withFilter(keySet).withCollector((ResultCollector)new ArrayListResultCollector());
        }
        try {
            ResultCollector rc = dataSet.execute((Function)new ExceptionHandlingFunction());
            ArrayList list = (ArrayList)rc.getResult();
            Log.getLogWriter().info("Successful completion of execution on partitioned region on nodes " + list);
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("Server unreachable")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerConnectivityException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("ExceptionHandlingFunction is not registered")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getCause() instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            throw new TestException("Caught the exception during function execution ", e);
        }
    }

    protected static void doFireAndForgetFunctionExecution() {
        Region<String, Integer> region;
        if (random.nextBoolean()) {
            Log.getLogWriter().info("Execution Fire and forget on partitioned region");
            region = partitionedRegion;
        } else {
            Log.getLogWriter().info("Execution Fire and forget on replicated region");
            region = replicatedRegion;
        }
        Execution dataSet = FunctionService.onRegion(region).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            ResultCollector rc = dataSet.execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    Object argument = null;
                    ArrayList<String> list = new ArrayList<String>();
                    InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                    String localVM = ds.getDistributedMember().getId();
                    Log.getLogWriter().info("Inside function execution (some time) node " + localVM);
                    for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                        for (int j = 0; j < 4; ++j) {
                        }
                    }
                    list.add(localVM);
                    Log.getLogWriter().info("Completed function execution (some time) node " + localVM);
                }

                public String getId() {
                    return "FireNForget";
                }

                public boolean hasResult() {
                    return false;
                }

                public boolean isHA() {
                    return false;
                }
            });
            Log.getLogWriter().info("Successful completion of Fire and forget execution ");
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("Server unreachable")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerConnectivityException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("ExceptionHandlingFunction is not registered")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getCause() instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            throw new TestException("Caught the exception during function execution ", e);
        }
    }

    protected void doReplicatedRegionFunctionExecution() {
        Log.getLogWriter().info("Execution on replicated Region");
        Execution dataSet = FunctionService.onRegion(replicatedRegion).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            ResultCollector rc = dataSet.execute((Function)new ExceptionHandlingFunction());
            ArrayList list = (ArrayList)rc.getResult();
            Log.getLogWriter().info("Successful completion of execution on replicated region on nodes " + list);
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("Server unreachable")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerConnectivityException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("ExceptionHandlingFunction is not registered")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getCause() instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            throw new TestException("Caught the exception during function execution ", e);
        }
    }

    protected void doOnServersFunctionExcecution() {
        Log.getLogWriter().info("Execution on onServers");
        Pool pool = PoolHelper.getPool("edgeDescript");
        if (pool == null) {
            Log.getLogWriter().info("Pool is null");
            pool = PoolHelper.createPool("edgeDescript");
        }
        Execution dataSet = FunctionService.onServers((Pool)pool).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            ResultCollector rc = dataSet.execute((Function)new ExceptionHandlingFunction());
            ArrayList list = (ArrayList)rc.getResult();
            Log.getLogWriter().info("Successful completion of execution onMembers on nodes " + list);
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("Server unreachable")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof ServerConnectivityException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("ExceptionHandlingFunction is not registered")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getCause() instanceof ServerOperationException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            throw new TestException("Caught the exception during function execution ", e);
        }
    }

    protected void doOnMembersFunctionExcecution() {
        Log.getLogWriter().info("Execution on onMembers");
        DistributedSystem ds = theCache.getDistributedSystem();
        Execution dataSet = FunctionService.onMembers((DistributedSystem)ds).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            ResultCollector rc = dataSet.execute((Function)new ExceptionHandlingFunction());
            ArrayList list = (ArrayList)rc.getResult();
            Log.getLogWriter().info("Successful completion of execution onMembers on nodes " + list);
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            if (e instanceof FunctionException && e.getMessage().contains("ExceptionHandlingFunction is not registered")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            throw new TestException("Caught the exception during function execution ", e);
        }
    }

    protected void stopStartVms() {
        int numRegions = CacheHelper.getCache().rootRegions().size();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        ParRegBB.getBB().getSharedMap().remove(DataStoreVmStr + RemoteTestModule.getMyVmid());
        Log.getLogWriter().info("In stopStartVms, choosing " + numVMsToStop + " vm(s) to stop...");
        List vmList = this.getDataStoreVms();
        ArrayList targetVms = new ArrayList();
        ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 1; i <= numVMsToStop; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            targetVms.add(vmList.get(randInt));
            vmList.remove(randInt);
            stopModes.add(TestConfig.tab().stringAt(ParRegPrms.stopModes));
        }
        StopStartVMs.stopStartVMs(targetVms, stopModes);
        Log.getLogWriter().info("Done in stopStartVms()");
    }

    protected List getDataStoreVms() {
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        Map aMap = ParRegBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(DataStoreVmStr)) continue;
            aList.add(new ClientVmInfo((Integer)aMap.get(key), null, null));
        }
        return aList;
    }
}

