/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.pdx.PdxInstance;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GatewayPrms;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.KnownKeysTest;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import parReg.colocation.Month;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.HashMapResultCollector;
import parReg.execute.KeysOperationsFunction;
import parReg.execute.MemberMappedArgsFunction;
import parReg.execute.MemberResultsCollector;
import parReg.execute.PrimaryExecutionFunction;
import parReg.execute.RegionOperationsFunction;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import util.BaseValueHolder;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class ExecutionAndColocationTest
extends KnownKeysTest {
    protected static final String KEY_LIST = "Key List";
    protected static final String PR_TOTAL_BUCKETS = "PR Total Buckets";
    protected static final String PR_TOTAL_DATASTORES = "PR Total DataStores";
    protected static final String DS_MEMBER_SET = "ds Member Set";
    protected static final String DS_SERVER_SET = "ds Server Set";

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ExecutionAndColocationTest();
            ((KnownKeysTest)testInstance).initInstance("clientRegion");
            if (isGatewayConfiguration) {
                String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
                GatewayHubHelper.createGatewayHub(gatewayHubConfig);
            }
        }
    }

    public static synchronized void HydraTask_initializeWithAccessor() {
        if (testInstance == null) {
            testInstance = new ExecutionAndColocationTest();
            long numOfAccessors = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfAccessors);
            if (numOfAccessors > TestConfig.tab().longAt(ParRegPrms.numberOfAccessors, 0L)) {
                ((KnownKeysTest)testInstance).initInstance("clientRegion");
            } else {
                ((KnownKeysTest)testInstance).initInstance("clientAccessor");
            }
        }
    }

    @Override
    public void initInstance(String regDescriptName) {
        super.initInstance();
        this.highAvailability = TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false);
        Cache myCache = null;
        myCache = (regDescriptName.equals("clientAccessor") || regDescriptName.equals("accessorRegion")) && TestConfig.tab().vecAt(CachePrms.names).contains("accessorCache") ? CacheHelper.createCache("accessorCache") : CacheHelper.createCache("cache1");
        ((ExecutionAndColocationTest)testInstance).registerFunctions();
        InternalResourceManager.ResourceObserver ro = ParRegPrms.getResourceObserver();
        if (ro != null) {
            InternalResourceManager rm = InternalResourceManager.getInternalResourceManager((Cache)myCache);
            InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)ro);
        }
        this.aRegion = RegionHelper.createRegion(regDescriptName);
        isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
        isGatewayConfiguration = TestConfig.tab().stringAt(GatewayPrms.names, null) != null;
        this.lockOperations = TestConfig.tab().booleanAt(ParRegPrms.lockOperations, false);
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public static synchronized void HydraTask_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new ExecutionAndColocationTest();
            ((KnownKeysTest)testInstance).initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(ExecutionAndColocationTest.testInstance.aRegion);
            }
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new ExecutionAndColocationTest();
            ((KnownKeysTest)testInstance).initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(ExecutionAndColocationTest.testInstance.aRegion);
            }
        }
    }

    public static synchronized void HydraTask_dataStoreInitialize() {
        if (testInstance == null) {
            testInstance = new ExecutionAndColocationTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
            if (isGatewayConfiguration) {
                String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
                GatewayHubHelper.createGatewayHub(gatewayHubConfig);
            }
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new ExecutionAndColocationTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            RegionAttributes attr = ExecutionAndColocationTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            if (prAttr == null) {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(-1L));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(-1L));
            } else {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(prAttr.getRecoveryDelay()));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(prAttr.getStartupRecoveryDelay()));
            }
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initRegisterFunction() {
        ((ExecutionAndColocationTest)testInstance).registerFunctions();
    }

    public static void HydraTask_doFunctionExecution() {
        PdxTest.initClassLoader();
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 9);
        ((ExecutionAndColocationTest)testInstance).doFunctionExecution(availableOps);
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    public static void HydraTask_executeFunctionAllKeysHA() {
        ((ExecutionAndColocationTest)testInstance).executeFunctionAllKeys();
        ((ExecutionAndColocationTest)testInstance).executeFunctionAllBuckets();
        ((ExecutionAndColocationTest)testInstance).executeFunctionMultipleNodes();
        if (!isBridgeConfiguration) {
            ((ExecutionAndColocationTest)testInstance).executeRegionFunctionMemberArgs();
        }
    }

    public static void HydraTask_executeFunctionAllKeys() {
        PdxTest.initClassLoader();
        ((ExecutionAndColocationTest)testInstance).executeFunctionAllKeys();
        ((ExecutionAndColocationTest)testInstance).executeFunctionAllBuckets();
        ((ExecutionAndColocationTest)testInstance).executeFunctionMultipleNodes();
        ((ExecutionAndColocationTest)testInstance).executeRegionFunctionMemberArgs();
        if (!isBridgeConfiguration) {
            ((ExecutionAndColocationTest)testInstance).executeMemberFunctionMemberArgs();
        } else {
            ((ExecutionAndColocationTest)testInstance).executeServerFunctionMemberArgs();
        }
    }

    public static void HydraTask_executeFunctionPrimaryBuckets() {
        ((ExecutionAndColocationTest)testInstance).executeFunctionPrimaryBucketsAllBuckets();
        ((ExecutionAndColocationTest)testInstance).executeFunctionPrimaryBucketsMultipleNodes();
        ((ExecutionAndColocationTest)testInstance).executeFunctionPrimaryBucketsSinlgeNode();
    }

    public void registerFunctions() {
        FunctionService.registerFunction((Function)new RegionOperationsFunction());
        FunctionService.registerFunction((Function)new KeysOperationsFunction());
        FunctionService.registerFunction((Function)new PrimaryExecutionFunction());
        FunctionService.registerFunction((Function)new MemberMappedArgsFunction());
    }

    public void doFunctionExecution(BitSet availableOps) {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        boolean useTransactions = InitImagePrms.useTransactions();
        if (useTransactions) {
            // empty if block
        }
        while (availableOps.cardinality() != 0 && System.currentTimeMillis() - startTime < minTaskGranularityMS) {
            int whichOp = this.getOp(availableOps, operations.length);
            boolean doneWithOps = false;
            boolean rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            try {
                switch (whichOp) {
                    case 7: {
                        doneWithOps = this.addNewKeyFunction();
                        break;
                    }
                    case 8: {
                        doneWithOps = this.putAllNewKeyFunction();
                        break;
                    }
                    case 1: {
                        doneWithOps = this.invalidateFunction();
                        break;
                    }
                    case 3: {
                        doneWithOps = this.destroyFunction();
                        break;
                    }
                    case 5: {
                        doneWithOps = this.updateExistingKeyFunction();
                        break;
                    }
                    case 6: {
                        doneWithOps = this.getFunction();
                        break;
                    }
                    case 2: {
                        doneWithOps = this.localInvalidateFunction();
                        break;
                    }
                    case 4: {
                        doneWithOps = this.localDestroyFunction();
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (Exception e) {
                throw new TestException("Caught exception during test ", e);
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.FAILED_TXOPS);
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    this.recordFailedOps(ParRegBB.INDOUBT_TXOPS);
                }
                catch (CommitConflictException e) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
                }
            }
            if (!doneWithOps) continue;
            Log.getLogWriter().info("Done with operation " + whichOp);
            availableOps.clear(whichOp);
        }
    }

    public static void HydraTask_waitForEventsReceival() {
        if (testInstance == null) {
            testInstance = new ExecutionAndColocationTest();
        }
        ((ExecutionAndColocationTest)testInstance).waitForEventsReceival();
    }

    protected boolean addNewKeyFunction() {
        Log.getLogWriter().info("Inside addNewKeyFunction()");
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from addNewKeyFunction()");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(key, callBackArg);
        }
        if (this.aRegion.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
            this.checkContainsValueForKey(key, false, "before addNewKey");
        }
        RegionOperationsFunction addKeyFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)addKeyFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            aList.add("putIfAbsent");
        } else {
            aList.add("addKey");
        }
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                Log.getLogWriter().info("Going to do " + aList.get(0) + " execute");
                drc = dataSet.withFilter(keySet).withArgs(aList).execute((Function)addKeyFunction);
            } else {
                aList.set(0, "addKey");
                Log.getLogWriter().info("Going to do " + aList.get(0) + " execute");
                aList.add(key);
                drc = dataSet.withArgs(aList).execute((Function)addKeyFunction);
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception during the onRegion function execution " + aList.get(0) + " ", e);
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    protected boolean putAllNewKeyFunction() {
        Log.getLogWriter().info("Inside putAllNewKeyFunction()");
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from putAllNewKeyFunction()");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        RandomValues randomValues = new RandomValues();
        BaseValueHolder value = this.createObject(key, randomValues);
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(key, callBackArg);
        }
        HashMap<String, BaseValueHolder> map = new HashMap<String, BaseValueHolder>();
        map.put(key, value);
        if (this.aRegion.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
            this.checkContainsValueForKey(key, false, "before addNewKey");
        }
        RegionOperationsFunction putAllFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)putAllFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("putAll");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        aList.add(map);
        try {
            Log.getLogWriter().info("Going to do putAll execute with " + map);
            ResultCollector drc = null;
            drc = !TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false) ? dataSet.withFilter(keySet).withArgs(aList).execute((Function)putAllFunction) : dataSet.withArgs(aList).execute((Function)putAllFunction);
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception during onRegion function execution for putAll operation ", e);
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    protected boolean invalidateFunction() {
        Log.getLogWriter().info("Inside invalidateFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1001, nextKey)) {
            Log.getLogWriter().info("All existing keys invalidated; returning from invalidate Function execution");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        if (this.aRegion.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
            this.checkContainsValueForKey(key, true, "before invalidate");
        }
        RegionOperationsFunction invalidateFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)invalidateFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("invalidate");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Going to do invalidate execute");
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                drc = dataSet.withFilter(keySet).withArgs(aList).execute(invalidateFunction.getId());
            } else {
                aList.add(key);
                drc = dataSet.withArgs(aList).execute(invalidateFunction.getId());
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception during single key invalidate operation using onRegion function execution ", e);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1001);
    }

    protected boolean destroyFunction() {
        Log.getLogWriter().info("Inside destroyFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_DESTROY);
        if (!this.keyIntervals.keyInRange(1003, nextKey)) {
            Log.getLogWriter().info("All destroys completed; returning from destroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Destroying " + key);
        if (this.aRegion.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
            this.checkContainsValueForKey(key, true, "before destroy");
        }
        RegionOperationsFunction destroyFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)destroyFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            aList.add("remove");
        } else {
            aList.add("destroy");
        }
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Going to do " + aList.get(0) + " execute");
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                drc = dataSet.withFilter(keySet).withArgs(aList).execute(destroyFunction.getId());
            } else {
                aList.set(0, "destroy");
                aList.add(key);
                drc = dataSet.withArgs(aList).execute(destroyFunction.getId());
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception during single key " + aList.get(0) + " operation using onRegion function execution ", e);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1003);
    }

    protected boolean updateExistingKeyFunction() {
        Log.getLogWriter().info("Inside update Function()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY);
        if (!this.keyIntervals.keyInRange(1005, nextKey)) {
            Log.getLogWriter().info("All existing keys updated; returning from updateExistingKey");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        RegionOperationsFunction updateFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)updateFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        Log.getLogWriter().info("Updating key " + key);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            aList.add("replace");
        } else {
            aList.add("update");
        }
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Going to do " + aList.get(0) + " execute");
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                drc = dataSet.withFilter(keySet).withArgs(aList).execute((Function)updateFunction);
            } else {
                aList.set(0, "update");
                aList.add(key);
                drc = dataSet.withArgs(aList).execute((Function)updateFunction);
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception when executing " + aList.get(0) + " on single key with onRegion function execution ", e);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1005);
    }

    protected boolean getFunction() {
        Log.getLogWriter().info("Inside getFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_GET);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All gets completed; returning from get");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        RegionOperationsFunction getFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)getFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("get");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Going to do get execute");
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                drc = dataSet.withFilter(keySet).withArgs(aList).execute(getFunction.getId());
            } else {
                Log.getLogWriter().info("Going to do get execute - Non partitioned region");
                aList.add(key);
                drc = dataSet.withArgs(aList).execute(getFunction.getId());
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception when doing a get on the key using onRegion function execution " + e.getMessage() + " Cause " + e.getCause(), e);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    protected boolean localInvalidateFunction() {
        Log.getLogWriter().info("Inside localInvalidateFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1002, nextKey)) {
            Log.getLogWriter().info("All local invalidates completed; returning from localInvalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        RegionOperationsFunction localInvalidateFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)localInvalidateFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("localinvalidate");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Going to do localinvalidate execute");
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                drc = dataSet.withFilter(keySet).withArgs(aList).execute(localInvalidateFunction.getId());
            } else {
                aList.add(key);
                drc = dataSet.withArgs(aList).execute(localInvalidateFunction.getId());
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception when doing local invalidate operation ", e);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1002);
    }

    protected boolean localDestroyFunction() {
        Log.getLogWriter().info("Inside local destroyFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_DESTROY);
        if (!this.keyIntervals.keyInRange(1004, nextKey)) {
            Log.getLogWriter().info("All local destroys completed; returning from localDestroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        if (this.aRegion.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
            this.checkContainsValueForKey(key, true, "before localDestroy");
        }
        RegionOperationsFunction localDestroyFunction = new RegionOperationsFunction();
        FunctionService.registerFunction((Function)localDestroyFunction);
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("localdestroy");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Going to do localdestroy execute");
            ResultCollector drc = null;
            if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
                drc = dataSet.withFilter(keySet).withArgs(aList).execute((Function)localDestroyFunction);
            } else {
                aList.add(key);
                drc = dataSet.withArgs(aList).execute((Function)localDestroyFunction);
            }
            Object result = drc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Got this exception during local destroy of single key using onRegion function execution ", e);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1004);
    }

    public static synchronized void HydraTask_verifyCustomPartitioning() {
        ((ExecutionAndColocationTest)testInstance).verifyCustomPartitioning();
    }

    protected void verifyCustomPartitioning() {
        PartitionedRegion pr = (PartitionedRegion)this.aRegion;
        int totalBuckets = pr.getTotalNumberOfBuckets();
        RegionAttributes attr = this.aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        int redundantCopies = prAttr.getRedundantCopies();
        int expectedNumCopies = redundantCopies + 1;
        int verifyBucketCopiesBucketId = 0;
        while (verifyBucketCopiesBucketId < totalBuckets) {
            Log.getLogWriter().info("Verifying data for bucket id " + verifyBucketCopiesBucketId + " out of " + totalBuckets + " buckets");
            List listOfMaps = null;
            try {
                listOfMaps = pr.getAllBucketEntries(verifyBucketCopiesBucketId);
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            int size = listOfMaps.size();
            if (size == 0) {
                Log.getLogWriter().info("Bucket " + verifyBucketCopiesBucketId + " is empty");
                ++verifyBucketCopiesBucketId;
                continue;
            }
            if (size != expectedNumCopies) {
                throw new TestException("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size());
            }
            Log.getLogWriter().info("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, and have " + listOfMaps.size());
            Log.getLogWriter().info("Validating co-location for all the redundant copies of the bucket with Id : " + verifyBucketCopiesBucketId);
            for (int i = 0; i < listOfMaps.size(); ++i) {
                BucketDump dump = (BucketDump)listOfMaps.get(i);
                Map map = dump.getValues();
                if (map.size() == 0) continue;
                this.verifyCustomPartition(map, verifyBucketCopiesBucketId);
                this.verifyUniqueBucketForCustomPartioning(verifyBucketCopiesBucketId);
            }
            ++verifyBucketCopiesBucketId;
        }
    }

    protected void verifyCustomPartition(Map map, int bucketid) {
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid) == null) {
                Log.getLogWriter().info("RoutingObject for the bucket id to be set in the BB");
                ParRegBB.getBB().getSharedMap().put("RoutingObjectForBucketid:" + bucketid, InitImageBB.getBB().getSharedMap().get(key));
                ParRegBB.getBB().getSharedMap().put("RoutingObjectKeyBucketid:" + bucketid, key);
                Log.getLogWriter().info("BB value set to " + key.toString());
                continue;
            }
            Log.getLogWriter().info("Checking the value for the routing object ");
            String blackBoardRoutingObject = ((Month)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid)).toString();
            String keyRoutingObject = ((Month)InitImageBB.getBB().getSharedMap().get(key)).toString();
            if (!keyRoutingObject.equalsIgnoreCase(blackBoardRoutingObject)) {
                throw new TestException("Expected same routing objects for the entries in this bucket id " + bucketid + "but got different values " + blackBoardRoutingObject + " and " + keyRoutingObject);
            }
            Log.getLogWriter().info("Got the expected values " + blackBoardRoutingObject + " and " + keyRoutingObject + " for the keys " + ParRegBB.getBB().getSharedMap().get("RoutingObjectKeyBucketid:" + bucketid) + " and " + key);
        }
    }

    protected void verifyUniqueBucketForCustomPartioning(int bucketId) {
        if (bucketId == 0) {
            Log.getLogWriter().info("This is the first bucket, so no validation required as there is no bucket to be compared");
            return;
        }
        for (int i = 0; i < bucketId; ++i) {
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i) == null) continue;
            String referenceValue = ((Month)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i)).toString();
            String currentValue = ((Month)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketId)).toString();
            Log.getLogWriter().info("currentValue: " + currentValue);
            Log.getLogWriter().info("referenceValue: " + referenceValue);
            if (currentValue.equalsIgnoreCase(referenceValue)) {
                throw new TestException("Two buckets with the id " + i + " and " + bucketId + " have the same routing Object " + referenceValue);
            }
            Log.getLogWriter().info("As expected the bucket with ids " + i + " and " + bucketId + " have the different routing Object " + currentValue + " and " + referenceValue);
        }
    }

    public static synchronized void HydraTask_verifyOverflowToDisk() {
        ((ExecutionAndColocationTest)testInstance).verifyOverflowToDisk();
    }

    protected void verifyOverflowToDisk() {
        PartitionedRegion pr = (PartitionedRegion)this.aRegion;
        if (pr.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        long numOverflowToDisk = pr.getDiskRegionStats().getNumOverflowOnDisk();
        long entriesInVm = pr.getDiskRegionStats().getNumEntriesInVM();
        long totalEntriesInBuckets = 0L;
        Set bucketList = pr.getDataStore().getAllLocalBuckets();
        for (Map.Entry entry : bucketList) {
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket == null) continue;
            totalEntriesInBuckets += (long)localBucket.entryCount();
        }
        if (bucketList.size() > 0) {
            if (numOverflowToDisk == 0L) {
                throw new TestException("For the region " + pr.getName() + " no eviction happened ");
            }
            Log.getLogWriter().info("For the region " + pr.getName() + " entries overflown to disk is " + numOverflowToDisk);
        }
        Log.getLogWriter().info("For the region " + pr.getName() + " entries in disk = " + numOverflowToDisk + " entries in vm = " + entriesInVm + "entries in bucket = " + totalEntriesInBuckets);
        if (totalEntriesInBuckets != numOverflowToDisk + entriesInVm) {
            throw new TestException("Entries in bucket (actual value " + totalEntriesInBuckets + " ) is not the same as the sum of entries in disk and entries in vm ( " + numOverflowToDisk + " and " + entriesInVm + ")");
        }
    }

    public void executeFunctionAllKeys() {
        Execution dataSet;
        Log.getLogWriter().info("executeFunctionAllKeys()");
        KeysOperationsFunction getAllKeysFunction = new KeysOperationsFunction();
        FunctionService.registerFunction((Function)getAllKeysFunction);
        HashMapResultCollector resultCollectorMap = new HashMapResultCollector();
        HashSet keySet = null;
        HashMap myMap = null;
        int expectedSize = 0;
        String scenario = "Function Execution done on multiple buckets (all the keys of the PR passed as filter) by using HashMapResultCollector \n";
        if (this.aRegion instanceof PartitionedRegion) {
            Log.getLogWriter().info("Inside p2p functionexecution");
            keySet = ((PartitionedRegion)this.aRegion).keys();
            expectedSize = keySet.size();
            dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorMap);
            scenario = scenario + " Topology : peer to peer \n";
        } else {
            Log.getLogWriter().info("Inside client server functionexecution");
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get(KEY_LIST);
            keySet = new HashSet();
            keySet.addAll(keyList);
            expectedSize = keySet.size();
            dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorMap);
            SilenceListener.waitForSilence(30L, 5000L);
            scenario = scenario + " Topology : client server \n";
        }
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("getKeys");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            Log.getLogWriter().info("Fetching all keys/values");
            ResultCollector rc = dataSet.withFilter(keySet).withArgs(aList).execute(getAllKeysFunction.getId());
            myMap = (HashMap)rc.getResult();
            Log.getLogWriter().info("Returned result " + ((Object)myMap).toString());
        }
        catch (Exception e) {
            throw new TestException("During " + scenario + " Got this exception ", e);
        }
        if (expectedSize != myMap.size()) {
            throw new TestException("For the scenario " + scenario + " for the function KeysOperationsFunction " + "Expected result collector returned map size to be " + expectedSize + ' ' + keySet + " (the filter set size passed) but got the value " + myMap.size() + ": " + myMap);
        }
        Log.getLogWriter().info("Got the expected size for the map " + myMap.size());
        Iterator iterator = myMap.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        Object value = null;
        Object referenceValue = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            referenceValue = this.aRegion instanceof PartitionedRegion ? ((PartitionedRegion)this.aRegion).get(key) : this.aRegion.get(key);
            if (value != null && referenceValue != null) {
                boolean valueIsPdxInstance = value instanceof PdxInstance;
                boolean referenceValueIsPdxInstance = referenceValue instanceof PdxInstance;
                if (valueIsPdxInstance != referenceValueIsPdxInstance) {
                    value = PdxTestVersionHelper.toBaseObject(value);
                    referenceValue = PdxTestVersionHelper.toBaseObject(referenceValue);
                }
                if (!value.equals(referenceValue)) {
                    throw new TestException("For the scenario " + scenario + " it is expected that the value returned by doing get through function execution match with the value in region \n" + "For the key " + key + " the values found in map is " + value + " and that in region is " + referenceValue);
                }
                Log.getLogWriter().info("For the key " + key + " the values found the expected values in map and region " + value);
                continue;
            }
            if (value == null && referenceValue == null) {
                Log.getLogWriter().info("Got expected null for the key " + key);
                continue;
            }
            throw new TestException("For the scenario " + scenario + " it is expected that the value returned by doing get through function execution match with the value in region \n" + "Expected value for the key " + key + " to be " + referenceValue + " but got the value " + value);
        }
    }

    public void executeFunctionMultipleNodes() {
        Execution dataSet;
        Log.getLogWriter().info("executeFunctionMultipleNodes()");
        KeysOperationsFunction getAllKeysFunction = new KeysOperationsFunction();
        FunctionService.registerFunction((Function)getAllKeysFunction);
        ArrayListResultCollector resultCollectorList = new ArrayListResultCollector();
        HashSet keySet = null;
        ArrayList myList = null;
        int expectedSize = 0;
        String scenario = "Function Execution done on multiple buckets (all the keys of the PR passed as filter) by using ArrayListResultCollector \n";
        if (this.aRegion instanceof PartitionedRegion) {
            Log.getLogWriter().info("Inside p2p functionexecution");
            keySet = ((PartitionedRegion)this.aRegion).keys();
            expectedSize = keySet.size();
            dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorList).withArgs((Object)"MultiNode");
            scenario = scenario + " Topology : peer to peer \n";
        } else {
            Log.getLogWriter().info("Inside client server functionexecution");
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get(KEY_LIST);
            keySet = new HashSet();
            keySet.addAll(keyList);
            expectedSize = keySet.size();
            dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorList).withArgs((Object)"MultiNode");
            scenario = scenario + " Topology : client server \n";
        }
        try {
            Log.getLogWriter().info("Fetching all keys/values");
            myList = (ArrayList)dataSet.withFilter(keySet).execute(getAllKeysFunction.getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("For the scenario " + scenario, e);
        }
        if (expectedSize != myList.size()) {
            throw new TestException("For the scenario " + scenario + " the function KeysOperationsFunction returns a result for each " + "filter object. Expected result collector returned list size " + "to be " + expectedSize + ' ' + keySet + " (the filter size) " + "but got the value " + myList.size() + ": " + myList);
        }
        Log.getLogWriter().info("Got the expected size for the list " + myList.size());
    }

    public void executeFunctionAllBuckets() {
        Execution dataSet;
        Log.getLogWriter().info("executeFunctionAllBuckets()");
        KeysOperationsFunction getAllKeysFunction = new KeysOperationsFunction();
        FunctionService.registerFunction((Function)getAllKeysFunction);
        HashMapResultCollector resultCollectorMap = new HashMapResultCollector();
        String scenario = "Function Execution done on all buckets (without filter) by using HashMapResultCollector \n";
        HashMap myMap = null;
        HashSet keySet = null;
        int expectedSize = 0;
        if (this.aRegion instanceof PartitionedRegion) {
            Log.getLogWriter().info("Inside p2p functionexecution");
            keySet = ((PartitionedRegion)this.aRegion).keys();
            expectedSize = keySet.size();
            dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorMap);
            scenario = scenario + " Topology : peer to peer \n";
        } else {
            Log.getLogWriter().info("Inside client server functionexecution");
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get(KEY_LIST);
            keySet = new HashSet();
            keySet.addAll(keyList);
            expectedSize = keySet.size();
            dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorMap).withArgs((Object)"All Buckets");
            scenario = scenario + " Topology : client server \n";
        }
        try {
            Log.getLogWriter().info("Fetching all keys/values");
            myMap = (HashMap)dataSet.execute(getAllKeysFunction.getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("During the scenario  Got this exception ", e);
        }
        if (myMap.size() != expectedSize) {
            throw new TestException("During the scenario " + scenario + " the function KeysOperationsFunction returns entries from local " + "data set (with vm_id). Expected size of the map to be " + expectedSize + ' ' + keySet + " (number of keys in the region) " + "but it is " + myMap.size() + ": " + myMap);
        }
        Log.getLogWriter().info("Got the expected size for the map " + expectedSize);
        myMap.clear();
        try {
            Log.getLogWriter().info("Fetching keys values through filter on all nodes");
            myMap = (HashMap)dataSet.withArgs((Object)"GetFilter").withCollector((ResultCollector)new HashMapResultCollector()).execute((Function)getAllKeysFunction).getResult();
        }
        catch (Exception e) {
            throw new TestException("During the scenario  Got this exception ", e);
        }
        expectedSize = keySet.size();
        if (myMap.size() != expectedSize) {
            throw new TestException("During the scenario " + scenario + " the function KeysOperationsFunction returns entries from local " + "data set (with vm_id). Expected size of the map to be " + expectedSize + ' ' + keySet + " (number of keys in the region) " + "but it is " + myMap.size() + ": " + myMap);
        }
        Log.getLogWriter().info("Got the expected size for the map " + expectedSize);
    }

    public void executeFunctionPrimaryBucketsAllBuckets() {
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
            Log.getLogWriter().info("Primary bucket execution need not be tested in case of non-PR tests");
        }
        Log.getLogWriter().info("Checking optimizeForWrite for no filter executions");
        PrimaryExecutionFunction primaryExecuteFunction = new PrimaryExecutionFunction();
        HashMap map = new HashMap();
        try {
            map = (HashMap)dataSet.withCollector((ResultCollector)new MemberResultsCollector()).execute(primaryExecuteFunction.getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Got the exception during execute on primary buckets ", e);
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String key = null;
        String value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = (String)entry.getKey();
            if (key.equalsIgnoreCase(value = (String)((ArrayList)entry.getValue()).get(0))) continue;
            throw new TestException(" The function PrimaryExecutionFunction verifies that the function execution happened on primary buckets and returns the node id where the function got executed For the memberID " + key + " the result received mentions the executed node ID as " + value);
        }
    }

    public void executeFunctionPrimaryBucketsMultipleNodes() {
        HashMap map;
        HashSet keySet;
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
            Log.getLogWriter().info("Primary bucket execution need not be tested in case of non-PR tests");
        }
        Log.getLogWriter().info("Checking optimizeForWrite for multiple nodes executions");
        PrimaryExecutionFunction primaryExecuteFunction = new PrimaryExecutionFunction();
        if (this.aRegion instanceof PartitionedRegion) {
            keySet = ((PartitionedRegion)this.aRegion).keys();
        } else {
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get(KEY_LIST);
            keySet = new HashSet();
            keySet.addAll(keyList);
        }
        try {
            map = (HashMap)dataSet.withFilter((Set)keySet).withCollector((ResultCollector)new MemberResultsCollector()).execute(primaryExecuteFunction.getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Got the exception during execute on primary buckets ", e);
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String key = null;
        String value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = (String)entry.getKey();
            if (key.equalsIgnoreCase(value = (String)((ArrayList)entry.getValue()).get(0))) continue;
            throw new TestException(" The function PrimaryExecutionFunction verifies that the function execution happened on primary buckets and returns the node id where the function got executed For the memberID " + key + " the result received mentions the executed node ID as " + value);
        }
    }

    public void executeFunctionPrimaryBucketsSinlgeNode() {
        HashSet keySet;
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
        if (!TestConfig.tab().booleanAt(InitImagePrms.useReplicatedRegions, false)) {
            Log.getLogWriter().info("Primary bucket execution need not be tested in case of non-PR tests");
        }
        PrimaryExecutionFunction primaryExecuteFunction = new PrimaryExecutionFunction();
        if (this.aRegion instanceof PartitionedRegion) {
            keySet = ((PartitionedRegion)this.aRegion).keys();
        } else {
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get(KEY_LIST);
            keySet = new HashSet();
            keySet.addAll(keyList);
        }
        Log.getLogWriter().info("Checking optimizeForWrite for single node executions");
        for (Object key : keySet) {
            HashMap map;
            HashSet singleKeySet = new HashSet();
            singleKeySet.add(key);
            try {
                map = (HashMap)dataSet.withFilter(singleKeySet).withCollector((ResultCollector)new MemberResultsCollector()).execute(primaryExecuteFunction.getId()).getResult();
            }
            catch (Exception e) {
                throw new TestException("Got the exception during execute on primary buckets ", e);
            }
            Iterator iterator = map.entrySet().iterator();
            Map.Entry entry = null;
            String mapKey = null;
            String value = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                mapKey = (String)entry.getKey();
                if (mapKey.equalsIgnoreCase(value = (String)((ArrayList)entry.getValue()).get(0))) continue;
                throw new TestException(" The function PrimaryExecutionFunction verifies that the function execution happened on primary buckets and returns the node id where the function got executed For the memberID " + key + " the result received mentions the executed node ID as " + value);
            }
            map.clear();
        }
    }

    public void executeRegionFunctionMemberArgs() {
        ArrayList list;
        Log.getLogWriter().info("executeRegionFunctionMemberArgs");
        HashMap<String, InternalDistributedMember> memberArgs = new HashMap<String, InternalDistributedMember>();
        Set allMemberSet = this.aRegion instanceof PartitionedRegion ? ((PartitionedRegion)this.aRegion).getAllNodes() : (Set)ParRegBB.getBB().getSharedMap().get(DS_MEMBER_SET);
        Iterator iterator = allMemberSet.iterator();
        while (iterator.hasNext()) {
            boolean shouldRemove = TestConfig.tab().getRandGen().nextBoolean();
            InternalDistributedMember member = (InternalDistributedMember)iterator.next();
            if (shouldRemove) continue;
            memberArgs.put(member.getId(), member);
        }
        Log.getLogWriter().info("The final member set is of size " + allMemberSet.size());
        Log.getLogWriter().info("Member args map is " + memberArgs);
        MemberMappedArgument argument = new MemberMappedArgument((Object)"Default Arg", memberArgs);
        InternalExecution dataSet = ((InternalExecution)FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)new ArrayListResultCollector())).withMemberMappedArgument(argument);
        try {
            list = (ArrayList)dataSet.execute(new MemberMappedArgsFunction().getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Caught exception during function execute ", e);
        }
        if (list.size() > allMemberSet.size() || list.size() <= 0) {
            throw new TestException("For the onRegion function execution with member Args Expected the size of the function execution result list to be between " + allMemberSet.size() + " (the number of all datastores) member list and 1 " + " but found " + list.size());
        }
        Log.getLogWriter().info("Received the expected list size after function execution " + allMemberSet.size());
        int defaultArgsCounter = 0;
        int memberArgsCounter = 0;
        for (Boolean argResult : list) {
            if (argResult.equals(Boolean.TRUE)) {
                ++memberArgsCounter;
                continue;
            }
            if (argResult.equals(Boolean.FALSE)) {
                ++defaultArgsCounter;
                continue;
            }
            throw new TestException("Unknown result after function execute");
        }
        if (memberArgsCounter > memberArgs.size()) {
            throw new TestException("For the onRegion function execution with member Args -  Expected member args to get executed on less than or equal to " + memberArgs.size() + " (the total member args passed) nodes" + " but got executed on " + memberArgsCounter + " nodes");
        }
        if (defaultArgsCounter > allMemberSet.size() - memberArgs.size() && !TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false)) {
            throw new TestException("For the onRegion function execution with member Args -  Expected default args to get executed on less than or equal to " + (allMemberSet.size() - memberArgs.size()) + " nodes" + " but got executed on " + defaultArgsCounter + " nodes");
        }
        Log.getLogWriter().info("The member args got executed on " + memberArgsCounter + " and default arg execution happened on " + defaultArgsCounter + " nodes (all expected nodes)");
    }

    public void executeMemberFunctionMemberArgs() {
        ArrayList list;
        Log.getLogWriter().info("executeMemberFunctionMemberArgs");
        Cache cache = CacheHelper.getCache();
        DistributedSystem ds = cache.getDistributedSystem();
        HashSet allMemberSet = new HashSet(((InternalDistributedSystem)ds).getDistributionManager().getNormalDistributionManagerIds());
        Iterator iterator = allMemberSet.iterator();
        HashMap<String, InternalDistributedMember> memberArgs = new HashMap<String, InternalDistributedMember>();
        while (iterator.hasNext()) {
            boolean shouldRemove = TestConfig.tab().getRandGen().nextBoolean();
            InternalDistributedMember member = (InternalDistributedMember)iterator.next();
            if (shouldRemove) continue;
            memberArgs.put(member.getId(), member);
        }
        Log.getLogWriter().info("The final member set is of size " + allMemberSet.size());
        Log.getLogWriter().info("Member args map is " + memberArgs);
        MemberMappedArgument argument = new MemberMappedArgument((Object)"Default Arg", memberArgs);
        InternalExecution dataSet = ((InternalExecution)FunctionService.onMembers((DistributedSystem)ds).withCollector((ResultCollector)new ArrayListResultCollector())).withMemberMappedArgument(argument);
        try {
            list = (ArrayList)dataSet.execute(new MemberMappedArgsFunction().getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Caught exception during onMembers function execute with member args ", e);
        }
        if (list.size() != allMemberSet.size()) {
            throw new TestException(" After the onMembers() function execute with member args  the function MemberMappedArgsFunction returns one result per executed node. \nExpected the size of the function execution result list to be " + allMemberSet.size() + " (total number of members in the ds) but found " + list.size());
        }
        Log.getLogWriter().info("Received the expected list size after function execution " + allMemberSet.size());
        int defaultArgsCounter = 0;
        int memberArgsCounter = 0;
        for (Boolean argResult : list) {
            if (argResult.equals(Boolean.TRUE)) {
                ++memberArgsCounter;
                continue;
            }
            if (argResult.equals(Boolean.FALSE)) {
                ++defaultArgsCounter;
                continue;
            }
            throw new TestException("Unknown result after function execute");
        }
        if (memberArgsCounter != memberArgs.size()) {
            throw new TestException(" After the onMembers() function execute with member args  the function MemberMappedArgsFunction returns one result per executed node. \nExpected member args to get executed on " + memberArgs.size() + " (member args nodes) nodes" + " but got executed on " + memberArgsCounter + " nodes");
        }
        if (defaultArgsCounter != allMemberSet.size() - memberArgs.size()) {
            throw new TestException(" After the onMembers() function execute with member args  the function MemberMappedArgsFunction returns one result per executed node. \nExpected default args to get executed on " + (allMemberSet.size() - memberArgs.size()) + " nodes" + " but got executed on " + defaultArgsCounter + " nodes");
        }
        Log.getLogWriter().info("The member args got executed on " + memberArgsCounter + " and default arg execution happened on " + defaultArgsCounter + " nodes (all expected nodes)");
    }

    public void executeServerFunctionMemberArgs() {
        Log.getLogWriter().info("executeServerFunctionMemberArgs");
        Pool pool = PoolHelper.getPool("edgeDescript");
        if (pool == null) {
            Log.getLogWriter().info("Pool is null");
            try {
                pool = PoolHelper.createPool("edgeDescript");
            }
            catch (Exception e) {
                if (e.getMessage().contains("edgeDescript not found in hydra.PoolPrms-names")) {
                    Log.getLogWriter().warning("This test does not use pool and hence onServer() not to be tested");
                    return;
                }
                throw new TestException(e.getMessage());
            }
        }
        Set allMemberSet = (Set)ParRegBB.getBB().getSharedMap().get(DS_SERVER_SET);
        Iterator iterator = allMemberSet.iterator();
        HashMap<String, InternalDistributedMember> memberArgs = new HashMap<String, InternalDistributedMember>();
        while (iterator.hasNext()) {
            boolean shouldRemove = TestConfig.tab().getRandGen().nextBoolean();
            InternalDistributedMember member = (InternalDistributedMember)iterator.next();
            if (shouldRemove) continue;
            memberArgs.put(member.getId(), member);
        }
        Log.getLogWriter().info("The final member set is of size " + allMemberSet.size());
        Log.getLogWriter().info("Member args map is " + memberArgs);
        MemberMappedArgument argument = new MemberMappedArgument((Object)"Default Arg", memberArgs);
        InternalExecution dataSet = ((InternalExecution)FunctionService.onServers((Pool)pool).withCollector((ResultCollector)new ArrayListResultCollector())).withMemberMappedArgument(argument);
        try {
            ResultCollector rc = dataSet.execute(new MemberMappedArgsFunction().getId());
            Object result = rc.getResult();
            Log.getLogWriter().info("Returned result " + result.toString());
        }
        catch (Exception e) {
            throw new TestException("Caught exception during function execute ", e);
        }
    }

    public void putKeySetInBB() {
        HashSet allServerSet;
        Set allMemberSet;
        int totalDataStoreNodes;
        int totalNumOfBuckets;
        Set keySet;
        if (this.aRegion instanceof PartitionedRegion) {
            keySet = ((PartitionedRegion)this.aRegion).keys();
            totalNumOfBuckets = ((PartitionedRegion)this.aRegion).getTotalNumberOfBuckets();
            totalDataStoreNodes = ((PartitionedRegion)this.aRegion).getAllNodes().size();
            allMemberSet = ((PartitionedRegion)this.aRegion).getAllNodes();
            allServerSet = new HashSet(InternalDistributedSystem.getAnyInstance().getDistributionManager().getNormalDistributionManagerIds());
        } else {
            keySet = this.aRegion.keySet();
            totalNumOfBuckets = 0;
            totalDataStoreNodes = 0;
            allMemberSet = null;
            allServerSet = null;
        }
        ArrayList keyList = new ArrayList();
        keyList.addAll(keySet);
        if (ParRegBB.getBB().getSharedMap().get(KEY_LIST) == null) {
            ParRegBB.getBB().getSharedMap().put(KEY_LIST, keyList);
            ParRegBB.getBB().getSharedMap().put(PR_TOTAL_BUCKETS, new Integer(totalNumOfBuckets));
            ParRegBB.getBB().getSharedMap().put(PR_TOTAL_DATASTORES, new Integer(totalDataStoreNodes));
            ParRegBB.getBB().getSharedMap().put(DS_MEMBER_SET, allMemberSet);
            ParRegBB.getBB().getSharedMap().put(DS_SERVER_SET, allServerSet);
        } else {
            Log.getLogWriter().info("Key set already kept in BB");
        }
    }

    public void waitForEventsReceival() {
        SilenceListener.waitForSilence(50L, 5000L);
    }

    public static void killVms() {
        try {
            MasterController.sleepForMs(5000);
            ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static void HydraTask_killVms() {
        MasterController.sleepForMs(5000);
        ExecutionAndColocationTest cfr_ignored_0 = (ExecutionAndColocationTest)testInstance;
        ExecutionAndColocationTest.killVms();
    }

    public static void HydraTask_putKeySetInBB() {
        ((ExecutionAndColocationTest)testInstance).putKeySetInBB();
    }
}

