/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionContext;
import hydra.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import util.TestException;

public class NonPRFunction
extends FunctionAdapter {
    public void execute(FunctionContext context) {
        boolean isRegionContext = context instanceof RegionFunctionContext;
        RegionFunctionContext regionContext = null;
        if (isRegionContext) {
            regionContext = (RegionFunctionContext)context;
            Region region = regionContext.getDataSet();
            if (region.getAttributes().getDataPolicy() != DataPolicy.REPLICATE) {
                throw new TestException("For non PR region the function execution on region happened on non replicate region");
            }
            if (regionContext.getArguments() != null && regionContext.getArguments() instanceof DistributedMember) {
                DistributedMember vmId = (DistributedMember)regionContext.getArguments();
                DistributedSystem ds = regionContext.getDataSet().getCache().getDistributedSystem();
                DistributedMember localVM = ds.getDistributedMember();
                if (!localVM.equals(vmId)) {
                    throw new TestException("The execution on replicated region was not supposed to happen on a remote node.");
                }
            }
            Set keySet = region.keySet();
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                list.add(region.get(iterator.next()));
            }
            context.getResultSender().lastResult(list);
        } else {
            Log.getLogWriter().info("OnRegions execution");
            MultiRegionFunctionContext mrContext = (MultiRegionFunctionContext)context;
            Set regionSet = mrContext.getRegions();
            ArrayList<DataPolicy> list = new ArrayList<DataPolicy>();
            for (Region aRegion : regionSet) {
                DataPolicy dataPolicy = aRegion.getAttributes().getDataPolicy();
                if (dataPolicy == DataPolicy.EMPTY || dataPolicy == DataPolicy.NORMAL) {
                    throw new TestException("OnRegions Function got executed on illegal datapolicy region node " + dataPolicy);
                }
                Log.getLogWriter().info("OnRegions function execution happened on the node with datapolicy for region " + dataPolicy);
                list.add(dataPolicy);
            }
            context.getResultSender().lastResult(list);
        }
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return false;
    }
}

