/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionContext;
import hydra.Log;
import java.util.HashMap;
import java.util.Set;

public class OnRegionsFunction
extends FunctionAdapter {
    public void execute(FunctionContext context) {
        Log.getLogWriter().info("Inside execute of OnRegionsFunction");
        MultiRegionFunctionContext mrContext = (MultiRegionFunctionContext)context;
        Set regionSet = mrContext.getRegions();
        Log.getLogWriter().info("Got the region set of size " + regionSet.size() + " and region set is " + regionSet + " and args is " + context.getArguments());
        if (context.getArguments() instanceof String && context.getArguments().equals("regionSize")) {
            for (Region aRegion : regionSet) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                Log.getLogWriter().info("For the region " + aRegion.getName() + " region size is " + aRegion.size());
                map.put(aRegion.getName(), aRegion.size());
                context.getResultSender().sendResult(map);
            }
            context.getResultSender().lastResult(new HashMap());
        }
        if (context.getArguments() instanceof String && context.getArguments().equals("invalidateEntries")) {
            for (Region aRegion : regionSet) {
                Set keySet = aRegion.keySet();
                for (Object key : keySet) {
                    aRegion.invalidate(key);
                }
            }
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }
        Log.getLogWriter().info("Completed execute of OnRegionsFunction");
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return true;
    }
}

