/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import hydra.Log;
import java.io.Serializable;
import java.util.ArrayList;
import parReg.execute.ExecuteExceptionBB;

public class PartialResultsExecutionFunction
implements Function {
    public void execute(FunctionContext context) {
        long now = System.currentTimeMillis();
        if (now % 2L == 0L) {
            for (int i = 0; i < 10; ++i) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(new Integer(i));
                context.getResultSender().sendResult(list);
            }
            ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.exceptionNodes);
            SenderIdWithOpId arg = (SenderIdWithOpId)context.getArguments();
            this.throwException(arg.getSenderId(), arg.getOpId());
        } else {
            Log.getLogWriter().info("Sending results");
            ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.sendResultsNodes);
            ArrayList<String> list = new ArrayList<String>();
            list.add(InternalDistributedSystem.getAnyInstance().getMemberId());
            context.getResultSender().lastResult(list);
        }
    }

    public String getId() {
        return "PartialResultsExecutionFunction";
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public Exception throwException(int senderId, int opId) {
        long now = System.currentTimeMillis();
        if (now % 3L == 0L) {
            Log.getLogWriter().info("Throwing fabricated Function exception [id=" + opId + "] sender=" + senderId);
            throw new FunctionException("Fabricated Checked Exception [id=" + opId + "] myId: " + GemFireCacheImpl.getInstance().getMyId() + " sender=" + senderId);
        }
        if (now % 3L == 1L) {
            Log.getLogWriter().info("Throwing fabricated Runtime exception [id=" + opId + "] sender=" + senderId);
            throw new RuntimeException("Fabricated Runtime Exception [id=" + opId + "] myId: " + GemFireCacheImpl.getInstance().getMyId() + " sender=" + senderId);
        }
        Log.getLogWriter().info("Throwing fabricated NullPointerException [id=" + opId + "] sender=" + senderId);
        throw new NullPointerException("Fabricated NullPointerException [id=" + opId + "] myId: " + GemFireCacheImpl.getInstance().getMyId() + " sender=" + senderId);
    }

    public static final class SenderIdWithOpId
    implements Serializable {
        private static final long serialVersionUID = -6371596340222874760L;
        private int senderId;
        private int opId;

        public SenderIdWithOpId() {
        }

        public SenderIdWithOpId(int id, int opId) {
            this.senderId = id;
            this.opId = opId;
        }

        public final int getSenderId() {
            return this.senderId;
        }

        public final int getOpId() {
            return this.opId;
        }
    }
}

