/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import parReg.ParRegBB;
import parReg.colocation.KeyResolver;
import parReg.colocation.Month;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.BBResultCollector;
import parReg.execute.NodePruningFunction;
import parReg.execute.ResultSenderFunction;
import util.TestException;

public class ResultSenderTest {
    protected static ResultSenderTest testInstance;
    protected static Cache theCache;
    protected static Region aRegion;
    public static final int NUM_KEYS = 50;
    public static final String BUCKETS_ON_NODE = "Buckets on node";
    public static final String ALL_BUCKET_IDS = "All Bucket Ids";

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
            testInstance.initialize("region");
        }
    }

    public static synchronized void HydraTask_initializeServer() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
            testInstance.initialize("bridge");
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
            testInstance.initialize("edge");
        }
    }

    public static synchronized void HydraTask_populateRegion() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
        }
        testInstance.populateRegion(aRegion);
    }

    public static synchronized void HydraTask_populateRegionWithCustomPartition() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
        }
        testInstance.populateRegionWithCustomPartition(aRegion);
    }

    public static synchronized void HydraTask_registerFunction() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
        }
        FunctionService.registerFunction((Function)new ResultSenderFunction());
        FunctionService.registerFunction((Function)new NodePruningFunction());
    }

    public static synchronized void HydraTask_updateBBWithNodes() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
        }
        testInstance.updateBBWithNodes(aRegion);
    }

    public static synchronized void HydraTask_doRegionFunction() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
        }
        testInstance.doRegionFunction(aRegion);
    }

    public static synchronized void HydraTask_doNodePruningRegionFunction() {
        if (testInstance == null) {
            testInstance = new ResultSenderTest();
        }
        testInstance.doNodePruningRegionFunction(aRegion);
    }

    protected void initialize(String regionDescriptName) {
        theCache = CacheHelper.createCache("cache1");
        String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
        Log.getLogWriter().info("Creating region " + regionName);
        RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
        String poolName = attributes.getPoolName();
        if (poolName != null) {
            PoolHelper.createPool(poolName);
        }
        aRegion = theCache.createRegion(regionName, attributes);
        Log.getLogWriter().info("Completed creating region " + aRegion.getName());
    }

    protected void populateRegion(Region region) {
        for (int i = 0; i < 50; ++i) {
            String keyName = "Key " + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations);
            Integer value = new Integer(i);
            region.put((Object)keyName, (Object)value);
        }
        Log.getLogWriter().info("Completed put for 50 keys and region size is " + region.size());
    }

    protected void populateRegionWithCustomPartition(Region region) {
        for (int i = 0; i < 50; ++i) {
            String keyName = "Key " + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations);
            Month routingObjectHolder = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            KeyResolver key = new KeyResolver(keyName, routingObjectHolder);
            Integer value = new Integer(i);
            region.put((Object)key, (Object)value);
        }
        Log.getLogWriter().info("Completed put for 50 keys and region size is " + region.size());
    }

    protected void updateBBWithNodes(Region region) {
        HashSet allBucketIds;
        if (!(region instanceof PartitionedRegion)) {
            throw new TestException("This test should be using partitioned region");
        }
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        String localVM = ds.getDistributedMember().getId();
        List bucketListOnNode = ((PartitionedRegion)region).getLocalBucketsListTestOnly();
        ParRegBB.getBB().getSharedMap().put(localVM, bucketListOnNode);
        if (ParRegBB.getBB().getSharedMap().get(ALL_BUCKET_IDS) == null) {
            allBucketIds = new HashSet();
            allBucketIds.addAll(bucketListOnNode);
        } else {
            allBucketIds = (HashSet)ParRegBB.getBB().getSharedMap().get(ALL_BUCKET_IDS);
            allBucketIds.addAll(bucketListOnNode);
        }
        ParRegBB.getBB().getSharedMap().put(ALL_BUCKET_IDS, allBucketIds);
    }

    protected void doRegionFunction(Region region) {
        ArrayList list;
        ResultSenderFunction function = new ResultSenderFunction();
        Set keySet = region.keySet();
        Execution dataSet = FunctionService.onRegion((Region)region).withFilter(keySet).withCollector((ResultCollector)new BBResultCollector());
        try {
            list = (ArrayList)dataSet.execute((Function)new ResultSenderFunction()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Function execution failed with exception ", e);
        }
        if (list.size() - 1 != keySet.size()) {
            throw new TestException("The getResult should have returned the list of size " + keySet.size() + " size of filter but returned " + (list.size() - 1));
        }
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.resultSenderCounter);
    }

    protected void doNodePruningRegionFunction(Region region) {
        this.verifyExecuteLocally(region);
        this.verifyExecuteSingleRemoteNode(region);
        this.verifyExecuteOnAllBuckets(region);
    }

    protected void verifyExecuteSingleRemoteNode(Region region) {
        Log.getLogWriter().info("verifyExecuteSingleRemoteNode");
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        HashSet allMemberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
        InternalDistributedMember localVM = ds.getDistributionManager().getDistributionManagerId();
        allMemberSet.remove(localVM);
        Iterator iterator = allMemberSet.iterator();
        while (iterator.hasNext()) {
            ArrayList list;
            String node = ((InternalDistributedMember)iterator.next()).toString();
            ArrayList bucketsOnNode = (ArrayList)ParRegBB.getBB().getSharedMap().get(node);
            Log.getLogWriter().info("Filter set is for the buckets on node " + node + " who have buckets " + bucketsOnNode);
            HashSet keySet = new HashSet();
            Iterator iterator1 = bucketsOnNode.iterator();
            while (iterator1.hasNext()) {
                int bucketId = (Integer)iterator1.next();
                try {
                    keySet.addAll(((PartitionedRegion)region).getBucketKeys(bucketId));
                }
                catch (Exception e) {
                    throw new TestException("Test issue: Caught the exception ", e);
                }
            }
            HashSet<String> keySetHashCodes = new HashSet<String>();
            for (KeyResolver key : keySet) {
                keySetHashCodes.add(key.getRoutingHint().toString());
            }
            Log.getLogWriter().info("Partition resolvers for the keySet : " + keySetHashCodes.toString());
            Execution dataSet = FunctionService.onRegion((Region)region).withFilter(keySet).withCollector((ResultCollector)new ArrayListResultCollector());
            try {
                list = (ArrayList)dataSet.execute((Function)new NodePruningFunction()).getResult();
            }
            catch (Exception e) {
                throw new TestException("Function execution failed with exception ", e);
            }
            ParRegBB.getBB().printSharedMap();
            if (list.size() == 1) continue;
            throw new TestException("This function Should have executed only on 1 node " + node + " but executed on " + list);
        }
    }

    protected void verifyExecuteOnAllBuckets(Region region) {
        ArrayList list;
        Log.getLogWriter().info("verifyExecuteOnAllBuckets");
        Log.getLogWriter().info("Function to be executed on buckets all buckets");
        ArrayList allBucketIds = new ArrayList();
        HashSet allBuckets = (HashSet)ParRegBB.getBB().getSharedMap().get(ALL_BUCKET_IDS);
        allBucketIds.addAll(allBuckets);
        if (allBucketIds.size() != 12) {
            throw new TestException("With custom partitioning on, the total number of buckets should be 12 but the buckets are " + allBucketIds);
        }
        Execution dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            list = (ArrayList)dataSet.execute((Function)new NodePruningFunction()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Function execution failed with exception ", e);
        }
        Log.getLogWriter().info("The list is " + list);
        List optimumNodes = this.getOptimumNodeList(allBucketIds);
        ParRegBB.getBB().printSharedMap();
        if (list.size() > optimumNodes.size()) {
            throw new TestException("This function (execute on all buckets - without filter) should have executed on " + optimumNodes.size() + " nodes (" + optimumNodes + ") but executed on " + list.size() + " nodes (" + list + ")");
        }
        Log.getLogWriter().info("Execution on number of nodes " + list.size() + " (" + list + ") and the test calculated " + optimumNodes.size() + " nodes (" + optimumNodes + ")");
    }

    protected void verifyRandomFilter(Region region) {
        ArrayList list;
        List bucketIds;
        Log.getLogWriter().info("verifyRandomFilter");
        HashSet keySet = new HashSet();
        while ((bucketIds = this.getRandomBucketIds(12)).size() == 0) {
        }
        Iterator iterator1 = bucketIds.iterator();
        while (iterator1.hasNext()) {
            int bucketId = (Integer)iterator1.next();
            try {
                keySet.addAll(((PartitionedRegion)region).getBucketKeys(bucketId));
            }
            catch (Exception e) {
                throw new TestException("Test issue: Caught the exception ", e);
            }
        }
        Log.getLogWriter().info("Function to be executed on buckets " + bucketIds);
        HashSet<String> keySetHashCodes = new HashSet<String>();
        for (KeyResolver key : keySet) {
            keySetHashCodes.add(key.getRoutingHint().toString());
        }
        Log.getLogWriter().info("Partition resolvers for the keySet : " + keySetHashCodes.toString());
        Execution dataSet = FunctionService.onRegion((Region)region).withFilter(keySet).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            list = (ArrayList)dataSet.execute((Function)new NodePruningFunction()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Function execution failed with exception ", e);
        }
        Log.getLogWriter().info("The list is " + list);
        List optimumNodes = this.getOptimumNodeList(bucketIds);
        ParRegBB.getBB().printSharedMap();
        if (list.size() > optimumNodes.size()) {
            throw new TestException("This function with routing Objects " + keySetHashCodes + " could have executed on " + optimumNodes + " but executed on " + list);
        }
        Log.getLogWriter().info("Execution on number of nodes " + list.size() + " (" + list + ") and the test calculated " + optimumNodes.size() + " nodes (" + optimumNodes + ")");
    }

    protected List getOptimumNodeList(List bucketIds) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        HashSet allMemberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
        ArrayList<String> optimumNodeList = new ArrayList<String>();
        while (bucketIds.size() != 0) {
            Iterator memberSetIterator = allMemberSet.iterator();
            String bestNode = "";
            int numOfBucketsOnBestNode = 0;
            HashMap<String, ArrayList> bucketMap = new HashMap<String, ArrayList>();
            while (memberSetIterator.hasNext()) {
                String node = ((InternalDistributedMember)memberSetIterator.next()).toString();
                ArrayList bucketsOnNode = (ArrayList)ParRegBB.getBB().getSharedMap().get(node);
                bucketsOnNode.retainAll(bucketIds);
                bucketMap.put(node, bucketsOnNode);
                if (bucketsOnNode.size() <= numOfBucketsOnBestNode) continue;
                numOfBucketsOnBestNode = bucketsOnNode.size();
                bestNode = node;
            }
            optimumNodeList.add(bestNode);
            bucketIds.removeAll((List)bucketMap.get(bestNode));
        }
        return optimumNodeList;
    }

    protected void verifyExecuteLocally(Region region) {
        ArrayList list;
        Log.getLogWriter().info("verifyExecuteLocally");
        List bucketListOnLocalNode = ((PartitionedRegion)region).getLocalBucketsListTestOnly();
        HashSet keySet = new HashSet();
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        String localVM = ds.getDistributedMember().getId();
        Iterator iterator = bucketListOnLocalNode.iterator();
        while (iterator.hasNext()) {
            int bucketId = (Integer)iterator.next();
            try {
                keySet.addAll(((PartitionedRegion)region).getBucketKeys(bucketId));
            }
            catch (Exception e) {
                throw new TestException("Test issue: Caught the exception ", e);
            }
        }
        Execution dataSet = FunctionService.onRegion((Region)region).withFilter(keySet).withArgs((Object)localVM).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            list = (ArrayList)dataSet.execute((Function)new NodePruningFunction()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Function execution failed with exception ", e);
        }
        if (list.size() != 1) {
            throw new TestException("This function Should have executed only on 1 node " + localVM + " but executed on " + list);
        }
    }

    protected List getRandomBucketIds(int maxBucketId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        long now = System.currentTimeMillis();
        Random rand = new Random(now);
        for (int i = 1; i <= 12; ++i) {
            if (!rand.nextBoolean()) continue;
            list.add(i);
        }
        return list;
    }
}

