/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute.useCase1;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import parReg.execute.useCase1.FxRate;
import parReg.execute.useCase1.Hierarchy;
import parReg.execute.useCase1.ImntRiskSensitivity;
import parReg.execute.useCase1.Instrument;
import parReg.execute.useCase1.Position;
import parReg.execute.useCase1.PositionRisk;
import parReg.execute.useCase1.PositionUndRisk;
import parReg.execute.useCase1.RiskPartitionKey;
import parReg.execute.useCase1.UndRiskSensitivity;
import parReg.execute.useCase1.UseCase1;
import parReg.execute.useCase1.UseCase1Function;

public class RiskCalcListener
extends CacheListenerAdapter
implements Declarable {
    public static final String DELT = "DELT";
    public static final String VEGA = "VEGA";
    public static final String GAMM = "GAMM";
    public static final String STK = "STK";
    public static final String XFX = "XFX";
    long totalTime = 0L;

    public void afterCreate(EntryEvent event) {
        this.afterUpdate(event);
    }

    public void afterUpdate(EntryEvent event) {
        int i;
        if (event.getNewValue() == null) {
            return;
        }
        RiskPartitionKey eventKey = (RiskPartitionKey)event.getKey();
        if (eventKey.getType() != 0) {
            return;
        }
        Position position = (Position)event.getNewValue();
        Log.getLogWriter().info("Listener invoked for Position " + position);
        Log.getLogWriter().info("Instrument id is " + position.id_imnt);
        String irsKey = new StringBuffer().append(position.id_imnt).append("|VEGA").toString();
        ImntRiskSensitivity irs = (ImntRiskSensitivity)UseCase1.getInstrumentSensitivityRegion().get((Object)new RiskPartitionKey(irsKey, position.id_imnt, 3));
        Log.getLogWriter().info("Doing get with " + new RiskPartitionKey(irsKey, position.id_imnt, 3));
        Log.getLogWriter().info("Region size is " + UseCase1.getInstrumentSensitivityRegion().size());
        Log.getLogWriter().info("In Listener Received Instrument Risk sensitivity : " + irs);
        if (irs == null) {
            return;
        }
        float am_exp_rsk = irs.am_exp_rsk;
        Log.getLogWriter().info("am_exp_rsk value is " + am_exp_rsk);
        Instrument instrument = (Instrument)UseCase1.getInstrumentRegion().get((Object)new RiskPartitionKey(String.valueOf(position.id_imnt), position.id_imnt, 2));
        Log.getLogWriter().info("In Listener Received Instrument : " + instrument);
        if (instrument == null) {
            return;
        }
        String fxKey = instrument.id_ccy_main + "|USD";
        Region fxRateRegion = UseCase1.getFxRateRegion();
        FxRate rate = (FxRate)fxRateRegion.get((Object)fxKey);
        Log.getLogWriter().info("In Listener Received fxRate : " + rate);
        if (rate == null) {
            return;
        }
        float fx_mult = rate.rt_fx;
        PositionRisk positionRisk = new PositionRisk();
        positionRisk.id_posn_new = position.id_posn_new;
        positionRisk.am_fv = position.am_posn * am_exp_rsk * fx_mult * instrument.am_sz_ctrt;
        PartitionedRegion undSensitivityRegion = UseCase1.getUndSensitivityRiskRegion();
        UseCase1Function useCase1Function = new UseCase1Function();
        FunctionService.registerFunction((Function)useCase1Function);
        ArrayList ursList = null;
        try {
            HashSet<RiskPartitionKey> set = new HashSet<RiskPartitionKey>();
            set.add(eventKey);
            Execution ds = FunctionService.onRegion((Region)undSensitivityRegion).withFilter(set).withArgs((Object)new Integer(position.id_imnt));
            ursList = (ArrayList)ds.execute((Function)useCase1Function).getResult();
            Log.getLogWriter().info("List size is " + ursList.size());
            Log.getLogWriter().info("List is " + ursList.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ursList == null) {
            return;
        }
        ArrayList combinedList = new ArrayList();
        for (int i2 = 0; i2 < ursList.size(); ++i2) {
            combinedList.addAll((List)ursList.get(i2));
        }
        PositionUndRisk[] undRisks = new PositionUndRisk[combinedList.size()];
        for (i = 0; i < combinedList.size(); ++i) {
            Log.getLogWriter().info("The list has " + (UndRiskSensitivity)combinedList.get(i));
            String undKey = new StringBuffer().append(position.id_imnt).append("|").append(((UndRiskSensitivity)combinedList.get((int)i)).id_imnt_und).append("|DELT").toString();
            UndRiskSensitivity und = (UndRiskSensitivity)UseCase1.getUndSensitivityRiskRegion().get((Object)new RiskPartitionKey(undKey, position.id_imnt, 4));
            Log.getLogWriter().info("In Listener, received UndRiskSensitivity " + und);
            if (und == null) {
                return;
            }
            float und_price = und.am_exp_rsk;
            undRisks[i] = new PositionUndRisk();
            undRisks[i].id_posn_new = position.id_posn_new;
            undRisks[i].id_imnt_und = ((UndRiskSensitivity)combinedList.get((int)i)).id_imnt_und;
            undRisks[i].id_param_rsk = ((UndRiskSensitivity)combinedList.get((int)i)).id_param_rsk;
            undRisks[i].am_risk = position.am_posn * ((UndRiskSensitivity)combinedList.get((int)i)).am_exp_rsk * fx_mult * instrument.am_sz_ctrt * und_price;
        }
        positionRisk.am_delta = 0;
        positionRisk.am_delta_avg = 0;
        positionRisk.am_delta_equity = 0;
        positionRisk.am_delta_ccy = 0;
        positionRisk.am_vega = 0;
        positionRisk.am_gamma = 0;
        for (i = 0; i < undRisks.length; ++i) {
            float thisRiskDelta = undRisks[i].am_risk;
            if (undRisks[i].id_param_rsk.equals(DELT)) {
                positionRisk.am_delta = (int)((float)positionRisk.am_delta + thisRiskDelta);
                Instrument undInst = (Instrument)event.getRegion().get((Object)new RiskPartitionKey(String.valueOf(undRisks[i].id_imnt_und), undRisks[i].id_imnt_und, 2));
                if (undInst == null) {
                    undInst = instrument;
                }
                if (undInst.id_typ_imnt.equals(STK)) {
                    positionRisk.am_delta_equity = (int)((float)positionRisk.am_delta_equity + thisRiskDelta);
                }
                if (undInst.id_typ_imnt.equals(XFX)) {
                    positionRisk.am_delta_ccy = (int)((float)positionRisk.am_delta_ccy + thisRiskDelta);
                }
            }
            if (undRisks[i].id_param_rsk.equals(VEGA)) {
                positionRisk.am_vega = (int)((float)positionRisk.am_vega + thisRiskDelta);
            }
            if (!undRisks[i].id_param_rsk.equals(GAMM)) continue;
            positionRisk.am_gamma = (int)((float)positionRisk.am_gamma + thisRiskDelta);
        }
        if (undRisks.length == 0) {
            positionRisk.am_delta_avg = 0;
        } else {
            positionRisk.am_delta_avg = positionRisk.am_delta / undRisks.length;
            Log.getLogWriter().info("Calculating the average : " + positionRisk.am_delta + "/" + undRisks.length + "=" + positionRisk.am_delta_avg);
        }
        Log.getLogWriter().info("Postion risk values : positionRisk.am_delta " + positionRisk.am_delta + " positionRisk.am_delta_avg " + positionRisk.am_delta_avg + " positionRisk.am_delta_equity " + positionRisk.am_delta_equity + " positionRisk.am_delta_ccy " + positionRisk.am_delta_ccy + " positionRisk.am_vega " + positionRisk.am_vega + " positionRisk.am_gamma " + positionRisk.am_gamma);
        Hierarchy hierarchy = (Hierarchy)UseCase1.getHierarchyRegion().get((Object)String.valueOf(position.id_book));
        if (hierarchy == null) {
            return;
        }
        positionRisk.id_book = hierarchy.id_book;
        positionRisk.id_prtf = hierarchy.id_prtf;
        positionRisk.id_country = hierarchy.id_country;
        positionRisk.id_desk = hierarchy.id_desk;
        for (int i3 = 0; i3 < undRisks.length; ++i3) {
            undRisks[i3].id_desk = hierarchy.id_desk;
            undRisks[i3].id_country = hierarchy.id_country;
            undRisks[i3].id_prtf = hierarchy.id_prtf;
            undRisks[i3].id_sector = instrument.id_sector;
            Log.getLogWriter().info("undRisks[" + i3 + "] has the value " + undRisks[i3].toString());
        }
        PartitionedRegion posRiskRegion = UseCase1.getPositionRiskRegion();
        PartitionedRegion posUndRiskRegion = UseCase1.getPositionUndRiskRegion();
        Log.getLogWriter().info("Putting in the position Risk region with key " + positionRisk.id_posn_new + " and value " + positionRisk + " in the region " + posRiskRegion.getPartitionAttributes());
        posRiskRegion.put((Object)new Integer(positionRisk.id_posn_new), (Object)positionRisk);
        Log.getLogWriter().info("Did put in the position Risk region with key " + positionRisk.id_posn_new + " and value " + positionRisk);
        for (int i4 = 0; i4 < undRisks.length; ++i4) {
            StringBuffer key = new StringBuffer();
            key.append(undRisks[i4].id_posn_new);
            key.append("|");
            key.append(undRisks[i4].id_imnt_und);
            key.append("|");
            key.append(undRisks[i4].id_param_rsk);
            Log.getLogWriter().info("Putting in the position Und Risk region with key " + key.toString() + " and value " + undRisks[i4]);
            posUndRiskRegion.put((Object)key.toString(), (Object)undRisks[i4]);
        }
    }

    public void init(Properties arg0) {
    }
}

