/*
 * Decompiled with CFR 0.152.
 */
package parReg.fixedPartitioning;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.FixedPartitionBlackboard;
import hydra.FixedPartitionPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PartitionPrms;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.colocation.Month;
import parReg.execute.FunctionServiceTest;
import parReg.fixedPartitioning.FixedKeyResolver;
import parReg.fixedPartitioning.FixedPartitioningTest;
import util.NameFactory;
import util.PRObserver;
import util.TestException;

public class FPREvictionTest
extends FixedPartitioningTest {
    protected static final int HEAVY_OBJECT_SIZE_VAL = 500;

    public static void StartTask_initialize() {
        HydraVector fixedPartitions = TestConfig.tab().vecAt(FixedPartitionPrms.partitionNames);
        int redundantCopies = TestConfig.tab().intAt(PartitionPrms.redundantCopies);
        ArrayList secondaryFixedPartitions = new ArrayList();
        for (int i = 0; i < redundantCopies; ++i) {
            secondaryFixedPartitions.addAll(fixedPartitions);
        }
        FixedPartitionBlackboard.getInstance().getSharedMap().put("PrimaryPartitions", fixedPartitions);
        FixedPartitionBlackboard.getInstance().getSharedMap().put("SecondaryPartitions", secondaryFixedPartitions);
    }

    public static synchronized void HydraTask_p2p_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new FPREvictionTest();
            isBridgeClient = false;
            FPREvictionTest.setDataStoreSequenceId();
            ((FixedPartitioningTest)testInstance).initialize("dataStore");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
        }
    }

    public static synchronized void HydraTask_p2p_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new FPREvictionTest();
            isBridgeClient = false;
            ((FixedPartitioningTest)testInstance).initialize("accessor");
        }
    }

    public static void HydraTask_populateRegions() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            ((FPREvictionTest)testInstance).populateRegion(aRegion);
        }
    }

    @Override
    public void initialize(String regionDescription) {
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String cacheXmlFile = key + ".xml";
        File aFile = new File(cacheXmlFile);
        if (!aFile.exists()) {
            theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
            for (String rName : regionNames) {
                String regionName = RegionHelper.getRegionDescription(rName).getRegionName();
                if (rName.equalsIgnoreCase("rootRegion") && regionDescription.equalsIgnoreCase("dataStore")) {
                    rootRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
                    rootRegion.createSubregion("subRegion", RegionHelper.getRegionAttributes("subRegion"));
                    continue;
                }
                if (rName.equalsIgnoreCase("aRootRegion") && regionDescription.equalsIgnoreCase("accessor")) {
                    rootRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
                    rootRegion.createSubregion("subRegion", RegionHelper.getRegionAttributes("aSubRegion"));
                    continue;
                }
                if (!rName.startsWith(regionDescription)) continue;
                RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
            }
            ((FunctionServiceTest)testInstance).registerFunctions();
            this.createXmlFile(aFile);
        } else {
            this.createCacheFromXml(cacheXmlFile);
        }
    }

    protected void populateRegion(Region aRegion) {
        Log.getLogWriter().info("Putting 50 entries into " + aRegion.getFullPath());
        for (int i = 1; i <= 50; ++i) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            String keyName = NameFactory.getNextPositiveObjectName();
            FixedKeyResolver key = new FixedKeyResolver(keyName, callBackArg);
            byte[] newVal = new byte[250000];
            aRegion.put((Object)key, (Object)newVal);
            MasterController.sleepForMs(10);
        }
    }

    public static void HydraTask_verifyEvictionLocalDestroy() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            ((FPREvictionTest)testInstance).verifyEvictionLocalDestroy(pr);
        }
    }

    protected void verifyEvictionLocalDestroy(PartitionedRegion aRegion) {
        if (aRegion.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        double numEvicted = 0.0;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Iterator iterator = bucketList.iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket != null) {
                Log.getLogWriter().info("For the bucket " + localBucket.getName() + " evicted entries are " + localBucket.getEvictions());
                count += localBucket.getEvictions();
            }
            if (bucketList.size() <= 0 || count != 0L) continue;
            throw new TestException("No eviction happened in the test");
        }
    }
}

