/*
 * Decompiled with CFR 0.152.
 */
package parReg.fixedPartitioning;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ConfigPrms;
import hydra.FixedPartitionBlackboard;
import hydra.FixedPartitionPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PartitionPrms;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import parReg.colocation.Month;
import parReg.colocation.ParRegColocation;
import parReg.execute.FunctionServiceTest;
import parReg.execute.KeysOperationsFunction;
import parReg.execute.LocalDataSetFunctionPrimaryExecute;
import parReg.execute.LocalDataSetFunctionPrimaryExecuteFalse;
import parReg.execute.MemberResultsCollector;
import parReg.execute.PartitionObjectHolder;
import parReg.execute.PrimaryExecutionFunction;
import parReg.execute.RegionOperationsFunction;
import parReg.fixedPartitioning.FixedKeyResolver;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class FixedPartitioningTest
extends FunctionServiceTest {
    protected static Long dataStoreSequenceId;
    public final String PRIMARY_PARTITIONS = "primary_partitions_";
    public final String SECONDARY_PARTITIONS = "secondary_partitions_";
    public final String PRIMARY_BUCKETS = "primary_buckets_";
    public final String ALL_BUCKETS = "all_buckets_";
    public static final String DATASTORE_SEQUENCE_ID = "dataStore_sequence_id_";
    public static Region rootRegion;

    public static void StartTask_initialize() {
        ParRegColocation.StartTask_initialize();
        HydraVector primaryPartitions = TestConfig.tab().vecAt(FixedPartitionPrms.partitionNames);
        int redundantCopies = TestConfig.tab().intAt(PartitionPrms.redundantCopies);
        ArrayList secondaryPartitions = new ArrayList();
        for (int i = 0; i < redundantCopies; ++i) {
            secondaryPartitions.addAll(primaryPartitions);
        }
        Log.getLogWriter().info("RedundantCopies is " + redundantCopies);
        Log.getLogWriter().info("PrimaryPartitions are " + primaryPartitions);
        Log.getLogWriter().info("Secondary partitions are " + secondaryPartitions);
        FixedPartitionBlackboard.getInstance().getSharedMap().put("PrimaryPartitions", primaryPartitions);
        FixedPartitionBlackboard.getInstance().getSharedMap().put("SecondaryPartitions", secondaryPartitions);
    }

    public static synchronized void HydraTask_p2p_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new FixedPartitioningTest();
            isBridgeClient = false;
            FixedPartitioningTest.setDataStoreSequenceId();
            ((FixedPartitioningTest)testInstance).initialize("dataStore");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
        }
    }

    public static synchronized void HydraTask_p2p_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new FixedPartitioningTest();
            isBridgeClient = false;
            ((FixedPartitioningTest)testInstance).initialize("accessor");
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new FixedPartitioningTest();
            isBridgeClient = false;
            FixedPartitioningTest.setDataStoreSequenceId();
            String key = "VmId_" + RemoteTestModule.getMyVmid();
            String cacheXmlFile = key + ".xml";
            File aFile = new File(cacheXmlFile);
            if (!aFile.exists()) {
                theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
                BridgeHelper.startBridgeServer("bridge");
            }
            ((FixedPartitioningTest)testInstance).initialize("dataStore");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            isBridgeConfiguration = true;
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new FixedPartitioningTest();
            ((FixedPartitioningTest)testInstance).initialize("accessor");
            Pool pool = PoolHelper.createPool("edgeDescript");
            isBridgeConfiguration = true;
        }
    }

    public static void HydraTask_loadRegions() {
        ((FixedPartitioningTest)testInstance).loadRegions();
    }

    public static void HydraTask_updateBBWithPartitionInfo() {
        ((FixedPartitioningTest)testInstance).updateBBWithPartitionInfo();
    }

    public static void HydraTask_loadRegionsWithFuncExec() {
        ((FixedPartitioningTest)testInstance).loadRegionsWithFuncExec();
    }

    public static synchronized void HydraTask_registerInterest() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            ParRegUtil.registerInterest(aRegion);
            Log.getLogWriter().info("registered interest for the region " + aRegion.getName());
        }
    }

    public static void HydraTask_stopStartVms() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            ((FixedPartitioningTest)testInstance).stopStartVms();
            long timeToStop = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
            if (timeToStop <= 0L) continue;
            throw new StopSchedulingTaskOnClientOrder("Ops have completed");
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    public static void HydraTask_recycleClientAndValidateBehavior() {
        ((FixedPartitioningTest)testInstance).recycleClientAndValidateBehavior();
    }

    public static void HydraTask_verifyPRMetaData() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            String regionName = aRegion.getName();
            if (aRegion instanceof PartitionedRegion) {
                FixedPartitioningTest.verifyPRMetaData(aRegion);
                Log.getLogWriter().info("verified Meta Data for the region " + regionName);
                continue;
            }
            Log.getLogWriter().info("The region " + regionName + " is not partitioned region and hence need not verify metadata");
        }
    }

    public static void HydraTask_verifyRegionSize() {
        ((FixedPartitioningTest)testInstance).Task_verifyRegionSize();
    }

    @Override
    public void Task_verifyRegionSize() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.verifyRegionSize(aRegion);
            Log.getLogWriter().info("verified Region size for the region " + aRegion.getName());
        }
    }

    @Override
    public void initialize(String regionDescriptName) {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String cacheXmlFile = key + ".xml";
        File aFile = new File(cacheXmlFile);
        if (!aFile.exists()) {
            theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
            for (String rName : regionNames) {
                String regionName;
                if (rName.startsWith(regionDescriptName)) {
                    regionName = RegionHelper.getRegionDescription(rName).getRegionName();
                    RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
                    continue;
                }
                if (rName.equalsIgnoreCase("rootRegion") && regionDescriptName.equalsIgnoreCase("dataStore")) {
                    regionName = RegionHelper.getRegionDescription(rName).getRegionName();
                    rootRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
                    rootRegion.createSubregion("subRegion", RegionHelper.getRegionAttributes("subRegion"));
                    continue;
                }
                if (!rName.equalsIgnoreCase("aRootRegion") || !regionDescriptName.equalsIgnoreCase("accessor")) continue;
                regionName = RegionHelper.getRegionDescription(rName).getRegionName();
                rootRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
                rootRegion.createSubregion("subRegion", RegionHelper.getRegionAttributes("aSubRegion"));
            }
            ((FunctionServiceTest)testInstance).registerFunctions();
            this.createXmlFile(aFile);
        } else {
            this.createCacheFromXml(cacheXmlFile);
        }
    }

    public void createXmlFile(File aFile) {
        if (!aFile.exists()) {
            try {
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(aFile), true);
                CacheXmlGenerator.generate((Cache)theCache, (PrintWriter)pw);
                pw.close();
            }
            catch (IOException ex) {
                throw new TestException("IOException during cache.xml generation to " + aFile + " : ", ex);
            }
        }
    }

    public void createCacheFromXml(String cacheXmlFile) {
        Log.getLogWriter().info("Creating cache using the xml file " + cacheXmlFile);
        theCache = CacheHelper.createCacheFromXml(cacheXmlFile);
    }

    @Override
    public void registerFunctions() {
        FunctionService.registerFunction((Function)new RegionOperationsFunction());
        FunctionService.registerFunction((Function)new KeysOperationsFunction());
        FunctionService.registerFunction((Function)new LocalDataSetFunctionPrimaryExecute());
        FunctionService.registerFunction((Function)new LocalDataSetFunctionPrimaryExecuteFalse());
        FunctionService.registerFunction((Function)new PrimaryExecutionFunction());
    }

    @Override
    protected void loadRegions() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = this.sc.incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, for Region shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate;
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            try {
                Object value = this.getValueToAdd(key);
                Month callBackArg = Month.months[(int)(shouldAddCount % 12L)];
                Log.getLogWriter().info("Callback arg is " + callBackArg.toString() + " which has hashCode " + callBackArg.hashCode());
                InitImageBB.getBB().getSharedMap().put(key, callBackArg);
                Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
                for (Region<?, ?> aRegion : regionSet) {
                    Log.getLogWriter().info("Region is :" + aRegion);
                    Log.getLogWriter().info("Doing put in region " + aRegion.getName() + "for key value " + key.toString() + " " + value.toString());
                    aRegion.put((Object)key, value);
                    Log.getLogWriter().info("The region size is for " + aRegion.getName() + " is " + aRegion.size());
                }
                this.sc.increment(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + " out of " + numKeysToCreate);
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected void loadRegionsWithFuncExec() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = this.sc.incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, for Region shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate;
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            try {
                Object value = this.getValueToAdd(key);
                if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                    Month callBackArg = Month.months[(int)(shouldAddCount % 12L)];
                    Log.getLogWriter().info("Callback arg is " + callBackArg.toString() + " which has hashCode " + callBackArg.hashCode());
                    InitImageBB.getBB().getSharedMap().put(key, callBackArg);
                    Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
                    for (Region<?, ?> aRegion : regionSet) {
                        Log.getLogWriter().info("Doing put in region " + aRegion.getName() + " for key value " + key.toString() + " " + value.toString());
                        this.addNewKeyFunction(aRegion, key);
                        Log.getLogWriter().info("The region size is " + aRegion.size() + " region is " + aRegion.getName());
                    }
                }
                this.sc.increment(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + " out of " + numKeysToCreate);
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    public static void HydraTask_putKeySetInBB() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            boolean isKeySetInBB = testInstance.putKeySetInBB(aRegion);
            if (!isKeySetInBB) continue;
            return;
        }
    }

    public static void HydraTask_doFireAndForgetExecutions() {
        FixedPartitioningTest.doOnRegionFireAndForgetExecutions();
        if (isBridgeConfiguration) {
            FunctionServiceTest.doFireAndForgetServerExecutions();
        } else {
            FunctionServiceTest.doFireAndForgetMemberExecutions();
        }
    }

    public static void doOnRegionFireAndForgetExecutions() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            Execution dataSet = FunctionService.onRegion(aRegion);
            HashSet<String> keySet = new HashSet<String>();
            if (System.currentTimeMillis() % 2L == 0L) {
                Log.getLogWriter().info("Doing onRegion() fire and forget execution using single key");
                String key = NameFactory.getNextPositiveObjectName();
                Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                InitImageBB.getBB().getSharedMap().put(key, callBackArg);
                keySet.add(key);
            } else {
                Log.getLogWriter().info("Doing onRegion() fire and forget execution using multiple keys");
                String key1 = NameFactory.getNextPositiveObjectName();
                String key2 = NameFactory.getNextPositiveObjectName();
                String key3 = NameFactory.getNextPositiveObjectName();
                String key4 = NameFactory.getNextPositiveObjectName();
                Month callBackArg1 = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                Month callBackArg2 = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                Month callBackArg3 = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                Month callBackArg4 = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                InitImageBB.getBB().getSharedMap().put(key1, callBackArg1);
                InitImageBB.getBB().getSharedMap().put(key2, callBackArg2);
                InitImageBB.getBB().getSharedMap().put(key3, callBackArg3);
                InitImageBB.getBB().getSharedMap().put(key4, callBackArg4);
                keySet.add(key1);
                keySet.add(key2);
                keySet.add(key3);
                keySet.add(key4);
            }
            try {
                dataSet.withFilter(keySet).execute((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        if (context instanceof RegionFunctionContext) {
                            RegionFunctionContext prContext = (RegionFunctionContext)context;
                            Log.getLogWriter().info("Inside FireAndForget PartitionedRegionFunctionContext execute");
                            Set keySet = prContext.getFilter();
                            Log.getLogWriter().info("got the filer set " + keySet.toString());
                            PartitionedRegion pr = (PartitionedRegion)prContext.getDataSet();
                            for (Object key : keySet) {
                                RandomValues randomValues = new RandomValues();
                                ValueHolder value = new ValueHolder((String)key, randomValues);
                                pr.put(key, (Object)value);
                                Log.getLogWriter().info("Did put using execute..");
                            }
                        }
                    }

                    public String getId() {
                        return "" + ((Object)((Object)this)).hashCode();
                    }

                    public boolean hasResult() {
                        return false;
                    }

                    public boolean optimizeForWrite() {
                        return true;
                    }

                    public boolean isHA() {
                        return false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TestException("Caught the exception during execute " + e);
            }
        }
    }

    public static void HydraTask_doRandomFuncExec() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            FixedPartitioningTest.doRandomFunctionExecutions(aRegion);
            Log.getLogWriter().info("Random function execution on the region " + aRegion.getName());
        }
        long timeToStop = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (timeToStop > 0L) {
            throw new StopSchedulingTaskOnClientOrder("Ops have completed");
        }
    }

    public static void HydraTask_doOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 7);
        ((FixedPartitioningTest)testInstance).doOps(availableOps);
        Log.getLogWriter().info("Cardinality is " + availableOps.cardinality());
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    @Override
    protected boolean addNewKey() {
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from addNewKey()");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(key, callBackArg);
        }
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.addNewKey(aRegion, key);
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    @Override
    protected boolean addNewKeyFunction() {
        Log.getLogWriter().info("Inside addNewKeyFunction()");
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from addNewKeyFunction()");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(key, callBackArg);
        }
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.addNewKeyFunction(aRegion, key);
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    @Override
    protected boolean invalidateFunction() {
        Log.getLogWriter().info("Inside invalidateFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1001, nextKey)) {
            Log.getLogWriter().info("All existing keys invalidated; returning from invalidate Function execution");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.invalidateFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1001);
    }

    @Override
    protected boolean invalidate() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1001, nextKey)) {
            Log.getLogWriter().info("All existing keys invalidated; returning from invalidate operation");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.invalidate(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1001);
    }

    @Override
    protected boolean localInvalidateFunction() {
        Log.getLogWriter().info("Inside localInvalidateFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1002, nextKey)) {
            Log.getLogWriter().info("All local invalidates completed; returning from localInvalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.localInvalidateFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1002);
    }

    @Override
    protected boolean localInvalidate() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1002, nextKey)) {
            Log.getLogWriter().info("All local invalidates completed; returning from localInvalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.localInvalidate(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1002);
    }

    @Override
    protected boolean destroyFunction() {
        Log.getLogWriter().info("Inside destroyFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_DESTROY);
        if (!this.keyIntervals.keyInRange(1003, nextKey)) {
            Log.getLogWriter().info("All destroys completed; returning from destroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.destroyFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1003);
    }

    @Override
    protected boolean destroy() {
        Log.getLogWriter().info("Inside destroy()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_DESTROY);
        if (!this.keyIntervals.keyInRange(1003, nextKey)) {
            Log.getLogWriter().info("All destroys completed; returning from destroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.destroy(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1003);
    }

    @Override
    protected boolean localDestroyFunction() {
        Log.getLogWriter().info("Inside localDestroyFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_DESTROY);
        if (!this.keyIntervals.keyInRange(1004, nextKey)) {
            Log.getLogWriter().info("All local destroys completed; returning from localDestroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.localDestroyFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1004);
    }

    @Override
    protected boolean localDestroy() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_DESTROY);
        if (!this.keyIntervals.keyInRange(1004, nextKey)) {
            Log.getLogWriter().info("All local destroys completed; returning from localDestroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.localDestroy(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1004);
    }

    @Override
    protected boolean updateExistingKeyFunction() {
        Log.getLogWriter().info("Inside update Function()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY);
        if (!this.keyIntervals.keyInRange(1005, nextKey)) {
            Log.getLogWriter().info("All existing keys updated; returning from updateExistingKey");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.updateFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1005);
    }

    @Override
    protected boolean updateExistingKey() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY);
        if (!this.keyIntervals.keyInRange(1005, nextKey)) {
            Log.getLogWriter().info("All existing keys updated; returning from updateExistingKey");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.updateExistingKey(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1005);
    }

    @Override
    protected boolean getFunction() {
        Log.getLogWriter().info("Inside getFunction()");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_GET);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All gets completed; returning from get");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.getFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    @Override
    protected boolean get() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_GET);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All gets completed; returning from get");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.get(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    @Override
    protected boolean queryFunction() {
        Log.getLogWriter().info("queryFunction");
        long nextKey = this.sc.incrementAndRead(InitImageBB.LAST_QUERY);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All query completed (done on same keys of gets) ; returning from query");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            this.queryFunction(aRegion, key);
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    public static void HydraTask_verifyFPRCoLocation() {
        ((FixedPartitioningTest)testInstance).verifyCoLocation();
    }

    protected void verifyCoLocation() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (aRegion instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)aRegion;
                if (pr.getAttributes().getPartitionAttributes().getFixedPartitionAttributes() == null) continue;
                this.verifyBucketCoLocation(pr);
                this.verifyPrimaryBucketCoLocation(pr);
                continue;
            }
            Log.getLogWriter().info("The region " + aRegion.getName() + " is not partitioned region and hence need not verify custom partitioning");
        }
    }

    public static void HydraTask_verifyRebalanceBehavior() {
        ((FixedPartitioningTest)testInstance).verifyRebalanceBehavior();
    }

    protected void verifyRebalanceBehavior() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            boolean isFPR = false;
            if (!(aRegion instanceof PartitionedRegion)) continue;
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            if (pr.isFixedPartitionedRegion()) {
                isFPR = true;
            } else {
                PartitionedRegion colWithRegion;
                String colocatedWithReg = pr.getPartitionAttributes().getColocatedWith();
                if (colocatedWithReg != null && (colWithRegion = (PartitionedRegion)theCache.getRegion(colocatedWithReg)).isFixedPartitionedRegion()) {
                    isFPR = true;
                }
            }
            if (isFPR) {
                this.verifyFPRsDontRebalance(pr);
                continue;
            }
            this.verifyNormalPRsRebalance(pr);
        }
    }

    public void verifyFPRsDontRebalance(PartitionedRegion pr) {
        List primaryBucketList = pr.getLocalPrimaryBucketsListTestOnly();
        List allBucketList = pr.getLocalBucketsListTestOnly();
        boolean isRebalanced = false;
        if (primaryBucketList != null && primaryBucketList.size() != 0) {
            isRebalanced = true;
        }
        if (!isRebalanced && allBucketList != null && allBucketList.size() != 0) {
            isRebalanced = true;
        }
        if (isRebalanced) {
            throw new TestException("For the Fixed Partitioned Region, " + pr.getName() + " expected not to rebalance but got rebalanced. Rebalanced primary  " + "buckets " + primaryBucketList + " and total rebalanced buckets " + allBucketList);
        }
        Log.getLogWriter().info("The Fixed Partitioned Region " + pr.getName() + " did not rebalance - which is as expected.");
    }

    public void verifyNormalPRsRebalance(PartitionedRegion pr) {
        List primaryBucketList = pr.getLocalPrimaryBucketsListTestOnly();
        List allBucketList = pr.getLocalBucketsListTestOnly();
        boolean isRebalanced = true;
        if (primaryBucketList == null || primaryBucketList.size() == 0) {
            isRebalanced = false;
        }
        if (isRebalanced && (allBucketList == null || allBucketList.size() == 0)) {
            isRebalanced = false;
        }
        if (!isRebalanced) {
            throw new TestException("For the normal Partitioned Region, " + pr.getName() + " expected buckets to rebalance but did not rebalance. Primary  " + "buckets " + primaryBucketList + " and total rebalanced buckets " + allBucketList);
        }
        Log.getLogWriter().info("The normal Partitioned Region " + pr.getName() + " did rebalance - which is as expected.");
    }

    public static void HydraTask_verifyOverflowToDisk() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (!(aRegion instanceof PartitionedRegion)) continue;
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            ((FixedPartitioningTest)testInstance).verifyOverflowToDisk(pr);
        }
    }

    protected void verifyOverflowToDisk(PartitionedRegion pr) {
        if (pr.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        long numOverflowToDisk = pr.getDiskRegionStats().getNumOverflowOnDisk();
        long entriesInVm = pr.getDiskRegionStats().getNumEntriesInVM();
        long totalEntriesInBuckets = 0L;
        Set bucketList = pr.getDataStore().getAllLocalBuckets();
        for (Map.Entry entry : bucketList) {
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket == null) continue;
            totalEntriesInBuckets += (long)localBucket.entryCount();
        }
        if (bucketList.size() > 0) {
            if (numOverflowToDisk == 0L) {
                throw new TestException("For the region " + pr.getName() + " no eviction happened ");
            }
            Log.getLogWriter().info("For the region " + pr.getName() + " entries overflown to disk is " + numOverflowToDisk);
        }
        Log.getLogWriter().info("For the region " + pr.getName() + " entries in disk = " + numOverflowToDisk + " entries in vm = " + entriesInVm + "entries in bucket = " + totalEntriesInBuckets);
        if (totalEntriesInBuckets != numOverflowToDisk + entriesInVm) {
            throw new TestException("Entries in bucket (actual value " + totalEntriesInBuckets + " ) is not the same as the sum of entries in disk and entries in vm ( " + numOverflowToDisk + " and " + entriesInVm + ")");
        }
    }

    public static void HydraTask_verifyFixedPartitioning() {
        ((FixedPartitioningTest)testInstance).verifyFixedPartitioning();
    }

    protected void verifyFixedPartitioning() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (aRegion instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)aRegion;
                if (pr.getAttributes().getPartitionAttributes().getFixedPartitionAttributes() != null) {
                    this.printVmParitionInfo(pr);
                    this.verifyPrimaryFixedPartitioning(pr);
                    this.verifySecondaryFixedPartitioning(pr);
                    continue;
                }
                Log.getLogWriter().info("There are no FPA attributes for " + pr.getName());
                continue;
            }
            Log.getLogWriter().info("The region " + aRegion.getName() + " is not partitioned region and hence need not verify custom partitioning");
        }
    }

    protected void verifyPrimaryFixedPartitioning(PartitionedRegion pr) {
        List primaryBucketList = pr.getLocalPrimaryBucketsListTestOnly();
        HashMap<String, Set<Integer>> partition2Buckets = new HashMap<String, Set<Integer>>();
        if (primaryBucketList == null || primaryBucketList.size() == 0) {
            Log.getLogWriter().info("There are no primary buckets on this member");
            return;
        }
        List primaryPartitionsForPr = pr.getPrimaryFixedPartitionAttributes_TestsOnly();
        List<String> primaryPartitions = this.getPartitionNames(primaryPartitionsForPr);
        for (Integer bucketId : primaryBucketList) {
            Set keySet = pr.getBucketKeys(bucketId.intValue());
            Month routingObject = null;
            for (Object key : keySet) {
                Set<Integer> bucketIdSet;
                routingObject = key instanceof FixedKeyResolver ? (Month)((FixedKeyResolver)key).getRoutingHint() : (key instanceof PartitionObjectHolder ? (Month)((PartitionObjectHolder)key).getRoutingHint() : (Month)InitImageBB.getBB().getSharedMap().get(key));
                String partitionName = routingObject.getQuarter();
                if (!primaryPartitions.contains(partitionName)) {
                    throw new TestException(" For the region " + pr.getName() + " for the key ," + key + " in the primary bucket " + bucketId + " the getPartition returned " + partitionName + " but the primary partitions on the node is " + primaryPartitions);
                }
                Log.getLogWriter().info(" For the region " + pr.getName() + " for the key ," + key + " in the primary bucket " + bucketId + " the getPartition returned " + partitionName + " and the primary partitions on the node is " + primaryPartitions);
                if (partition2Buckets.get(partitionName) == null) {
                    bucketIdSet = new HashSet<Integer>();
                    bucketIdSet.add(bucketId);
                    partition2Buckets.put(partitionName, bucketIdSet);
                    continue;
                }
                bucketIdSet = (Set)partition2Buckets.get(partitionName);
                if (bucketIdSet.contains(bucketId)) continue;
                bucketIdSet.add(bucketId);
            }
        }
        this.verifyPartitionNumBuckets(pr, primaryPartitionsForPr, partition2Buckets);
    }

    protected void verifySecondaryFixedPartitioning(PartitionedRegion pr) {
        if (pr.getLocalBucketsListTestOnly() == null || pr.getLocalBucketsListTestOnly().size() == 0) {
            Log.getLogWriter().info("There are no buckets on this member");
            return;
        }
        HashSet bucketSet = new HashSet(pr.getLocalBucketsListTestOnly());
        bucketSet.removeAll(pr.getLocalPrimaryBucketsListTestOnly());
        Log.getLogWriter().info("Secondary buckets for the partitioned region " + pr.getName() + " on this member are " + bucketSet);
        HashMap<String, Set<Integer>> partition2Buckets = new HashMap<String, Set<Integer>>();
        List secondaryPartitionsForPr = pr.getSecondaryFixedPartitionAttributes_TestsOnly();
        List<String> secondaryPartitions = this.getPartitionNames(secondaryPartitionsForPr);
        for (Integer bucketId : bucketSet) {
            Set keySet = pr.getBucketKeys(bucketId.intValue());
            Month routingObject = null;
            for (Object key : keySet) {
                Set<Integer> bucketIdSet;
                routingObject = key instanceof FixedKeyResolver ? (Month)((FixedKeyResolver)key).getRoutingHint() : (key instanceof PartitionObjectHolder ? (Month)((PartitionObjectHolder)key).getRoutingHint() : (Month)InitImageBB.getBB().getSharedMap().get(key));
                String partitionName = routingObject.getQuarter();
                if (!secondaryPartitions.contains(partitionName)) {
                    throw new TestException(" For the region " + pr.getName() + " for the key ," + key + " in the secondary bucket " + bucketId + " the getPartition returned " + partitionName + " but the secondary partitions on the node is " + secondaryPartitions);
                }
                Log.getLogWriter().info(" For the region " + pr.getName() + " for the key ," + key + " in the secondary bucket " + bucketId + " the getPartition returned " + partitionName + " and the secondary partitions on the node is " + secondaryPartitions);
                if (partition2Buckets.get(partitionName) == null) {
                    bucketIdSet = new HashSet<Integer>();
                    bucketIdSet.add(bucketId);
                    partition2Buckets.put(partitionName, bucketIdSet);
                    continue;
                }
                bucketIdSet = (Set)partition2Buckets.get(partitionName);
                if (bucketIdSet.contains(bucketId)) continue;
                bucketIdSet.add(bucketId);
            }
        }
        this.verifyPartitionNumBuckets(pr, secondaryPartitionsForPr, partition2Buckets);
    }

    protected List<String> getPartitionNames(List<FixedPartitionAttributesImpl> fpas) {
        ArrayList<String> partitionNames = new ArrayList<String>();
        for (FixedPartitionAttributesImpl fpa : fpas) {
            String partitionName = fpa.getPartitionName();
            partitionNames.add(partitionName);
        }
        return partitionNames;
    }

    protected void verifyPartitionNumBuckets(PartitionedRegion pr, List<FixedPartitionAttributesImpl> fpas, Map<String, Set<Integer>> partition2Buckets) {
        for (FixedPartitionAttributes fixedPartitionAttributes : fpas) {
            String partitionName = fixedPartitionAttributes.getPartitionName();
            HashSet bucketIdsOnMemberForPR = new HashSet();
            if (partition2Buckets.get(partitionName) != null) {
                Set<Integer> bucketIdSetForPartition = partition2Buckets.get(partitionName);
                int expectedNumBucketsForPartition = fixedPartitionAttributes.getNumBuckets();
                if (bucketIdSetForPartition.size() != expectedNumBucketsForPartition) {
                    throw new TestException("For the partitioned region " + pr.getName() + " for partition name " + partitionName + " expected number of buckets is " + expectedNumBucketsForPartition + " (" + fixedPartitionAttributes + ") but found " + bucketIdSetForPartition.size() + " bucket ids for this partition is " + bucketIdSetForPartition);
                }
                Log.getLogWriter().info("For the partitioned region " + pr.getName() + " for partition name " + partitionName + " found the expected number of buckets " + expectedNumBucketsForPartition + " bucket ids are " + bucketIdSetForPartition);
                if (!Collections.disjoint(bucketIdSetForPartition, bucketIdsOnMemberForPR)) {
                    throw new TestException("For the partitioned region " + pr.getName() + " for partition name " + partitionName + " bucket is shared with other partitions. Partition2Bucket map is " + partition2Buckets);
                }
            }
            Log.getLogWriter().info("Partition to bucket map for the partitioned region " + pr.getName() + " is " + partition2Buckets);
        }
    }

    protected void updateBBWithPartitionInfo() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (aRegion instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)aRegion;
                if (pr.getAttributes().getPartitionAttributes().getFixedPartitionAttributes() == null) {
                    return;
                }
                Map vmInfo = (Map)ParRegBB.getBB().getSharedMap().get(RemoteTestModule.getMyVmid());
                vmInfo.put("primary_partitions_", pr.getPrimaryFixedPartitionAttributes_TestsOnly());
                vmInfo.put("secondary_partitions_", pr.getSecondaryFixedPartitionAttributes_TestsOnly());
                vmInfo.put("primary_buckets_", pr.getLocalPrimaryBucketsListTestOnly());
                vmInfo.put("all_buckets_", pr.getLocalBucketsListTestOnly());
                ParRegBB.getBB().getSharedMap().put(RemoteTestModule.getMyVmid(), vmInfo);
                continue;
            }
            Log.getLogWriter().info("The region " + aRegion.getName() + " is not partitioned region and hence need not verify custom partitioning");
        }
    }

    @Override
    protected void stopStartVms() {
        int numRegions = CacheHelper.getCache().rootRegions().size();
        PRObserver.initialize();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        Log.getLogWriter().info("In stopStartVms, choosing " + numVMsToStop + " vm(s) to stop...");
        List vmList = this.getDataStoreVms();
        ArrayList targetVms = new ArrayList();
        ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 1; i <= numVMsToStop; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            targetVms.add(vmList.get(randInt));
            vmList.remove(randInt);
            stopModes.add(TestConfig.tab().stringAt(ParRegPrms.stopModes));
        }
        StopStartVMs.stopStartVMs(targetVms, stopModes);
        PRObserver.waitForRebalRecov(targetVms, 1, numRegions, null, null, false);
        Log.getLogWriter().info("Done in FixedPartitioning.stopStartVms()");
    }

    public void recycleClientAndValidateBehavior() {
        int numRegions = CacheHelper.getCache().rootRegions().size();
        PRObserver.initialize();
        ArrayList<ClientVmInfo> targetVms = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModes = new ArrayList<String>();
        List vmList = this.getDataStoreVms();
        int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
        ClientVmInfo targetMember = (ClientVmInfo)vmList.get(randInt);
        targetVms.add(targetMember);
        stopModes.add(TestConfig.tab().stringAt(ParRegPrms.stopModes));
        StopStartVMs.stopVMs(targetVms, stopModes);
        InternalDistributedMember memberAfterCrash = this.getPrimaryOwner(targetMember);
        this.isMemberEligibleToHostPrimary(memberAfterCrash, targetMember);
        this.verifyRedundantCopiesSatisfied(targetMember, false);
        StopStartVMs.startVMs(targetVms);
        PRObserver.waitForRebalRecov(targetVms, 1, numRegions, null, null, false);
        InternalDistributedMember memberAfterRecycle = this.getPrimaryOwner(targetMember);
        int newMemberVmId = -1;
        int memberAfterCrashVmId = -1;
        try {
            newMemberVmId = RemoteTestModule.Master.getVmid(memberAfterRecycle.getHost(), memberAfterRecycle.getVmPid());
            memberAfterCrashVmId = RemoteTestModule.Master.getVmid(memberAfterCrash.getHost(), memberAfterCrash.getVmPid());
        }
        catch (Exception e) {
            throw new TestException("Caught Exception ", e);
        }
        if (newMemberVmId != targetMember.getVmid()) {
            throw new TestException("The member vm_" + memberAfterCrashVmId + " did not give back the primary ownership of buckets after the primary node vm_" + targetMember.getVmid() + " came back");
        }
        Log.getLogWriter().info("Old member was vm_" + memberAfterCrashVmId + " and new member is vm_" + targetMember.getVmid());
        this.verifyRedundantCopiesSatisfied(targetMember, true);
    }

    public InternalDistributedMember getPrimaryOwner(ClientVmInfo crashedOrRecycledVm) {
        MasterController.sleepForMs(30000);
        int targetVmId = crashedOrRecycledVm.getVmid();
        Map vmInfo = (Map)ParRegBB.getBB().getSharedMap().get(targetVmId);
        List primaryBucketsOnVm = (List)vmInfo.get("primary_buckets_");
        InternalDistributedMember newMember = null;
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            HashSet<InternalDistributedMember> memberSet = new HashSet<InternalDistributedMember>();
            Iterator i$ = primaryBucketsOnVm.iterator();
            while (i$.hasNext()) {
                int bucketId = (Integer)i$.next();
                newMember = pr.getBucketPrimary(bucketId);
                Log.getLogWriter().info("For the bucketId " + bucketId + " the primary member is " + newMember);
                memberSet.add(newMember);
            }
            if (memberSet.size() == 1) continue;
            throw new TestException("For the recycled vm " + crashedOrRecycledVm.getVmid() + " primary buckets " + primaryBucketsOnVm + " for the region " + aRegion.getName() + " is hosted by " + memberSet.size() + " members - " + memberSet);
        }
        return newMember;
    }

    public void verifyRedundantCopiesSatisfied(ClientVmInfo crashedOrRecycledMember, boolean isExpectedToBeSatisfied) {
        int targetVmId = crashedOrRecycledMember.getVmid();
        Map vmInfo = (Map)ParRegBB.getBB().getSharedMap().get(targetVmId);
        List bucketsOnVm = (List)vmInfo.get("all_buckets_");
        Log.getLogWriter().info("Buckets on crashed vm are " + bucketsOnVm);
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            int redundantCopies = pr.getPartitionAttributes().getRedundantCopies();
            Iterator i$ = bucketsOnVm.iterator();
            while (i$.hasNext()) {
                int expectedNumBucketCopies;
                int bucketId = (Integer)i$.next();
                HashSet<String> bucketOwners = new HashSet<String>();
                try {
                    List aList = pr.getBucketOwnersForValidation(bucketId);
                    if (aList.size() == 0) continue;
                    for (int i = 0; i < aList.size(); ++i) {
                        Object[] tmpArr = (Object[])aList.get(i);
                        InternalDistributedMember member = (InternalDistributedMember)tmpArr[0];
                        int pid = member.getVmPid();
                        Integer vmId = null;
                        try {
                            vmId = new Integer(RemoteTestModule.Master.getVmid(member.getHost(), pid));
                        }
                        catch (RemoteException e) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                        bucketOwners.add("vm_" + vmId);
                    }
                }
                catch (Exception e) {
                    throw new TestException("Caught Exception ", e);
                }
                int n = expectedNumBucketCopies = isExpectedToBeSatisfied ? redundantCopies + 1 : redundantCopies;
                if (bucketOwners.size() != expectedNumBucketCopies) {
                    if (isExpectedToBeSatisfied) {
                        throw new TestException("For Fixed Partitioned Regions, after the crash of the vm_" + crashedOrRecycledMember.getVmid() + " the buckets hosted by the member " + bucketsOnVm + " should have their redundantCopies satisfied \n" + " For the bucket id " + bucketId + " for the region, expected number of copies " + expectedNumBucketCopies + " but found the following number of members hosting the buckets" + bucketOwners.size() + "-" + bucketOwners);
                    }
                    throw new TestException("For Fixed Partitioned Regions, after the crash of the vm_" + crashedOrRecycledMember.getVmid() + " the buckets hosted by the member " + bucketsOnVm + " should have their redundantCopies unsatisfied \n" + " For the bucket id " + bucketId + " for the region, expected number of copies " + expectedNumBucketCopies + " but found the following number of members hosting the buckets" + bucketOwners.size() + "-" + bucketOwners);
                }
                Log.getLogWriter().info("For the partitioned region " + pr.getName() + " for the bucket id " + bucketId + " of the crashed/recycled vm vm_" + crashedOrRecycledMember.getVmid() + " found the expected number of bucket copies " + expectedNumBucketCopies + "-" + bucketOwners);
            }
        }
    }

    public void isMemberEligibleToHostPrimary(InternalDistributedMember newMember, ClientVmInfo crashedMember) {
        int crashedMemberVmId = crashedMember.getVmid();
        Map vmInfoOfCrashedMember = (Map)ParRegBB.getBB().getSharedMap().get(crashedMemberVmId);
        List primaryPartitionsOfCrashedMember = (List)vmInfoOfCrashedMember.get("primary_partitions_");
        int newMemberVmId = -1;
        try {
            newMemberVmId = RemoteTestModule.Master.getVmid(newMember.getHost(), newMember.getVmPid());
        }
        catch (Exception e) {
            throw new TestException("Caught exception ", e);
        }
        Map vmInfoOfNewMember = (Map)ParRegBB.getBB().getSharedMap().get(newMemberVmId);
        List secondaryPartitionsOfNewMember = (List)vmInfoOfNewMember.get("secondary_partitions_");
        List<String> crashedMemberPrimaryPartitions = this.getPartitionNames(primaryPartitionsOfCrashedMember);
        List<String> newMemberSecPartitions = this.getPartitionNames(secondaryPartitionsOfNewMember);
        if (!newMemberSecPartitions.containsAll(crashedMemberPrimaryPartitions)) {
            throw new TestException("New vm vm_" + newMemberVmId + " with secondary partitions " + newMemberSecPartitions + " is not eligible to host primary of crashed member vm_" + crashedMemberVmId + " with primary partitions " + crashedMemberPrimaryPartitions);
        }
        Log.getLogWriter().info("New vm vm_" + newMemberVmId + " with secondary partitions " + newMemberSecPartitions + " is eligible to host primary of crashed member vm_" + crashedMemberVmId + " with primary partitions " + crashedMemberPrimaryPartitions);
    }

    public static void setDataStoreSequenceId() {
        if (ParRegBB.getBB().getSharedMap().get(RemoteTestModule.getMyVmid()) == null) {
            HashMap<String, Long> vmInfo = new HashMap<String, Long>();
            dataStoreSequenceId = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfDataStores);
            vmInfo.put(DATASTORE_SEQUENCE_ID, dataStoreSequenceId);
            ParRegBB.getBB().getSharedMap().put(RemoteTestModule.getMyVmid(), vmInfo);
        } else {
            HashMap vmInfo = (HashMap)ParRegBB.getBB().getSharedMap().get(RemoteTestModule.getMyVmid());
            dataStoreSequenceId = (Long)vmInfo.get(DATASTORE_SEQUENCE_ID);
        }
    }

    public void printVmParitionInfo(PartitionedRegion pr) {
        Map vmInfo = (Map)ParRegBB.getBB().getSharedMap().get(RemoteTestModule.getMyVmid());
        Log.getLogWriter().info("Primary buckets for the partitioned region " + pr.getName() + " on this member are " + pr.getLocalPrimaryBucketsListTestOnly());
        Log.getLogWriter().info("Total buckets for the partitioned region " + pr.getName() + " on this member are " + pr.getLocalBucketsListTestOnly());
        Log.getLogWriter().info("Primary partition attributes for the region " + pr.getName() + " on this member are " + vmInfo.get("primary_partitions_"));
        Log.getLogWriter().info("Secondary partition attributes for the region " + pr.getName() + " on this member are " + vmInfo.get("secondary_partitions_"));
    }

    public static synchronized void HydraTask_logLocalSize() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            Log.getLogWriter().info("Number of entries in this data store: " + ParRegUtil.getLocalSize(aRegion));
        }
    }

    public static void HydraTask_verifyPrimaries() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (aRegion instanceof PartitionedRegion) {
                FixedPartitioningTest.verifyPrimaries(aRegion);
                Log.getLogWriter().info("verified primaries for the region " + aRegion.getName());
                continue;
            }
            Log.getLogWriter().info("The region " + aRegion.getName() + " is not partitioned region and hence need not verify primaries");
        }
    }

    public static void HydraTask_verifyBucketCopies() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            testInstance.verifyBucketCopies(aRegion);
        }
    }

    public static void HydraTask_verifyRegionContents() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            testInstance.verifyRegionContents(aRegion);
        }
    }

    public static void HydraTask_onRegionFunctionPrimaryBuckets() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (!(aRegion instanceof PartitionedRegion)) continue;
            PartitionedRegion pr = (PartitionedRegion)aRegion;
            ((FixedPartitioningTest)testInstance).executeFunctionPrimaryBucketsAllBuckets(pr);
            ((FixedPartitioningTest)testInstance).executeFunctionPrimaryBucketsMultipleNodes(pr);
            ((FixedPartitioningTest)testInstance).executeFunctionPrimaryBucketsSingleNode(pr);
        }
    }

    public static void HydraTask_executeFunctionAllKeys() {
        Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
        for (Region<?, ?> aRegion : regionSet) {
            ((FixedPartitioningTest)testInstance).executeFunctionAllKeys(aRegion);
            ((FixedPartitioningTest)testInstance).executeFunctionAllBuckets(aRegion);
            ((FixedPartitioningTest)testInstance).executeFunctionMultipleNodes(aRegion);
        }
    }

    public void executeFunctionPrimaryBucketsAllBuckets(PartitionedRegion aRegion) {
        Execution dataSet = FunctionService.onRegion((Region)aRegion);
        Log.getLogWriter().info("Checking optimizeForWrite for no filter executions");
        PrimaryExecutionFunction primaryExecuteFunction = new PrimaryExecutionFunction();
        HashMap map = new HashMap();
        try {
            map = (HashMap)dataSet.withCollector((ResultCollector)new MemberResultsCollector()).execute(primaryExecuteFunction.getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Got the exception during execute on primary buckets " + e);
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String key = null;
        String value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = (String)entry.getKey();
            if (key.equals(value = (String)((ArrayList)entry.getValue()).get(0))) continue;
            throw new TestException("For the memberID " + key + " the result received mentions the executed node ID as " + value);
        }
        Log.getLogWriter().info("Successful completion of executeFunctionPrimaryBucketsAllBuckets and the result is " + map);
    }

    public void executeFunctionPrimaryBucketsMultipleNodes(PartitionedRegion aRegion) {
        HashMap map;
        HashSet keySet;
        Execution dataSet = FunctionService.onRegion((Region)aRegion);
        Log.getLogWriter().info("Checking optimizeForWrite for multiple nodes executions");
        PrimaryExecutionFunction primaryExecuteFunction = new PrimaryExecutionFunction();
        if (aRegion instanceof PartitionedRegion) {
            keySet = aRegion.keys();
        } else {
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get("Key List");
            keySet = new HashSet();
            keySet.addAll(keyList);
        }
        try {
            map = (HashMap)dataSet.withFilter((Set)keySet).withCollector((ResultCollector)new MemberResultsCollector()).execute(primaryExecuteFunction.getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Got the exception during execute on primary buckets " + e);
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String key = null;
        String value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = (String)entry.getKey();
            if (key.equals(value = (String)((ArrayList)entry.getValue()).get(0))) continue;
            throw new TestException("For the memberID " + key + " the result received mentions the executed node ID as " + value);
        }
        Log.getLogWriter().info("Successful completion of executeFunctionPrimaryBucketsMultipleNodes and the result is " + map);
    }

    public void executeFunctionPrimaryBucketsSingleNode(PartitionedRegion aRegion) {
        HashSet keySet;
        Execution dataSet = FunctionService.onRegion((Region)aRegion);
        PrimaryExecutionFunction primaryExecuteFunction = new PrimaryExecutionFunction();
        if (aRegion instanceof PartitionedRegion) {
            keySet = aRegion.keys();
        } else {
            ArrayList keyList = (ArrayList)ParRegBB.getBB().getSharedMap().get("Key List");
            keySet = new HashSet();
            keySet.addAll(keyList);
        }
        Log.getLogWriter().info("Checking optimizeForWrite for single node executions");
        for (Object key : keySet) {
            HashMap map;
            HashSet singleKeySet = new HashSet();
            singleKeySet.add(key);
            try {
                map = (HashMap)dataSet.withFilter(singleKeySet).withCollector((ResultCollector)new MemberResultsCollector()).execute(primaryExecuteFunction.getId()).getResult();
            }
            catch (Exception e) {
                throw new TestException("Got the exception during execute on primary buckets " + e);
            }
            Iterator iterator = map.entrySet().iterator();
            Map.Entry entry = null;
            String mapKey = null;
            String value = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                mapKey = (String)entry.getKey();
                if (mapKey.equals(value = (String)((ArrayList)entry.getValue()).get(0))) continue;
                throw new TestException("For the memberID " + mapKey + " the result received mentions the executed node ID as " + value);
            }
            map.clear();
        }
        Log.getLogWriter().info("Successful completion of executeFunctionPrimaryBucketsSingleNode");
    }

    @Override
    public void doOnRegionsExecutions() {
        Object regionDescriptName = null;
        HashSet regionSet = (HashSet)((FixedPartitioningTest)testInstance).getTestRegions();
        this.doOnRegionsExecutions(regionSet);
    }

    public Set<Region<?, ?>> getTestRegions() {
        Set rootRegions = theCache.rootRegions();
        HashSet testRegions = new HashSet();
        Vector regionNames = (Vector)TestConfig.tab().get(RegionPrms.regionName);
        for (Object region : regionNames) {
            Region aRegion;
            String regionName = region.toString();
            Log.getLogWriter().info("RegionName is : " + regionName);
            if (regionName.equalsIgnoreCase("subRegion")) {
                aRegion = theCache.getRegion("/rootRegion/subRegion");
                testRegions.add(aRegion);
                continue;
            }
            if (regionName.equalsIgnoreCase("rootRegion")) continue;
            aRegion = theCache.getRegion(regionName);
            testRegions.add(aRegion);
        }
        return testRegions;
    }
}

