/*
 * Decompiled with CFR 0.152.
 */
package parReg.partitionMan;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionManager;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.pdx.PdxInstance;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.TestConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import pdx.PdxTest;
import rebalance.RebalanceUtil;
import recovDelay.PrState;
import util.BaseValueHolder;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class PartitionManTest {
    public static PartitionManTest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    private static final String allRegionsSnapshotKey = "allRegionsSnapshot";

    public static synchronized void HydraTask_initializeClient() throws Throwable {
        if (testInstance == null) {
            testInstance = new PartitionManTest();
            testInstance.initializeInstance();
            CacheHelper.createCache("cache1");
            PartitionManTest.createRegions();
            Log.getLogWriter().info(TestHelper.regionHierarchyToString());
            if (PartitionManTest.testInstance.isBridgeConfiguration) {
                PartitionManTest.testInstance.isBridgeClient = true;
            }
        }
        testInstance.initializeInstancePerThread();
    }

    public static synchronized void HydraTask_initialize() throws Throwable {
        if (testInstance == null) {
            testInstance = new PartitionManTest();
            testInstance.initializeInstance();
            CacheHelper.createCache("cache1");
            PartitionManTest.createRegions();
            Log.getLogWriter().info(TestHelper.regionHierarchyToString());
            if (PartitionManTest.testInstance.isBridgeConfiguration) {
                PartitionManTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        testInstance.initializeInstancePerThread();
    }

    private static void createRegions() {
        boolean createAccessor = ParRegPrms.getCreateAccessor();
        HydraVector regionConfigNames = TestConfig.tab().vecAt(RegionPrms.names);
        for (String configName : regionConfigNames) {
            if (createAccessor) {
                if (!configName.startsWith("accessor")) continue;
                RegionHelper.createRegion(configName);
                continue;
            }
            if (!configName.startsWith("dataStore")) continue;
            RegionHelper.createRegion(configName);
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        PRObserver.installObserverHook();
    }

    private void initializeInstancePerThread() {
    }

    public static void HydraTask_load() {
        String key;
        long counterValue;
        int NUM_TO_LOAD_DEFAULT = 500;
        int numToLoad = TestConfig.tab().intAt(ParRegPrms.upperThreshold, 500);
        RandomValues rv = new RandomValues();
        Set rootRegions = CacheHelper.getCache().rootRegions();
        HashSet allRegions = new HashSet(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        long lastLogTime = System.currentTimeMillis();
        long logIntervalMs = 10000L;
        while ((counterValue = NameFactory.getCounterForName(key = NameFactory.getNextPositiveObjectName())) <= (long)numToLoad) {
            ValueHolder value = new ValueHolder(key, rv);
            for (Region aRegion : allRegions) {
                aRegion.put((Object)key, (Object)value);
                if (System.currentTimeMillis() - lastLogTime < 10000L) continue;
                Log.getLogWriter().info("Loading with key index " + counterValue + ", targeting key index " + numToLoad);
                lastLogTime = System.currentTimeMillis();
            }
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    public static void HydraTask_createPrimBuckets() {
        testInstance.testCreatePrimaryBucket();
    }

    public static void HydraTask_writeSnapshot() {
        testInstance.writeSnapshot();
    }

    public static void HydraTask_verifyPrimaryColocation() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        HashSet allRegions = new HashSet(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        Region goldenRegion = CacheHelper.getCache().getRegion("/pr1");
        HashSet goldenPrimBucketSet = new HashSet(((PartitionedRegion)goldenRegion).getLocalPrimaryBucketsListTestOnly());
        Log.getLogWriter().info(PrState.getPrPicture(goldenRegion));
        for (Region aRegion : allRegions) {
            HashSet primaryBucketSet = new HashSet(((PartitionedRegion)aRegion).getLocalPrimaryBucketsListTestOnly());
            if (goldenPrimBucketSet == null) {
                goldenPrimBucketSet = primaryBucketSet;
                goldenRegion = aRegion;
                continue;
            }
            if (!primaryBucketSet.equals(goldenPrimBucketSet)) {
                HashSet missingBuckets = new HashSet(goldenPrimBucketSet);
                missingBuckets.removeAll(primaryBucketSet);
                HashSet extraBuckets = new HashSet(primaryBucketSet);
                extraBuckets.removeAll(goldenPrimBucketSet);
                StringBuffer aStr = new StringBuffer();
                if (missingBuckets.size() != 0) {
                    aStr.append("The bucketIDs " + missingBuckets + " are primary in " + goldenRegion.getFullPath() + " but are not primary in " + aRegion.getFullPath() + "\n");
                }
                if (extraBuckets.size() != 0) {
                    aStr.append("The bucketIDs " + extraBuckets + " are primary in " + aRegion.getFullPath() + " but are not primary in " + goldenRegion.getFullPath() + "\n");
                }
                aStr.append("Primary bucket ids for " + goldenRegion.getFullPath() + ": " + goldenPrimBucketSet + ", primary bucket ids for " + aRegion.getFullPath() + ": " + primaryBucketSet);
                Log.getLogWriter().info(PrState.getPrPicture(goldenRegion) + "\n\n" + PrState.getPrPicture(aRegion));
                throw new TestException("Bug 44181 detected " + aStr.toString());
            }
            Log.getLogWriter().info(goldenRegion.getFullPath() + " and " + aRegion.getFullPath() + " have colocated primary bucket ids: " + primaryBucketSet);
        }
    }

    public static void HydraTask_rebalance() {
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.rebalance);
        if (counter == 1L) {
            ResourceManager resMan = CacheHelper.getCache().getResourceManager();
            RebalanceFactory factory = resMan.createRebalanceFactory();
            HashSet<String> regSet = new HashSet<String>();
            regSet.add("/pr1");
            factory.includeRegions(regSet);
            regSet = new HashSet();
            HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.regionName);
            for (String regionName : regionNames) {
                if (regionName.equals("/pr1")) continue;
                regSet.add((String)CacheHelper.getCache().getRegion("/" + regionName));
            }
            try {
                Log.getLogWriter().info("Calling rebalance simulate");
                RebalanceOperation simulateOp = factory.simulate();
                RebalanceResults simulateResults = simulateOp.getResults();
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(simulateResults, "Simulate"));
                Log.getLogWriter().info("Starting rebalancing");
                RebalanceOperation rebalanceOp = factory.start();
                RebalanceResults rebalanceResults = rebalanceOp.getResults();
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
                RebalanceUtil.isBalanceImproved(rebalanceResults);
                RebalanceUtil.checkSimulateAgainstRebalance(simulateResults, rebalanceResults);
                RebalanceUtil.primariesBalanced();
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_verifyPRs() {
        HashSet allRegions = new HashSet(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(allRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : allRegions) {
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            int redundantCopies = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
            Log.getLogWriter().info("Verifying PR " + aRegion.getFullPath() + " with " + redundantCopies + " redundantCopies");
            try {
                ParRegUtil.verifyPRMetaData(aRegion);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            try {
                ParRegUtil.verifyPrimaries(aRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            try {
                ParRegUtil.verifyBucketCopies(aRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            catch (TestException e) {
                aStr.append(e.toString() + "\n");
            }
            if (aStr.length() > 0) {
                throw new TestException(aStr.toString());
            }
            Log.getLogWriter().info("Done verifying PR internal consistency for " + aRegion.getFullPath());
        }
    }

    public static void HydraTask_verifyFromSnapshot() {
        try {
            testInstance.verifyFromSnapshot();
        }
        catch (TestException e) {
            throw new TestException("Bug 44173 detected: " + TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
    }

    private void testCreatePrimaryBucket() throws TestException {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        boolean destroyExistingRemote = ParRegPrms.getDestroyExistingRemote();
        boolean destroyExistingLocal = ParRegPrms.getDestroyExistingLocal();
        for (Region aRegion : rootRegions) {
            int numBuckets = aRegion.getAttributes().getPartitionAttributes().getTotalNumBuckets();
            int numRCs = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
            for (int bucketId = 0; bucketId < numBuckets; ++bucketId) {
                Boolean expectedResult;
                String before_prPicture;
                block17: {
                    Log.getLogWriter().info("BucketId is " + bucketId);
                    before_prPicture = PrState.getPrPicture(aRegion);
                    Log.getLogWriter().info(PrState.getPrPicture(aRegion, bucketId));
                    expectedResult = null;
                    Boolean[] tmp = ParRegUtil.getBucketStatus(aRegion, bucketId);
                    if (tmp == null) {
                        expectedResult = true;
                    } else {
                        boolean bucketIsLocal = tmp[0];
                        boolean bucketIsPrimary = tmp[1];
                        expectedResult = bucketIsLocal && bucketIsPrimary ? Boolean.valueOf(destroyExistingLocal) : (destroyExistingRemote ? Boolean.valueOf(true) : null);
                    }
                    Log.getLogWriter().info("Expected result of PartitionManager.createPrimaryBucket(...) is " + (expectedResult == null ? IllegalStateException.class.getName() : expectedResult.toString()));
                    Log.getLogWriter().info("Calling createPrimaryBucket for " + aRegion.getFullPath() + " with bucket ID " + bucketId + ", destroyExistingRemote " + destroyExistingRemote + " destroyExistingLocal " + destroyExistingLocal);
                    boolean result = false;
                    try {
                        long startTime = System.currentTimeMillis();
                        result = PartitionManager.createPrimaryBucket((Region)aRegion, (int)bucketId, (boolean)destroyExistingRemote, (boolean)destroyExistingLocal);
                        long duration = System.currentTimeMillis() - startTime;
                        Log.getLogWriter().info("Done calling createPrimaryBucket for " + aRegion.getFullPath() + " with bucket ID " + bucketId + ", result is " + result + ", duration " + duration + "ms");
                        if (expectedResult == null) {
                            throw new TestException("Expected call to PartitionManager.createPrimaryBucket(...) to throw " + IllegalStateException.class.getName() + ", but it returned " + result);
                        }
                    }
                    catch (IllegalStateException e) {
                        Log.getLogWriter().info("PartitionManager.createPrimaryBucket(...) resulted in " + e);
                        if (expectedResult == null) break block17;
                        throw new TestException("Expected call to PartitionManager.createPrimaryBucket(...) to return " + expectedResult + " but it threw " + e);
                    }
                }
                Log.getLogWriter().info(PrState.getPrPicture(aRegion, bucketId));
                if (expectedResult == null || !expectedResult.booleanValue()) {
                    String after_prPicture = PrState.getPrPicture(aRegion);
                    if (!before_prPicture.equals(after_prPicture)) {
                        Log.getLogWriter().info("Before call to createPrimaryBucket: " + before_prPicture + "\nAfter call to createPrimaryBucket: " + after_prPicture);
                        throw new TestException("After call to createPrimaryBucket buckets were moved");
                    }
                    Log.getLogWriter().info("Verified that no buckets moved after calling createPrimaryBucket");
                } else {
                    List primaryBucketList = ((PartitionedRegion)aRegion).getLocalPrimaryBucketsListTestOnly();
                    Log.getLogWriter().info("Primary buckets for this jvm: " + primaryBucketList);
                    if (!primaryBucketList.contains(bucketId)) {
                        Log.getLogWriter().info("Before call to createPrimaryBucket: " + before_prPicture);
                        Log.getLogWriter().info("After call to createPrimaryBucket: " + PrState.getPrPicture(aRegion));
                        throw new TestException("Bug 44181 detected: After calling createPrimaryBucket for bucketId " + bucketId + ", this member does not host that bucket as a primary. Primary buckets for this member: " + primaryBucketList);
                    }
                }
                try {
                    ParRegUtil.verifyPrimaries(aRegion, numRCs);
                }
                catch (TestException e) {
                    Log.getLogWriter().info("Before call to createPrimaryBucket: " + before_prPicture);
                    Log.getLogWriter().info("After call to createPrimaryBucket: " + PrState.getPrPicture(aRegion));
                    throw new TestException("Bug 44174 detected: " + TestHelper.getStackTrace(e));
                }
                try {
                    this.verifyFromSnapshot();
                }
                catch (TestException e) {
                    Log.getLogWriter().info("Before call to createPrimaryBucket: " + before_prPicture);
                    Log.getLogWriter().info("After call to createPrimaryBucket: " + PrState.getPrPicture(aRegion));
                    throw new TestException("Bug 44173 detected: " + TestHelper.getStackTrace(e));
                }
                try {
                    ParRegUtil.verifyBucketCopies(aRegion, numRCs);
                    continue;
                }
                catch (TestException e) {
                    Log.getLogWriter().info("Before call to createPrimaryBucket: " + before_prPicture);
                    Log.getLogWriter().info("After call to createPrimaryBucket: " + PrState.getPrPicture(aRegion));
                    throw e;
                }
            }
        }
    }

    protected void writeSnapshot() {
        HashSet allRegions = new HashSet(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(allRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        Log.getLogWriter().info("Preparing to write snapshot for " + allRegions.size() + " regions");
        HashMap allRegionsSnapshot = new HashMap();
        for (Region aRegion : allRegions) {
            HashMap regionSnapshot = new HashMap();
            for (Object key : aRegion.keySet()) {
                Object value = null;
                if (aRegion.containsValueForKey(key)) {
                    value = aRegion.get(key);
                }
                if (value instanceof BaseValueHolder) {
                    regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                    continue;
                }
                regionSnapshot.put(key, value);
            }
            allRegionsSnapshot.put(aRegion.getFullPath(), regionSnapshot);
            Log.getLogWriter().info("Region snapshot for " + aRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        }
        ParRegBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        Log.getLogWriter().info("Put snapshot for " + allRegions.size() + " regions into blackboard at key " + allRegionsSnapshotKey);
    }

    private void verifyFromSnapshot() {
        Map allRegionsSnapshot = (Map)ParRegBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
        if (allRegionsSnapshot == null) {
            Log.getLogWriter().info("Not verifying from snapshot because the snapshot in the blackboard is null");
            return;
        }
        Set snapshotRegionNames = allRegionsSnapshot.keySet();
        HashSet<String> definedRegionNames = new HashSet<String>();
        for (Region aRegion : CacheHelper.getCache().rootRegions()) {
            definedRegionNames.add(aRegion.getFullPath());
            Set subRegSet = aRegion.subregions(true);
            for (Region subReg : subRegSet) {
                definedRegionNames.add(subReg.getFullPath());
            }
        }
        HashSet missingRegionsInCache = new HashSet(snapshotRegionNames);
        missingRegionsInCache.removeAll(definedRegionNames);
        HashSet extraRegionsInCache = new HashSet(definedRegionNames);
        extraRegionsInCache.removeAll(snapshotRegionNames);
        if (missingRegionsInCache.size() != 0) {
            throw new TestException("Expected to find regions " + missingRegionsInCache + " defined in cache");
        }
        if (extraRegionsInCache.size() != 0) {
            throw new TestException("Found unexpected regions defined in cache: " + extraRegionsInCache);
        }
        for (String regionName : allRegionsSnapshot.keySet()) {
            Map regionSnapshot = (Map)allRegionsSnapshot.get(regionName);
            Region aRegion = CacheHelper.getCache().getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            this.verifyFromSnapshot(aRegion, regionSnapshot);
        }
    }

    public void verifyFromSnapshot(Region aRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = aRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + "  of size " + aRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (snapshotSize != regionSize) {
            errStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
        }
        for (Object key : regionSnapshot.keySet()) {
            try {
                ParRegUtil.verifyContainsKey(aRegion, key, true);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            Object expectedValue = regionSnapshot.get(key);
            try {
                ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = aRegion.get(key);
                if (actualValue instanceof BaseValueHolder) {
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof PdxInstance) {
                    actualValue = PdxTest.toValueHolder(actualValue);
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof byte[] && expectedValue instanceof byte[]) {
                    byte[] actual = (byte[])actualValue;
                    byte[] expected = (byte[])expectedValue;
                    if (actual.length == expected.length) continue;
                    throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
                }
                throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
        }
        HashSet aRegionKeySet = new HashSet(aRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        aRegionKeySet.removeAll(snapshotKeySet);
        if (aRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + aRegion.getFullPath() + ": " + aRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + aRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, " + "verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }
}

