/*
 * Decompiled with CFR 0.152.
 */
package parReg.query;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import hct.BridgeNotify;
import hct.BridgeNotifyBB;
import hydra.CacheHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import parReg.query.NewPortfolio;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class ConcBridgeNotify
extends BridgeNotify {
    private int numOfId = 100;
    private int numOfRegions = 1;

    public static synchronized void HydraTask_initialize() {
        if (bridgeClient == null) {
            bridgeClient = new ConcBridgeNotify();
            bridgeClient.initialize();
        }
    }

    @Override
    protected void populateRegion(Region aRegion) {
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            String name = NameFactory.getNextPositiveObjectName();
            Object anObj = this.getObjectToAdd(name);
            try {
                aRegion.put((Object)name, anObj);
                continue;
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        MasterController.sleepForMs(60000);
    }

    protected void query(Region aRegion, Object key, NewPortfolio expectedValue) {
        SelectResults results = this.query(aRegion, key);
        if (this.isSerialExecution) {
            if (results.size() == 0) {
                if (expectedValue != null) {
                    throw new TestException("ExpectedValue = <" + expectedValue + ">, but query ResultSet was empty");
                }
                Log.getLogWriter().info("Successful validation of empty result set (null)");
            } else {
                NewPortfolio result = (NewPortfolio)results.asList().get(0);
                if (!result.equals((Object)expectedValue)) {
                    throw new TestException("Expected value of " + key + " to be <" + expectedValue + "> but query returned <" + result + ">");
                }
                Log.getLogWriter().info("Successful validation of query results");
            }
        }
    }

    @Override
    protected void addObject(Region aRegion, String name, boolean logAddition) {
        List singleKeyList;
        Object anObj = this.getObjectToAdd(name);
        String callback = "Create event originated in pid " + ProcessMgr.getProcessId();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_CREATE", BridgeNotifyBB.NUM_CREATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
    }

    @Override
    protected Object getObjectToAdd(String name) {
        long i = NameFactory.getPositiveNameCounter();
        int index = (int)(i % (long)this.numOfId);
        NewPortfolio val = new NewPortfolio(name, index);
        Log.getLogWriter().info("set portfolio done");
        return val;
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        List singleKeyList;
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Object name = null;
        for (Object potentialKey : aSet) {
            if (!aRegion.containsValueForKey(potentialKey)) continue;
            name = potentialKey;
            break;
        }
        if (name == null) {
            Log.getLogWriter().info("invalidateObject: No entries with value in region");
            return;
        }
        boolean containsValue = aRegion.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            String callback = "Invalidate event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_LOCAL_INVALIDATE", BridgeNotifyBB.NUM_LOCAL_INVALIDATE);
                }
            } else {
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                if (!alreadyInvalidated) {
                    BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_INVALIDATE", BridgeNotifyBB.NUM_INVALIDATE);
                }
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(aRegion, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
    }

    protected void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        List singleKeyList;
        try {
            String callback = "Destroy event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_LOCAL_DESTROY", BridgeNotifyBB.NUM_LOCAL_DESTROY);
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_DESTROY", BridgeNotifyBB.NUM_DESTROY);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        catch (BridgeWriterException bwe) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(bwe));
            }
            Throwable cause = bwe.getCause();
            if (cause == null) {
                throw new TestException(TestHelper.getStackTrace());
            }
            if (cause.toString().startsWith("com.gemstone.gemfire.cache.EntryNotFoundException")) {
                Log.getLogWriter().info("Caught " + (Object)((Object)bwe) + " (expected with concurrent execution); continuing with test");
            }
            throw new TestException(TestHelper.getStackTrace());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
    }

    @Override
    protected void updateObject(Region aRegion, Object name) {
        List singleKeyList;
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        try {
            String callback = "Update event originated in pid " + ProcessMgr.getProcessId();
            Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(name, newObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_UPDATE", BridgeNotifyBB.NUM_UPDATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
    }

    @Override
    protected Object getUpdateObject(String name) {
        return this.getObjectToAdd(name);
    }

    @Override
    protected void addObject(Region aRegion, boolean logAddition) {
        super.addObject(aRegion, logAddition);
        this.doQuery(logAddition);
    }

    @Override
    protected void updateObject(Region aRegion) {
        super.updateObject(aRegion);
        this.doQuery(true);
    }

    @Override
    protected void readObject(Region aRegion) {
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("readObject: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("readObject: getting name " + name);
        try {
            Object anObj = aRegion.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        this.doQuery(true);
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        super.destroyObject(aRegion, isLocalDestroy);
        this.doQuery(true);
    }

    protected void doQuery(boolean logAddition) {
        String region1 = "/myRegion";
        String[] queries = new String[]{"select distinct * from " + region1 + " where name = $1 ", "select distinct * from " + region1 + " where status = 'active'", "select distinct * from " + region1 + " where id != 0 AND status = 'active'", "select distinct * from " + region1 + " where id <= 1 AND status <> 'active'", "select distinct * from " + region1 + " where NOT (id <= 5 AND status <> 'active')", "select distinct * from " + region1 + " where id < 5 OR status != 'active'", "import parReg.\"query\".Position; select distinct * from " + region1 + " r, " + " r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00", "import parReg.\"query\".Position; select distinct r.name, pVal, r.status from " + region1 + " r, " + "r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00 AND pVal.qty >= 500", "import parReg.\"query\".Position; select distinct positions from " + region1, "import parReg.\"query\".Position; select distinct \"type\" from " + region1 + ", positions.values pVal TYPE Position where pVal.qty > 1000.00"};
        int i = new Random().nextInt(queries.length);
        if (i == 0) {
            this.doQuery1(logAddition, region1);
            return;
        }
        Log.getLogWriter().info("query string number is " + i);
        Query query = CacheHelper.getCache().getQueryService().newQuery(queries[i]);
        if (logAddition) {
            Log.getLogWriter().info(" query = " + query);
        }
        try {
            Object result = query.execute();
            if (result instanceof Collection && logAddition) {
                Log.getLogWriter().info("Size of result is :" + ((Collection)result).size());
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
        }
    }

    protected void doQuery1(boolean logAddition, String region1) {
        String queryString = "select distinct * from " + region1 + " where name = $1 ";
        Query query = CacheHelper.getCache().getQueryService().newQuery(queryString);
        if (logAddition) {
            Log.getLogWriter().info(" query = " + query.toString());
        }
        int regionNum = -1;
        for (int i = 0; i < this.numOfRegions; ++i) {
            if (!region1.equals("/myRegion" + i)) continue;
            regionNum = i;
            Log.getLogWriter().info(" region num = " + regionNum);
        }
        Region aRegion = regionNum > -1 ? CacheHelper.getCache().getRegion("myRegion" + "" + regionNum) : CacheHelper.getCache().getRegion("myRegion");
        Set keys = aRegion.keySet();
        Iterator itr = keys.iterator();
        Object[] params = new Object[1];
        if (itr.hasNext()) {
            params[0] = itr.next();
            try {
                Object result = query.execute(params);
                if (result instanceof Collection && logAddition) {
                    Log.getLogWriter().info("Size of result for first query ($1) is :" + ((Collection)result).size());
                    if (((Collection)result).size() > 1) {
                        throw new TestException("Query result when checking key (name) can not be more than 1");
                    }
                }
            }
            catch (Exception e) {
                throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
            }
        }
    }
}

