/*
 * Decompiled with CFR 0.152.
 */
package parReg.query;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import hydra.CacheHelper;
import hydra.Log;
import hydra.TestConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import parReg.query.NewPortfolio;
import parReg.query.index.IndexTest;
import pdx.PdxTestVersionHelper;
import query.QueryPrms;
import query.QueryTest;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class ConcQueryAndEntryOpsTest
extends QueryTest {
    private Object numOfQueriesLock = new Object();
    private int numOfQueries = 0;

    public static synchronized void HydraTask_initialize() {
        if (queryTest == null) {
            queryTest = new ConcQueryAndEntryOpsTest();
            queryTest.initialize();
        }
    }

    public static void HydraTask_getNumOfQueries() {
        if (queryTest == null) {
            queryTest = new ConcQueryAndEntryOpsTest();
        }
        ((ConcQueryAndEntryOpsTest)queryTest).printNumOfQueries();
    }

    protected void printNumOfQueries() {
        Log.getLogWriter().info("Number of queries executed is " + this.numOfQueries);
    }

    @Override
    protected void createIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        if (!objectType.equals("parReg.query.NewPortfolio")) {
            return;
        }
        IndexTest indexTest = new IndexTest();
        int regionNumber = new Random().nextInt(this.numOfRegions);
        indexTest.createIndex("QueryRegion" + "" + regionNumber);
    }

    @Override
    protected void removeIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        if (!objectType.equals("parReg.query.NewPortfolio")) {
            return;
        }
        IndexTest indexTest = new IndexTest();
        int regionNumber = new Random().nextInt(this.numOfRegions);
        indexTest.removeIndex("QueryRegion" + "" + regionNumber);
    }

    @Override
    protected Object getObjectToAdd(String name) {
        boolean useRandomValues = false;
        useRandomValues = TestConfig.tab().booleanAt(QueryPrms.useRandomValues, false);
        if (useRandomValues) {
            ValueHolder anObj = new ValueHolder(name, this.randomValues);
            return anObj;
        }
        long i = NameFactory.getPositiveNameCounter();
        int index = (int)(i % (long)this.maxObjects);
        NewPortfolio val = new NewPortfolio(name, index);
        Log.getLogWriter().info("set portfolio ");
        return val;
    }

    @Override
    protected Object getUpdateObject(String name) {
        return this.getObjectToAdd(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doQuery(boolean logAddition) {
        block9: {
            int i;
            String region1 = this.randRgn();
            String[] queries = new String[]{"select distinct * from " + region1 + " where name = $1 ", "select distinct * from " + region1 + " where status = 'active'", "select distinct * from " + region1 + " where id != 0 AND status = 'active'", "select distinct * from " + region1 + " where id <= 1 AND status <> 'active'", "select distinct * from " + region1 + " where NOT (id <= 5 AND status <> 'active')", "select distinct * from " + region1 + " where id < 5 OR status != 'active'", "import parReg.\"query\".Position; select distinct * from " + region1 + " r, " + "r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00", "import parReg.\"query\".Position; select distinct r.name, pVal, r.status from " + region1 + " r, " + "r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00 AND pVal.qty >= 500", "select distinct * from " + this.randRgn() + ".keys", "select distinct e.value from " + this.randRgn() + ".entries e"};
            if (this.queryLimit != -1) {
                int q = 0;
                while (q < queries.length) {
                    int n = q++;
                    queries[n] = queries[n] + " limit " + this.queryLimit;
                }
            }
            if ((i = new Random().nextInt(queries.length)) == 0) {
                this.doQuery1(logAddition, region1);
                return;
            }
            Query query = CacheHelper.getCache().getQueryService().newQuery(queries[i]);
            if (logAddition) {
                Log.getLogWriter().info(" query = " + query);
            }
            try {
                Object result = query.execute();
                this.validateQueryLimit(result);
                if (!(result instanceof Collection) || !logAddition) break block9;
                Object object = this.numOfQueriesLock;
                synchronized (object) {
                    ++this.numOfQueries;
                }
                Log.getLogWriter().info("Size of result is :" + ((Collection)result).size());
            }
            catch (Exception e) {
                throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doQuery1(boolean logAddition, String region1) {
        String queryString = "select distinct * from " + region1 + " where name = $1 ";
        Query query = CacheHelper.getCache().getQueryService().newQuery(queryString);
        if (logAddition) {
            Log.getLogWriter().info(" query = " + query.toString());
        }
        int regionNum = 0;
        for (int i = 0; i < this.numOfRegions; ++i) {
            if (!region1.equals("/QueryRegion" + i)) continue;
            regionNum = i;
            Log.getLogWriter().info(" region num = " + regionNum);
        }
        Region aRegion = CacheHelper.getCache().getRegion("QueryRegion" + "" + regionNum);
        Set keys = aRegion.keySet();
        Iterator itr = keys.iterator();
        Object[] params = new Object[1];
        if (itr.hasNext()) {
            block11: {
                params[0] = itr.next();
                Log.getLogWriter().info("param $1 is " + params[0]);
                NewPortfolio aNP = (NewPortfolio)PdxTestVersionHelper.toBaseObject(aRegion.get(params[0]));
                Log.getLogWriter().info("Rgion name is " + aRegion.getName());
                Log.getLogWriter().info("The object in region with key " + params[0] + " is " + aNP);
                try {
                    Object result = query.execute(params);
                    this.validateQueryLimit(result);
                    if (!(result instanceof Collection) || !logAddition) break block11;
                    Object object = this.numOfQueriesLock;
                    synchronized (object) {
                        ++this.numOfQueries;
                    }
                    Log.getLogWriter().info("Size of result is :" + ((Collection)result).size());
                    if (((Collection)result).size() > 1) {
                        throw new TestException("Query result when checking key (name) can not be more than 1");
                    }
                }
                catch (QueryInvocationTargetException ite) {
                    if (QueryPrms.allowQueryInvocationTargetException()) {
                        Log.getLogWriter().info("Caught " + (Object)((Object)ite) + " (expected with concurrent execution); continuing with test");
                    }
                    throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(ite));
                }
                catch (Exception e) {
                    throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
                }
            }
            Log.getLogWriter().info("Finished checking query 1.");
        }
    }
}

