/*
 * Decompiled with CFR 0.152.
 */
package parReg.query.index;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import distcache.gemfire.GemFireCachePrms;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Collection;
import java.util.Iterator;
import query.index.IndexPrms;
import util.TestHelper;

public class IndexTest {
    protected static IndexTest indexTest;

    public static synchronized void HydraTask_CreateIndex() {
        if (indexTest == null) {
            indexTest = new IndexTest();
        }
        indexTest.createIndex(GemFireCachePrms.getRegionName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createIndex(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    long numOfIndexes = 1L;
                    numOfIndexes = TestConfig.tab().longAt(IndexPrms.numOfIndexes, 1L);
                    qs.createIndex("nameIndex", IndexType.PRIMARY_KEY, "name", "/" + RegionName2);
                    Log.getLogWriter().info("Index nameIndex Created successfully");
                    if (numOfIndexes >= 2L) {
                        qs.createIndex("idIndex", IndexType.FUNCTIONAL, "id", "/" + RegionName2);
                        Log.getLogWriter().info("Index idIndex Created successfully");
                    }
                    if (numOfIndexes >= 3L) {
                        qs.createIndex("mktValueIndex", IndexType.FUNCTIONAL, "pVal.mktValue", "/" + RegionName2 + " pf, pf.positions.values pVal TYPE Position", "import parReg.\"query\".Position;");
                        Log.getLogWriter().info("Index mktValueIndex Created successfully");
                    }
                    if (numOfIndexes < 4L) return;
                    qs.createIndex("statusIndex", IndexType.FUNCTIONAL, "status", "/" + RegionName2);
                    Log.getLogWriter().info("Index statusIndex Created successfully");
                    return;
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    return;
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                    return;
                }
                catch (QueryException e) {
                    throw new HydraRuntimeException("Could not create Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Hey !!!!! Could not obtain QueryService for the cache ");
            }
            return;
        } else {
            Log.getLogWriter().info("Hey !!!!! Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    public void createIndex1(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    qs.createIndex("nameIndex", IndexType.PRIMARY_KEY, "name", "/" + RegionName2);
                    Log.getLogWriter().info("Index nameIndex Created successfully");
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                }
                catch (QueryException e) {
                    throw new HydraRuntimeException("Could not create Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Hey !!!!! Could not obtain QueryService for the cache ");
            }
        } else {
            Log.getLogWriter().info("Hey !!!!! Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    public void createIndex2(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    qs.createIndex("idIndex", IndexType.FUNCTIONAL, "id", "/" + RegionName2);
                    Log.getLogWriter().info("Index idIndex Created successfully");
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                }
                catch (QueryException e) {
                    throw new HydraRuntimeException("Could not create Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Hey !!!!! Could not obtain QueryService for the cache ");
            }
        } else {
            Log.getLogWriter().info("Hey !!!!! Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    public void createIndex3(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    qs.createIndex("mktValueIndex", IndexType.FUNCTIONAL, "pVal.mktValue", "/" + RegionName2 + " pf, pf.positions.values pVal TYPE Position", "import parReg.\"query\".Position;");
                    Log.getLogWriter().info("Index mktValueIndex Created successfully");
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                }
                catch (QueryException e) {
                    throw new HydraRuntimeException("Could not create Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Hey !!!!! Could not obtain QueryService for the cache ");
            }
        } else {
            Log.getLogWriter().info("Hey !!!!! Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    public static synchronized void HydraTask_RemoveIndex() {
        if (indexTest == null) {
            indexTest = new IndexTest();
        }
        indexTest.removeIndex(GemFireCachePrms.getRegionName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeIndex(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    Collection indexes = qs.getIndexes(region);
                    if (indexes == null) {
                        Log.getLogWriter().info("No index manager defined");
                        return;
                    }
                    if (indexes.size() == 0) {
                        return;
                    }
                    Log.getLogWriter().info("The size of the index to be removed is " + indexes.size());
                    Iterator iter = indexes.iterator();
                    if (!iter.hasNext()) return;
                    Index idx = (Index)iter.next();
                    String name = idx.getName();
                    qs.removeIndex(idx);
                    Log.getLogWriter().info("Index " + name + " removed successfully");
                    return;
                }
                catch (Exception e) {
                    throw new HydraRuntimeException("Could not remove Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Hey !!!!! Could not obtain QueryService for the cache ");
            }
        }
    }
}

