/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import parReg.tx.PidRoutingObject;
import parReg.tx.PrTxBB;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class CallbackListener
extends AbstractListener
implements CacheListener,
Declarable {
    private ArrayList roList = new ArrayList();

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        this.processCallback(event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.processCallback(event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        this.processCallback(event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.processCallback(event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    private void processCallback(EntryEvent event) {
        Object callback = event.getCallbackArgument();
        if (callback instanceof PidRoutingObject) {
            PidRoutingObject ro = (PidRoutingObject)callback;
            if (!this.roList.contains(ro)) {
                this.roList.add(ro);
            }
        } else {
            throw new TestException("CallbackListener expected callbackArgument of type PidRoutingObject, but found " + callback.getClass());
        }
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        Iterator it = this.roList.iterator();
        PidRoutingObject ro = (PidRoutingObject)it.next();
        int hashBucket = ro.hashCode() % numVms;
        while (it.hasNext()) {
            PidRoutingObject nextRo = (PidRoutingObject)it.next();
            int nextHashBucket = nextRo.hashCode() % numVms;
            if (hashBucket != nextHashBucket) {
                throw new TestException("VM " + ProcessMgr.getProcessId() + " is the dataStore for disparate routingObjects " + hashBucket + " and " + nextHashBucket);
            }
            Log.getLogWriter().info("Two pids resolved to same bucket: " + ro.getPid() + " and " + nextRo.getPid() + " both resolved to bucket " + hashBucket);
        }
        if (this.roList.size() > 1) {
            // empty if block
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = PrTxBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

