/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import parReg.tx.ExecuteTx;
import parReg.tx.GetAllMembersInDS;
import parReg.tx.ModResult;
import parReg.tx.ModRoutingObject;
import parReg.tx.PidRoutingObject;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import parReg.tx.SerializableDistributedMember;
import parReg.tx.VerifyCustomPartitioningFunction;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationsClient;
import util.TestException;
import util.TestHelper;

public class CustomPartitionTest
extends OperationsClient {
    protected static CustomPartitionTest testInstance;
    static Region testRegion;
    static Region routingRegion;
    private ArrayList errorMsgs = new ArrayList();
    private ArrayList errorException = new ArrayList();
    private int customPartitionMethod;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new CustomPartitionTest();
            testInstance.initializeOperationsClient();
            try {
                testInstance.initializePrms();
                testInstance.initialize();
                testInstance.registerFunctions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    protected void initialize() {
        String bridgeConfig;
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
        }
        String regionConfig = ConfigPrms.getRegionConfig();
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfig);
        String regionName = rd.getRegionName();
        RegionHelper.createRegion(regionName, factory);
        testRegion = RegionHelper.getRegion(regionName);
        if (testRegion.getAttributes().getPoolName() != null) {
            testRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("registered interest in ALL_KEYS for " + testRegion.getFullPath());
        }
        if ((bridgeConfig = ConfigPrms.getBridgeConfig()) != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
        if (this.customPartitionMethod == 2) {
            rd = RegionHelper.getRegionDescription("routingRegion");
            factory = RegionHelper.getAttributesFactory("routingRegion");
            regionName = rd.getRegionName();
            RegionHelper.createRegion(regionName, factory);
            routingRegion = RegionHelper.getRegion(regionName);
        }
    }

    protected void registerFunctions() {
        Declarable f = new VerifyCustomPartitioningFunction();
        FunctionService.registerFunction((Function)f);
        f = new GetAllMembersInDS();
        FunctionService.registerFunction((Function)f);
        f = new ExecuteTx();
        FunctionService.registerFunction((Function)f);
        Log.getLogWriter().info("Registered functions: " + FunctionService.getRegisteredFunctions());
    }

    protected void initializePrms() {
        this.customPartitionMethod = PrTxPrms.getCustomPartitionMethod();
        Log.getLogWriter().info("Using customPartitionMethod " + PrTxPrms.customPartitionMethodToString(this.customPartitionMethod));
    }

    public static void HydraTask_populateRegions() {
        Cache myCache = CacheHelper.getCache();
        Set allRegions = myCache.rootRegions();
        for (Region aRegion : allRegions) {
            testInstance.populateRegion(aRegion);
        }
    }

    protected void populateRegion(Region aRegion) {
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        for (int i = 0; i < numVms; ++i) {
            this.addEntry(aRegion);
        }
    }

    public static void HydraTask_doEntryOperations() {
        try {
            testInstance.doEntryOperations();
        }
        catch (Exception e) {
            Log.getLogWriter().info("doEntryOperations threw Exception " + e);
            throw new TestException("doEntryOperations caught Exception " + TestHelper.getStackTrace(e));
        }
    }

    protected void doEntryOperations() {
        TestHelper.checkForEventError(PrTxBB.getBB());
        super.doEntryOperations(testRegion);
    }

    public static void HydraTask_executeTx() {
        Function f = FunctionService.getFunction((String)"parReg.tx.ExecuteTx");
        Cache myCache = CacheHelper.getCache();
        Set allRegions = myCache.rootRegions();
        for (Region aRegion : allRegions) {
            testInstance.executeTx(aRegion, f);
        }
    }

    protected void executeTx(Region aRegion, Function f) {
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        for (int i = 0; i < numVms; ++i) {
            HashSet<String> filter = new HashSet<String>();
            filter.add(NameFactory.getObjectNameForCounter(i));
            Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)dm.toString()).withFilter(filter);
            Log.getLogWriter().info("executing " + f.getId() + " with filter " + filter);
            ResultCollector rc = e.execute(f.getId());
            Log.getLogWriter().info("executed " + f.getId());
            List results = (List)rc.getResult();
            Log.getLogWriter().info("ResultCollector.getResult() = " + results);
        }
    }

    public static void HydraTask_executeGetAllMembersInDS() {
        Function f = FunctionService.getFunction((String)"parReg.tx.GetAllMembersInDS");
        testInstance.executeGetAllMembersInDS(f);
    }

    protected void executeGetAllMembersInDS(Function f) {
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        Execution e = FunctionService.onMembers((DistributedSystem)ds).withArgs((Object)dm.toString());
        Log.getLogWriter().info("executing " + f.getId());
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        Log.getLogWriter().info("ResultCollector.getResult() = " + results);
        StringBuffer s = new StringBuffer();
        s.append("ResultCollector : \n");
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        for (SerializableDistributedMember sdm : results) {
            s.append("   " + sdm.toString() + "\n");
            pidList.add(new Integer(sdm.getPid()));
        }
        PrTxBB.getBB().getSharedMap().put("Pids", pidList);
        Log.getLogWriter().info(s.toString());
    }

    public static void HydraTask_executeVerifyCustomPartitioningFunction() {
        Function f = FunctionService.getFunction((String)"parReg.tx.VerifyCustomPartitioningFunction");
        Cache myCache = CacheHelper.getCache();
        Set allRegions = myCache.rootRegions();
        for (PartitionedRegion pr : allRegions) {
            if (pr.getName().equalsIgnoreCase("routingRegion")) continue;
            testInstance.executeVerifyCustomPartitioningFunction(pr, f);
        }
    }

    protected void executeVerifyCustomPartitioningFunction(PartitionedRegion pr, Function f) {
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        List pidList = (List)PrTxBB.getBB().getSharedMap().get("Pids");
        for (int i = 0; i < numVms; ++i) {
            HashSet<Object> filter = new HashSet<Object>();
            switch (this.customPartitionMethod) {
                case 2: {
                    Integer pid = (Integer)pidList.get(i);
                    filter.add(new PidRoutingObject("callback", pid));
                    break;
                }
                case 3: {
                    filter.add(new ModRoutingObject(NameFactory.getObjectNameForCounter(i)));
                    break;
                }
                case 1: {
                    filter.add(NameFactory.getObjectNameForCounter(i));
                    break;
                }
                default: {
                    String s = "Test expects a customPartitionMethod based on PartitionResolver, KeyResolver or CallbackResolver";
                    Log.getLogWriter().info(s);
                    throw new HydraConfigException(s);
                }
            }
            Execution e = FunctionService.onRegion((Region)pr).withArgs((Object)dm.toString()).withFilter(filter);
            Log.getLogWriter().info("executing " + f.getId());
            ResultCollector rc = e.execute(f);
            Log.getLogWriter().info("Finished executing " + f.getId());
            List results = (List)rc.getResult();
            Log.getLogWriter().info("ResultCollector.getResult() = " + results);
            StringBuffer s = new StringBuffer();
            s.append("ResultCollector : \n");
            for (ModResult result : results) {
                if (result.getHashList().size() > 1) {
                    String err = "Keys in " + result.getDM().toString() + " mapped to more than one hash code " + result.getHashList() + "\n" + TestHelper.getStackTrace();
                    Log.getLogWriter().info(err);
                    throw new TestException(err);
                }
                s.append("   " + result.getDM().toString() + ": " + result.getNumKeys() + " entries with routingObjects (hashCodes) = " + result.getHashList() + "\n");
            }
            Log.getLogWriter().info(s.toString());
        }
    }

    @Override
    protected Object getNewKey() {
        Object key = super.getNewKey();
        if (this.customPartitionMethod == 3) {
            key = new ModRoutingObject(key);
        }
        return key;
    }

    @Override
    public BaseValueHolder getValueForKey(Object key) {
        if (key instanceof ModRoutingObject) {
            return super.getValueForKey(((ModRoutingObject)key).getKey());
        }
        return super.getValueForKey(key);
    }

    @Override
    protected void addEntry(Region aRegion) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        Object callback = this.getCallback(key, "Create event originated in pid ", ProcessMgr.getProcessId());
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.create(key, (Object)anObj, callback);
            Log.getLogWriter().info("addEntry: done creating key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj, callback);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
        if (this.customPartitionMethod == 2) {
            routingRegion.put(key, callback);
        }
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        if (this.customPartitionMethod == 2) {
            throw new TestException("putIfAbsent does not support callbacks.  This operation cannot be executed with customPartitionMethod.CALLBACK_RESOLVER");
        }
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
        }
        aRegion.putIfAbsent(key, (Object)anObj);
        Log.getLogWriter().info("putIfAbsent: done putting key " + key);
    }

    @Override
    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            Object callback = this.getCallback(key, "Invalidate event originated in pid ", ProcessMgr.getProcessId());
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                aRegion.localInvalidate(key, callback);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            Object callback = this.getCallback(key, "Destroy event originated in pid ", ProcessMgr.getProcessId());
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                aRegion.localDestroy(key, callback);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void remove(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            Log.getLogWriter().info("remove: removing key " + key);
            aRegion.remove(key, aRegion.get(key));
            Log.getLogWriter().info("remove: done removing key " + key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        BaseValueHolder anObj = this.getUpdateObject(aRegion, key);
        Object callback = this.getCallback(key, "Update event originated in pid ", ProcessMgr.getProcessId());
        Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
        aRegion.put(key, (Object)anObj, callback);
        Log.getLogWriter().info("Done with call to put (update)");
    }

    @Override
    protected BaseValueHolder getUpdateObject(Region aRegion, Object key) {
        BaseValueHolder anObj = null;
        anObj = this.customPartitionMethod == 3 ? super.getUpdateObject(aRegion, ((ModRoutingObject)key).getKey()) : super.getUpdateObject(aRegion, key);
        return anObj;
    }

    @Override
    protected void replace(Region aRegion) {
        if (this.customPartitionMethod == 2) {
            throw new TestException("ConcurrentMap API replace does not support callbackArgs");
        }
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        BaseValueHolder anObj = null;
        anObj = this.getUpdateObject(aRegion, key);
        Log.getLogWriter().info("replaceEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            aRegion.replace(key, aRegion.get(key), (Object)anObj);
        } else {
            aRegion.replace(key, (Object)anObj);
        }
        Log.getLogWriter().info("Done with call to replace");
    }

    @Override
    protected void getKey(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        Object callback = this.getCallback(key, "Get originated in pid ", ProcessMgr.getProcessId());
        Object anObj = null;
        Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
        anObj = aRegion.get(key, callback);
        Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
    }

    @Override
    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKey();
        Object callback = this.getCallback(key, "Get originated in pid ", ProcessMgr.getProcessId());
        int beforeSize = aRegion.size();
        Object anObj = null;
        Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
        anObj = aRegion.get(key, callback);
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
        if (this.customPartitionMethod == 2) {
            routingRegion.put(key, callback);
        }
    }

    private Object getCallback(Object key, String prefix, int pid) {
        String sCallback = prefix + pid;
        if (this.customPartitionMethod == 2) {
            Object o = routingRegion.get(key);
            if (o != null) {
                PidRoutingObject ro = (PidRoutingObject)routingRegion.get(key);
                return new PidRoutingObject(prefix, ro.getPid());
            }
            return new PidRoutingObject(prefix, pid);
        }
        return sCallback;
    }
}

