/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import parReg.tx.ObjectNameListener;
import util.NameFactory;
import util.OperationsClient;
import util.TestException;

public class ExecuteTx
extends OperationsClient
implements Function,
Declarable {
    private Object[] keySet;
    private ObjectNameListener myListener;
    private int numVms;

    public void execute(FunctionContext context) {
        ArrayList list = new ArrayList();
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isRegionContext = context instanceof RegionFunctionContext;
        boolean isPartitionedRegionContext = false;
        RegionFunctionContext regionContext = null;
        if (!(context instanceof RegionFunctionContext)) {
            throw new TestException("Function requires PartitionedRegionContext!");
        }
        regionContext = (RegionFunctionContext)context;
        isPartitionedRegionContext = PartitionRegionHelper.isPartitionedRegion((Region)regionContext.getDataSet());
        if (!isPartitionedRegionContext) {
            throw new TestException("Function requires PartitionedRegionContext!");
        }
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + context.getArguments().toString() + " with filter " + regionContext.getFilter());
        Region aRegion = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)regionContext);
        this.keySet = aRegion.keySet().toArray();
        this.myListener = (ObjectNameListener)aRegion.getAttributes().getCacheListener();
        this.numVms = TestConfig.getInstance().getTotalVMs() - 1;
        this.initializeOperationsClient();
        this.doEntryOperations(aRegion);
        context.getResultSender().lastResult((Object)true);
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public void init(Properties props) {
    }

    @Override
    protected Object getExistingKey(Region aRegion) {
        if (this.keySet.length == 0) {
            Log.getLogWriter().info("Could not get a random key from " + aRegion.getFullPath() + " because the region has no keys");
            return null;
        }
        Object key = this.keySet[TestConfig.tab().getRandGen().nextInt(0, this.keySet.length - 1)];
        Log.getLogWriter().info("getExistingKey() in " + RemoteTestModule.getMyClientName() + " returning " + key + " from keySet " + this.keySet);
        return key;
    }

    @Override
    protected Object getNewKey() {
        List hashCodes = this.myListener.getHashCodes();
        String key = null;
        int counter = 0;
        int hash = 0;
        while (!hashCodes.contains(hash = (counter = (int)NameFactory.getCounterForName(key = NameFactory.getNextPositiveObjectName())) % this.numVms)) {
        }
        Log.getLogWriter().info("getNewKey() returning key " + key + " with hashCode " + hash + ", local hashCodes = " + hashCodes);
        return key;
    }

    public boolean isHA() {
        return false;
    }
}

