/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionWriterException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PartitionDescription;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import parReg.tx.ExecuteOp;
import parReg.tx.GetAllMembersInDS;
import parReg.tx.GetKeySet;
import parReg.tx.GetNewKey;
import parReg.tx.GetValueForKey;
import parReg.tx.KeySetResult;
import parReg.tx.MixedRegionBB;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import tx.EntryValidator;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import util.BaseValueHolder;
import util.CacheUtil;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TxEventCountersBB;
import util.TxHelper;
import util.TxWriterCountersBB;
import util.ValueHolder;
import util.WriterCountersBB;

public class MixedRegionViewTest {
    public static MixedRegionViewTest testInstance = null;
    protected GsRandom rng;
    protected boolean txInProgress = false;
    protected boolean isProxy = false;
    protected Integer myVmPid;
    protected boolean initializeTxInfo = true;
    protected boolean checkEventCounters;
    protected boolean useFunctionExecution;
    protected TXStateInterface txContext = null;
    public RandomValues randomValues = null;
    protected int maxKeys;
    public int modValInitializer = 0;
    protected boolean isSerialExecution;
    protected HydraThreadLocal txState = new HydraThreadLocal();
    public static final int NO_REPLICATION_RESTRICTION = 0;
    public static final int USE_REPLICATED_REGION = 1;
    public static final int USE_PARTITIONED_REGION = 2;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String memberIdString = " memberId=";
    static int numPRsWithList = 1;
    static boolean useLocalKeySet;
    static final int WRITER_EVENTS = 0;
    static final int LISTENER_EVENTS = 1;

    public synchronized void initialize() {
        this.rng = TestConfig.tab().getRandGen();
        this.randomValues = new RandomValues();
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        if (this.isSerialExecution) {
            Log.getLogWriter().info("Test is running in SERIAL_EXECUTION mode");
        }
        this.useFunctionExecution = PrTxPrms.useFunctionExecution();
        Log.getLogWriter().info("useFunctionExecution = " + this.useFunctionExecution);
        this.myVmPid = new Integer(RemoteTestModule.getMyPid());
        this.checkEventCounters = TxPrms.checkEventCounters();
        Log.getLogWriter().info("checkEventCounters = " + this.checkEventCounters);
        useLocalKeySet = PrTxPrms.useLocalKeySet();
        Log.getLogWriter().info("useLocalKeySet = " + useLocalKeySet);
    }

    public synchronized void initialize(String regionConfig) {
        this.initialize();
        StringBuffer aStr = new StringBuffer();
        boolean alwaysFireLocalListeners = Boolean.getBoolean("gemfire.BucketRegion.alwaysFireLocalListeners");
        aStr.append("alwaysFireLocalListeners= " + alwaysFireLocalListeners + " ");
        PrTxBB.getBB().getSharedMap().put("alwaysFireLocalListeners", new Boolean(alwaysFireLocalListeners));
        RegionAttributes ratts = RegionHelper.getRegionAttributes(regionConfig);
        PartitionAttributes patts = ratts.getPartitionAttributes();
        int redundantCopies = patts.getRedundantCopies();
        aStr.append("redundantCopies = " + redundantCopies + " ");
        PrTxBB.getBB().getSharedMap().put("redundantCopies", new Integer(redundantCopies));
        if (alwaysFireLocalListeners) {
            numPRsWithList = redundantCopies + 1;
            aStr.append("calculated numPRsWithListener = " + numPRsWithList + " ");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public static MixedRegionViewTest getTestInstance() {
        return testInstance;
    }

    public static synchronized void HydraTask_createReplicatedRegions() {
        if (testInstance == null) {
            throw new TestException("HydraTask_createReplicatedRegions: createPartitionedRegions must be invoked prior to this method");
        }
        if (CacheUtil.getCache() == null) {
            throw new TestException("HydraTask_createReplicatedRegions: createPartitionedRegions must be invoked prior to this method");
        }
        testInstance.createRegionHierarchy(ConfigPrms.getRegionConfig());
    }

    public void createRegionHierarchy(String regionConfig) {
        int numRoots = TestConfig.tab().intAt(TxPrms.numRootRegions);
        int breadth = TestConfig.tab().intAt(TxPrms.numSubRegions);
        int depth = TestConfig.tab().intAt(TxPrms.regionDepth);
        Object r = null;
        for (int i = 0; i < numRoots; ++i) {
            String rootName = "root" + (i + 1);
            Region rootRegion = RegionHelper.createRegion(rootName, regionConfig);
            Log.getLogWriter().info("Created root region " + rootName);
            this.createEntries(rootRegion);
            this.createSubRegions(rootRegion, breadth, depth, "Region");
        }
    }

    private void createSubRegions(Region r, int numChildren, int levelsLeft, String parentName) {
        String regionConfig = ConfigPrms.getRegionConfig();
        for (int i = 1; i <= numChildren; ++i) {
            String currentName = parentName + "-" + i;
            Region child = null;
            try {
                RegionAttributes regionAttrs = RegionHelper.getRegionAttributes(regionConfig);
                this.isProxy = regionAttrs.getDataPolicy().isEmpty();
                child = r.createSubregion(currentName, regionAttrs);
                Log.getLogWriter().info("Created subregion " + TestHelper.regionToString(child, true));
            }
            catch (RegionExistsException e) {
                child = r.getSubregion(currentName);
                Log.getLogWriter().info("Got subregion " + TestHelper.regionToString(child, true));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            this.createEntries(child);
            if (levelsLeft <= 1) continue;
            this.createSubRegions(child, numChildren, levelsLeft - 1, currentName);
        }
    }

    private void createEntries(Region aRegion) {
        this.maxKeys = TestConfig.tab().intAt(TxPrms.maxKeys, 10);
        long startKey = 0L;
        for (int i = 0; i < this.maxKeys; ++i) {
            String key = NameFactory.getObjectNameForCounter(startKey + (long)i);
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, startKey + (long)i);
            ValueHolder val = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer));
            ++this.modValInitializer;
            String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            try {
                aRegion.create((Object)key, (Object)val, (Object)callback);
            }
            catch (RegionDestroyedException e) {
                if (this.isSerialExecution) {
                    throw e;
                }
                Log.getLogWriter().info("Created " + i + " keys in " + aRegion.getFullPath() + " before getting " + (Object)((Object)e) + "; continuing test");
                break;
            }
            catch (EntryExistsException e) {
                Log.getLogWriter().fine("Created via distribution in region <" + aRegion.getFullPath() + "> " + key + " = " + ((Object)val).toString());
                continue;
            }
            Log.getLogWriter().fine("Created in region <" + aRegion.getFullPath() + "> " + key + " = " + ((Object)val).toString());
        }
    }

    public static synchronized void HydraTask_createPartitionedRegions() {
        if (testInstance == null) {
            testInstance = new MixedRegionViewTest();
            try {
                testInstance.createPartitionedRegions();
                testInstance.initialize(ConfigPrms.getRegionConfig());
                testInstance.registerFunctions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("HydraTask_createPartitionedRegions caught Exception " + e + ":" + e.getMessage());
                throw new TestException("HydraTask_createPartitionedRegions caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    public void createPartitionedRegions() {
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            CacheUtil.setCache(c);
            c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
            c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
            if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
                c.setCopyOnRead(true);
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            PartitionDescription pd = rd.getPartitionDescription();
            PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
            PartitionAttributes prAttrs = null;
            String colocatedWith = null;
            int numRegions = PrTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                if (i > 0) {
                    colocatedWith = regionBase + "_" + i;
                    prFactory.setColocatedWith(colocatedWith);
                    prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                }
                Region region = RegionHelper.createRegion(regionName, aFactory);
            }
        }
    }

    public static void HydraTask_populateRegions() {
        testInstance.populateRegions();
    }

    protected void populateRegions() {
        Set regions = CacheUtil.getCache().rootRegions();
        Region sampleRegion = null;
        for (Region sRegion : regions) {
            if (!PartitionRegionHelper.isPartitionedRegion((Region)sRegion)) continue;
            sampleRegion = sRegion;
            break;
        }
        if (sampleRegion == null) {
            throw new TestException("There are no PartitionedRegions present.  Check test config");
        }
        int numBuckets = sampleRegion.getAttributes().getPartitionAttributes().getTotalNumBuckets() * TestHelper.getNumVMs();
        for (int i = 0; i < numBuckets; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            Set rootRegions = CacheUtil.getCache().rootRegions();
            for (Region aRegion : rootRegions) {
                if (!PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) continue;
                ValueHolder vh = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer++));
                String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
                Log.getLogWriter().info("populateRegion: calling create for key " + key + ", object " + TestHelper.toString(vh) + ", region is " + aRegion.getFullPath());
                aRegion.create((Object)key, (Object)vh, (Object)callback);
                Log.getLogWriter().info("populateRegion: done creating key " + key);
            }
        }
    }

    public static void HydraTask_dumpLocalKeys() {
        testInstance.dumpLocalKeys();
    }

    protected void dumpLocalKeys() {
        StringBuffer aStr = new StringBuffer();
        DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        aStr.append("Keys hosted as primary " + dm.toString() + " by region\n");
        Set rootRegions = CacheUtil.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Region localRegion = PartitionRegionHelper.getLocalData((Region)aRegion);
            Set keySet = localRegion.keySet();
            HashSet primaryKeySet = new HashSet();
            for (Object key : keySet) {
                DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, key);
                if (!primary.equals(dm)) continue;
                primaryKeySet.add(key);
            }
            aStr.append("   " + aRegion.getName() + ": " + primaryKeySet + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected void registerFunctions() {
        Declarable f = new GetAllMembersInDS();
        FunctionService.registerFunction((Function)f);
        f = new GetNewKey();
        FunctionService.registerFunction((Function)f);
        f = new GetKeySet();
        FunctionService.registerFunction((Function)f);
        f = new GetValueForKey();
        FunctionService.registerFunction((Function)f);
        f = new ExecuteOp();
        FunctionService.registerFunction((Function)f);
        Log.getLogWriter().info("Registered functions: " + FunctionService.getRegisteredFunctions());
    }

    private void initializeTxInfo() {
        Integer txVmPid = new Integer(RemoteTestModule.getMyPid());
        TxBB.getBB().getSharedMap().put(TxBB.TX_VM_PID, txVmPid);
        Log.getLogWriter().info("Putting txVmPid into BB at " + TxBB.TX_VM_PID + " with value = " + txVmPid);
        String myClientName = RemoteTestModule.getMyClientName();
        TxBB.getBB().getSharedMap().put(TxBB.TX_VM_CLIENTNAME, myClientName);
        Log.getLogWriter().info("Putting clientVmName of txVm into BB at " + TxBB.TX_VM_CLIENTNAME + " with value " + myClientName);
        TxBB.getBB().getSharedMap().put(TxBB.TxWriterAction, TxBB.TXACTION_NONE);
        this.initializeTxInfo = false;
    }

    public static void HydraTask_executeTx() {
        TestHelper.checkForEventError(TxBB.getBB());
        testInstance.executeTx();
    }

    protected void executeTx() {
        if (this.initializeTxInfo) {
            this.initializeTxInfo();
        }
        if (this.txInProgress) {
            TxHelper.internalResume(this.txContext);
            this.finishTx();
        } else {
            this.beginTx();
            this.txContext = TxHelper.internalSuspend();
        }
        this.txInProgress = !this.txInProgress;
    }

    protected void beginTx() {
        long txNum = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.TX_NUMBER);
        Log.getLogWriter().info("In beginTx() for TX_NUMBER = " + txNum);
        MasterController.sleepForMs(10000);
        TxBB.getBB().getSharedCounters().increment(TxBB.PROCESS_EVENTS);
        Log.getLogWriter().fine("Clearing BB NON_TX_OPLIST");
        TxBB.getBB().getSharedMap().remove(TxBB.NON_TX_OPLIST);
        Log.getLogWriter().info("Removing CacheListener operation lists from BB");
        TxBB.getBB().getSharedMap().remove(TxBB.LocalListenerOpListPrefix + (txNum - 1L));
        TxBB.getBB().getSharedMap().remove(TxBB.RemoteListenerOpListPrefix + (txNum - 1L));
        this.checkAndClearEventCounters();
        TxHelper.begin();
        boolean allowGetOperations = true;
        OpList opList = MixedRegionViewTest.doOperations(allowGetOperations);
        TxBB.putOpList(opList);
        TxBB.getBB().getSharedMap().put(TxBB.TX_OPLIST_KEY, TxBB.getOpListKey());
        Log.getLogWriter().info("validating tx state");
        this.validateTxOps(true);
        this.setExpectedEventCounts();
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        sc.zero(TxBB.TX_COMPLETED);
        sc.increment(TxBB.TX_READY_FOR_VALIDATION);
    }

    protected void finishTx() {
        int n = this.rng.nextInt(1, 100);
        int commitPercentage = TxPrms.getCommitPercentage();
        boolean failedCommit = false;
        boolean txAborted = false;
        boolean isCausedByTransactionWriterException = false;
        if (n <= commitPercentage) {
            block12: {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    failedCommit = true;
                    TxBB.inc(TxBB.NUM_EXPECTED_FAILED_COMMIT);
                    Log.getLogWriter().info("finishTx() caught " + e.toString());
                    Throwable causedBy = e.getCause();
                    if (!(causedBy instanceof TransactionWriterException)) break block12;
                    isCausedByTransactionWriterException = true;
                }
            }
            if (failedCommit && !isCausedByTransactionWriterException && !TxBB.getBB().getSharedMap().get(TxBB.TxWriterAction).equals(TxBB.TXACTION_NONE)) {
                throw new TestException("Invoked TransactionWriter after conflict detected " + TestHelper.getStackTrace());
            }
            if (TxBB.getBB().getSharedMap().get(TxBB.TxWriterAction).equals(TxBB.TXACTION_ABORT)) {
                txAborted = true;
            }
            if (!(!txAborted || failedCommit && isCausedByTransactionWriterException)) {
                throw new TestException("TransactionWriter threw TransactionWriterException (to abort tx), but caller did not process ConflictException Caused by TransactionWriterException " + TestHelper.getStackTrace());
            }
            if (failedCommit && isCausedByTransactionWriterException && !txAborted) {
                throw new TestException("Unexpected TX ABORT " + TestHelper.getStackTrace());
            }
            if (failedCommit) {
                if (txAborted) {
                    TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_ABORT);
                } else {
                    TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_ROLLBACK);
                }
                this.validateCommittedState(false);
            } else {
                TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_COMMIT);
                this.validateCommittedState(true);
            }
        } else {
            TxBB.inc(TxBB.NUM_EXPECTED_ROLLBACK);
            TxHelper.rollback();
            TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_ROLLBACK);
            this.validateCommittedState(false);
        }
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        sc.zero(TxBB.TX_READY_FOR_VALIDATION);
        sc.increment(TxBB.TX_COMPLETED);
    }

    protected void validateCommittedState(boolean txCommitted) {
        if (this.isProxy) {
            return;
        }
        if (txCommitted) {
            Log.getLogWriter().info("TX COMPLETED: validating tx committed");
            this.validateCombinedOpsAfterCommit();
        } else {
            Log.getLogWriter().info("TX COMPLETED: validating tx rollback");
            this.validateCombinedOpsAfterRollback();
        }
    }

    protected void validateCombinedOpsAfterCommit() {
        int j;
        int i;
        OpList nonTxOpList = (OpList)TxBB.getBB().getSharedMap().get(TxBB.NON_TX_OPLIST);
        if (nonTxOpList == null) {
            this.validateTxOps(true, TxBB.TXACTION_COMMIT);
            return;
        }
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        OpList fullList = new OpList();
        for (i = 0; i < nonTxOpList.numOps(); ++i) {
            Operation nonTxOp = nonTxOpList.getOperation(i);
            for (j = 0; j < txOpList.numOps(); ++j) {
                Operation txOp = txOpList.getOperation(j);
                if (txOp.isEntryGet() || !nonTxOp.affectedBy(txOp)) continue;
                if (txOp.isEntryDestroy()) {
                    nonTxOp = null;
                    break;
                }
                nonTxOp.setNewValue(txOp.getNewValue());
            }
            if (nonTxOp == null) continue;
            fullList.add(nonTxOp);
        }
        for (i = 0; i < txOpList.numOps(); ++i) {
            Operation txOp = txOpList.getOperation(i);
            for (j = 0; j < nonTxOpList.numOps(); ++j) {
                Operation nonTxOp = nonTxOpList.getOperation(j);
                if (!txOp.affectedBy(nonTxOp) || txOp.isEntryDestroy()) continue;
                txOp = null;
                break;
            }
            if (txOp == null) continue;
            fullList.add(txOp);
        }
        Log.getLogWriter().fine("COMBINED NON-TX & TX OPS = " + fullList);
        this.validateState(fullList, true);
    }

    protected void validateCombinedOpsAfterRollback() {
        OpList nonTxOpList = (OpList)TxBB.getBB().getSharedMap().get(TxBB.NON_TX_OPLIST);
        if (nonTxOpList == null) {
            this.validateTxOps(false, TxBB.TXACTION_ROLLBACK);
            return;
        }
        this.validateNonTxOps();
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        OpList shortList = new OpList();
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Operation txOp = txOpList.getOperation(i);
            for (int j = 0; j < nonTxOpList.numOps(); ++j) {
                Operation nonTxOp = nonTxOpList.getOperation(j);
                if (!txOp.affectedBy(nonTxOp)) continue;
                txOp = null;
                break;
            }
            if (txOp == null) continue;
            shortList.add(txOp);
        }
        Log.getLogWriter().fine("TXOPS NOT AFFECTED BY NON-TX OPS = " + shortList);
        this.validateState(shortList, false);
    }

    public static void HydraTask_checkCommittedState() {
        Log.getLogWriter().info("HydraTask_checkCommittedState(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        MasterController.sleepForMs(1000);
        testInstance.checkCommittedState();
        if (TxBB.getBB().getSharedCounters().read(TxBB.TX_COMPLETED) == 1L) {
            TxBB.getBB().getSharedCounters().zero(TxBB.PROCESS_EVENTS);
        }
    }

    protected void checkCommittedState() {
        if (TxBB.getBB().getSharedCounters().read(TxBB.TX_READY_FOR_VALIDATION) == 1L) {
            boolean executeNonTxOperations = TxPrms.getExecuteNonTxOperations();
            Log.getLogWriter().info("TxPrms.getExecuteNonTxOperations() = " + executeNonTxOperations);
            if (executeNonTxOperations) {
                Log.getLogWriter().info("executing non-tx operations");
                OpList opList = MixedRegionViewTest.doOperations();
                TxBB.getBB().getSharedMap().put(TxBB.NON_TX_OPLIST, opList);
                Log.getLogWriter().info("non-tx operations written to BB " + opList.toString());
            } else {
                Log.getLogWriter().info("check view, TX in progress, we should only see committed state");
            }
            if (!this.validateNonTxOps()) {
                this.validateTxOps(false);
            }
            return;
        }
        if (TxBB.getBB().getSharedCounters().read(TxBB.TX_COMPLETED) == 1L) {
            String txAction = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION);
            if (txAction.equals(TxBB.TXACTION_COMMIT)) {
                Log.getLogWriter().info("validate tx committed");
                this.validateCombinedOpsAfterCommit();
            } else {
                Log.getLogWriter().info("validate tx rollback");
                this.validateCombinedOpsAfterRollback();
            }
            return;
        }
        Log.getLogWriter().info("checkCommittedState: no tx state to verify, returning");
    }

    protected void validateAllStates(boolean isTxVisible) {
        this.validateNonTxOps();
        this.validateTxOps(isTxVisible);
    }

    protected boolean validateNonTxOps() {
        boolean nonTxOpsVerified = false;
        OpList nonTxOpList = (OpList)TxBB.getBB().getSharedMap().get(TxBB.NON_TX_OPLIST);
        if (nonTxOpList != null) {
            Log.getLogWriter().info("validateAllStates() - verifying state with nonTxOpList");
            this.validateState(nonTxOpList, true);
            nonTxOpsVerified = true;
        }
        return nonTxOpsVerified;
    }

    protected boolean validateTxOps(boolean isTxVisible) {
        return this.validateTxOps(isTxVisible, TxBB.TXACTION_NONE);
    }

    protected boolean validateTxOps(boolean isTxVisible, String txAction) {
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        Log.getLogWriter().info("validateAllStates() - verifying state with txOpList");
        this.validateState(txOpList, isTxVisible, txAction);
        return true;
    }

    protected void validateState(OpList opList, boolean isVisible) {
        this.validateState(opList, isVisible, TxBB.TXACTION_NONE);
    }

    protected void validateState(OpList opList, boolean isVisible, String txAction) {
        opList = opList.collapse(txAction);
        for (int i = 0; i < opList.numOps(); ++i) {
            Operation op = opList.getOperation(i);
            if (op.isLocalOperation() && !MixedRegionViewTest.inTxVm()) {
                Log.getLogWriter().fine("validateState() - isVisible forced to false");
                isVisible = false;
            }
            if (!op.isEntryOperation()) {
                throw new TestException("Unknown operation " + op);
            }
            EntryValidator expectedValues = EntryValidator.getExpected(op, isVisible);
            EntryValidator actualValues = EntryValidator.getActual(op);
            expectedValues.compare(actualValues);
        }
    }

    protected void checkWriterCounters() {
        SharedCounters counters = MixedRegionBB.getBB().getSharedCounters();
        long writerCreate = counters.read(MixedRegionBB.WRITER_CREATE);
        long writerCreateIsLoad = counters.read(MixedRegionBB.WRITER_CREATE_ISLOAD);
        long writerUpdate = counters.read(MixedRegionBB.WRITER_UPDATE);
        long writerUpdateIsLoad = counters.read(MixedRegionBB.WRITER_UPDATE_ISLOAD);
        long writerDestroy = counters.read(MixedRegionBB.WRITER_DESTROY);
        long writerInval = counters.read(MixedRegionBB.WRITER_INVALIDATE);
        long writerLocalDestroy = 0L;
        long writerLocalInval = 0L;
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numBeforeCreateEvents_isDist", writerCreate + writerCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotExp", writerCreate + writerCreateIsLoad));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeCreateEvents_isNotRemote", writerCreate + writerCreateIsLoad));
        } else {
            al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", "numBeforeCreateEvents_isNotRemote", writerCreate + writerCreateIsLoad));
        }
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLoad", writerCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLoad", writerCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLocalLoad", writerCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLocalLoad", writerCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetLoad", writerCreate + writerCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetSearch", writerCreate + writerCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isDist", writerDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotExp", writerDestroy));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotRemote", writerDestroy));
        } else {
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", "numBeforeDestroyEvents_isNotRemote", writerDestroy));
        }
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLoad", writerDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLocalLoad", writerDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetLoad", writerDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetSearch", writerDestroy));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isDist", writerUpdate + writerUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotExp", writerUpdate + writerUpdateIsLoad));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotRemote", writerUpdate + writerUpdateIsLoad));
        } else {
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", "numBeforeUpdateEvents_isNotRemote", writerUpdate + writerUpdateIsLoad));
        }
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLoad", writerUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLoad", writerUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLocalLoad", writerUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLocalLoad", writerUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetLoad", writerUpdate + writerUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetSearch", writerUpdate + writerUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotRemote", 0L));
        WriterCountersBB.getBB().checkEventCounters(al);
    }

    protected void checkTxWriterCounters() {
        SharedCounters counters = MixedRegionBB.getBB().getSharedCounters();
        long prWriterCreate = counters.read(MixedRegionBB.PR_LISTENER_CREATE);
        long prWriterCreateIsLoad = counters.read(MixedRegionBB.PR_LISTENER_CREATE_ISLOAD);
        long prWriterUpdate = counters.read(MixedRegionBB.PR_LISTENER_UPDATE);
        long prWriterUpdateIsLoad = counters.read(MixedRegionBB.PR_LISTENER_UPDATE_ISLOAD);
        long prWriterDestroy = counters.read(MixedRegionBB.PR_LISTENER_DESTROY);
        long rrWriterCreate = counters.read(MixedRegionBB.RR_LISTENER_CREATE);
        long rrWriterCreateIsLoad = counters.read(MixedRegionBB.RR_LISTENER_CREATE_ISLOAD);
        long rrWriterUpdate = counters.read(MixedRegionBB.RR_LISTENER_UPDATE);
        long rrWriterUpdateIsLoad = counters.read(MixedRegionBB.RR_LISTENER_UPDATE_ISLOAD);
        long rrWriterDestroy = counters.read(MixedRegionBB.RR_LISTENER_DESTROY);
        long writerCreate = prWriterCreate + rrWriterCreate;
        long writerCreateIsLoad = prWriterCreateIsLoad + rrWriterCreateIsLoad;
        long writerUpdate = prWriterUpdate + rrWriterUpdate;
        long writerUpdateIsLoad = prWriterUpdateIsLoad + rrWriterUpdateIsLoad;
        long writerDestroy = prWriterDestroy + rrWriterDestroy;
        if (this.isProxy) {
            long numConflatedCreateDestroy = counters.read(MixedRegionBB.CONFLATED_CREATE_DESTROY);
            writerDestroy += numConflatedCreateDestroy;
        }
        long writerLocalDestroy = 0L;
        long writerLocalInval = 0L;
        String endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION);
        if (endResult == null) {
            return;
        }
        if (!endResult.equals(TxBB.TXACTION_COMMIT) && endResult.equals(TxBB.TXACTION_ROLLBACK)) {
            writerCreate = 0L;
            writerCreateIsLoad = 0L;
            writerUpdate = 0L;
            writerUpdateIsLoad = 0L;
            writerDestroy = 0L;
        }
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numCreateTxEvents_isDist", writerCreate + writerCreateIsLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotExp", writerCreate + writerCreateIsLoad));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numCreateTxEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numCreateTxEvents_isNotRemote", writerCreate + writerCreateIsLoad));
        } else {
            al.add(new ExpCounterValue("numCreateTxEvents_isRemote", writerCreate + writerCreateIsLoad));
            al.add(new ExpCounterValue("numCreateTxEvents_isNotRemote", 0L));
        }
        al.add(new ExpCounterValue("numCreateTxEvents_isLoad", writerCreateIsLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLoad", writerCreate));
        al.add(new ExpCounterValue("numCreateTxEvents_isLocalLoad", writerCreateIsLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLocalLoad", writerCreate));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetLoad", writerCreate + writerCreateIsLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetSearch", writerCreate + writerCreateIsLoad));
        al.add(new ExpCounterValue("numDestroyTxEvents_isDist", writerDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotExp", writerDestroy));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numDestroyTxEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numDestroyTxEvents_isNotRemote", writerDestroy));
        } else {
            al.add(new ExpCounterValue("numDestroyTxEvents_isRemote", writerDestroy));
            al.add(new ExpCounterValue("numDestroyTxEvents_isNotRemote", 0L));
        }
        al.add(new ExpCounterValue("numDestroyTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLoad", writerDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLocalLoad", writerDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetLoad", writerDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetSearch", writerDestroy));
        al.add(new ExpCounterValue("numUpdateTxEvents_isDist", writerUpdate + writerUpdateIsLoad));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotExp", writerUpdate + writerUpdateIsLoad));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numUpdateTxEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numUpdateTxEvents_isNotRemote", writerUpdate + writerUpdateIsLoad));
        } else {
            al.add(new ExpCounterValue("numUpdateTxEvents_isRemote", writerUpdate + writerUpdateIsLoad));
            al.add(new ExpCounterValue("numUpdateTxEvents_isNotRemote", 0L));
        }
        al.add(new ExpCounterValue("numUpdateTxEvents_isLoad", writerUpdateIsLoad));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLoad", writerUpdate));
        al.add(new ExpCounterValue("numUpdateTxEvents_isLocalLoad", writerUpdateIsLoad));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLocalLoad", writerUpdate));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetLoad", writerUpdate + writerUpdateIsLoad));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetSearch", writerUpdate + writerUpdateIsLoad));
        TxWriterCountersBB.getBB().checkEventCounters(al);
    }

    protected void checkEventCounters() {
        SharedCounters counters = MixedRegionBB.getBB().getSharedCounters();
        int numVmsWithList = TestHelper.getNumVMs();
        long prListenerCreate = counters.read(MixedRegionBB.PR_LISTENER_CREATE);
        long prListenerCreateIsLoad = counters.read(MixedRegionBB.PR_LISTENER_CREATE_ISLOAD);
        long prListenerUpdate = counters.read(MixedRegionBB.PR_LISTENER_UPDATE);
        long prListenerUpdateIsLoad = counters.read(MixedRegionBB.PR_LISTENER_UPDATE_ISLOAD);
        long prListenerDestroy = counters.read(MixedRegionBB.PR_LISTENER_DESTROY);
        long prListenerInval = counters.read(MixedRegionBB.PR_LISTENER_INVALIDATE);
        long rrListenerCreate = counters.read(MixedRegionBB.RR_LISTENER_CREATE);
        long rrListenerCreateIsLoad = counters.read(MixedRegionBB.RR_LISTENER_CREATE_ISLOAD);
        long rrListenerUpdate = counters.read(MixedRegionBB.RR_LISTENER_UPDATE);
        long rrListenerUpdateIsLoad = counters.read(MixedRegionBB.RR_LISTENER_UPDATE_ISLOAD);
        long rrListenerDestroy = counters.read(MixedRegionBB.RR_LISTENER_DESTROY);
        long rrListenerInval = counters.read(MixedRegionBB.RR_LISTENER_INVALIDATE);
        long numConflatedCreateDestroy = 0L;
        if (this.isProxy) {
            numConflatedCreateDestroy = counters.read(MixedRegionBB.CONFLATED_CREATE_DESTROY);
        }
        long numClose = 0L;
        String endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION);
        if (endResult == null) {
            return;
        }
        if (!endResult.equals(TxBB.TXACTION_COMMIT)) {
            prListenerCreate = 0L;
            prListenerCreateIsLoad = 0L;
            prListenerUpdate = 0L;
            prListenerUpdateIsLoad = 0L;
            prListenerDestroy = 0L;
            prListenerInval = 0L;
            rrListenerCreate = 0L;
            rrListenerCreateIsLoad = 0L;
            rrListenerUpdate = 0L;
            rrListenerUpdateIsLoad = 0L;
            rrListenerDestroy = 0L;
            rrListenerInval = 0L;
            numConflatedCreateDestroy = 0L;
        }
        Log.getLogWriter().info("For PartitionedRegions, expect callbacks from " + numPRsWithList + " dataStores.");
        Log.getLogWriter().info("For ReplicatedRegions, expect callbacks from " + numVmsWithList + " VMs.");
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", (prListenerCreate + prListenerCreateIsLoad) * (long)numPRsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", (prListenerCreate + prListenerCreateIsLoad) * (long)numPRsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", "numAfterCreateEvents_isNotRemote", (prListenerCreate + prListenerCreateIsLoad) * (long)numPRsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", prListenerCreateIsLoad * (long)numPRsWithList + rrListenerCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", prListenerCreate * (long)numPRsWithList + rrListenerCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", prListenerCreateIsLoad * (long)numPRsWithList + rrListenerCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", prListenerCreate * (long)numPRsWithList + rrListenerCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", (prListenerCreate + prListenerCreateIsLoad) * (long)numPRsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", (prListenerCreate + prListenerCreateIsLoad) * (long)numPRsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", prListenerDestroy * (long)numPRsWithList + rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", prListenerDestroy * (long)numPRsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", "numAfterDestroyEvents_isNotRemote", prListenerDestroy * (long)numPRsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", prListenerDestroy * (long)numPRsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", prListenerDestroy * (long)numPRsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", prListenerDestroy * (long)numPRsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", prListenerDestroy * (long)numPRsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", "numAfterInvalidateEvents_isNotRemote", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", prListenerInval * (long)numPRsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPRsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPRsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", "numAfterUpdateEvents_isNotRemote", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPRsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", prListenerUpdateIsLoad * (long)numPRsWithList + rrListenerUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", prListenerUpdate * (long)numPRsWithList + rrListenerUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", prListenerUpdateIsLoad * (long)numPRsWithList + rrListenerUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", prListenerUpdate * (long)numPRsWithList + rrListenerUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPRsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPRsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numClose", numClose, false));
        EventCountersBB.getBB().checkEventCounters(al);
    }

    protected void checkTxEventCounters() {
        String endResult;
        SharedCounters counters = MixedRegionBB.getBB().getSharedCounters();
        int numVmsWithList = TestHelper.getNumVMs();
        int numPrsWithList = numPRsWithList;
        long prListenerCreate = counters.read(MixedRegionBB.PR_LISTENER_CREATE);
        long prListenerCreateIsLoad = counters.read(MixedRegionBB.PR_LISTENER_CREATE_ISLOAD);
        long prListenerUpdate = counters.read(MixedRegionBB.PR_LISTENER_UPDATE);
        long prListenerUpdateIsLoad = counters.read(MixedRegionBB.PR_LISTENER_UPDATE_ISLOAD);
        long prListenerDestroy = counters.read(MixedRegionBB.PR_LISTENER_DESTROY);
        long prListenerInval = counters.read(MixedRegionBB.PR_LISTENER_INVALIDATE);
        long rrListenerCreate = counters.read(MixedRegionBB.RR_LISTENER_CREATE);
        long rrListenerCreateIsLoad = counters.read(MixedRegionBB.RR_LISTENER_CREATE_ISLOAD);
        long rrListenerUpdate = counters.read(MixedRegionBB.RR_LISTENER_UPDATE);
        long rrListenerUpdateIsLoad = counters.read(MixedRegionBB.RR_LISTENER_UPDATE_ISLOAD);
        long rrListenerDestroy = counters.read(MixedRegionBB.RR_LISTENER_DESTROY);
        long rrListenerInval = counters.read(MixedRegionBB.RR_LISTENER_INVALIDATE);
        long numConflatedCreateDestroy = 0L;
        if (this.isProxy) {
            numConflatedCreateDestroy = counters.read(MixedRegionBB.CONFLATED_CREATE_DESTROY);
        }
        if ((endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION)) == null) {
            return;
        }
        if (!endResult.equals(TxBB.TXACTION_COMMIT)) {
            numPrsWithList = 1;
            numVmsWithList = 1;
            numConflatedCreateDestroy = 0L;
        }
        Log.getLogWriter().info("For PartitionedRegions, expect callbacks from " + numPrsWithList + " dataStores.");
        Log.getLogWriter().info("For ReplicatedRegions, expect callbacks from " + numVmsWithList + " VMs.");
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numCreateTxEvents_isDist", (prListenerCreate + prListenerCreateIsLoad) * (long)numPrsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotExp", (prListenerCreate + prListenerCreateIsLoad) * (long)numPrsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isRemote", "numCreateTxEvents_isNotRemote", (prListenerCreate + prListenerCreateIsLoad) * (long)numPrsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isLoad", prListenerCreateIsLoad * (long)numPrsWithList + rrListenerCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLoad", prListenerCreate * (long)numPrsWithList + rrListenerCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isLocalLoad", prListenerCreateIsLoad * (long)numPrsWithList + rrListenerCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLocalLoad", prListenerCreate * (long)numPrsWithList + rrListenerCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetLoad", (prListenerCreate + prListenerCreateIsLoad) * (long)numPrsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetSearch", (prListenerCreate + prListenerCreateIsLoad) * (long)numPrsWithList + (rrListenerCreate + rrListenerCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numDestroyTxEvents_isDist", prListenerDestroy * (long)numPrsWithList + rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotExp", prListenerDestroy * (long)numPrsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numDestroyTxEvents_isRemote", "numDestroyTxEvents_isNotRemote", prListenerDestroy * (long)numPrsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numDestroyTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLoad", prListenerDestroy * (long)numPrsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numDestroyTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLocalLoad", prListenerDestroy * (long)numPrsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetLoad", prListenerDestroy * (long)numPrsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetSearch", prListenerDestroy * (long)numPrsWithList + (rrListenerDestroy * (long)numVmsWithList + numConflatedCreateDestroy)));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isDist", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotExp", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isRemote", "numInvalidateTxEvents_isNotRemote", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotLoad", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotLocalLoad", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotNetLoad", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotNetSearch", prListenerInval * (long)numPrsWithList + rrListenerInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isDist", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPrsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotExp", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPrsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isRemote", "numUpdateTxEvents_isNotRemote", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPrsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isLoad", prListenerUpdateIsLoad * (long)numPrsWithList + rrListenerUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLoad", prListenerUpdate * (long)numPrsWithList + rrListenerUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isLocalLoad", prListenerUpdateIsLoad * (long)numPrsWithList + rrListenerUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLocalLoad", prListenerUpdate * (long)numPrsWithList + rrListenerUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetLoad", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPrsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetSearch", (prListenerUpdate + prListenerUpdateIsLoad) * (long)numPrsWithList + (rrListenerUpdate + rrListenerUpdateIsLoad) * (long)numVmsWithList));
        TxEventCountersBB.getBB().checkEventCounters(al);
    }

    private void setExpectedEventCounts() {
        if (!this.checkEventCounters) {
            return;
        }
        MixedRegionBB.getBB().zeroEventCounters();
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        this.incrementEventCounters(txOpList, 0);
        this.incrementEventCounters(txOpList.getEntriesWithUniqueKeys(txOpList.getEntryOps()), 1);
    }

    private boolean updatedInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        int i = 0;
        for (i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
        }
        ++i;
        while (i < txOpList.numOps()) {
            tmpOp = txOpList.getOperation(i);
            if (tmpOp.isEntryUpdate() && tmpOp.usesSameRegionAndKey(op)) {
                Log.getLogWriter().info("updatedInThisTx returning TRUE + updateOperation = " + tmpOp.toString() + " occurred after get/loadOp = " + op.toString());
                rc = true;
                break;
            }
            ++i;
        }
        return rc;
    }

    private boolean invalidatedInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        for (int i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            if (!tmpOp.isEntryInvalidate() || !tmpOp.usesSameRegionAndKey(op)) continue;
            Log.getLogWriter().info("invalidatedInThisTx returning TRUE + invalidateOperation = " + tmpOp.toString() + " occurred before op = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    private boolean createdInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        for (int i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            if (!tmpOp.isEntryCreate() || !tmpOp.usesSameRegionAndKey(op)) continue;
            Log.getLogWriter().info("createdInThisTx returning TRUE, createOperation = " + tmpOp.toString() + " occurred prior to destroyOp = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    private boolean destroyedBeforeLoadInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        for (int i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            if (!tmpOp.isEntryDestroy() || !tmpOp.usesSameRegionAndKey(op)) continue;
            Log.getLogWriter().info("destroyedBeforeLoad returning TRUE + destroyOperation = " + tmpOp.toString() + " occurred prior to getOperation = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    private boolean destroyedInThisTx(Operation op) {
        Operation tmpOp;
        int i;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        Log.getLogWriter().fine("Searching for original (create) operation in OpList, op = " + op.toString());
        for (i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            Log.getLogWriter().fine("operation " + tmpOp.toString() + " does not match createOp = " + op.toString());
        }
        Log.getLogWriter().fine("Found original operation in opList " + op.toString());
        Log.getLogWriter().fine("Searching for an entry-destroy on same region/key as createOp  " + op.toString());
        ++i;
        while (i < txOpList.numOps()) {
            tmpOp = txOpList.getOperation(i);
            if (tmpOp.isEntryDestroy() && tmpOp.usesSameRegionAndKey(op)) {
                Log.getLogWriter().info("destroyedInThisTx returning TRUE + destroyOperation = " + tmpOp.toString() + " occurred prior to createOp = " + op.toString());
                rc = true;
                break;
            }
            Log.getLogWriter().fine("Operation " + tmpOp.toString() + " does not match createOp = " + op.toString());
            ++i;
        }
        return rc;
    }

    public void incrementEventCounters(OpList txOpList, int counterType) {
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Region aRegion;
            boolean isPartitioned = false;
            Operation op = txOpList.getOperation(i);
            String opName = op.getOpName();
            if (counterType == 1 && PartitionRegionHelper.isPartitionedRegion((Region)(aRegion = RegionHelper.getRegion(op.getRegionName())))) {
                isPartitioned = true;
            }
            boolean isLoad = false;
            if (op.isEntryGet()) {
                if (op.isPreviouslyInvalid() || this.invalidatedInThisTx(op)) {
                    opName = "entry-update";
                    isLoad = true;
                } else if (this.destroyedBeforeLoadInThisTx(op)) {
                    opName = counterType == 0 ? "entry-create" : "entry-update";
                } else if (op.getOldValue() == null) {
                    opName = "entry-create";
                    isLoad = true;
                    if (counterType == 1 && this.updatedInThisTx(op)) {
                        isLoad = false;
                    }
                }
            }
            SharedCounters sc = MixedRegionBB.getBB().getSharedCounters();
            if (opName.equalsIgnoreCase("entry-create")) {
                if (counterType == 1) {
                    if (isPartitioned) {
                        sc.increment(isLoad ? MixedRegionBB.PR_LISTENER_CREATE_ISLOAD : MixedRegionBB.PR_LISTENER_CREATE);
                        continue;
                    }
                    sc.increment(isLoad ? MixedRegionBB.RR_LISTENER_CREATE_ISLOAD : MixedRegionBB.RR_LISTENER_CREATE);
                    continue;
                }
                if (this.destroyedInThisTx(op)) {
                    sc.increment(MixedRegionBB.CONFLATED_CREATE_DESTROY);
                }
                sc.increment(isLoad ? MixedRegionBB.WRITER_CREATE_ISLOAD : MixedRegionBB.WRITER_CREATE);
                continue;
            }
            if (opName.equalsIgnoreCase("entry-update")) {
                if (counterType == 1) {
                    if (isPartitioned) {
                        sc.increment(isLoad ? MixedRegionBB.PR_LISTENER_UPDATE_ISLOAD : MixedRegionBB.PR_LISTENER_UPDATE);
                        continue;
                    }
                    sc.increment(isLoad ? MixedRegionBB.RR_LISTENER_UPDATE_ISLOAD : MixedRegionBB.RR_LISTENER_UPDATE);
                    continue;
                }
                sc.increment(isLoad ? MixedRegionBB.WRITER_UPDATE_ISLOAD : MixedRegionBB.WRITER_UPDATE);
                continue;
            }
            if (opName.equalsIgnoreCase("entry-destroy")) {
                if (counterType == 1) {
                    if (this.createdInThisTx(op)) continue;
                    sc.increment(isPartitioned ? MixedRegionBB.PR_LISTENER_DESTROY : MixedRegionBB.RR_LISTENER_DESTROY);
                    continue;
                }
                sc.increment(MixedRegionBB.WRITER_DESTROY);
                continue;
            }
            if (!opName.equalsIgnoreCase("entry-inval") || op.isDoubleInvalidate()) continue;
            if (counterType == 1) {
                sc.increment(isPartitioned ? MixedRegionBB.PR_LISTENER_INVALIDATE : MixedRegionBB.RR_LISTENER_INVALIDATE);
                continue;
            }
            sc.increment(MixedRegionBB.WRITER_INVALIDATE);
        }
        MixedRegionBB.getBB().printSharedCounters();
    }

    private void checkAndClearEventCounters() {
        if (!this.checkEventCounters) {
            return;
        }
        this.checkWriterCounters();
        this.checkTxWriterCounters();
        this.checkEventCounters();
        this.checkTxEventCounters();
        EventCountersBB.getBB().zeroAllCounters();
        WriterCountersBB.getBB().zeroAllCounters();
        TxEventCountersBB.getBB().zeroAllCounters();
        TxWriterCountersBB.getBB().zeroAllCounters();
        TxBB.getBB().getSharedMap().put(TxBB.TxWriterAction, TxBB.TXACTION_NONE);
    }

    public static void logExecutionNumber() {
        long exeNum = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    public static boolean logRoundRobinNumber() {
        TxBB BB2 = TxBB.getBB();
        String rrStartThread = (String)BB2.getSharedMap().get(TxBB.RoundRobinStartThread);
        String currentThreadName = Thread.currentThread().getName();
        if (rrStartThread == null) {
            rrStartThread = currentThreadName;
            BB2.getSharedMap().put(TxBB.RoundRobinStartThread, rrStartThread);
        }
        if (currentThreadName.equals(rrStartThread)) {
            long rrNum = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.RoundRobinNumber);
            Log.getLogWriter().info("Beginning round " + rrNum);
            return true;
        }
        return false;
    }

    public static long getRoundRobinNumber() {
        return TxBB.getBB().getSharedCounters().read(TxBB.RoundRobinNumber);
    }

    public Region getRandomRegion(boolean allowRootRegion) {
        Region aRegion = null;
        String regionName = TestConfig.tab().stringAt(TxPrms.excludeRegionName, null);
        if (regionName != null) {
            aRegion = CacheUtil.getCache().getRegion(regionName);
        }
        return this.getRandomRegion(allowRootRegion, aRegion, 0);
    }

    public Region getRandomRegion(boolean allowRootRegion, int restriction) {
        Region aRegion = null;
        String regionName = TestConfig.tab().stringAt(TxPrms.excludeRegionName, null);
        if (regionName != null) {
            aRegion = CacheUtil.getCache().getRegion(regionName);
        }
        return this.getRandomRegion(allowRootRegion, aRegion, restriction);
    }

    public Region getRandomRegion(boolean allowRootRegion, Region excludeRegion, int restriction) {
        int i;
        Object[] rootRegionArr = CacheUtil.getCache().rootRegions().toArray();
        if (rootRegionArr.length == 0) {
            return null;
        }
        ArrayList<Object> regionList = new ArrayList<Object>();
        if (allowRootRegion) {
            for (i = 0; i < rootRegionArr.length; ++i) {
                regionList.add(rootRegionArr[i]);
            }
        }
        for (i = 0; i < rootRegionArr.length; ++i) {
            Region rootRegion = (Region)rootRegionArr[i];
            Object[] regionArr = this.getSubregions(rootRegion, true).toArray();
            for (int j = 0; j < regionArr.length; ++j) {
                regionList.add(regionArr[j]);
            }
        }
        if (regionList.size() == 0) {
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, regionList.size() - 1);
        Region aRegion = (Region)regionList.get(randInt);
        if (restriction != 0 || excludeRegion != null) {
            int startIndex = randInt;
            boolean done = true;
            do {
                done = true;
                try {
                    if (restriction == 2) {
                        done = PartitionRegionHelper.isPartitionedRegion((Region)aRegion);
                    }
                    if (restriction == 1) {
                        done = this.isHierReplicated(aRegion);
                    }
                    if (excludeRegion != null && aRegion.getFullPath().equals(excludeRegion.getFullPath())) {
                        done = false;
                    }
                }
                catch (RegionDestroyedException e) {
                    done = false;
                }
                if (done) break;
                if (++randInt == regionList.size()) {
                    randInt = 0;
                }
                if (randInt == startIndex) {
                    return null;
                }
                aRegion = (Region)regionList.get(randInt);
            } while (!done);
        }
        return aRegion;
    }

    public static OpList doOperations() {
        boolean allowGetOperations = true;
        return MixedRegionViewTest.doOperations(allowGetOperations);
    }

    public static OpList doOperations(boolean allowGetOperations) {
        HydraVector operations = TestConfig.tab().vecAt(TxPrms.operations);
        int numOps = TestConfig.tab().intAt(TxPrms.numOps);
        return testInstance.doOperations(operations, numOps, allowGetOperations);
    }

    public OpList doOperations(Vector operations, int numOperationsToDo) {
        boolean allowGetOperations = true;
        return this.doOperations(operations, numOperationsToDo, allowGetOperations);
    }

    public OpList doOperations(Vector operations, int numOperationsToDo, boolean allowGetOperations) {
        Log.getLogWriter().info("Executing " + numOperationsToDo + " random operations...");
        long TIME_LIMIT_MS = 60000L;
        long timeOfLastOp = System.currentTimeMillis();
        OpList opList = new OpList();
        this.initializeKeySet(PrTxPrms.useLocalKeySet());
        int numOpsCompleted = 0;
        while (numOpsCompleted < numOperationsToDo) {
            Operation op = null;
            String operation = (String)operations.get(TestConfig.tab().getRandGen().nextInt(0, operations.size() - 1));
            if (operation.startsWith("entry-get") && !allowGetOperations) {
                operation = "entry-create";
            }
            Log.getLogWriter().info("Operation is " + operation);
            int restriction = 2;
            if (numOpsCompleted > 0 && this.rng.nextBoolean()) {
                restriction = 0;
            }
            if (PrTxPrms.alwaysUsePartitionedRegions()) {
                restriction = 2;
            }
            Region aRegion = this.getRandomRegion(true, restriction);
            if (operation.equalsIgnoreCase("entry-create")) {
                op = this.createEntry(aRegion);
            } else if (operation.equalsIgnoreCase("entry-update")) {
                op = this.updateEntry(aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-destroy")) {
                op = this.destroyEntry(aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-inval")) {
                op = this.invalEntry(aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-getWithNewKey")) {
                op = this.getEntryWithNewKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithExistingKey")) {
                op = this.getWithExistingKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithPreviousKey")) {
                op = this.getEntryWithPreviousKey(aRegion);
            } else {
                throw new TestException("Unknown operation " + operation);
            }
            if (op == null) {
                if (System.currentTimeMillis() - timeOfLastOp <= 60000L) continue;
                throw new TestException("Could not execute a successful operation in 60000 millis; possible test config problem");
            }
            opList.add(op);
            this.updateKeySet(op);
            ++numOpsCompleted;
            timeOfLastOp = System.currentTimeMillis();
        }
        Log.getLogWriter().info("Completed execution of " + opList);
        return opList;
    }

    public Operation createEntry(Region aRegion) {
        Object key = this.getNewKey(aRegion);
        Object oldValue = null;
        ValueHolder vh = new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
        String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Log.getLogWriter().info("createEntry: putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
        if (this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
            this.executeOp(aRegion, "entry-create", key, vh, callback);
        } else {
            try {
                aRegion.create(key, (Object)vh, (Object)callback);
            }
            catch (RegionDestroyedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (EntryExistsException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("createEntry: done putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
        return new Operation(aRegion.getFullPath(), key, "entry-create", oldValue, vh.modVal);
    }

    public Operation updateEntry(Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not update a key in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        BaseValueHolder vh = null;
        Log.getLogWriter().info("updateEntry: Getting value to prepare for update for key " + key + " in region " + aRegion.getFullPath());
        Object oldValue = this.getValueInVM(aRegion, key);
        if (oldValue instanceof BaseValueHolder) {
            vh = (BaseValueHolder)oldValue;
            oldValue = ((BaseValueHolder)oldValue).modVal;
        } else {
            vh = new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
        }
        Log.getLogWriter().info("updateEntry: Value to update is " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        vh = (BaseValueHolder)CopyHelper.copy((Object)vh);
        vh.modVal = new Integer(vh.modVal + 1);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Log.getLogWriter().info("updateEntry: Putting new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        if (this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
            this.executeOp(aRegion, "entry-update", key, vh, callback);
        } else {
            try {
                aRegion.put(key, (Object)vh, (Object)callback);
            }
            catch (RegionDestroyedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("updateEntry: Done putting new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        return new Operation(aRegion.getFullPath(), key, "entry-update", oldValue, vh.modVal);
    }

    public Operation destroyEntry(Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not destroy an entry in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Log.getLogWriter().info("destroyEntry: destroying key " + key + " in region " + aRegion.getFullPath());
            if (this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
                this.executeOp(aRegion, "entry-destroy", key, null, callback);
            } else {
                aRegion.destroy(key, (Object)callback);
            }
            Log.getLogWriter().info("destroyEntry: done destroying key " + key + " in region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), key, "entry-destroy", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation invalEntry(Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not invalidate an entry in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Log.getLogWriter().info("invalEntry: invalidating key " + key + " in region " + aRegion.getFullPath());
            if (this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
                this.executeOp(aRegion, "entry-inval", key, null, callback);
            } else {
                aRegion.invalidate(key, (Object)callback);
            }
            Log.getLogWriter().info("invalEntry: done invalidating key " + key + " in region " + aRegion.getFullPath());
            Object newValue = this.getValueInVM(aRegion, key);
            return new Operation(aRegion.getFullPath(), key, "entry-inval", oldValue, newValue);
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation getWithExistingKey(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not get with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getWithExistingKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            BaseValueHolder vh = null;
            vh = this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion) ? (BaseValueHolder)this.executeOp(aRegion, "entry-getWithExistingKey", key, null, null) : (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getWithExistingKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation getEntryWithPreviousKey(Region aRegion) {
        Object key;
        if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
            key = this.getRandomKey(aRegion);
        } else {
            long keysUsed = NameFactory.getPositiveNameCounter();
            key = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Log.getLogWriter().info("getEntryWithPreviousKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = null;
            vh = this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion) ? (BaseValueHolder)this.executeOp(aRegion, "entry-getWithPreviousKey", key, null, null) : (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getEntryWithPreviousKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Object getNewKey(Region aRegion) {
        Object key = PartitionRegionHelper.isPartitionedRegion((Region)aRegion) ? this.getNewKeyForPartitionedRegion(aRegion) : NameFactory.getNextPositiveObjectName();
        return key;
    }

    public Object getNewKeyForPartitionedRegion(Region aRegion) {
        TXStateInterface txState = TxHelper.internalSuspend();
        Object sampleKey = this.getRandomKey(aRegion);
        Object newKey = null;
        Log.getLogWriter().info("Looking for a new key colocated with " + sampleKey);
        DistributedMember localDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetNewKey");
        HashSet<Object> filter = new HashSet<Object>();
        filter.add(sampleKey);
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)localDM.toString()).withFilter(filter);
        Log.getLogWriter().info("executing " + f.getId() + " on region " + aRegion.getName() + " with filter " + filter);
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        for (Object key : results) {
            if (key == null) continue;
            newKey = key;
            break;
        }
        Log.getLogWriter().info("Found new key " + newKey + " from same member as sampleKey " + sampleKey);
        TxHelper.internalResume(txState);
        return newKey;
    }

    public Operation getEntryWithNewKey(Region aRegion) {
        Object key = this.getNewKey(aRegion);
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntryWithNewKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = null;
            vh = this.useFunctionExecution && PartitionRegionHelper.isPartitionedRegion((Region)aRegion) ? (BaseValueHolder)this.executeOp(aRegion, "entry-getWithExistingKey", key, null, null) : (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getEntryWithNewKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation putEntry(Region aRegion, Object key, BaseValueHolder value, String opName) {
        Object oldValue = this.getValueInVM(aRegion, key);
        if (oldValue instanceof BaseValueHolder) {
            oldValue = ((BaseValueHolder)oldValue).modVal;
        }
        try {
            String callback = updateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Log.getLogWriter().info("putEntry: putting key " + key + ", object " + value + " in region " + aRegion.getFullPath());
            aRegion.put(key, (Object)value, (Object)callback);
            Log.getLogWriter().info("putEntry: done putting key " + key + ", object " + value + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new Operation(aRegion.getFullPath(), key, opName, oldValue, value.modVal);
    }

    public Object getRandomKey(Region aRegion) {
        return this.getRandomKey(aRegion, null);
    }

    public Object getRandomKey(Region aRegion, Object excludeKey) {
        if (aRegion == null) {
            return null;
        }
        HashSet aSet = null;
        try {
            if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
                String mapKey = "keySet_" + aRegion.getFullPath();
                KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
                List aList = keySetResult.getKeySet();
                aSet = new HashSet(aList);
            } else {
                aSet = new HashSet(((LocalRegion)aRegion).testHookKeys());
            }
        }
        catch (RegionDestroyedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object[] keyArr = aSet.toArray();
        if (keyArr.length == 0) {
            Log.getLogWriter().info("Could not get a random key from " + aRegion.getFullPath() + " because the region has no keys");
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, keyArr.length - 1);
        Object key = keyArr[randInt];
        if (key.equals(excludeKey)) {
            if (keyArr.length == 1) {
                return null;
            }
            if (++randInt == keyArr.length) {
                randInt = 0;
            }
            key = keyArr[randInt];
        }
        return key;
    }

    public Object getNewValue(Object key) {
        return new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
    }

    public static boolean inTxThreadWithTxInProgress() {
        return TxHelper.getTransactionId() != null;
    }

    public static boolean inTxVm() {
        Integer txVmPid = (Integer)TxBB.getBB().getSharedMap().get(TxBB.TX_VM_PID);
        if (txVmPid == null) {
            return false;
        }
        int myVmPid = ProcessMgr.getProcessId();
        return txVmPid == myVmPid;
    }

    public boolean isHierReplicated(Region aRegion) {
        boolean isReplicated = aRegion.getAttributes().getDataPolicy().withReplication();
        if (isReplicated) {
            return true;
        }
        Object[] regionArr = this.getSubregions(aRegion, true).toArray();
        for (int j = 0; j < regionArr.length; ++j) {
            Region subR = (Region)regionArr[j];
            if (!subR.getAttributes().getDataPolicy().withReplication()) continue;
            return true;
        }
        return false;
    }

    public Set getSubregions(Region aRegion, boolean recursive) {
        try {
            Set regionSet = aRegion.subregions(recursive);
            return regionSet;
        }
        catch (RegionDestroyedException e) {
            String errorRegionName;
            if (this.isSerialExecution) {
                throw e;
            }
            String regionName = aRegion.getFullPath();
            if (!regionName.equals(errorRegionName = e.getRegionFullPath())) {
                throw e;
            }
            return new HashSet();
        }
    }

    public Object getValueInVM(Region aRegion, Object key) {
        Object value = null;
        Region.Entry entry = aRegion.getEntry(key);
        if (entry != null && (value = entry.getValue()) == null) {
            value = Token.INVALID;
        }
        return value;
    }

    protected void initializeKeySet(boolean useLocalKeySet) {
        TXStateInterface txState = TxHelper.internalSuspend();
        DistributedMember targetDM = null;
        if (useLocalKeySet) {
            targetDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        }
        Set rootRegions = CacheUtil.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            if (!PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) continue;
            KeySetResult keySetResult = this.getKeySet(aRegion, targetDM);
            String mapKey = "keySet_" + aRegion.getFullPath();
            PrTxBB.getBB().getSharedMap().put(mapKey, keySetResult);
            targetDM = keySetResult.getDistributedMember();
            List keyList = keySetResult.getKeySet();
            Object[] keySet = keyList.toArray();
            Log.getLogWriter().info("KeySet for " + targetDM + "  = " + keyList);
        }
        TxHelper.internalResume(txState);
    }

    protected KeySetResult getKeySet(Region aRegion, DistributedMember targetDM) {
        KeySetResult ksResult2 = null;
        DistributedMember localDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetKeySet");
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)localDM.toString());
        Log.getLogWriter().info("executing " + f.getId() + " on region " + aRegion.getName());
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        DistributedMember remoteDM = null;
        boolean keySetAvailable = false;
        for (KeySetResult ksResult2 : results) {
            remoteDM = ksResult2.getDistributedMember();
            if (targetDM == null && !localDM.equals(remoteDM)) {
                targetDM = remoteDM;
            }
            if (targetDM == null || !remoteDM.equals(targetDM)) continue;
            keySetAvailable = true;
            break;
        }
        if (!keySetAvailable) {
            ksResult2 = null;
            throw new TestException("Test issue with getNewKey -- no keySet found");
        }
        Log.getLogWriter().info("Returning keySet from member " + targetDM);
        return ksResult2;
    }

    protected void updateKeySet(Operation op) {
        String regionName = op.getRegionName();
        if (PartitionRegionHelper.isPartitionedRegion((Region)RegionHelper.getRegion(regionName))) {
            Object key = op.getKey();
            String mapKey = "keySet_" + regionName;
            KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
            List keyList = keySetResult.getKeySet();
            if (op.isEntryCreate()) {
                keyList.add(key);
            } else if (op.isEntryDestroy()) {
                keyList.remove(key);
            }
            PrTxBB.getBB().getSharedMap().put(mapKey, keySetResult);
        }
    }

    protected Object executeOp(Region aRegion, String opName, Object key, Object value, String callback) {
        Log.getLogWriter().info("Invoking ExecuteOp with " + opName + "(" + key + ", " + value + ")");
        Function f = FunctionService.getFunction((String)"parReg.tx.ExecuteOp");
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        HashSet<Object> filter = new HashSet<Object>();
        filter.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add(dm.toString());
        aList.add(opName);
        aList.add(key);
        aList.add(value);
        aList.add(callback);
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs(aList).withFilter(filter);
        Log.getLogWriter().info("executing " + f.getId() + " with filter " + filter);
        ResultCollector rc = e.execute(f.getId());
        Log.getLogWriter().info("executed " + f.getId());
        List result = (List)rc.getResult();
        BaseValueHolder vh = (BaseValueHolder)result.get(0);
        return vh;
    }
}

