/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionResolver;
import hydra.TestConfig;
import java.io.Serializable;
import util.NameFactory;

public class ModRoutingObject
implements PartitionResolver,
Serializable,
Comparable {
    private Object key;
    private long counterValue;
    private int modValue;

    ModRoutingObject(Object key) {
        this.key = key;
        this.counterValue = NameFactory.getCounterForName(key);
        this.modValue = (int)this.counterValue % (TestConfig.getInstance().getTotalVMs() - 1);
    }

    public Object getKey() {
        return this.key;
    }

    public long getCounterValue() {
        return this.counterValue;
    }

    public long getModValue() {
        return this.modValue;
    }

    public String toString() {
        return this.counterValue + "_" + this.modValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModRoutingObject)) {
            return false;
        }
        ModRoutingObject o = (ModRoutingObject)obj;
        if (!this.key.equals(o.getKey())) {
            return false;
        }
        if (this.counterValue != o.getCounterValue()) {
            return false;
        }
        return (long)this.modValue == o.getModValue();
    }

    public int hashCode() {
        return this.modValue;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Serializable getRoutingObject(EntryOperation op) {
        return (ModRoutingObject)op.getKey();
    }

    public void close() {
    }

    public int compareTo(Object o) {
        ModRoutingObject mro = (ModRoutingObject)o;
        return (int)(this.counterValue - mro.counterValue);
    }
}

