/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import parReg.tx.PrTxBB;
import util.AbstractListener;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class ObjectNameListener
extends AbstractListener
implements CacheListener,
Declarable {
    private ArrayList hashCodes = new ArrayList();
    private ArrayList keySet = new ArrayList();

    public List getHashCodes() {
        return this.hashCodes;
    }

    public synchronized Object[] getKeySetArray() {
        return this.keySet.toArray();
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        this.processEvent(event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.processEvent(event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        this.processEvent(event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.processEvent(event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    private synchronized void processEvent(EntryEvent event) {
        Object key = event.getKey();
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        if (key instanceof String) {
            int counter = (int)NameFactory.getCounterForName(key);
            int hash = counter % numVms;
            Log.getLogWriter().info("In " + RemoteTestModule.getMyClientName() + ": adding key " + key + " with hashCode " + hash);
            if (!this.hashCodes.contains(hash)) {
                this.hashCodes.add(hash);
            }
        } else {
            throw new TestException("ObjectNameListener expected key of type String , but found " + key.getClass());
        }
        if (event.getOperation().isDestroy()) {
            int index = this.keySet.indexOf(key);
            this.keySet.remove(index);
            Log.getLogWriter().info("Removed " + key + " from keySet");
        } else {
            this.keySet.add(key);
            Log.getLogWriter().info("Added " + key + " from keySet");
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = PrTxBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

