/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TransactionObserver;
import com.gemstone.gemfire.internal.cache.TransactionObserverAdapter;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import tx.TxBB;
import tx.TxPrms;
import tx.ViewTest;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.TestException;
import util.TxEventCountersBB;
import util.TxHelper;
import util.TxWriterCountersBB;
import util.WriterCountersBB;

public class ParRegViewTest
extends ViewTest {
    static int numVmsWithListeners = 1;
    static int numEdgeClients = 0;
    static boolean useLocalKeySet;

    public static synchronized void HydraTask_initialize() {
        if (viewTest == null) {
            viewTest = new ParRegViewTest();
            viewTest.initialize();
            ((ParRegViewTest)viewTest).initialize(ConfigPrms.getRegionConfig());
        }
    }

    public void initialize(String regionConfig) {
        StringBuffer aStr = new StringBuffer();
        boolean alwaysFireLocalListeners = Boolean.getBoolean("gemfire.BucketRegion.alwaysFireLocalListeners");
        aStr.append("alwaysFireLocalListeners= " + alwaysFireLocalListeners + " ");
        PrTxBB.getBB().getSharedMap().put("alwaysFireLocalListeners", new Boolean(alwaysFireLocalListeners));
        RegionAttributes ratts = RegionHelper.getRegionAttributes(regionConfig);
        PartitionAttributes patts = ratts.getPartitionAttributes();
        int redundantCopies = patts.getRedundantCopies();
        aStr.append("redundantCopies = " + redundantCopies + " ");
        PrTxBB.getBB().getSharedMap().put("redundantCopies", new Integer(redundantCopies));
        if (alwaysFireLocalListeners) {
            numVmsWithListeners = redundantCopies + 1;
            aStr.append("calculated numVmsWithListeners = " + numVmsWithListeners + " ");
        }
        int totalVMs = TestConfig.getInstance().getTotalVMs();
        int bridgeVMs = BridgeHelper.getEndpoints().size();
        if (bridgeVMs > 0) {
            numEdgeClients = totalVMs - bridgeVMs;
        }
        Log.getLogWriter().info("numEdgeClients = " + numEdgeClients + " numVmsWithListeners = " + numVmsWithListeners);
        useLocalKeySet = PrTxPrms.useLocalKeySet();
        aStr.append("useLocalKeySet = " + useLocalKeySet);
        Log.getLogWriter().info(aStr.toString());
        TxBB.getBB().getSharedMap().put("afterCommitProcessed", new Boolean(false));
    }

    @Override
    protected void checkWriterCounters() {
        SharedCounters counters = TxBB.getBB().getSharedCounters();
        long localCreate = counters.read(TxBB.LOCAL_CREATE);
        long localCreateIsLoad = counters.read(TxBB.LOCAL_CREATE_ISLOAD);
        long localUpdate = counters.read(TxBB.LOCAL_UPDATE);
        long localUpdateIsLoad = counters.read(TxBB.LOCAL_UPDATE_ISLOAD);
        long localDestroy = counters.read(TxBB.LOCAL_DESTROY);
        long localInval = counters.read(TxBB.LOCAL_INVALIDATE);
        long localLocalDestroy = counters.read(TxBB.LOCAL_LOCAL_DESTROY);
        long localLocalInval = counters.read(TxBB.LOCAL_LOCAL_INVALIDATE);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numBeforeCreateEvents_isDist", localCreate + localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotExp", localCreate + localCreateIsLoad));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeCreateEvents_isNotRemote", localCreate + localCreateIsLoad));
        } else {
            al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", localCreate + localCreateIsLoad));
            al.add(new ExpCounterValue("numBeforeCreateEvents_isNotRemote", 0L));
        }
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLoad", localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLoad", localCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLocalLoad", localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLocalLoad", localCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetLoad", localCreate + localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetSearch", localCreate + localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isDist", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotExp", localDestroy));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotRemote", localDestroy));
        } else {
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", localDestroy));
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotRemote", 0L));
        }
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLoad", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLocalLoad", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetLoad", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetSearch", localDestroy));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isDist", localUpdate + localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotExp", localUpdate + localUpdateIsLoad));
        if (useLocalKeySet) {
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotRemote", localUpdate + localUpdateIsLoad));
        } else {
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", localUpdate + localUpdateIsLoad));
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotRemote", 0L));
        }
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLoad", localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLoad", localUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLocalLoad", localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLocalLoad", localUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetLoad", localUpdate + localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetSearch", localUpdate + localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotRemote", 0L));
        WriterCountersBB.getBB().checkEventCounters(al);
    }

    @Override
    protected void checkEventCounters() {
        SharedCounters counters = TxBB.getBB().getSharedCounters();
        long remoteCreate = counters.read(TxBB.REMOTE_CREATE);
        long remoteCreateIsLoad = counters.read(TxBB.REMOTE_CREATE_ISLOAD);
        long remoteUpdate = counters.read(TxBB.REMOTE_UPDATE);
        long remoteUpdateIsLoad = counters.read(TxBB.REMOTE_UPDATE_ISLOAD);
        long remoteDestroy = counters.read(TxBB.REMOTE_DESTROY);
        long remoteInval = counters.read(TxBB.REMOTE_INVALIDATE);
        long remoteLocalDestroy = counters.read(TxBB.REMOTE_LOCAL_DESTROY);
        long remoteLocalInval = counters.read(TxBB.REMOTE_LOCAL_INVALIDATE);
        long numConflatedCreateDestroy = counters.read(TxBB.CONFLATED_CREATE_DESTROY);
        if (!this.isProxy) {
            numConflatedCreateDestroy = 0L;
        }
        long numClose = 0L;
        String endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION);
        if (endResult == null) {
            return;
        }
        int numVmsWithList = numVmsWithListeners + numEdgeClients;
        Log.getLogWriter().info("expect callbacks from " + numVmsWithList + " VMs based on numVmsWithListeners(" + numVmsWithListeners + ") + numEdgeClients(" + numEdgeClients + ")");
        if (!endResult.equals(TxBB.TXACTION_COMMIT)) {
            remoteCreate = 0L;
            remoteCreateIsLoad = 0L;
            remoteUpdate = 0L;
            remoteUpdateIsLoad = 0L;
            remoteDestroy = 0L;
            remoteInval = 0L;
            remoteLocalDestroy = 0L;
            remoteLocalInval = 0L;
            numConflatedCreateDestroy = 0L;
        }
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", "numAfterCreateEvents_isNotRemote", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", remoteCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", remoteCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", remoteCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", remoteCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", "numAfterDestroyEvents_isNotRemote", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", "numAfterInvalidateEvents_isNotRemote", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", "numAfterUpdateEvents_isNotRemote", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", remoteUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", remoteUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", remoteUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", remoteUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numClose", numClose, false));
        EventCountersBB.getBB().checkEventCounters(al);
    }

    @Override
    protected void checkTxEventCounters(Blackboard bb) {
        String endResult;
        SharedCounters counters = TxBB.getBB().getSharedCounters();
        long numCreate = counters.read(TxBB.REMOTE_CREATE);
        long numCreateIsLoad = counters.read(TxBB.REMOTE_CREATE_ISLOAD);
        long numUpdate = counters.read(TxBB.REMOTE_UPDATE);
        long numUpdateIsLoad = counters.read(TxBB.REMOTE_UPDATE_ISLOAD);
        long numDestroy = counters.read(TxBB.REMOTE_DESTROY);
        long numInval = counters.read(TxBB.REMOTE_INVALIDATE);
        long numLocalDestroy = counters.read(TxBB.REMOTE_LOCAL_DESTROY);
        long numLocalInval = counters.read(TxBB.REMOTE_LOCAL_INVALIDATE);
        long numConflatedCreateDestroy = counters.read(TxBB.CONFLATED_CREATE_DESTROY);
        long numCreateInDestroyedRegion = counters.read(TxBB.CREATE_IN_DESTROYED_REGION);
        long numCreateInDestroyedRegion_isLoad = counters.read(TxBB.CREATE_IN_DESTROYED_REGION_ISLOAD);
        int numTxCallbacks = numVmsWithListeners;
        if (bb.equals(TxWriterCountersBB.getBB())) {
            numTxCallbacks = 1;
        }
        if ((endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION)) == null) {
            return;
        }
        if (!endResult.equals(TxBB.TXACTION_COMMIT)) {
            if (bb.equals(TxWriterCountersBB.getBB())) {
                if (endResult.equals(TxBB.TXACTION_ROLLBACK)) {
                    numCreate = 0L;
                    numCreateIsLoad = 0L;
                    numUpdate = 0L;
                    numUpdateIsLoad = 0L;
                    numDestroy = 0L;
                    numInval = 0L;
                    numLocalDestroy = 0L;
                    numLocalInval = 0L;
                    numConflatedCreateDestroy = 0L;
                    numCreateInDestroyedRegion = 0L;
                    numCreateInDestroyedRegion_isLoad = 0L;
                }
            } else {
                numTxCallbacks = 1;
                Log.getLogWriter().info("Commit failed or was rolled back, remote TxListeners will not be included in counts, numTxCallbacks = " + numTxCallbacks);
                if (!this.isProxy) {
                    numConflatedCreateDestroy = 0L;
                }
            }
        }
        Log.getLogWriter().info("expect callback invocations from " + numTxCallbacks + " VMs");
        if (bb.equals(TxEventCountersBB.getBB())) {
            this.verifyCallbackInvocation(numTxCallbacks);
        }
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numCreateTxEvents_isDist", (numCreate + numCreateIsLoad) * (long)numTxCallbacks + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotExp", (numCreate + numCreateIsLoad) * (long)numTxCallbacks + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isRemote", "numCreateTxEvents_isNotRemote", (numCreate + numCreateIsLoad) * (long)numTxCallbacks + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isLoad", numCreateIsLoad * (long)numTxCallbacks + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLoad", numCreate * (long)numTxCallbacks + numCreateInDestroyedRegion));
        al.add(new ExpCounterValue("numCreateTxEvents_isLocalLoad", numCreateIsLoad * (long)numTxCallbacks + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLocalLoad", numCreate * (long)numTxCallbacks + numCreateInDestroyedRegion));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetLoad", (numCreate + numCreateIsLoad) * (long)numTxCallbacks + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetSearch", (numCreate + numCreateIsLoad) * (long)numTxCallbacks + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numDestroyTxEvents_isDist", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotExp", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numDestroyTxEvents_isRemote", "numDestroyTxEvents_isNotRemote", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numDestroyTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLoad", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numDestroyTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLocalLoad", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetLoad", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetSearch", numDestroy * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isDist", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotExp", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isRemote", "numInvalidateTxEvents_isNotRemote", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotLoad", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotLocalLoad", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotNetLoad", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotNetSearch", numInval * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isDist", (numUpdate + numUpdateIsLoad) * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotExp", (numUpdate + numUpdateIsLoad) * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isRemote", "numUpdateTxEvents_isNotRemote", (numUpdate + numUpdateIsLoad) * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isLoad", numUpdateIsLoad * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLoad", numUpdate * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isLocalLoad", numUpdateIsLoad * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLocalLoad", numUpdate * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetLoad", (numUpdate + numUpdateIsLoad) * (long)numTxCallbacks));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetSearch", (numUpdate + numUpdateIsLoad) * (long)numTxCallbacks));
        if (bb instanceof TxEventCountersBB) {
            ((TxEventCountersBB)bb).checkEventCounters(al);
        } else {
            ((TxWriterCountersBB)bb).checkEventCounters(al);
        }
    }

    @Override
    public void setupCommitTestCallbacks(String commitStatePrm) {
        if (!PrTxPrms.killLocalTxVm()) {
            this.setupRemoteCallbacks(commitStatePrm);
        } else {
            TXStateInterface txState = TxHelper.getTxState();
            int commitStateTrigger = TxPrms.getCommitStateTrigger(commitStatePrm);
            TxBB.getBB().getSharedMap().put(TxBB.CommitStateTrigger, new Integer(commitStateTrigger));
            Log.getLogWriter().info("TxPrms.commitStateTrigger = " + commitStatePrm + "(" + commitStateTrigger + ")");
            switch (commitStateTrigger) {
                case 0: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 1: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 2: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void beforeSend(TXStateProxy tx, boolean rollback) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 3: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 4: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 5: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void duringIndividualCommit(TXStateProxy tx, Object callbackArg) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 6: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterIndividualCommit(TXStateProxy tx, Object callbackArg) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 7: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterApplyChanges(TXStateProxy tx) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 8: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterReleaseLocalLocks(TXStateProxy tx) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 9: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterSend(TXStateProxy tx, boolean rollback) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 10: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterSend(TXStateProxy tx, boolean rollback) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 11: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterSend(TXStateProxy tx, boolean rollback) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                default: {
                    throw new TestException("Unexpected commitStateTrigger " + TxPrms.toStringForCommitStateTrigger(commitStateTrigger));
                }
            }
        }
    }

    private void setupRemoteCallbacks(String commitStatePrm) {
        TXStateInterface txState = TxHelper.getTxState();
        TransactionId txId = TxHelper.getTransactionId();
        Log.getLogWriter().info("Invoking setupRemoteTestCallbacks with " + txId + " and trigger " + commitStatePrm);
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember targetDM = (DistributedMember)PrTxBB.getBB().getSharedMap().get("targetDM");
        Function f = FunctionService.getFunction((String)"parReg.tx.SetupRemoteTestCallbacks");
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add(txId);
        aList.add(commitStatePrm);
        Execution e = FunctionService.onMember((DistributedSystem)ds, (DistributedMember)targetDM).withArgs(aList);
        Log.getLogWriter().info("executing " + f.getId() + " on member " + targetDM);
        ResultCollector rc = e.execute(f.getId());
        Log.getLogWriter().info("executed " + f.getId());
        Object result = rc.getResult();
    }

    @Override
    protected boolean updatesVisible() {
        Integer mapValue = (Integer)TxBB.getBB().getSharedMap().get(TxBB.CommitStateTrigger);
        int commitStateTrigger = mapValue;
        boolean isVisible = false;
        Boolean listenerProcessedCommit = (Boolean)TxBB.getBB().getSharedMap().get("afterCommitProcessed");
        if (commitStateTrigger == 9 || commitStateTrigger == 8 || commitStateTrigger == 6 || listenerProcessedCommit.booleanValue()) {
            isVisible = true;
        }
        Log.getLogWriter().info("updatesVisible(" + TxPrms.toStringForCommitStateTrigger(commitStateTrigger) + ") returning " + isVisible);
        return isVisible;
    }

    static final class CommitTestCallback {
        CommitTestCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void run() {
            Object object = ViewTest.killSyncObject;
            synchronized (object) {
                Log.getLogWriter().info("product invoked CommitTestCallback, killSyncObject.notify() ...");
                ViewTest.killSyncObject.notify();
            }
            MasterController.sleepForMs(30000);
        }
    }
}

