/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import parReg.tx.CustomPartitionTest;
import parReg.tx.ObjectNameListener;
import util.BaseValueHolder;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class PrTxCustomPartitionTest
extends CustomPartitionTest {
    private ObjectNameListener myListener;
    private int numVms;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new PrTxCustomPartitionTest();
            ((PrTxCustomPartitionTest)testInstance).initializeOperationsClient();
            try {
                testInstance.initializePrms();
                testInstance.initialize();
                testInstance.registerFunctions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        Set regions = CacheHelper.getCache().rootRegions();
        Iterator it = regions.iterator();
        if (it.hasNext()) {
            Region aRegion = (Region)it.next();
            this.myListener = (ObjectNameListener)aRegion.getAttributes().getCacheListener();
        }
        this.numVms = TestConfig.getInstance().getTotalVMs() - 1;
    }

    @Override
    protected void populateRegion(Region aRegion) {
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        for (int i = 0; i < numVms; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            BaseValueHolder anObj = this.getValueForKey(key);
            Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            aRegion.create((Object)key, (Object)anObj);
            Log.getLogWriter().info("addEntry: done creating key " + key);
        }
    }

    @Override
    protected Object getExistingKey(Region aRegion) {
        Object key = null;
        Object[] keySet = this.myListener.getKeySetArray();
        if (keySet.length > 0) {
            int index = TestConfig.tab().getRandGen().nextInt(0, keySet.length - 1);
            key = keySet[index];
            Log.getLogWriter().info("getExistingKey() in " + RemoteTestModule.getMyClientName() + " returning " + key);
            return key;
        }
        return null;
    }

    @Override
    protected Object getNewKey() {
        List hashCodes = this.myListener.getHashCodes();
        String key = null;
        int counter = 0;
        int hash = 0;
        while (!hashCodes.contains(hash = (counter = (int)NameFactory.getCounterForName(key = NameFactory.getNextPositiveObjectName())) % this.numVms)) {
        }
        Log.getLogWriter().info("getNewKey() returning key " + key + " with hashCode " + hash + ", local hashCodes = " + hashCodes);
        return key;
    }
}

