/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.PartitionDescription;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import parReg.tx.GetAllMembersInDS;
import parReg.tx.GetKeySet;
import parReg.tx.GetNewKey;
import parReg.tx.GetValueForKey;
import parReg.tx.KeySetResult;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import parReg.tx.SerializableDistributedMember;
import parReg.tx.SetupRemoteTestCallbacks;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import tx.TxViewUtil;
import util.BaseValueHolder;
import util.CacheUtil;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class PrViewUtil
extends TxViewUtil {
    public static synchronized void HydraTask_createColocatedRegions() {
        if (txUtilInstance == null) {
            txUtilInstance = new PrViewUtil();
            try {
                ((PrViewUtil)txUtilInstance).createColocatedRegions();
                ((PrViewUtil)txUtilInstance).registerFunctions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    public void createColocatedRegions() {
        super.initialize();
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            CacheUtil.setCache(c);
            c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
            c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
            if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
                c.setCopyOnRead(true);
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            PartitionDescription pd = rd.getPartitionDescription();
            PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
            PartitionAttributes prAttrs = null;
            String colocatedWith = null;
            int numRegions = PrTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                if (i > 0) {
                    colocatedWith = regionBase + "_" + i;
                    prFactory.setColocatedWith(colocatedWith);
                    prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                }
                Region region = RegionHelper.createRegion(regionName, aFactory);
            }
        }
    }

    public static synchronized void HydraTask_createClientRegions() {
        if (txUtilInstance == null) {
            txUtilInstance = new PrViewUtil();
            ((PrViewUtil)txUtilInstance).createClientRegions();
            ((PrViewUtil)txUtilInstance).registerFunctions();
        }
    }

    public void createClientRegions() {
        super.initialize();
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            CacheUtil.setCache(c);
            c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
            c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
            if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
                c.setCopyOnRead(true);
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            int numRegions = PrTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                Region aRegion = RegionHelper.createRegion(regionName, aFactory);
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("registered interest in ALL_KEYS for " + regionName);
            }
        }
    }

    public static void HydraTask_populateRegions() {
        ((PrViewUtil)txUtilInstance).populateRegions();
    }

    @Override
    public void populateRegions() {
        Set regions = CacheUtil.getCache().rootRegions();
        Region sampleRegion = (Region)regions.iterator().next();
        int numBuckets = sampleRegion.getAttributes().getPartitionAttributes().getTotalNumBuckets() * TestHelper.getNumVMs();
        for (int i = 0; i < numBuckets; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            Set rootRegions = CacheUtil.getCache().rootRegions();
            for (Region aRegion : rootRegions) {
                ValueHolder vh = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer++));
                String callback = "Create event originated in pid " + ProcessMgr.getProcessId() + " memberId=" + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
                Log.getLogWriter().info("populateRegion: calling create for key " + key + ", object " + TestHelper.toString(vh) + ", region is " + aRegion.getFullPath());
                aRegion.create((Object)key, (Object)vh, (Object)callback);
                Log.getLogWriter().info("populateRegion: done creating key " + key);
            }
        }
    }

    public static void HydraTask_dumpLocalKeys() {
        ((PrViewUtil)txUtilInstance).dumpLocalKeys();
    }

    protected void dumpLocalKeys() {
        StringBuffer aStr = new StringBuffer();
        DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        aStr.append("Keys hosted as primary " + dm.toString() + " by region\n");
        Set rootRegions = CacheUtil.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Region localRegion = PartitionRegionHelper.getLocalData((Region)aRegion);
            Set keySet = localRegion.keySet();
            HashSet primaryKeySet = new HashSet();
            for (Object key : keySet) {
                DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, key);
                if (!primary.equals(dm)) continue;
                primaryKeySet.add(key);
            }
            aStr.append("   " + aRegion.getName() + ": " + primaryKeySet + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected void registerFunctions() {
        Declarable f = new GetAllMembersInDS();
        FunctionService.registerFunction((Function)f);
        f = new GetNewKey();
        FunctionService.registerFunction((Function)f);
        f = new GetKeySet();
        FunctionService.registerFunction((Function)f);
        f = new GetValueForKey();
        FunctionService.registerFunction((Function)f);
        f = new SetupRemoteTestCallbacks();
        FunctionService.registerFunction((Function)f);
        Log.getLogWriter().info("Registered functions: " + FunctionService.getRegisteredFunctions());
    }

    public static OpList doOperations(boolean allowGetOperations) {
        HydraVector operations = TestConfig.tab().vecAt(TxPrms.operations);
        int numOps = TestConfig.tab().intAt(TxPrms.numOps);
        return ((PrViewUtil)txUtilInstance).doOperations(operations, numOps, allowGetOperations);
    }

    @Override
    public OpList doOperations(Vector operations, int numOperationsToDo, boolean allowGetOperations) {
        Log.getLogWriter().info("Executing " + numOperationsToDo + " random operations in tx");
        long TIME_LIMIT_MS = 60000L;
        long timeOfLastOp = System.currentTimeMillis();
        OpList opList = new OpList();
        this.initializeKeySet(PrTxPrms.useLocalKeySet());
        int numOpsCompleted = 0;
        while (numOpsCompleted < numOperationsToDo) {
            Region aRegion;
            Object[] rootRegionArr;
            Operation op = null;
            String operation = (String)operations.get(TestConfig.tab().getRandGen().nextInt(0, operations.size() - 1));
            if (!operation.equals("cache-close") && !operation.equals("region-create") && (rootRegionArr = CacheUtil.getCache().rootRegions().toArray()).length == 0) {
                if (operations.indexOf("region-create") < 0) {
                    throw new TestException("No regions are available and no create region operation is specified");
                }
                Log.getLogWriter().info("In doOperations, forcing region create because no regions are present");
                operation = "region-create";
            }
            if (operation.startsWith("entry-get") && !allowGetOperations) {
                operation = "entry-create";
            }
            Log.getLogWriter().info("Operation is " + operation);
            if (operation.equalsIgnoreCase("entry-create")) {
                op = this.createEntry(this.getRandomRegion(true), false);
            } else if (operation.equalsIgnoreCase("entry-update")) {
                aRegion = this.getRandomRegion(true);
                op = this.updateEntry(aRegion, this.getRandomKey(aRegion));
            } else {
                if (operation.equalsIgnoreCase("putAll")) {
                    List<Operation> putAllOps = this.putAll(this.getRandomRegion(true));
                    for (Operation o : putAllOps) {
                        opList.add(o);
                        this.updateKeySet(o);
                        ++numOpsCompleted;
                    }
                    timeOfLastOp = System.currentTimeMillis();
                    continue;
                }
                if (operation.equalsIgnoreCase("entry-destroy")) {
                    aRegion = this.getRandomRegion(true);
                    op = this.destroyEntry(false, aRegion, this.getRandomKey(aRegion), false);
                } else if (operation.equalsIgnoreCase("entry-localDestroy")) {
                    aRegion = this.getRandomRegionNoReplication(true);
                    if (aRegion != null) {
                        op = this.destroyEntry(true, aRegion, this.getRandomKey(aRegion), false);
                    }
                } else if (operation.equalsIgnoreCase("entry-inval")) {
                    aRegion = this.getRandomRegion(true);
                    op = this.invalEntry(false, aRegion, this.getRandomKey(aRegion), false);
                } else if (operation.equalsIgnoreCase("entry-localInval")) {
                    aRegion = this.getRandomRegionNoReplication(true);
                    if (aRegion != null) {
                        op = this.invalEntry(true, aRegion, this.getRandomKey(aRegion), false);
                    }
                } else if (operation.equalsIgnoreCase("entry-getWithNewKey")) {
                    aRegion = this.getRandomRegion(true);
                    op = this.getEntryWithNewKey(aRegion);
                } else if (operation.equalsIgnoreCase("entry-getWithExistingKey")) {
                    aRegion = this.getRandomRegion(true);
                    op = this.getWithExistingKey(aRegion);
                } else if (operation.equalsIgnoreCase("entry-getWithPreviousKey")) {
                    aRegion = this.getRandomRegion(true);
                    op = this.getEntryWithPreviousKey(aRegion);
                } else if (operation.equalsIgnoreCase("getAll")) {
                    op = this.getAll(this.getRandomRegion(true));
                } else if (operation.equalsIgnoreCase("region-create")) {
                    op = this.createRegion();
                } else if (operation.equalsIgnoreCase("region-destroy")) {
                    op = this.destroyRegion(false, this.getRandomRegion(true));
                } else if (operation.equalsIgnoreCase("region-localDestroy")) {
                    aRegion = this.getRandomRegionNoReplication(true);
                    if (aRegion != null) {
                        op = this.destroyRegion(true, aRegion);
                    }
                } else if (operation.equalsIgnoreCase("region-inval")) {
                    aRegion = this.getRandomRegion(true);
                    op = this.invalRegion(false, this.getRandomRegion(true));
                } else if (operation.equalsIgnoreCase("region-localInval")) {
                    aRegion = this.getRandomRegionNoReplication(true);
                    if (aRegion != null) {
                        op = this.invalRegion(true, aRegion);
                    }
                } else if (operation.equalsIgnoreCase("cache-close")) {
                    op = this.closeCache();
                } else {
                    throw new TestException("Unknown operation " + operation);
                }
            }
            if (op == null) {
                if (System.currentTimeMillis() - timeOfLastOp <= 60000L) continue;
                throw new TestException("Could not execute a successful operation in 60000 millis; possible test config problem");
            }
            opList.add(op);
            this.updateKeySet(op);
            ++numOpsCompleted;
            timeOfLastOp = System.currentTimeMillis();
        }
        Log.getLogWriter().info("Completed execution of " + opList);
        return opList;
    }

    protected void updateKeySet(Operation op) {
        String regionName = op.getRegionName();
        Object key = op.getKey();
        String mapKey = "keySet_" + regionName;
        KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
        List keyList = keySetResult.getKeySet();
        if (op.isEntryCreate()) {
            keyList.add(key);
        } else if (op.isEntryDestroy()) {
            keyList.remove(key);
        }
        PrTxBB.getBB().getSharedMap().put(mapKey, keySetResult);
    }

    protected void initializeKeySet(boolean useLocalKeySet) {
        DistributedMember targetDM = null;
        DistributedMember excludeDM = null;
        PoolImpl pool = (PoolImpl)PoolManager.find((String)"brloader");
        if (pool != null) {
            ServerLocation delegate = pool.getNextOpServerLocation();
            String delegateHost = delegate.getHostName();
            int dot = delegateHost.indexOf(".");
            if (dot > 0) {
                delegateHost = delegateHost.substring(0, dot);
            }
            int delegatePort = delegate.getPort();
            String mappingKey = delegateHost + ":" + delegatePort;
            excludeDM = (DistributedMember)TxBB.getBB().getSharedMap().get(mappingKey);
            Log.getLogWriter().info("Retrieved port to dm mapping from BB for excludeDM: " + mappingKey + ":" + excludeDM);
        }
        if (useLocalKeySet) {
            targetDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        }
        Set rootRegions = CacheUtil.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            KeySetResult keySetResult = this.getKeySet(aRegion, targetDM, excludeDM);
            String mapKey = "keySet_" + aRegion.getFullPath();
            PrTxBB.getBB().getSharedMap().put(mapKey, keySetResult);
            targetDM = keySetResult.getDistributedMember();
            PrTxBB.getBB().getSharedMap().put("targetDM", targetDM);
            List keyList = keySetResult.getKeySet();
            Object[] keySet = keyList.toArray();
            Log.getLogWriter().info("KeySet for " + targetDM + "  = " + keyList);
        }
    }

    protected KeySetResult getKeySet(Region aRegion, DistributedMember targetDM) {
        return this.getKeySet(aRegion, targetDM, null);
    }

    protected KeySetResult getKeySet(Region aRegion, DistributedMember targetDM, DistributedMember excludeDM) {
        KeySetResult ksResult2 = null;
        DistributedMember localDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetKeySet");
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)localDM.toString());
        TXStateInterface txState = TxHelper.internalSuspend();
        Log.getLogWriter().info("executing " + f.getId() + " on region " + aRegion.getName());
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        TxHelper.internalResume(txState);
        List results = (List)rc.getResult();
        DistributedMember remoteDM = null;
        boolean keySetAvailable = false;
        for (KeySetResult ksResult2 : results) {
            remoteDM = ksResult2.getDistributedMember();
            Log.getLogWriter().fine("getKeySet DM selection: targetDM = " + targetDM + ", localDM = " + localDM + ", excludeDM = " + excludeDM + ", remoteDM = " + remoteDM);
            if (targetDM == null) {
                if (localDM.equals(remoteDM)) {
                    Log.getLogWriter().fine("skipping localDM " + localDM);
                } else if (excludeDM == null) {
                    Log.getLogWriter().fine("excludeDM == null, taking first remote response from " + remoteDM);
                    targetDM = remoteDM;
                } else if (!excludeDM.equals(remoteDM)) {
                    Log.getLogWriter().fine("excludeDM == null, targetDM = first DM which is not excludeDM(" + excludeDM + ") " + remoteDM);
                    targetDM = remoteDM;
                }
            }
            if (targetDM == null || !remoteDM.equals(targetDM)) continue;
            keySetAvailable = true;
            break;
        }
        if (!keySetAvailable) {
            ksResult2 = null;
            throw new TestException("Test issue with getNewKey -- no keySet found");
        }
        Log.getLogWriter().info("Returning keySet from member " + targetDM);
        return ksResult2;
    }

    protected List executeGetAllMembersInDS() {
        DistributedSystem ds = CacheUtil.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetAllMembersInDS");
        Execution e = FunctionService.onMembers((DistributedSystem)ds).withArgs((Object)dm.toString());
        Log.getLogWriter().info("executing " + f.getId());
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        Log.getLogWriter().info("ResultCollector.getResult() = " + results);
        StringBuffer s = new StringBuffer();
        s.append("ResultCollector : \n");
        ArrayList<DistributedMember> dmList = new ArrayList<DistributedMember>();
        for (SerializableDistributedMember sdm : results) {
            s.append("   " + sdm.toString() + "\n");
            dmList.add(sdm.getDistributedMember());
        }
        Log.getLogWriter().info(s.toString());
        return dmList;
    }

    public static Object getValueForKey(Region aRegion, String key) {
        Object val = null;
        TXStateInterface txState = TxHelper.internalSuspend();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetValueForKey");
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)key);
        Log.getLogWriter().info("executing " + f.getId() + " on region " + aRegion.getName() + " and key " + key);
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        for (Object testVal : results) {
            if (testVal == null) continue;
            val = testVal;
            break;
        }
        TxHelper.internalResume(txState);
        Log.getLogWriter().info("Returning value " + val + " for key " + key);
        return val;
    }

    @Override
    public Object getRandomKey(Region aRegion, Object excludeKey) {
        if (this.suspendResume) {
            this.txState.set(TxHelper.internalSuspend());
        }
        if (aRegion == null) {
            return null;
        }
        String mapKey = "keySet_" + aRegion.getFullPath();
        KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
        List keyList = keySetResult.getKeySet();
        Object[] keyArr = keyList.toArray();
        if (keyArr.length == 0) {
            Log.getLogWriter().info("Could not get a random key from " + aRegion.getFullPath() + " because the region has no keys");
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, keyArr.length - 1);
        Object key = keyArr[randInt];
        if (key.equals(excludeKey)) {
            if (keyArr.length == 1) {
                return null;
            }
            if (++randInt == keyArr.length) {
                randInt = 0;
            }
            key = keyArr[randInt];
        }
        if (this.suspendResume) {
            TxHelper.internalResume((TXStateInterface)this.txState.get());
        }
        return key;
    }

    @Override
    public Operation getEntryWithPreviousKey(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Log.getLogWriter().info("getEntryWithPreviousKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getEntryWithPreviousKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    @Override
    public Object getNewKey(Region aRegion) {
        TXStateInterface txState = TxHelper.internalSuspend();
        Object sampleKey = this.getRandomKey(aRegion);
        Object newKey = null;
        Log.getLogWriter().info("Looking for a new key colocated with " + sampleKey);
        DistributedMember localDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetNewKey");
        HashSet<Object> filter = new HashSet<Object>();
        filter.add(sampleKey);
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)localDM.toString()).withFilter(filter);
        Log.getLogWriter().info("executing " + f.getId() + " on region " + aRegion.getName() + " with filter " + filter);
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        for (Object key : results) {
            if (key == null) continue;
            newKey = key;
            break;
        }
        Log.getLogWriter().info("Found new key " + newKey + " from same member as sampleKey " + sampleKey);
        TxHelper.internalResume(txState);
        return newKey;
    }
}

