/*
 * Decompiled with CFR 0.152.
 */
package pdx;

import com.gemstone.gemfire.GemFireRethrowable;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxWriter;
import hydra.CacheHelper;
import hydra.Log;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import parReg.query.NewPortfolio;
import pdx.EnumHolder;
import pdx.PdxBB;
import pdx.PdxPrms;
import pdx.PdxTestVersionHelper;
import util.BaseValueHolder;
import util.QueryObject;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class PdxTest {
    public static boolean pdx661Behavior;
    public static ClassLoader fixedLoader;
    public static ClassLoader version1Loader;
    public static ClassLoader version2Loader;

    public static ClassLoader initClassLoader() {
        if (PdxPrms.getInitClassLoader()) {
            if (pdx661Behavior) {
                return PdxTest.setRandomLoader();
            }
            return PdxTest.setFixedLoader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ClassLoader setRandomLoader() {
        Class<PdxTest> clazz;
        if (version1Loader == null) {
            clazz = PdxTest.class;
            // MONITORENTER : pdx.PdxTest.class
            if (version1Loader == null) {
                version1Loader = PdxTest.createClassLoader(1L);
            }
            // MONITOREXIT : clazz
        }
        if (version2Loader == null) {
            clazz = PdxTest.class;
            // MONITORENTER : pdx.PdxTest.class
            if (version2Loader == null) {
                version2Loader = PdxTest.createClassLoader(2L);
            }
            // MONITOREXIT : clazz
        }
        long counter = PdxBB.getBB().getSharedCounters().incrementAndRead(PdxBB.pdxClassPathIndex);
        long version = counter % 2L + 1L;
        ClassLoader clToInstall = null;
        clToInstall = version == 1L ? version1Loader : version2Loader;
        Log.getLogWriter().info("Setting class loader with " + clToInstall);
        Thread.currentThread().setContextClassLoader(clToInstall);
        return clToInstall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ClassLoader setFixedLoader() {
        if (fixedLoader == null) {
            Class<PdxTest> clazz = PdxTest.class;
            // MONITORENTER : pdx.PdxTest.class
            if (fixedLoader == null) {
                long counter = PdxBB.getBB().getSharedCounters().incrementAndRead(PdxBB.pdxClassPathIndex);
                long version = counter % 2L + 1L;
                fixedLoader = PdxTest.createClassLoader(version);
                Log.getLogWriter().info("Setting class loader for all threads in this jvm to " + fixedLoader);
                Thread.currentThread().setContextClassLoader(fixedLoader);
                // MONITOREXIT : clazz
                return fixedLoader;
            }
            // MONITOREXIT : clazz
        }
        Log.getLogWriter().info("Setting previously created class loader with " + fixedLoader);
        Thread.currentThread().setContextClassLoader(fixedLoader);
        return fixedLoader;
    }

    public static ClassLoader createClassLoader(long version) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        cl = ClassLoader.getSystemClassLoader();
        String alternateVersionClassPath = System.getProperty("JTESTS") + File.separator + ".." + File.separator + ".." + File.separator + "testsVersions" + File.separator + "version" + version + File.separator + "classes/";
        URLClassLoader newClassLoader = null;
        try {
            newClassLoader = new URLClassLoader(new URL[]{new File(alternateVersionClassPath).toURL()}, cl);
            Log.getLogWriter().info("Created (but not yet installing) class loader with " + alternateVersionClassPath + ": " + newClassLoader);
        }
        catch (MalformedURLException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return newClassLoader;
    }

    public static Object getVersionedInstance(String className) {
        try {
            Class<?> aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            Object newObj = constructor.newInstance(new Object[0]);
            return newObj;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    public static BaseValueHolder getVersionedValueHolder(String className, String key, RandomValues rv) {
        try {
            Class<?> aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = aClass.getConstructor(String.class, RandomValues.class);
            Object newObj = constructor.newInstance(key, rv);
            return (BaseValueHolder)newObj;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    public static BaseValueHolder getVersionedValueHolder(String className, Object anObj, RandomValues rv) {
        try {
            Class<?> aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = aClass.getConstructor(Object.class, RandomValues.class);
            Object newObj = constructor.newInstance(anObj, rv);
            return (BaseValueHolder)newObj;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    public static NewPortfolio getVersionedNewPortfolio(String className, String name, int index) {
        try {
            Class<?> aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = aClass.getConstructor(String.class, Integer.TYPE);
            Object newObj = constructor.newInstance(name, index);
            return (NewPortfolio)newObj;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    public static QueryObject getVersionedQueryObject(String className, long base, int valueGeneration, int byteArraySize, int levels) {
        try {
            Class<?> aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = aClass.getConstructor(Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object newObj = constructor.newInstance(base, valueGeneration, byteArraySize, levels);
            return (QueryObject)newObj;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    public static BaseValueHolder toValueHolder(Object anObj) {
        boolean expectPdxInstance = true;
        Cache aCache = CacheHelper.getCache();
        if (aCache != null) {
            expectPdxInstance = aCache.getPdxReadSerialized();
        }
        if (anObj instanceof BaseValueHolder) {
            return (BaseValueHolder)anObj;
        }
        if (anObj instanceof PdxInstance) {
            if (!expectPdxInstance) {
                throw new TestException("Did not expect a PdxInstance: " + anObj);
            }
            PdxInstance pdxInst = (PdxInstance)anObj;
            PdxTestVersionHelper.doEnumValidation(pdxInst);
            Object backingObj = pdxInst.getObject();
            if (backingObj instanceof BaseValueHolder) {
                Log.getLogWriter().info("Obtained " + backingObj + " from PdxInstance " + pdxInst);
                return (BaseValueHolder)backingObj;
            }
            throw new TestException("Expected " + pdxInst + " to represent an instance of ValueHolder, but getObject() is " + TestHelper.toString(backingObj));
        }
        if (anObj == null) {
            return null;
        }
        throw new TestException("Expected " + anObj + " to be a PdxInstance or a ValueHolder");
    }

    public static Map<String, Object> getFieldMap(Object anObject) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Class<?> aClass = anObject.getClass();
        fieldMap.put("className", aClass.getName());
        Map<String, Field> actualFields = PdxTest.getAllFields(anObject);
        for (String fieldName : actualFields.keySet()) {
            Field aField = actualFields.get(fieldName);
            if (Modifier.isFinal(aField.getModifiers()) || Modifier.isTransient(aField.getModifiers())) continue;
            Object fieldValue = null;
            try {
                fieldValue = aField.get(anObject);
            }
            catch (IllegalArgumentException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (fieldMap.containsKey(fieldName)) {
                throw new TestException("test problem: field " + fieldName + " already exists");
            }
            if (aField.getType().isEnum() && fieldValue != null) {
                EnumHolder holder = new EnumHolder(aField.getType().getName(), fieldValue.toString());
                fieldMap.put(fieldName, holder);
                continue;
            }
            fieldMap.put(fieldName, fieldValue);
        }
        Log.getLogWriter().info("created fieldMap " + fieldMap + " for object " + anObject);
        return fieldMap;
    }

    public static Object restoreFromFieldMap(Map<String, Object> fieldMap) {
        String className = (String)fieldMap.get("className");
        Object newInstance = PdxTest.getVersionedInstance(className);
        Map<String, Field> actualFieldMap = PdxTest.getAllFields(newInstance);
        for (String fieldName : fieldMap.keySet()) {
            Object fieldValue = fieldMap.get(fieldName);
            Field aField = actualFieldMap.get(fieldName);
            if (aField == null) {
                Log.getLogWriter().info("Did not restore " + fieldName + ", it exists in fieldMap, but not in actual Fields");
                continue;
            }
            try {
                if (fieldValue instanceof EnumHolder) {
                    Class<?> enumClass;
                    EnumHolder holder = (EnumHolder)fieldValue;
                    String enumClassName = holder.getClassName();
                    String enumValue = holder.getEnumValue();
                    try {
                        enumClass = Class.forName(enumClassName, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Object anObj = Enum.valueOf(enumClass, enumValue);
                    aField.set(newInstance, anObj);
                    continue;
                }
                aField.set(newInstance, fieldValue);
            }
            catch (IllegalArgumentException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("restoreFromFieldMap returning " + newInstance + " restored from " + fieldMap);
        return newInstance;
    }

    private static Map<String, Field> getAllFields(Object anObject) {
        HashMap<String, Field> aMap = new HashMap<String, Field>();
        for (Class<?> aClass = anObject.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            Field[] fields;
            for (Field aField : fields = aClass.getDeclaredFields()) {
                String fieldName = aField.getName();
                aMap.put(fieldName, aField);
            }
        }
        return aMap;
    }

    public static String getOldValueStr(EntryEvent eEvent) {
        try {
            Object value = eEvent.getOldValue();
            if (value instanceof PdxInstance) {
                try {
                    Object backingObj = ((PdxInstance)value).getObject();
                    return "PdxInstance representing: " + TestHelper.toString(backingObj);
                }
                catch (SerializationException e) {
                    Throwable lastCause = TestHelper.getLastCausedBy(e);
                    if (lastCause instanceof ClassNotFoundException) {
                        return "<PdxInstance could not be obtained due to: " + e.getMessage() + ">";
                    }
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            return TestHelper.toString(value);
        }
        catch (SerializationException e) {
            Throwable lastCause = TestHelper.getLastCausedBy(e);
            if (lastCause instanceof ClassNotFoundException) {
                return "<Class " + lastCause.getMessage() + " was not found>";
            }
            throw e;
        }
    }

    public static String getNewValueStr(EntryEvent eEvent) {
        try {
            Object value = eEvent.getNewValue();
            if (value instanceof PdxInstance) {
                try {
                    Object backingObj = ((PdxInstance)value).getObject();
                    return "PdxInstance representing: " + TestHelper.toString(backingObj);
                }
                catch (SerializationException e) {
                    Throwable lastCause = TestHelper.getLastCausedBy(e);
                    if (lastCause instanceof ClassNotFoundException) {
                        return "<PdxInstance representing " + e.getMessage() + " but class could not be found>";
                    }
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            return TestHelper.toString(value);
        }
        catch (SerializationException e) {
            Throwable lastCause = TestHelper.getLastCausedBy(e);
            if (lastCause instanceof ClassNotFoundException) {
                return "<Class " + lastCause.getMessage() + " was not found>";
            }
            throw e;
        }
    }

    public static void invokeToData(Object anObj, PdxWriter writer) throws GemFireRethrowable {
        Class<?> aClass = anObj.getClass();
        try {
            Method aMethod = aClass.getMethod("myToData", PdxWriter.class);
            aMethod.invoke(anObj, writer);
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            Throwable rootExc = e.getTargetException();
            if (rootExc instanceof GemFireRethrowable) {
                throw (GemFireRethrowable)rootExc;
            }
            if (rootExc instanceof RuntimeException) {
                throw (RuntimeException)rootExc;
            }
            if (rootExc instanceof Error) {
                throw (Error)rootExc;
            }
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    public static void invokeFromData(Object anObj, PdxReader reader) {
        Class<?> aClass = anObj.getClass();
        try {
            Method aMethod = aClass.getMethod("myFromData", PdxReader.class);
            aMethod.invoke(anObj, reader);
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            Throwable baseException = e.getTargetException();
            if (baseException instanceof Error) {
                throw (Error)baseException;
            }
            if (baseException instanceof RuntimeException) {
                throw (RuntimeException)baseException;
            }
            throw new TestException(TestHelper.getStackTrace(baseException));
        }
    }

    public static String getFieldValue(Object anObj, String fieldName) throws NoSuchFieldException {
        try {
            Field aField = anObj.getClass().getField(fieldName);
            Object value = aField.get(anObj);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    static {
        fixedLoader = null;
        version1Loader = null;
        version2Loader = null;
        String propValue = System.getProperty("gemfire.loadClassOnEveryDeserialization");
        Log.getLogWriter().info("loadClassOnEveryDeserialization is " + propValue);
        pdx661Behavior = propValue == null ? false : propValue.equals("true");
        Log.getLogWriter().info("pdx661Behavior is " + pdx661Behavior);
    }
}

