/*
 * Decompiled with CFR 0.152.
 */
package pdx;

import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.ReflectionBasedAutoSerializer;
import hydra.CacheHelper;
import hydra.Log;
import java.util.ArrayList;
import pdx.PdxPrms;
import util.PdxTestSerializer;
import util.TestException;
import util.TestHelper;

public class PdxTestVersionHelper {
    public static void handleException(RuntimeException e) {
        boolean pdxReadSerialized = false;
        Cache aCache = CacheHelper.getCache();
        if (aCache != null) {
            pdxReadSerialized = aCache.getPdxReadSerialized();
        }
        if (!pdxReadSerialized && (e instanceof SerializationException || e instanceof ServerOperationException)) {
            ArrayList<Throwable> causeChain = new ArrayList<Throwable>();
            causeChain.add(e);
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                causeChain.add(cause);
            }
            Throwable lastCause = (Throwable)causeChain.get(causeChain.size() - 1);
            if (lastCause instanceof ClassNotFoundException) {
                String causeChainStr = "";
                for (int i = 0; i < causeChain.size(); ++i) {
                    Throwable t = (Throwable)causeChain.get(i);
                    causeChainStr = i == 0 ? causeChainStr + t.getClass().getName() : " " + causeChainStr + " caused by " + t.getClass().getName();
                }
                Log.getLogWriter().info("Got expected ClassNotFoundException for " + lastCause.getMessage() + " with this exception chain: " + causeChainStr);
                return;
            }
        }
        throw e;
    }

    public static Object toBaseObject(Object anObj) {
        boolean expectPdxInstance = true;
        Cache aCache = CacheHelper.getCache();
        if (aCache != null) {
            expectPdxInstance = aCache.getPdxReadSerialized();
        }
        if (anObj instanceof PdxInstance) {
            if (!expectPdxInstance) {
                throw new TestException("Did not expect a PdxInstance: " + anObj);
            }
            PdxInstance pdxInst = (PdxInstance)anObj;
            Object baseObj = pdxInst.getObject();
            Log.getLogWriter().info("Obtained " + baseObj + " from PdxInstance " + pdxInst);
            return baseObj;
        }
        if (anObj == null) {
            return anObj;
        }
        return anObj;
    }

    public static PdxSerializer instantiatePdxSerializer() {
        String className = PdxPrms.getPdxSerializerClassName();
        if (className.equals(ReflectionBasedAutoSerializer.class.getName())) {
            ArrayList<String> aList = new ArrayList<String>();
            aList.add("util.VersionedValueHolder#identity=myValue");
            aList.add(".*");
            ReflectionBasedAutoSerializer mySerializer = new ReflectionBasedAutoSerializer(aList);
            Log.getLogWriter().info("Created " + mySerializer.getClass().getName() + " with args: " + aList);
            return mySerializer;
        }
        if (className.equals(PdxTestSerializer.class.getName())) {
            Log.getLogWriter().info("Created " + PdxTestSerializer.class.getName());
            return new PdxTestSerializer();
        }
        throw new TestException("Test problem: don't know about " + className);
    }

    public static void doEnumValidation(PdxInstance pdxInst) throws TestException {
        boolean doEnumValidation = PdxPrms.getDoEnumValidation();
        if (!doEnumValidation) {
            return;
        }
        if (pdxInst.isEnum()) {
            throw new TestException("isEnum() on " + pdxInst + " returned true");
        }
        String className = pdxInst.getClassName();
        if (!className.equals("util.VersionedValueHolder") && !className.equals("util.PdxVersionedValueHolder")) {
            throw new TestException("getClassName() on " + pdxInst + " returned " + className);
        }
        Object enumObj = pdxInst.getField("aDay");
        if (enumObj != null) {
            if (!(enumObj instanceof PdxInstance)) {
                throw new TestException("Expected enum field aDay to be a PdxInstance but it is " + TestHelper.toString(enumObj));
            }
            PdxInstance enumPdxInst = (PdxInstance)enumObj;
            className = enumPdxInst.getClassName();
            if (!className.equals("util.VersionedValueHolder$Day")) {
                throw new TestException("getClassName() on " + enumPdxInst + " returned " + className);
            }
        }
    }
}

