/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraInternalException;
import hydra.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import perffmwk.ComparisonConstants;
import perffmwk.PerfStatValue;
import perffmwk.StatSpec;
import perffmwk.TestComparison;
import perffmwk.ValueComparator;

public abstract class BaseComparison
implements TestComparison,
ComparisonConstants {
    protected List comparators;
    protected boolean markFailedTests;
    protected List statspecColumn;
    protected List opColumn;
    protected List[] valColumns;
    protected LogWriter log;

    BaseComparison(List comparators, boolean markFailedTests) {
        this.comparators = comparators;
        this.markFailedTests = markFailedTests;
        this.statspecColumn = new ArrayList();
        this.opColumn = new ArrayList();
        this.valColumns = new ArrayList[this.comparators.size()];
        for (int i = 0; i < this.comparators.size(); ++i) {
            this.valColumns[i] = new ArrayList();
        }
        this.log = Log.getLogWriter();
    }

    @Override
    public List getStatSpecColumn() {
        return this.statspecColumn;
    }

    @Override
    public List getOpColumn() {
        return this.opColumn;
    }

    @Override
    public List[] getValColumns() {
        return this.valColumns;
    }

    protected double getOpValue(String op, PerfStatValue psv) {
        if (op.equals("min")) {
            return psv.getMin();
        }
        if (op.equals("max")) {
            return psv.getMax();
        }
        if (op.equals("avg")) {
            return psv.getMean();
        }
        if (op.equals("del")) {
            return psv.getMaxMinusMin();
        }
        if (op.equals("std")) {
            return psv.getStddev();
        }
        throw new HydraInternalException("Should not happen: " + op);
    }

    protected void fillInRows() {
        SortedMap statspecs = null;
        for (ValueComparator comparator : this.comparators) {
            if (comparator == null) continue;
            statspecs = comparator.getTest().getStatSpecs();
            break;
        }
        for (StatSpec statspec : statspecs.values()) {
            String statspecName = statspec.getName();
            if (statspec.getMinCompare()) {
                this.fillInRow("min", statspecName);
            }
            if (statspec.getMaxCompare()) {
                this.fillInRow("max", statspecName);
            }
            if (statspec.getMeanCompare()) {
                this.fillInRow("avg", statspecName);
            }
            if (statspec.getMaxMinusMinCompare()) {
                this.fillInRow("del", statspecName);
            }
            if (!statspec.getStddevCompare()) continue;
            this.fillInRow("std", statspecName);
        }
    }

    protected abstract void fillInRow(String var1, String var2);

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.statspecColumn.iterator();
        while (i.hasNext()) {
            buf.append("\nStat spec: " + i.next());
        }
        i = this.opColumn.iterator();
        while (i.hasNext()) {
            buf.append("\nOperation: " + i.next());
        }
        for (int i2 = 0; i2 < this.valColumns.length; ++i2) {
            buf.append("\nValues: " + this.valColumns[i2]);
        }
        return buf.toString();
    }
}

