/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import hydra.Log;
import perffmwk.HistogramStatsPrms;
import perffmwk.PerformanceStatistics;

public class HistogramStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    private static final boolean logHighLatencyWarnings = HistogramStatsPrms.logHighLatencyWarnings();
    private static final String OPERATIONS = "operations";
    private static long[] binVals;
    private static String[] binNames;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        binVals = HistogramStatsPrms.getBinVals();
        binNames = new String[binVals.length + 1];
        StatisticDescriptor[] binDescriptors = new StatisticDescriptor[binVals.length + 2];
        for (int i = 0; i <= binVals.length; ++i) {
            if (i == 0) {
                HistogramStats.binNames[i] = "opsLessThan" + binVals[i] + "ns";
                binDescriptors[i] = HistogramStats.factory().createLongCounter(binNames[i], "Number of ops taking less than " + binVals[i] + " ns.", "ops", true);
                continue;
            }
            if (i == binVals.length) {
                HistogramStats.binNames[i] = "opsMoreThan" + binVals[binVals.length - 1] + "ns";
                binDescriptors[i] = HistogramStats.factory().createLongCounter(binNames[i], "Number of ops taking more than " + binVals[i - 1] + " ns.", "ops", false);
                continue;
            }
            HistogramStats.binNames[i] = "opsLessThan" + binVals[i] + "ns";
            binDescriptors[i] = HistogramStats.factory().createLongCounter(binNames[i], "Number of ops taking more than " + binVals[i - 1] + " and less than " + binVals[i] + " ns.", "ops", true);
        }
        binDescriptors[HistogramStats.binVals.length + 1] = HistogramStats.factory().createLongCounter(OPERATIONS, "Total number of ops included in the histogram", "ops", true);
        return binDescriptors;
    }

    public static HistogramStats getInstance() {
        return (HistogramStats)HistogramStats.getInstance(HistogramStats.class, 0);
    }

    public static HistogramStats getInstance(int scope) {
        return (HistogramStats)HistogramStats.getInstance(HistogramStats.class, scope);
    }

    public static HistogramStats getInstance(String name) {
        return (HistogramStats)HistogramStats.getInstance(HistogramStats.class, 0, name);
    }

    public static HistogramStats getInstance(String name, String trimspecName) {
        return (HistogramStats)HistogramStats.getInstance(HistogramStats.class, 0, name, trimspecName);
    }

    public HistogramStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public void incBin(long t) {
        this.statistics().incLong(OPERATIONS, 1L);
        for (int i = 0; i < binVals.length; ++i) {
            if (t >= binVals[i]) continue;
            this.statistics().incLong(binNames[i], 1L);
            return;
        }
        if (logHighLatencyWarnings) {
            Log.getLogWriter().warning("HIGH LATENCY: " + t);
        }
    }
}

