/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;

public class HistogramStatsPrms
extends BasePrms {
    public static Long enable;
    public static Long logHighLatencyWarnings;
    public static Long statisticsSpecification;
    public static Long binVals;

    public static boolean enable() {
        Long key = enable;
        return HistogramStatsPrms.tasktab().booleanAt(key, HistogramStatsPrms.tab().booleanAt(key, false));
    }

    public static boolean logHighLatencyWarnings() {
        Long key = logHighLatencyWarnings;
        return HistogramStatsPrms.tasktab().booleanAt(key, HistogramStatsPrms.tab().booleanAt(key, false));
    }

    public static long[] getBinVals() {
        Long key = binVals;
        HydraVector vals = HistogramStatsPrms.tab().vecAt(key);
        Object[] svals = vals.toArray();
        long[] lvals = new long[svals.length];
        long last = 0L;
        for (int i = 0; i < lvals.length; ++i) {
            try {
                lvals[i] = Long.parseLong((String)svals[i]);
                if (lvals[i] <= last) {
                    String s = HistogramStatsPrms.nameForKey(key) + " are not monotonically increasing";
                    throw new HydraConfigException(s);
                }
                last = lvals[i];
                continue;
            }
            catch (NumberFormatException e) {
                String s = "Illegal value for " + HistogramStatsPrms.nameForKey(key) + ": " + svals[i];
                throw new HydraConfigException(s, e);
            }
        }
        return lvals;
    }

    static {
        HistogramStatsPrms.setValues(HistogramStatsPrms.class);
    }
}

