/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.LogWriter;
import hydra.FileUtil;
import hydra.HydraInternalException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfigComparison;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import perffmwk.ComparisonConstants;
import perffmwk.Formatter;
import perffmwk.PerfComparisonException;
import perffmwk.RatioComparison;
import perffmwk.RawComparison;
import perffmwk.Test;
import perffmwk.TestComparison;
import perffmwk.TestContainer;
import perffmwk.ValueComparator;
import util.TestHelper;

public class PerfComparer
extends Formatter
implements ComparisonConstants {
    private static final String COMP_REPORT_FILE_PROP = "compReportFile";
    private static String CompReportFile;
    private static final String LOG_LEVEL_PROP = "logLevel";
    private static LogWriter log;
    private static final String MODE_PROP = "mode";
    private static String Mode;
    private static final String RATIO_MODE = "ratio";
    private static final String RAW_MODE = "raw";
    private static final String RATIO_THRESHOLD_PROP = "ratio.threshold";
    protected static double RatioThreshold;
    private static final String OMIT_FAILED_TESTS_PROP = "omitFailedTests";
    private static boolean OmitFailedTests;
    private static final String MARK_FAILED_TESTS_PROP = "markFailedTests";
    private static boolean MarkFailedTests;
    private static final String COMPARE_BY_KEY_PROP = "compareByKey";
    private static boolean CompareByKey;
    private static final String ADD_TEST_KEY_PROP = "addTestKey";
    private static boolean AddTestKey;
    private static final String ADD_CONFIG_DIFFS_PROP = "addConfigDiffs";
    private static boolean AddConfigDiffs;
    private static final String STAT_SPEC_FILE_PROP = "statSpecFile";
    private static String StatSpecFile;
    private static final String GENERATE_CSV_FILE_PROP = "generateCSVFile";
    private static boolean GenerateCSVFile;
    private static final String CSV_FILE_PROP = "csvFile";
    private static String CSVFile;
    private static List TestContainerDirs;

    private static boolean readParameters(String[] args) {
        StringBuffer configuration = new StringBuffer();
        String fileName = System.getProperty(COMP_REPORT_FILE_PROP, "perfcomparison.txt");
        CompReportFile = fileName.equals("none") ? null : FileUtil.absoluteFilenameFor(fileName);
        configuration.append("\ncompReportFile = " + CompReportFile);
        String logLevel = System.getProperty(LOG_LEVEL_PROP, "info");
        configuration.append("\nlogLevel = " + logLevel);
        log = CompReportFile == null ? Log.createLogWriter("perfcomparer", logLevel) : Log.createLogWriter("perfcomparer", "perfcomparer", logLevel, true);
        log.info("PerfComparer PID is " + ProcessMgr.getProcessId());
        String jtests = System.getProperty("JTESTS");
        if (jtests == null) {
            PerfComparer.usage("Missing JTESTS");
            return false;
        }
        configuration.append("\nJTESTS = " + jtests);
        String gemfire = System.getProperty("gemfire.home");
        if (gemfire == null) {
            PerfComparer.usage("Missing gemfire.home");
            return false;
        }
        configuration.append("\ngemfire.home = " + gemfire);
        Mode = System.getProperty(MODE_PROP, RATIO_MODE);
        if (!Mode.equals(RATIO_MODE) && !Mode.equals(RAW_MODE)) {
            PerfComparer.usage("Illegal mode: " + Mode);
            return false;
        }
        configuration.append("\nmode = " + Mode);
        try {
            String ratioThreshold = System.getProperty(RATIO_THRESHOLD_PROP, ".05");
            RatioThreshold = Double.parseDouble(ratioThreshold);
            if (RatioThreshold < 0.0) {
                PerfComparer.usage("Illegal ratio.threshold: " + RatioThreshold);
                return false;
            }
        }
        catch (NumberFormatException e) {
            PerfComparer.usage("Illegal ratio.threshold: " + RatioThreshold);
            return false;
        }
        configuration.append("\nratio.threshold = " + RatioThreshold);
        RatioThreshold += 1.0;
        OmitFailedTests = Boolean.getBoolean(OMIT_FAILED_TESTS_PROP);
        MarkFailedTests = Boolean.getBoolean(MARK_FAILED_TESTS_PROP);
        if (MarkFailedTests) {
            OmitFailedTests = false;
        }
        configuration.append("\nomitFailedTests = " + OmitFailedTests);
        configuration.append("\nmarkFailedTests = " + MarkFailedTests);
        CompareByKey = Boolean.getBoolean(COMPARE_BY_KEY_PROP);
        configuration.append("\ncompareByKey = " + CompareByKey);
        AddTestKey = Boolean.getBoolean(ADD_TEST_KEY_PROP);
        configuration.append("\naddTestKey = " + AddTestKey);
        AddConfigDiffs = Boolean.getBoolean(ADD_CONFIG_DIFFS_PROP);
        configuration.append("\naddConfigDiffs = " + AddConfigDiffs);
        StatSpecFile = System.getProperty(STAT_SPEC_FILE_PROP);
        if (StatSpecFile != null && !FileUtil.exists(StatSpecFile = FileUtil.absoluteFilenameFor(StatSpecFile))) {
            PerfComparer.usage("File not found: " + StatSpecFile);
            return false;
        }
        configuration.append("\nstatSpecFile = " + StatSpecFile);
        GenerateCSVFile = Boolean.getBoolean(GENERATE_CSV_FILE_PROP);
        configuration.append("\ngenerateCSVFile = " + GenerateCSVFile);
        String fileName2 = System.getProperty(CSV_FILE_PROP, "perfcomparison.csv");
        CSVFile = FileUtil.absoluteFilenameFor(fileName2);
        configuration.append("\ncvsFile = " + CSVFile);
        if (args.length == 0) {
            PerfComparer.usage("No directories specified");
            return false;
        }
        TestContainerDirs = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            String testContainerDir = FileUtil.absoluteFilenameFor(args[i]);
            if (TestContainerDirs.contains(testContainerDir)) continue;
            TestContainerDirs.add(testContainerDir);
        }
        configuration.append("\ndirectories = " + TestContainerDirs);
        log.info(configuration.toString());
        return true;
    }

    private static void usage(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n** " + s);
        buf.append("\nUsage: java");
        buf.append(" -Dgemfire.home=<path_to_gemfire_product_tree>");
        buf.append(" -DJTESTS=<path_to_test_classes>");
        buf.append(" [optional_properties]");
        buf.append(" perffmwk.PerfComparer <list_of_directories>");
        buf.append("\nwhere optional properties include:");
        buf.append("\n-DcompReportFile=<report_filename(default:$pwd/perfcomparison.txt)>");
        buf.append("\n-DlogLevel=<log_level(default:info)>");
        buf.append("\n-Dmode=<comparison_mode(default:ratio)>");
        buf.append("\n-Dratio.threshold=<ratio_threshold(default:0.05)>");
        buf.append("\n-DomitFailedTests=<whether_to_omit_failed_tests(default:false)>");
        buf.append("\n-DmarkFailedTests=<whether_to_mark_failed_tests(default:false)>");
        buf.append("\n-DcompareByKey=<whether_to_compare_tests_by_key(default:false)>");
        buf.append("\n-DaddTestKey=<whether_to_include_test_key(default:false)>");
        buf.append("\n-DaddConfigDiffs=<whether_to_include_config_diffs(default:false)>");
        buf.append("\n-DstatSpecFile=<stat_spec_filename>");
        buf.append("\n-DgenerateCSVFile=<whether_to_generate_csv_file(default:false)>");
        buf.append("\n-DcsvFile=<csv_filename(default:$pwd/perfcomparison.csv)>");
        System.out.println(buf.toString());
    }

    private static void writeReport(String report, String filename) {
        if (filename == null) {
            new PrintStream(new FileOutputStream(FileDescriptor.out)).println(report);
        } else {
            FileUtil.writeToFile(filename, report);
        }
    }

    private static String formatValues(List testIds, List testDescriptions, List testContainers, List testComparisons, List testConfigDiffs) {
        TestContainer testContainer;
        Test test;
        int i;
        List tests;
        int i2;
        int j;
        int i3;
        ArrayList[] valColumns;
        log.info("Formatting summary...");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("================================================================================");
        PerfComparer.center("Comparison Report", pw);
        PerfComparer.center(new Date().toString(), pw);
        ArrayList<String> testIdColumn = new ArrayList<String>();
        ArrayList<String> statSpecColumn = new ArrayList<String>();
        ArrayList<String> opColumn = new ArrayList<String>();
        if (testContainers.size() == 1) {
            TestContainer testContainer2 = (TestContainer)testContainers.get(0);
            valColumns = new ArrayList[testContainer2.getTests().size()];
        } else {
            valColumns = new ArrayList[testContainers.size()];
        }
        for (i3 = 0; i3 < valColumns.length; ++i3) {
            valColumns[i3] = new ArrayList();
        }
        for (i3 = 0; i3 < testComparisons.size(); ++i3) {
            TestComparison testComparison = (TestComparison)testComparisons.get(i3);
            String testId = (String)testIds.get(i3);
            if (testContainers.size() != 1) {
                List valColumn = testComparison.getValColumns()[0];
                for (j = 0; j < valColumn.size(); ++j) {
                    if (j == 0) {
                        if (CompareByKey) {
                            testIdColumn.add(testId);
                            continue;
                        }
                        testIdColumn.add(String.valueOf(i3));
                        continue;
                    }
                    testIdColumn.add("");
                }
            }
            statSpecColumn.addAll(testComparison.getStatSpecColumn());
            opColumn.addAll(testComparison.getOpColumn());
            List[] tmp = testComparison.getValColumns();
            for (j = 0; j < testComparison.getValColumns().length; ++j) {
                valColumns[j].addAll(tmp[j]);
            }
        }
        if (testContainers.size() != 1 && Mode.equals(RATIO_MODE)) {
            testIdColumn.add("");
            statSpecColumn.add("");
            opColumn.add("AVG");
            for (i3 = 0; i3 < valColumns.length; ++i3) {
                valColumns[i3].add(new Double(PerfComparer.average(valColumns[i3], PerfComparer.colnum(i3))));
            }
        }
        String numFormat = "0.00";
        ArrayList<Vector> columns = new ArrayList<Vector>();
        if (testContainers.size() != 1) {
            columns.add(PerfComparer.padRight(PerfComparer.addTitle("TEST", testIdColumn)));
        }
        columns.add(PerfComparer.padRight(PerfComparer.addTitle("STATSPEC", statSpecColumn)));
        columns.add(PerfComparer.padRight(PerfComparer.addTitle("OP", opColumn)));
        for (i2 = 0; i2 < valColumns.length; ++i2) {
            columns.add(PerfComparer.padLeft(PerfComparer.addTitle(PerfComparer.colnum(i2), valColumns[i2]), numFormat));
        }
        pw.println("================================================================================");
        for (i2 = 0; i2 < ((List)columns.get(0)).size(); ++i2) {
            String row = "";
            for (j = 0; j < columns.size(); ++j) {
                String s = ((List)columns.get(j)).get(i2) + " ";
                row = row + s;
            }
            pw.println(row);
        }
        if (MarkFailedTests) {
            pw.println("\nNOTE: Reported values include only passing tests but failures are marked.");
        } else if (OmitFailedTests) {
            pw.println("\nNOTE: Reported values include only passing tests.");
        } else {
            pw.println("\nNOTE: Reported values possibly include failed or hung tests.");
        }
        pw.println("================================================================================");
        PerfComparer.center("Statistic Value Key", pw);
        pw.println("     = Statistic value is unavailable or omitted");
        pw.println(" --- = Statistic value is less than the ratio threshold");
        pw.println("+inf = Statistic value went from zero to non-zero or vice versa and this is good");
        pw.println("-inf = Statistic value went from zero to non-zero or vice versa and this is bad");
        pw.println(" err = Statistic has multiple values instead of one");
        if (MarkFailedTests) {
            pw.println(" xxx = The test failed or hung");
        }
        if (testConfigDiffs != null) {
            String formattedDiffs = PerfComparer.formatTestConfigDiffs(testConfigDiffs);
            pw.println(formattedDiffs);
        }
        if (((TestContainer)testContainers.get(0)).isNativeClient()) {
            pw.println("================================================================================");
            PerfComparer.center("Native Client Build Key", pw);
            if (testContainers.size() == 1) {
                TestContainer testContainer3 = (TestContainer)testContainers.get(0);
                tests = testContainer3.getTests();
                for (i = 0; i < tests.size(); ++i) {
                    test = (Test)tests.get(i);
                    if (test.getStatConfig().isNativeClient()) {
                        pw.println(i + ": " + test.getNativeClientBuildVersion());
                        continue;
                    }
                    pw.println(i + ": none");
                }
            } else {
                for (int i4 = 0; i4 < testContainers.size(); ++i4) {
                    testContainer = (TestContainer)testContainers.get(i4);
                    if (testContainer.isNativeClient()) {
                        pw.println(i4 + ": " + testContainer.getNativeClientBuildVersion());
                        continue;
                    }
                    pw.println(i4 + ": none");
                }
            }
        }
        if (((TestContainer)testContainers.get(0)).isNativeClient()) {
            pw.println("================================================================================");
            PerfComparer.center("Native Client Source Key", pw);
            if (testContainers.size() == 1) {
                TestContainer testContainer4 = (TestContainer)testContainers.get(0);
                tests = testContainer4.getTests();
                for (i = 0; i < tests.size(); ++i) {
                    test = (Test)tests.get(i);
                    if (test.getStatConfig().isNativeClient()) {
                        pw.println(i + ": " + test.getNativeClientSourceVersion());
                        continue;
                    }
                    pw.println(i + ": none");
                }
            } else {
                for (int i5 = 0; i5 < testContainers.size(); ++i5) {
                    testContainer = (TestContainer)testContainers.get(i5);
                    if (testContainer.isNativeClient()) {
                        pw.println(i5 + ": " + testContainer.getNativeClientSourceVersion());
                        continue;
                    }
                    pw.println(i5 + ": none");
                }
            }
        }
        pw.println("================================================================================");
        PerfComparer.center("Java Build Key", pw);
        if (testContainers.size() == 1) {
            TestContainer testContainer5 = (TestContainer)testContainers.get(0);
            tests = testContainer5.getTests();
            for (i = 0; i < tests.size(); ++i) {
                test = (Test)tests.get(i);
                pw.println(i + ": " + test.getBuildVersion());
            }
        } else {
            for (int i6 = 0; i6 < testContainers.size(); ++i6) {
                testContainer = (TestContainer)testContainers.get(i6);
                pw.println(i6 + ": " + testContainer.getBuildVersion());
            }
        }
        pw.println("================================================================================");
        PerfComparer.center("Java Source Key", pw);
        if (testContainers.size() == 1) {
            TestContainer testContainer6 = (TestContainer)testContainers.get(0);
            tests = testContainer6.getTests();
            for (i = 0; i < tests.size(); ++i) {
                test = (Test)tests.get(i);
                pw.println(i + ": " + test.getSourceVersion());
            }
        } else {
            for (int i7 = 0; i7 < testContainers.size(); ++i7) {
                testContainer = (TestContainer)testContainers.get(i7);
                pw.println(i7 + ": " + testContainer.getSourceVersion());
            }
        }
        pw.println("================================================================================");
        PerfComparer.center("JDK Key", pw);
        if (testContainers.size() == 1) {
            TestContainer testContainer7 = (TestContainer)testContainers.get(0);
            tests = testContainer7.getTests();
            for (i = 0; i < tests.size(); ++i) {
                test = (Test)tests.get(i);
                pw.println(i + ": Build JDK " + test.getBuildJDK() + " Runtime JDK " + test.getRuntimeJDK() + " " + test.getJavaVMName());
            }
        } else {
            for (int i8 = 0; i8 < testContainers.size(); ++i8) {
                testContainer = (TestContainer)testContainers.get(i8);
                pw.println(i8 + ": Build JDK " + testContainer.getBuildJDK() + " Runtime JDK " + testContainer.getRuntimeJDK() + " " + testContainer.getJavaVMName());
            }
        }
        pw.println("================================================================================");
        PerfComparer.center("Directory Key", pw);
        if (testContainers.size() == 1) {
            TestContainer testContainer8 = (TestContainer)testContainers.get(0);
            tests = testContainer8.getTests();
            for (i = 0; i < tests.size(); ++i) {
                test = (Test)tests.get(i);
                pw.println(i + ": " + test.getTestDir());
            }
        } else {
            for (int i9 = 0; i9 < testContainers.size(); ++i9) {
                testContainer = (TestContainer)testContainers.get(i9);
                pw.println(i9 + ": " + testContainer.getTestContainerDir());
            }
        }
        if (AddTestKey) {
            pw.println("================================================================================");
            PerfComparer.center("Test Key", pw);
            for (int i10 = 0; i10 < testIds.size(); ++i10) {
                String suffix;
                String testId = (String)testIds.get(i10);
                String testDescription = (String)testDescriptions.get(i10);
                if (CompareByKey) {
                    suffix = ":\n\"" + testDescription + "\"";
                    pw.println("\nTEST " + testId + suffix);
                    continue;
                }
                suffix = ":\n" + testId + "\n\"" + testDescription + "\"";
                pw.println("\nTEST " + i10 + suffix);
            }
        }
        pw.flush();
        return sw.toString();
    }

    private static String formatCSV(List testIds, List testDescriptions, List testContainers, List testComparisons) {
        if (TestContainerDirs.size() == 1) {
            return PerfComparer.formatCSVSingle(testIds, testDescriptions, testContainers, testComparisons);
        }
        return PerfComparer.formatCSVMulti(testIds, testDescriptions, testContainers, testComparisons);
    }

    private static String formatCSVMulti(List testIds, List testDescriptions, List testContainers, List testComparisons) {
        int i;
        int j;
        int i2;
        ArrayList[] valColumns;
        log.info("Formatting CSV...");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ArrayList<String> testIdColumn = new ArrayList<String>();
        ArrayList statSpecColumn = new ArrayList();
        ArrayList opColumn = new ArrayList();
        if (testContainers.size() == 1) {
            TestContainer testContainer = (TestContainer)testContainers.get(0);
            valColumns = new ArrayList[testContainer.getTests().size()];
        } else {
            valColumns = new ArrayList[testContainers.size()];
        }
        for (i2 = 0; i2 < valColumns.length; ++i2) {
            valColumns[i2] = new ArrayList();
        }
        for (i2 = 0; i2 < testComparisons.size(); ++i2) {
            TestComparison testComparison = (TestComparison)testComparisons.get(i2);
            String testId = (String)testIds.get(i2);
            if (testContainers.size() != 1) {
                List valColumn = testComparison.getValColumns()[0];
                for (j = 0; j < valColumn.size(); ++j) {
                    if (j == 0) {
                        if (CompareByKey) {
                            testIdColumn.add(testId);
                            continue;
                        }
                        testIdColumn.add(String.valueOf(i2));
                        continue;
                    }
                    testIdColumn.add("");
                }
            }
            statSpecColumn.addAll(testComparison.getStatSpecColumn());
            opColumn.addAll(testComparison.getOpColumn());
            List[] tmp = testComparison.getValColumns();
            for (j = 0; j < testComparison.getValColumns().length; ++j) {
                valColumns[j].addAll(tmp[j]);
            }
        }
        String numFormat = "0.00";
        ArrayList<Vector> columns = new ArrayList<Vector>();
        if (testContainers.size() != 1) {
            columns.add(PerfComparer.padRight(PerfComparer.addTitle("TEST", testIdColumn)));
        }
        columns.add(PerfComparer.padRight(PerfComparer.addTitle("STATSPEC", statSpecColumn)));
        columns.add(PerfComparer.padRight(PerfComparer.addTitle("OP", opColumn)));
        for (i = 0; i < valColumns.length; ++i) {
            columns.add(PerfComparer.padLeft(PerfComparer.addTitle(PerfComparer.colnum(i), valColumns[i]), numFormat));
        }
        for (i = 0; i < ((List)columns.get(0)).size(); ++i) {
            String row = "";
            for (j = 0; j < columns.size(); ++j) {
                if (j > 0) {
                    row = row + ",";
                }
                String s = ((String)((List)columns.get(j)).get(i)).trim();
                row = row + s;
            }
            pw.println(row);
        }
        pw.flush();
        return sw.toString();
    }

    private static String formatCSVSingle(List testIds, List testDescriptions, List testContainers, List testComparisons) {
        int i;
        log.info("Formatting CSV...");
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("TestPath");
        headerRow.add("TestName");
        SortedSet testPropertyKeys = PerfComparer.getTestPropertyKeys(testContainers);
        headerRow.addAll(PerfComparer.resortHVT(testPropertyKeys));
        SortedSet testStatSpecNames = PerfComparer.getTestStatSpecNames(testComparisons);
        headerRow.addAll(testStatSpecNames);
        if (AddTestKey) {
            headerRow.add("TestDescription");
        }
        TestContainer testContainer = (TestContainer)testContainers.get(0);
        ArrayList[] rows = new ArrayList[testContainer.getTests().size()];
        for (i = 0; i < rows.length; ++i) {
            rows[i] = new ArrayList();
        }
        for (i = 0; i < rows.length; ++i) {
            String testId = (String)testIds.get(i);
            Test test = (Test)testContainer.getTests().get(i);
            if (!test.getTestId().equals(testId)) {
                String s = "Things aren't lining up.  Expected testId: " + testId + " but got testId: " + test.getTestId();
                throw new HydraInternalException(s);
            }
            SortedMap testProps = test.getTestProperties();
            String testFullName = (String)testProps.get("testName");
            String testPath = FileUtil.pathFor(testFullName);
            rows[i].add(testPath);
            String testName = FileUtil.filenameFor(testFullName);
            rows[i].add(testName.substring(0, testName.indexOf(".conf")));
            for (String testPropertyKey : testPropertyKeys) {
                String testPropertyVal = (String)testProps.get(testPropertyKey);
                if (testPropertyVal == null) {
                    rows[i].add("");
                    continue;
                }
                rows[i].add(testPropertyVal);
            }
            TestComparison testComparison = (TestComparison)testComparisons.get(0);
            List statSpecNames = testComparison.getStatSpecColumn();
            List statSpecVals = testComparison.getValColumns()[i];
            for (String testStatSpecName : testStatSpecNames) {
                int index = statSpecNames.indexOf(testStatSpecName);
                if (index == -1) {
                    rows[i].add("");
                    continue;
                }
                rows[i].add(statSpecVals.get(index));
            }
            if (!AddTestKey) continue;
            String testDescription = (String)testDescriptions.get(i);
            rows[i].add(testDescription.replace(',', ';'));
        }
        String numFormat = "0.00";
        for (int i2 = 0; i2 < rows.length; ++i2) {
            rows[i2] = new ArrayList(PerfComparer.formatDecimal(rows[i2], numFormat));
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println(PerfComparer.rowToCSVString(headerRow));
        for (int i3 = 0; i3 < rows.length; ++i3) {
            pw.println(PerfComparer.rowToCSVString(rows[i3]));
        }
        pw.flush();
        return sw.toString();
    }

    private static List resortHVT(Set testPropertyKeys) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator i = testPropertyKeys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.endsWith("ThreadsPerVM")) {
                if (i.hasNext()) {
                    String nextKey = (String)i.next();
                    if (nextKey.endsWith("VMsPerHost")) {
                        keys.add(nextKey);
                        keys.add(key);
                        continue;
                    }
                    keys.add(key);
                    keys.add(nextKey);
                    continue;
                }
                keys.add(key);
                continue;
            }
            keys.add(key);
        }
        return keys;
    }

    private static String rowToCSVString(List row) {
        String csv = "";
        Iterator it = row.iterator();
        while (it.hasNext()) {
            if (csv.length() == 0) {
                csv = csv + it.next();
                continue;
            }
            csv = csv + "," + it.next();
        }
        return csv;
    }

    private static String formatTestConfigDiffs(List testConfigDiffs) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("================================================================================");
        PerfComparer.center("Test Configuration Differences", pw);
        pw.flush();
        int headerSize = sw.toString().length();
        for (int i = 0; i < testConfigDiffs.size(); ++i) {
            String diffStr = new String();
            List[] diffs = (List[])testConfigDiffs.get(i);
            for (int j = 0; j < diffs.length; ++j) {
                List diff = diffs[j];
                if (diff == null || diff.size() <= 0) continue;
                diffStr = testConfigDiffs.size() == 1 ? diffStr + "Test " : diffStr + "     Dir ";
                diffStr = diffStr + j + ": " + diff.get(0) + "\n";
                for (int k = 1; k < diff.size(); ++k) {
                    diffStr = diffStr + "            " + diff.get(k) + "\n";
                }
            }
            if (diffStr.length() <= 0) continue;
            if (testConfigDiffs.size() != 1) {
                pw.println("Test " + i + ":\n");
            }
            pw.println(diffStr);
        }
        pw.flush();
        String result = sw.toString();
        return result.length() > headerSize ? result : "";
    }

    private static List addTitle(String title, List l) {
        ArrayList<String> tl = new ArrayList<String>();
        tl.add(title);
        tl.addAll(l);
        return tl;
    }

    private static String colnum(int i) {
        return "#" + i;
    }

    private static double average(List vals, String colnum) {
        double total = 0.0;
        int count = 0;
        boolean omissions = false;
        for (int i = 0; i < vals.size(); ++i) {
            Object o = vals.get(i);
            if (o instanceof Double) {
                total += ((Double)o).doubleValue();
                ++count;
                continue;
            }
            omissions = true;
        }
        if (omissions) {
            log.fine("Omitting non-numerical values from average for column " + colnum);
        }
        return count == 0 ? 0.0 : total / (double)count;
    }

    private static SortedSet getTestPropertyKeys(List testContainers) {
        TreeSet<String> allKeys = new TreeSet<String>();
        for (TestContainer testContainer : testContainers) {
            SortedSet keys = testContainer.getTestPropertyKeys();
            for (String key : keys) {
                if (key.equals("testName") || key.equals("perffmwk.comparisonKey") || key.equals("onlyOnPlatforms") || key.equals("trimSeconds") || key.equals("workSeconds")) continue;
                allKeys.add(key);
            }
        }
        return allKeys;
    }

    private static SortedSet getTestStatSpecNames(List testComparisons) {
        TreeSet<String> allNames = new TreeSet<String>();
        for (TestComparison testComparison : testComparisons) {
            List names = testComparison.getStatSpecColumn();
            for (String name : names) {
                allNames.add(name);
            }
        }
        return allNames;
    }

    private static List compare(List testIds, List testContainers, boolean markFailedTests) {
        ArrayList<TestComparison> testComparisons = new ArrayList<TestComparison>();
        if (testContainers.size() == 1) {
            TestContainer testContainer = (TestContainer)testContainers.get(0);
            TestComparison testComparison = PerfComparer.compare(testContainer, markFailedTests);
            testComparisons.add(testComparison);
        } else {
            for (String testId : testIds) {
                TestComparison testComparison = PerfComparer.compare(testId, testContainers, markFailedTests);
                testComparisons.add(testComparison);
            }
        }
        return testComparisons;
    }

    private static TestComparison compare(TestContainer testContainer, boolean markFailedTests) {
        log.info("Building value comparators for " + testContainer.getTestContainerDir() + "...");
        List comparators = PerfComparer.buildValueComparators(testContainer);
        if (log.fineEnabled()) {
            log.fine("Built value comparators for " + testContainer.getTestContainerDir() + ": " + comparators);
        }
        log.info("Comparing tests in " + testContainer.getTestContainerDir() + "...");
        TestComparison testComparison = PerfComparer.compareValues(comparators, markFailedTests);
        if (log.fineEnabled()) {
            log.fine("Compared tests in " + testContainer.getTestContainerDir() + ": " + testComparison);
        }
        return testComparison;
    }

    private static TestComparison compare(String testId, List testContainers, boolean markFailedTests) {
        log.info("Building value comparators for " + testId + "...");
        List comparators = PerfComparer.buildValueComparators(testId, testContainers);
        if (log.fineEnabled()) {
            log.fine("Built value comparators for " + testId + ": " + comparators);
        }
        log.info("Comparing tests for " + testId + "...");
        TestComparison testComparison = PerfComparer.compareValues(comparators, markFailedTests);
        if (testComparison.getStatSpecColumn().size() == 0) {
            log.warning("No statspecs found for " + testId);
        }
        if (log.fineEnabled()) {
            log.fine("Compared tests for " + testId + ": " + testComparison);
        }
        return testComparison;
    }

    private static TestComparison compareValues(List comparators, boolean markFailedTests) {
        if (Mode.equals(RAW_MODE)) {
            return new RawComparison(comparators, markFailedTests);
        }
        if (Mode.equals(RATIO_MODE)) {
            return new RatioComparison(comparators, RatioThreshold, markFailedTests);
        }
        throw new HydraInternalException("Should not happen: " + Mode);
    }

    private static List buildTestContainers(List testContainerDirs, boolean omitFailedTests, boolean compareByKey) {
        log.info("Building test containers...");
        boolean enforceConsistency = testContainerDirs.size() != 1;
        ArrayList<TestContainer> testContainers = new ArrayList<TestContainer>();
        for (String testContainerDir : testContainerDirs) {
            TestContainer testContainer = new TestContainer(testContainerDir, omitFailedTests, compareByKey, enforceConsistency);
            testContainers.add(testContainer);
        }
        if (log.fineEnabled()) {
            log.fine("Built test containers: " + testContainers);
        }
        return testContainers;
    }

    private static List buildTestSuite(List testContainers) {
        ArrayList<String> testIds;
        log.info("Building test suite...");
        if (testContainers.size() == 1) {
            testIds = new ArrayList<String>();
            TestContainer testContainer = (TestContainer)testContainers.get(0);
            for (Test test : testContainer.getTests()) {
                testIds.add(test.getTestId());
            }
        } else {
            TreeSet ids = new TreeSet();
            for (TestContainer testContainer : testContainers) {
                ids.addAll(testContainer.getTestIds());
            }
            testIds = new ArrayList(ids);
        }
        if (log.fineEnabled()) {
            log.fine("Built test suite: " + testIds);
        }
        return testIds;
    }

    private static List buildTestDescriptions(List testIds, List testContainers) {
        log.info("Building test descriptions...");
        ArrayList<String> testDescriptions = new ArrayList<String>();
        if (testContainers.size() == 1) {
            TestContainer testContainer = (TestContainer)testContainers.get(0);
            for (Test test : testContainer.getTests()) {
                testDescriptions.add(test.getTestDescription());
            }
        } else {
            for (String testId : testIds) {
                String testDescription = PerfComparer.getLastTestDescription(testId, testContainers);
                testDescriptions.add(testDescription);
            }
        }
        if (log.fineEnabled()) {
            log.fine("Built test descriptions: " + testDescriptions);
        }
        return testDescriptions;
    }

    private static String getLastTestDescription(String testId, List testContainers) {
        for (int i = testContainers.size() - 1; i >= 0; --i) {
            TestContainer testContainer = (TestContainer)testContainers.get(i);
            List tests = testContainer.getTestsWithId(testId);
            for (int j = tests.size() - 1; j >= 0; --j) {
                Test test = (Test)tests.get(j);
                String testDescription = test.getTestDescription();
                if (testDescription == null) continue;
                return testDescription;
            }
        }
        String s = "No test description found for test id: " + testId;
        throw new PerfComparisonException(s);
    }

    private static void resetStatSpecs(List testIds, List testContainers, String statSpecFile) {
        log.info("Resetting statspecs with global override " + statSpecFile);
        for (String testId : testIds) {
            PerfComparer.resetStatSpecs(testId, testContainers, statSpecFile);
        }
    }

    private static void resetStatSpecs(String testId, List testContainers, String statSpecFileOverride) {
        if (testContainers.size() == 1) {
            TestContainer testContainer = (TestContainer)testContainers.get(0);
            String statSpecFile = statSpecFileOverride;
            if (statSpecFileOverride == null) {
                statSpecFile = PerfComparer.getLastStatSpecFile(testContainer);
            }
            List tests = testContainer.getTests();
            for (Test test : tests) {
                test.resetStatSpecs(statSpecFile);
            }
        } else {
            String statSpecFile = statSpecFileOverride;
            if (statSpecFileOverride == null) {
                statSpecFile = PerfComparer.getLastStatSpecFile(testId, testContainers);
            }
            for (TestContainer testContainer : testContainers) {
                List tests = testContainer.getTestsWithId(testId);
                for (Test test : tests) {
                    test.resetStatSpecs(statSpecFile);
                }
            }
        }
    }

    private static String getLastStatSpecFile(TestContainer testContainer) {
        List tests = testContainer.getTests();
        for (int i = tests.size() - 1; i >= 0; --i) {
            Test test = (Test)tests.get(i);
            String statSpecFile = test.getStatSpecFile();
            if (statSpecFile == null) continue;
            return statSpecFile;
        }
        String s = "No statspec file found for tests in container: " + testContainer.getTestContainerDir();
        throw new PerfComparisonException(s);
    }

    private static String getLastStatSpecFile(String testId, List testContainers) {
        for (int i = testContainers.size() - 1; i >= 0; --i) {
            TestContainer testContainer = (TestContainer)testContainers.get(i);
            List tests = testContainer.getTestsWithId(testId);
            for (int j = tests.size() - 1; j >= 0; --j) {
                Test test = (Test)tests.get(j);
                String statSpecFile = test.getStatSpecFile();
                if (statSpecFile == null) continue;
                return statSpecFile;
            }
        }
        String s = "No statspec file found for test id: " + testId;
        throw new PerfComparisonException(s);
    }

    private static List buildValueComparators(TestContainer testContainer) {
        ArrayList<ValueComparator> comparators = new ArrayList<ValueComparator>();
        List tests = testContainer.getTests();
        for (int i = 0; i < tests.size(); ++i) {
            Test test = (Test)tests.get(i);
            ValueComparator comparator = new ValueComparator(i, test);
            comparators.add(comparator);
        }
        for (ValueComparator comparator : comparators) {
            if (comparator == null) continue;
            comparator.readArchives();
        }
        return comparators;
    }

    private static List buildValueComparators(String testId, List testContainers) {
        ArrayList<ValueComparator> comparators = new ArrayList<ValueComparator>();
        for (int i = 0; i < testContainers.size(); ++i) {
            TestContainer testContainer = (TestContainer)testContainers.get(i);
            List tests = testContainer.getTestsWithId(testId);
            if (tests.size() == 0) {
                comparators.add(null);
                continue;
            }
            if (tests.size() == 1) {
                Test test = (Test)tests.get(0);
                ValueComparator comparator = new ValueComparator(i, test);
                comparators.add(comparator);
                continue;
            }
            String s = "Not implemented yet: multiple tests in " + testContainer.getTestContainerDir() + " with id=" + testId;
            throw new UnsupportedOperationException(s);
        }
        for (ValueComparator comparator : comparators) {
            if (comparator == null) continue;
            comparator.readArchives();
        }
        return comparators;
    }

    private static List getTestConfigDiffs(List testIds, List testContainers) {
        ArrayList<List[]> diffs = new ArrayList<List[]>();
        if (testContainers.size() == 1) {
            TestContainer testContainer = (TestContainer)testContainers.get(0);
            List[] testDiffs = PerfComparer.getTestConfigDiffs(testContainer);
            diffs.add(testDiffs);
        } else {
            for (String testId : testIds) {
                List[] testDiffs = PerfComparer.getTestConfigDiffs(testId, testContainers);
                diffs.add(testDiffs);
            }
        }
        return diffs;
    }

    private static List[] getTestConfigDiffs(TestContainer testContainer) {
        ArrayList<String> testDirs = new ArrayList<String>();
        List tests = testContainer.getTests();
        for (Test test : tests) {
            testDirs.add(test.getTestDir());
        }
        return TestConfigComparison.getLatestConfDiffs(testDirs);
    }

    private static List[] getTestConfigDiffs(String testId, List testContainers) {
        ArrayList testDirs = new ArrayList();
        for (TestContainer testContainer : testContainers) {
            testDirs.addAll(testContainer.getTestDirsWithId(testId));
        }
        return TestConfigComparison.getLatestConfDiffs(testDirs);
    }

    public static void main(String[] args) {
        try {
            if (PerfComparer.readParameters(args)) {
                List testContainers = PerfComparer.buildTestContainers(TestContainerDirs, OmitFailedTests, CompareByKey);
                List testIds = PerfComparer.buildTestSuite(testContainers);
                List testDescriptions = PerfComparer.buildTestDescriptions(testIds, testContainers);
                PerfComparer.resetStatSpecs(testIds, testContainers, StatSpecFile);
                List testComparisons = PerfComparer.compare(testIds, testContainers, MarkFailedTests);
                List testConfigDiffs = null;
                if (AddConfigDiffs) {
                    testConfigDiffs = PerfComparer.getTestConfigDiffs(testIds, testContainers);
                }
                String report = PerfComparer.formatValues(testIds, testDescriptions, testContainers, testComparisons, testConfigDiffs);
                PerfComparer.writeReport(report, CompReportFile);
                if (GenerateCSVFile) {
                    report = PerfComparer.formatCSV(testIds, testDescriptions, testContainers, testComparisons);
                    PerfComparer.writeReport(report, CSVFile);
                }
                System.exit(0);
            } else {
                PerfComparer.logError("runcomparison() returned false");
                System.exit(1);
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            PerfComparer.logError(TestHelper.getStackTrace(t));
            System.exit(1);
        }
    }

    private static void logError(String msg) {
        if (log == null) {
            System.err.println(msg);
        } else {
            log.severe(msg);
        }
    }
}

