/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import hydra.FileUtil;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Vector;
import perffmwk.Formatter;
import perffmwk.PerfComparisonException;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatReader;
import perffmwk.PerfStatValue;
import perffmwk.StatConfig;
import perffmwk.StatSpec;
import perffmwk.StatSpecParser;
import perffmwk.TrimSpec;
import perffmwk.TrimSpecParser;
import util.TestHelper;

public class PerfReporter
extends Formatter {
    protected static final String LATEST_PROP_FILE_NAME = "latest.prop";
    protected static final String TRIM_SPEC_FILE_NAME = "trim.spec";
    protected static final String STAT_SPEC_FILE_NAME = "statistics.spec";
    public static final String PERFORMANCE_REPORT_FILE_NAME = "perfreport.txt";
    public static boolean brief = false;
    private static boolean useWorkaround = true;
    private static LogWriter log;

    public static void main(String[] args) {
        SystemFailure.loadEmergencyClasses();
        try {
            boolean result = PerfReporter.runperfreport(args);
            if (!result) {
                PerfReporter.logError("runperfreport() returned false");
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            PerfReporter.logError(TestHelper.getStackTrace(t));
        }
        System.exit(0);
    }

    public static boolean runperfreport(String[] args) {
        String jtests = System.getProperty("JTESTS");
        if (jtests == null) {
            PerfReporter.usage("Missing JTESTS");
            return false;
        }
        String gemfire = System.getProperty("gemfire.home");
        if (gemfire == null) {
            PerfReporter.usage("Missing gemfire.home");
            return false;
        }
        Vector<String> testDirs = new Vector<String>();
        if (args.length == 0) {
            testDirs.add(System.getProperty("user.dir"));
        } else {
            for (int i = 0; i < args.length; ++i) {
                String testDir = args[i];
                if (!FileUtil.exists(testDir)) {
                    PerfReporter.usage("Directory not found: " + testDir);
                    return false;
                }
                testDirs.add(FileUtil.absoluteFilenameFor(testDir));
            }
        }
        String statSpecFile = System.getProperty("statSpecFile");
        if (statSpecFile != null && !FileUtil.exists(statSpecFile)) {
            PerfReporter.usage("File not found: " + statSpecFile);
            return false;
        }
        String perfReportFile = System.getProperty("perfReportFile");
        String logLevel = System.getProperty("logLevel", "info");
        useWorkaround = Boolean.getBoolean("useWorkaround");
        brief = Boolean.getBoolean("Brief");
        log = Log.createLogWriter("perfreporter", "perfreporter", logLevel, true);
        log.info("PerfReporter PID is " + ProcessMgr.getProcessId());
        log.info("\nJTESTS = " + jtests + "\ngemfire.home = " + gemfire + "\nstatSpecFile = " + statSpecFile + "\nperfReportFile = " + perfReportFile + "\nlogLevel = " + logLevel + "\nBrief = " + brief + "\ntestDirs = " + testDirs);
        PerfReporter.generatePerformanceReports(testDirs);
        return true;
    }

    private static void generatePerformanceReports(Vector testDirs) {
        PerfReporter.log().info("Generating performance reports for " + testDirs.size() + " test directories");
        for (String testDir : testDirs) {
            String statreport;
            SortedMap statvalues;
            PerfReporter.log().info("..." + testDir);
            StatConfig statconfig = PerfReporter.getStatConfig(testDir);
            if (statconfig == null || (statvalues = PerfReporter.getStatValues(statconfig)) == null || (statreport = PerfReporter.getStatReport(statconfig, statvalues)) == null) continue;
            PerfReporter.printStatReport(statconfig, statreport);
        }
    }

    private static StatConfig getStatConfig(String testDir) {
        String latestPropFile = PerfReporter.getLatestPropFileName(testDir);
        String trimFile = PerfReporter.getTrimFileName(testDir);
        String statFile = PerfReporter.getStatFileName(testDir);
        try {
            return PerfReporter.getStatConfig(testDir, latestPropFile, trimFile, statFile);
        }
        catch (FileNotFoundException e) {
            PerfReporter.log().warning("Missing file: " + e.getMessage());
            return null;
        }
    }

    private static StatConfig getStatConfig(String testDir, String latestPropFile, String trimFile, String statFile) throws FileNotFoundException {
        StatConfig statconfig = new StatConfig(testDir);
        Properties latestProps = PerfReporter.loadPropFile(latestPropFile);
        statconfig.setLatestProperties(latestProps);
        String testPropFile = PerfReporter.getTestPropFileName(testDir, statconfig.getTestName());
        if (FileUtil.exists(testPropFile)) {
            Properties testProps = PerfReporter.loadPropFile(testPropFile);
            statconfig.setTestProperties(testProps);
        }
        if (PerfReporter.log().finerEnabled()) {
            PerfReporter.log().finer(testDir + " set test properties " + statconfig.getTestProperties());
        }
        if (trimFile != null) {
            TrimSpecParser.parseFile(trimFile, statconfig);
        }
        StatSpecParser.parseFile(statFile, statconfig);
        return statconfig;
    }

    protected static StatConfig getStatConfig(String testDir, String statFile) {
        try {
            String trimFile;
            StatConfig statconfig = new StatConfig(testDir);
            String latestPropFile = PerfReporter.getLatestPropFileName(testDir);
            if (!FileUtil.exists(latestPropFile)) {
                return null;
            }
            Properties p = PerfReporter.loadPropFile(latestPropFile);
            statconfig.setLatestProperties(p);
            String testPropFile = PerfReporter.getTestPropFileName(testDir, statconfig.getTestName());
            if (FileUtil.exists(testPropFile)) {
                Properties p2 = PerfReporter.loadPropFile(testPropFile);
                statconfig.setTestProperties(p2);
            }
            if (PerfReporter.log().finerEnabled()) {
                PerfReporter.log().finer(testDir + " set test properties " + statconfig.getTestProperties());
            }
            if (FileUtil.exists(trimFile = PerfReporter.getTrimFileName(testDir))) {
                TrimSpecParser.parseFile(trimFile, statconfig);
            }
            if (FileUtil.exists(statFile)) {
                StatSpecParser.parseFile(statFile, statconfig);
            }
            return statconfig;
        }
        catch (FileNotFoundException e) {
            throw new PerfComparisonException("File not found: " + e.getMessage(), e);
        }
    }

    protected static SortedMap getStatValues(StatConfig statconfig) {
        for (int i = 1; i <= PerfStatMgr.RETRY_LIMIT; ++i) {
            try {
                return PerfStatReader.processStatConfig(statconfig);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (!useWorkaround) {
                    String s = "Make sure that all statistics instances being combined have values for the full duration of the given trim interval.  If so, then the problem could be Bug 30288, and you should try running with -DuseWorkaround=true.";
                    throw new HydraRuntimeException(s, e);
                }
                MasterController.sleepForMs(1);
                if (i != PerfStatMgr.RETRY_LIMIT) continue;
                String s = "Workaround for Bug 30288 failed.  Make sure that all statistics instances being combined have values for the full duration of the given trim interval.";
                throw new HydraRuntimeException(s, e);
            }
        }
        throw new HydraInternalException("Should not happen");
    }

    private static String getStatReport(StatConfig statconfig, SortedMap statvalues) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        PerfReporter.printTitleInfo(statconfig, pw);
        pw.println("\n================================================================================\n");
        PerfReporter.printHeaderInfo(statconfig, pw);
        pw.println("");
        if (!brief) {
            pw.println("================================================================================");
            PerfReporter.center("Trim Values", pw);
            pw.println("================================================================================");
            PerfReporter.printTrimValues(statconfig, pw);
        }
        pw.println("================================================================================");
        PerfReporter.center("Statistics Values", pw);
        pw.println("================================================================================");
        PerfReporter.printStatisticsValues(statconfig, statvalues, pw);
        pw.flush();
        return sw.toString();
    }

    protected static void printStatReport(StatConfig statconfig, String report) {
        String fileName = PerfReporter.getPerfReportFileName(statconfig.getTestDir());
        if (fileName != null) {
            FileUtil.writeToFile(fileName, report);
        } else {
            new PrintStream(new FileOutputStream(FileDescriptor.out)).println(report);
        }
    }

    private static Properties loadPropFile(String fn) throws FileNotFoundException {
        try {
            Properties p = FileUtil.getProperties(fn);
            if (p.size() == 0) {
                throw new FileNotFoundException("File " + fn + " is empty");
            }
            return p;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to load " + fn);
        }
    }

    private static String getLatestPropFileName(String testDir) {
        return testDir + "/" + LATEST_PROP_FILE_NAME;
    }

    private static String getTestPropFileName(String testDir, String testName) {
        int dot;
        String fn = testName;
        int slash = fn.lastIndexOf("/");
        if (slash != -1) {
            fn = fn.substring(slash + 1, fn.length());
        }
        if ((dot = fn.lastIndexOf(".conf")) != -1) {
            fn = fn.substring(0, dot);
        }
        String testpropfn = testDir + "/" + fn + ".prop";
        if (PerfReporter.log().finerEnabled()) {
            PerfReporter.log().finer(testDir + " using test prop file " + testpropfn);
        }
        return testpropfn;
    }

    private static String getTrimFileName(String testDir) {
        return testDir + "/" + TRIM_SPEC_FILE_NAME;
    }

    private static String getStatFileName(String testDir) {
        String fn = System.getProperty("statSpecFile");
        if (fn == null) {
            fn = testDir + "/" + STAT_SPEC_FILE_NAME;
        }
        if (!FileUtil.exists(fn)) {
            fn = System.getProperty("JTESTS") + "/perffmwk/statistics.spec";
        }
        return fn;
    }

    private static String getPerfReportFileName(String testDir) {
        String fn = System.getProperty("perfReportFile");
        if (fn == null) {
            fn = testDir + "/" + PERFORMANCE_REPORT_FILE_NAME;
        } else if (fn.equals("-")) {
            fn = null;
        } else if (!new File(fn).isAbsolute()) {
            fn = testDir + "/" + fn;
        }
        return fn;
    }

    static String fillParagraph(String text, int indent) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        String indentString = "";
        for (int i = 0; i < indent; ++i) {
            indentString = indentString + " ";
        }
        pw.print(indentString);
        int printed = indentString.length();
        boolean firstWord = true;
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String word = text.substring(start, end);
            if (printed + word.length() > 72) {
                pw.println("");
                pw.print(indentString);
                printed = indentString.length();
                firstWord = true;
            }
            if (word.charAt(word.length() - 1) == '\n') {
                pw.write(word, 0, word.length() - 1);
            } else if (firstWord && Character.isWhitespace(word.charAt(0))) {
                pw.write(word, 1, word.length() - 1);
            } else {
                pw.print(word);
            }
            printed += end - start;
            firstWord = false;
            start = end;
            end = boundary.next();
        }
        return sw.toString();
    }

    private static void printTitleInfo(StatConfig statconfig, PrintWriter pw) {
        Properties p = statconfig.getLatestProperties();
        pw.println("");
        PerfReporter.center("Performance Report", pw);
        PerfReporter.center(p.getProperty("TestName"), pw);
        PerfReporter.center(new Date().toString(), pw);
    }

    private static void printHeaderInfo(StatConfig statconfig, PrintWriter pw) {
        Properties p = statconfig.getLatestProperties();
        pw.println("TestUser: " + p.getProperty("TestUser"));
        pw.println("TestDirectory: " + p.getProperty("hydra.HostDescription.masterHost.userDir"));
        String description = "No description";
        description = p.getProperty("hydra.Prms-testDescription", description);
        pw.println("TestDescription:");
        pw.println(PerfReporter.fillParagraph(description, 2));
        String requirement = "No requirement";
        requirement = p.getProperty("hydra.Prms-testRequirement", requirement);
        pw.println("TestRequirement: " + PerfReporter.fillParagraph(requirement, 0));
        pw.println("");
        String hosts = "master-" + p.getProperty("hydra.HostDescription.masterHost.hostName") + "(" + p.getProperty("hydra.HostDescription.masterHost.osType") + ")";
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            int index = name.indexOf(".hostName");
            if (!name.startsWith("hydra.HostDescription.") || index == -1 || name.equals("hydra.HostDescription.masterHost.hostName")) continue;
            hosts = hosts + " " + p.getProperty(name);
            String os = name.substring(0, index) + ".osType";
            hosts = hosts + "(" + p.getProperty(os) + ")";
        }
        pw.println("TestHosts: " + hosts);
        pw.println("");
        pw.println("Build Version: " + p.getProperty("build.version"));
        pw.println("Source Version: " + p.getProperty("source.repository") + ":" + p.getProperty("source.revision") + " (" + p.getProperty("source.date") + ")");
        if (statconfig.isNativeClient()) {
            pw.println("Native Client Build Version: " + p.getProperty("nativeClient.version"));
            pw.println("Native Client Source Version: " + p.getProperty("nativeClient.repository") + ":" + p.getProperty("nativeClient.revision"));
        }
    }

    private static void printTrimValues(StatConfig statconfig, PrintWriter pw) {
        for (TrimSpec trimspec : statconfig.getTrimSpecs().values()) {
            pw.println(trimspec.toReportString());
        }
    }

    protected static void printStatisticsValues(StatConfig statconfig, SortedMap statvalues, PrintWriter pw) {
        for (String statspeckey : statconfig.getStatSpecs().keySet()) {
            List statvaluesforspec;
            StatSpec statspec = statconfig.getStatSpecByKey(statspeckey);
            pw.println(statspec);
            if (!brief) {
                pw.println("--------------------------------------------------------------------------------");
            }
            if ((statvaluesforspec = (List)statvalues.get(statspec.getName())).size() == 0) {
                pw.println("No matches were found for this specification");
            } else {
                for (PerfStatValue statval : statvaluesforspec) {
                    pw.println("==>" + statval.toString());
                }
            }
            pw.println("================================================================================");
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    private static void usage(String s) {
        System.out.println("\n** " + s + "\n");
        System.out.println("Usage: java -Dgemfire.home=<path_to_gemfire_product_tree> -DJTESTS=<path_to_test_classes> [-DstatSpecFile=<statistics_specification_filename>] [-DperfReportFile=<perf_report_filename>] [-DlogLevel=<log_level(default:info)>] [-DuseWorkaround=<use_workaround_for_bug_30288(default:true)>] perffmwk.PerfReporter [test_directories]");
    }

    private static void logError(String msg) {
        if (log == null) {
            System.err.println(msg);
        } else {
            PerfReporter.log().severe(msg);
        }
    }
}

