/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.internal.StatArchiveReader;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RmiRegistryHelper;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import perffmwk.PerfStatReader;
import perffmwk.PerfStatValue;
import perffmwk.PerformanceStatistics;
import perffmwk.RemotePerfStatMgr;
import perffmwk.RuntimeStatSpec;
import perffmwk.StatConfigException;
import perffmwk.StatSpec;
import perffmwk.StatSpecParser;
import perffmwk.TrimInterval;
import perffmwk.TrimSpec;

public final class PerfStatMgr {
    private static PerfStatMgr instance;
    protected static int RETRY_LIMIT;
    private RemotePerfStatMgr delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PerfStatMgr getInstance() {
        if (instance != null) return instance;
        Class<PerfStatMgr> clazz = PerfStatMgr.class;
        synchronized (PerfStatMgr.class) {
            if (instance != null) return instance;
            try {
                RemotePerfStatMgr rps = (RemotePerfStatMgr)RmiRegistryHelper.lookupInMaster("RemotePerfStatMgr");
                instance = new PerfStatMgr(rps);
            }
            catch (Exception ex) {
                String s = "While looking up RemotePerfStatMgr";
                throw new HydraRuntimeException(s, ex);
            }
            return instance;
        }
    }

    private PerfStatMgr(RemotePerfStatMgr delegate) {
        this.delegate = delegate;
    }

    public void startTrim() {
        this.startTrim(null);
    }

    public void startTrim(String trimspecName) {
        try {
            this.delegate.startTrim(trimspecName);
        }
        catch (RemoteException ex) {
            String s = "While invoking startTrim()";
            throw new HydraRuntimeException(s, ex);
        }
    }

    public void endTrim() {
        this.endTrim(null);
    }

    public void endTrim(String trimspecName) {
        try {
            this.delegate.endTrim(trimspecName);
        }
        catch (RemoteException ex) {
            String s = "While invoking endTrim()";
            throw new HydraRuntimeException(s, ex);
        }
    }

    public void reportTrimInterval(TrimInterval interval) {
        try {
            this.delegate.reportTrimInterval(interval);
        }
        catch (RemoteException ex) {
            String s = "While invoking reportTrimInterval: " + interval;
            throw new HydraRuntimeException(s, ex);
        }
    }

    public void reportExtendedTrimInterval(TrimInterval interval) {
        try {
            this.delegate.reportExtendedTrimInterval(interval);
        }
        catch (RemoteException ex) {
            String s = "While invoking reportExtendedTrimInterval: " + interval;
            throw new HydraRuntimeException(s, ex);
        }
    }

    public void reportTrimIntervals(Map intervals) {
        try {
            this.delegate.reportTrimIntervals(intervals);
        }
        catch (RemoteException ex) {
            String s = "While invoking reportTrimIntervals()";
            throw new HydraRuntimeException(s, ex);
        }
    }

    public void reportExtendedTrimIntervals(Map intervals) {
        try {
            this.delegate.reportExtendedTrimIntervals(intervals);
        }
        catch (RemoteException ex) {
            String s = "While invoking reportExtendedTrimIntervals()";
            throw new HydraRuntimeException(s, ex);
        }
    }

    protected void registerStatistics(PerformanceStatistics statInst) {
        StatisticDescriptor[] statDescs = statInst.statistics().getType().getStatistics();
        ArrayList<RuntimeStatSpec> statspecs = new ArrayList<RuntimeStatSpec>();
        for (int i = 0; i < statDescs.length; ++i) {
            StatisticDescriptor statDesc = statDescs[i];
            statspecs.add(new RuntimeStatSpec(statInst, statDesc));
        }
        try {
            this.delegate.registerStatistics(statspecs);
        }
        catch (RemoteException ex) {
            String s = "While invoking registerStatistics()";
            throw new HydraRuntimeException(s, ex);
        }
    }

    public List readStatistics(String specification, TrimSpec trimspec) {
        RuntimeStatSpec statspec = StatSpecParser.parseRuntimeStatSpec(specification);
        return this.readStatistics(statspec, trimspec);
    }

    public List readStatistics(String specification) {
        RuntimeStatSpec statspec = StatSpecParser.parseRuntimeStatSpec(specification);
        return this.readStatistics(statspec);
    }

    public List readStatistics(String specification, boolean exactMatch) {
        RuntimeStatSpec statspec = StatSpecParser.parseRuntimeStatSpec(specification);
        statspec.setExactMatch(exactMatch);
        return this.readStatistics(statspec);
    }

    public List readStatistics(PerformanceStatistics statInst, String statName) {
        StatisticDescriptor sd = statInst.getStatisticDescriptor(statName);
        RuntimeStatSpec statspec = new RuntimeStatSpec(statInst, sd);
        return this.readStatistics(statspec);
    }

    public List readStatistics(RuntimeStatSpec statspec) {
        TrimSpec trimspec = this.getTrimSpec(statspec.getTrimSpecName());
        return this.readStatistics(statspec, trimspec);
    }

    public List readStatistics(RuntimeStatSpec statspec, TrimSpec trimspec) {
        long start = -1L;
        if (Log.getLogWriter().fineEnabled()) {
            start = System.currentTimeMillis();
            Log.getLogWriter().fine("StatSpec:\n" + statspec);
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("TrimSpec: " + trimspec);
        }
        for (int i = 1; i <= RETRY_LIMIT; ++i) {
            try {
                StatArchiveReader reader = this.getStatArchiveReader(statspec);
                List results = this.readStatistics(statspec, trimspec, reader);
                if (Log.getLogWriter().fineEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    Log.getLogWriter().fine("Read statistics in " + elapsed + " ms");
                }
                return results;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MasterController.sleepForMs(1);
                if (i != RETRY_LIMIT) continue;
                String s = "Either the workaround for Bug 30288 failed, or else all statistics instances being combined do not have values for the full duration of the given trim interval.";
                throw new HydraRuntimeException(s, e);
            }
        }
        throw new HydraInternalException("Should not happen");
    }

    private List readStatistics(StatSpec statspec, TrimSpec trimspec, StatArchiveReader reader) {
        ArrayList<PerfStatValue> psvs = new ArrayList<PerfStatValue>();
        StatArchiveReader.StatValue[] values = reader.matchSpec((StatArchiveReader.StatSpec)statspec);
        if (Log.getLogWriter().finerEnabled()) {
            Log.getLogWriter().finer("Values: " + values);
        }
        for (int i = 0; i < values.length; ++i) {
            StatArchiveReader.StatValue sv = values[i];
            if (Log.getLogWriter().finerEnabled()) {
                Log.getLogWriter().finer("Value: " + sv.toString());
            }
            PerfStatValue psv = PerfStatReader.getPerfStatValue(statspec, trimspec, sv);
            psvs.add(psv);
        }
        if (Log.getLogWriter().finerEnabled()) {
            Log.getLogWriter().finer("PerfStatValues: " + psvs);
        }
        return psvs.size() == 0 ? null : psvs;
    }

    private TrimSpec getTrimSpec(String trimspecName) {
        try {
            return this.delegate.getTrimSpec(trimspecName);
        }
        catch (RemoteException ex) {
            String s = "While invoking getTrimSpec()";
            throw new HydraRuntimeException(s, ex);
        }
    }

    private StatArchiveReader getStatArchiveReader(RuntimeStatSpec statspec) {
        try {
            List archives = statspec.getMatchingArchives();
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("Archives: " + archives);
            }
            return new StatArchiveReader(archives.toArray(new File[archives.size()]), (StatArchiveReader.ValueFilter[])new RuntimeStatSpec[]{statspec}, true);
        }
        catch (IOException e) {
            throw new StatConfigException("Unable to read archive", e);
        }
    }

    static {
        RETRY_LIMIT = 500;
    }
}

