/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.Log;
import java.text.DecimalFormat;
import java.util.SortedSet;
import perffmwk.PerfReporter;
import perffmwk.PerfStatException;
import perffmwk.StatSpec;
import perffmwk.TrimSpec;

public class PerfStatValue {
    private static final DecimalFormat format = new DecimalFormat("###.###");
    StatSpec statspec;
    TrimSpec trimspec;
    Double min;
    Double max;
    Double maxminusmin;
    Double mean;
    Double stddev;
    String productVersion;
    boolean isLargerBetter;
    Integer samples;
    SortedSet archives;

    public PerfStatValue(StatSpec statspec, TrimSpec trimspec) {
        this.statspec = statspec;
        this.trimspec = trimspec;
    }

    public void setProductVersion(String s) {
        this.productVersion = s;
    }

    public void setIsLargerBetter(boolean b) {
        this.isLargerBetter = b;
    }

    public void setMin(double d) {
        this.min = new Double(d);
    }

    public void setMax(double d) {
        this.max = new Double(d);
    }

    public void setMaxMinusMin(double d) {
        this.maxminusmin = new Double(d);
    }

    public void setMean(double d) {
        this.mean = new Double(d);
    }

    public void setStddev(double d) {
        this.stddev = new Double(d);
    }

    public void setSamples(int i) {
        this.samples = new Integer(i);
        this.trimspec.setSamples(i);
    }

    public void setArchives(SortedSet s) {
        this.archives = s;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public boolean isLargerBetter() {
        return this.isLargerBetter;
    }

    public double getMin() {
        if (this.min == null) {
            throw new PerfStatException("Min has not been specified in the statspec for this value");
        }
        return this.min;
    }

    public double getMax() {
        if (this.max == null) {
            throw new PerfStatException("Max has not been specified in the statspec for this value");
        }
        return this.max;
    }

    public double getMaxMinusMin() {
        if (this.maxminusmin == null) {
            throw new PerfStatException("MaxMinusMin has not been specified in the statspec for this value");
        }
        return this.maxminusmin;
    }

    public double getMean() {
        if (this.mean == null) {
            throw new PerfStatException("Mean has not been specified in the statspec for this value");
        }
        return this.mean;
    }

    public double getStddev() {
        if (this.stddev == null) {
            throw new PerfStatException("Stddev has not been specified in the statspec for this value");
        }
        return this.stddev;
    }

    public int getSamples() {
        if (this.samples == null) {
            throw new PerfStatException("There are no samples for this value");
        }
        return this.samples;
    }

    boolean isFlatline() {
        return !(this.min != null && this.min != 0.0 || this.max != null && this.max != 0.0 || this.maxminusmin != null && this.maxminusmin != 0.0 || this.mean != null && this.mean != 0.0 || this.stddev != null && this.stddev != 0.0);
    }

    public PerfStatValue dividedBy(PerfStatValue dpsv) {
        PerfStatValue psv = new PerfStatValue(this.statspec, this.trimspec);
        if (this.isFlatline() && dpsv.isFlatline()) {
            return null;
        }
        psv.setArchives(this.archives);
        psv.setProductVersion(this.productVersion);
        psv.setIsLargerBetter(this.isLargerBetter);
        psv.setSamples(this.samples);
        if (this.min != null && dpsv.min != null) {
            psv.setMin(this.divide(this.getMin(), dpsv.getMin()));
        }
        if (this.max != null && dpsv.max != null) {
            psv.setMax(this.divide(this.getMax(), dpsv.getMax()));
        }
        if (this.maxminusmin != null && dpsv.maxminusmin != null) {
            psv.setMaxMinusMin(this.divide(this.getMaxMinusMin(), dpsv.getMaxMinusMin()));
        }
        if (this.mean != null && dpsv.mean != null) {
            psv.setMean(this.divide(this.getMean(), dpsv.getMean()));
        }
        if (this.stddev != null && dpsv.stddev != null) {
            psv.setStddev(this.divide(this.getStddev(), dpsv.getStddev()));
        }
        return psv;
    }

    private double divide(double numerator, double denominator) {
        double div = numerator == 0.0 ? 0.0 : (denominator == 0.0 ? Double.MAX_VALUE : (numerator == denominator ? 1.0 : numerator / denominator));
        if (Log.getLogWriter().finerEnabled()) {
            Log.getLogWriter().finer("divide(" + numerator + ", " + denominator + ") ==> " + div);
        }
        return div;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.min != null) {
            buf.append(" min=" + format.format(this.min));
        }
        if (this.max != null) {
            buf.append(" max=" + format.format(this.max));
        }
        if (this.maxminusmin != null) {
            buf.append(" max-min=" + format.format(this.maxminusmin));
        }
        if (this.mean != null) {
            buf.append(" mean=" + format.format(this.mean));
        }
        if (this.stddev != null) {
            buf.append(" stddev=" + format.format(this.stddev));
        }
        if (!PerfReporter.brief) {
            buf.append("\n   ");
            buf.append(" samples=" + this.samples);
            buf.append(" archives=" + this.archives);
        }
        return buf.toString();
    }
}

