/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import java.util.List;
import java.util.SortedMap;
import perffmwk.BaseComparison;
import perffmwk.ComparisonConstants;
import perffmwk.PerfStatValue;
import perffmwk.ValueComparator;

public class RawComparison
extends BaseComparison
implements ComparisonConstants {
    RawComparison(List comparators, boolean markFailedTests) {
        super(comparators, markFailedTests);
        this.fillInRows();
    }

    @Override
    protected void fillInRow(String op, String statSpecName) {
        if (this.log.finerEnabled()) {
            this.log.finer("Filling in row for " + statSpecName + " " + op);
        }
        this.statspecColumn.add(statSpecName);
        this.opColumn.add(op);
        for (int i = 0; i < this.comparators.size(); ++i) {
            Object val;
            ValueComparator comparator = (ValueComparator)this.comparators.get(i);
            if (comparator == null) {
                val = "";
            } else if (this.markFailedTests && (comparator.getTest().getTestResult().equals("H") || comparator.getTest().getTestResult().equals("F"))) {
                val = "xxx";
            } else {
                SortedMap statValues = comparator.getStatValues();
                if (statValues == null) {
                    val = "";
                } else {
                    List psvs = (List)statValues.get(statSpecName);
                    if (psvs == null) {
                        val = "";
                    } else if (psvs.size() == 0) {
                        val = "";
                    } else if (psvs.size() == 1) {
                        PerfStatValue psv = (PerfStatValue)psvs.get(0);
                        val = new Double(this.getOpValue(op, psv));
                    } else {
                        val = "err";
                    }
                }
            }
            this.valColumns[i].add(val);
            if (!this.log.finerEnabled()) continue;
            if (comparator == null) {
                this.log.finer(i + ": has " + statSpecName + " " + op + " " + val);
                continue;
            }
            this.log.finer(i + ": value comparator " + comparator.getIndex() + " at " + comparator.getTest().getTestDir() + " for " + comparator.getTest().getTestId() + " has " + statSpecName + " " + op + " " + val);
        }
    }
}

