/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import perffmwk.HistogramStatsPrms;
import perffmwk.PerfReportPrms;
import perffmwk.RemotePerfStatMgr;
import perffmwk.RuntimeStatSpec;
import perffmwk.StatConfig;
import perffmwk.StatSpec;
import perffmwk.StatSpecParser;
import perffmwk.TrimInterval;
import perffmwk.TrimSpec;

public class RemotePerfStatMgrImpl
extends UnicastRemoteObject
implements RemotePerfStatMgr {
    public static final String RMI_NAME = "RemotePerfStatMgr";
    private static final DecimalFormat format = new DecimalFormat("###.###");
    private static int nextPerfStatsIndex = -1;
    private static final String COMMENT_DIVIDER = "\n//==============================================================================";
    private StatConfig statconfig = new StatConfig(System.getProperty("user.dir"));

    @Override
    public void startTrim(String trimspecName) throws RemoteException {
        String name = trimspecName;
        if (name == null) {
            name = TrimSpec.DEFAULT_TRIM_SPEC_NAME;
        }
        TrimSpec trimspec = this.statconfig.getTrimSpec(name);
        trimspec.start();
    }

    @Override
    public void endTrim(String trimspecName) throws RemoteException {
        String name = trimspecName;
        if (name == null) {
            name = TrimSpec.DEFAULT_TRIM_SPEC_NAME;
        }
        TrimSpec trimspec = this.statconfig.getTrimSpec(name);
        trimspec.end();
    }

    @Override
    public synchronized void reportTrimInterval(TrimInterval interval) throws RemoteException {
        String name = interval.getName();
        TrimSpec trimspec = this.statconfig.getTrimSpec(name);
        trimspec.start(interval.getStart());
        trimspec.end(interval.getEnd());
    }

    @Override
    public synchronized void reportExtendedTrimInterval(TrimInterval interval) throws RemoteException {
        String name = interval.getName();
        TrimSpec trimspec = this.statconfig.getTrimSpec(name);
        trimspec.start(interval.getStart());
        trimspec.endExtended(interval.getEnd());
    }

    @Override
    public synchronized void reportTrimIntervals(Map intervals) throws RemoteException {
        for (String name : intervals.keySet()) {
            long endTime;
            TrimSpec trimspec = this.statconfig.getTrimSpec(name);
            TrimInterval interval = (TrimInterval)intervals.get(name);
            long startTime = interval.getStart();
            if (startTime != -1L) {
                trimspec.start(startTime);
            }
            if ((endTime = interval.getEnd()) == -1L) continue;
            trimspec.end(endTime);
        }
    }

    @Override
    public synchronized void reportExtendedTrimIntervals(Map intervals) throws RemoteException {
        for (String name : intervals.keySet()) {
            long endTime;
            TrimSpec trimspec = this.statconfig.getTrimSpec(name);
            TrimInterval interval = (TrimInterval)intervals.get(name);
            long startTime = interval.getStart();
            if (startTime != -1L) {
                trimspec.startExtended(startTime);
            }
            if ((endTime = interval.getEnd()) == -1L) continue;
            trimspec.endExtended(endTime);
        }
    }

    @Override
    public TrimSpec getTrimSpec(String trimspecName) throws RemoteException {
        String name = trimspecName;
        if (name == null) {
            name = TrimSpec.DEFAULT_TRIM_SPEC_NAME;
        }
        return this.statconfig.getTrimSpec(name);
    }

    @Override
    public void registerStatistics(List statspecs) throws RemoteException {
        for (RuntimeStatSpec statspec : statspecs) {
            if (this.statconfig.getStatSpecsWithId(statspec.getId()) == null) {
                Log.getLogWriter().info("Autogenerating name for " + statspec + " with name " + statspec.getName());
                statspec.autogenerateName();
                this.statconfig.addStatSpec(statspec);
                if (!Log.getLogWriter().fineEnabled()) continue;
                Log.getLogWriter().fine("Registered statspec\n" + statspec);
                continue;
            }
            if (!Log.getLogWriter().finerEnabled()) continue;
            Log.getLogWriter().finer("Already registered statspec\n" + statspec);
        }
    }

    public void generateTrimSpecificationsFile() {
        String trimspecs = this.generateTrimSpecifications();
        if (trimspecs != null) {
            FileUtil.writeToFile("trim.spec", trimspecs);
        }
    }

    public void generateStatisticsSpecificationsFile() {
        Object obj;
        String histFile = null;
        if (TestConfig.tab().booleanAt(HistogramStatsPrms.enable, false)) {
            histFile = (String)TestConfig.tab().get(HistogramStatsPrms.statisticsSpecification);
        }
        boolean useAutoGeneratedStasSpec = (obj = TestConfig.tab().get(PerfReportPrms.useAutoGeneratedStatisticsSpecification)) == null ? false : Boolean.valueOf((String)obj);
        String statFile = null;
        statFile = useAutoGeneratedStasSpec ? System.getProperty("user.dir") + "/" + "autoGenerate.spec" : (String)TestConfig.tab().get(PerfReportPrms.statisticsSpecification);
        String stats = this.generateStatisticsSpecifications(statFile, histFile);
        this.statconfig.resetStatSpecs();
        if (stats != null) {
            FileUtil.writeToFile("statistics.spec", stats);
            try {
                StatSpecParser.parseFile("statistics.spec", this.statconfig);
            }
            catch (FileNotFoundException e) {
                throw new HydraRuntimeException("Should not happen");
            }
        }
    }

    private String generateTrimSpecifications() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("// Trim Specifications (Autogenerated)");
        pw.println("// " + TestConfig.getInstance().getTestName());
        pw.println("// " + new Date().toString());
        pw.println(COMMENT_DIVIDER);
        this.printTrimSpecs(pw);
        pw.flush();
        return sw.toString();
    }

    private String generateStatisticsSpecifications(String statFile, String histFile) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("// Statistics Specifications (Autogenerated)");
        pw.println("// " + TestConfig.getInstance().getTestName());
        pw.println("// " + new Date().toString());
        pw.println(COMMENT_DIVIDER);
        if (statFile == null) {
            this.printUserDefinedStatisticsSpecs(pw);
            pw.println("include $JTESTS/perffmwk/statistics.spec\n;");
        } else {
            pw.println("include " + statFile + "\n;");
        }
        if (histFile != null) {
            pw.println("include " + histFile + "\n;");
        }
        pw.flush();
        return sw.toString();
    }

    private void printTrimSpecs(PrintWriter pw) {
        for (TrimSpec trimspec : this.statconfig.getTrimSpecs().values()) {
            pw.println(trimspec.toSpecString());
        }
    }

    private void printUserDefinedStatisticsSpecs(PrintWriter pw) {
        for (StatSpec statspec : this.statconfig.getStatSpecs().values()) {
            pw.println(statspec.toSpecString());
        }
    }
}

