/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.internal.Assert;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import hydra.TestFileUtil;
import java.util.List;
import java.util.SortedMap;
import perffmwk.PerformanceStatistics;
import perffmwk.StatSpec;

public class RuntimeStatSpec
extends StatSpec {
    protected List matchingArchiveCache;
    private static int INDEX = -1;

    protected RuntimeStatSpec() {
        super("runtime");
    }

    public RuntimeStatSpec(PerformanceStatistics statInst, StatisticDescriptor statDesc) {
        super(statInst, statDesc);
        this.name = "runtime";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autogenerateName() {
        Class<StatSpec> clazz = StatSpec.class;
        synchronized (StatSpec.class) {
            Assert.assertTrue((this.name == null || this.name.equals("runtime") ? 1 : 0) != 0);
            this.name = "statspec" + ++INDEX;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected List getMatchingArchives() {
        if (this.matchingArchiveCache == null) {
            if (!TestConfig.tab().booleanAt(Prms.useNFS)) {
                String s = "Cannot read statistic archives properly when " + BasePrms.nameForKey(Prms.useNFS) + " is set false";
                throw new HydraConfigException(s);
            }
            String masterUserDir = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription().getUserDir();
            SortedMap<String, List<String>> allArchives = TestFileUtil.getStatisticArchives(masterUserDir);
            this.matchingArchiveCache = this.findMatchingArchives(allArchives, this.getId());
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("Found matching archives: " + this.matchingArchiveCache);
            }
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Matching archives: " + this.matchingArchiveCache);
        }
        return this.matchingArchiveCache;
    }
}

